
#define _GNU_SOURCE
#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<pthread.h>
#include<stdlib.h>

#include"zither.h"
#include<almemsys/almemsys.h>


/*
cahr * file_send(char *, char *, int *, int);
*/

char * command_check(char *);



/*---------------- COMMAND_CHECK --------------------*/
char * command_check(char * data)
{
char * chdata;

if(0 < (int)strlen(data)){
   if((chdata = (char *)strcasestr(data, "shutd")) != NULL){
      chdata[0] = 'X';
      chdata[1] = 'X';
      chdata[2] = 'X';
      chdata[3] = 'X';
      fprintf(stderr,"command_check(): The following are included. 'SHUTD'\n");
      return data;
      }
   else if((chdata = (char *)strcasestr(data, "reboo")) != NULL){
      chdata[0] = 'Y';
      chdata[1] = 'Y';
      chdata[2] = 'Y';
      chdata[3] = 'Y';
      fprintf(stderr,"command_check(): The following are included. 'REBOO'\n");
      return data;
      }
   else if((chdata = (char *)strcasestr(data, "init")) != NULL){
      chdata[0] = 'Z';
      chdata[1] = 'Z';
      chdata[2] = 'Z';
      fprintf(stderr,"command_check(): The following are included. 'INIT'\n");
      return data;
      }
//   else if((chdata = (char *)strcasestr(data, "kill")) != NULL){
//      chdata[0] = 'A';
//      chdata[1] = 'A';
//      chdata[2] = 'A';
//      fprintf(stderr,"file.c: command_check(1): The following are included. 'KILL'\n");
//      return data;
//      }
   else{
      return data;
      }
   }

else{
   fprintf(stderr,"command_check(): not haystack data.\n");
   }

return data;
}



/*---------------- FILE SEND --------------------*/
char * file_send(int sock_fd, char * filename, char * data, int * stat, int interval, char delim)
{
FILE * fp;
FILE * lfp;
int fd, count;

char * lock_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));
char * backup_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));

// lockfile 名を作る
lock_filename = safe_memcpy(lock_filename, filename, BUF_MAX);
lock_filename = safe_strncat(lock_filename, "_lock", BUF_MAX);

// backupfile 名を作る
backup_filename = safe_memcpy(backup_filename, filename, BUF_MAX);
backup_filename = safe_strncat(backup_filename, "_backup", BUF_MAX);


for(count = 0; count < 15; count++){
   if((lfp = fopen(lock_filename, "r"))==NULL){                      // lock_file が無い場合
      if((lfp = fopen(lock_filename, "w+"))!=NULL){                  // lock_file を作れた場合

         if((fp = fopen(filename, "r"))!=NULL){                      // file が読めた場合
            fd = fileno(fp); 

            if(0 > (file_copy(filename, backup_filename))){          // file の服制を作る
               fprintf(stderr,"file_send(): file copy err. <%s -> %s>\n",
                 filename, backup_filename);
               }
            #ifdef FILESEND_DEBUG
            else{
               fprintf(stdout,"FILESEND_DEBUG: file_send(): OK file copy: %s -> %s \n", filename, backup_filename);
               }
            #endif

            data = safe_filefdcat(fd, data, stat, BUF_MAX, interval); // file をdataに読む

            // 特定文字列の粛正
            data = command_check(data);

            #ifdef FILESEND_DEBUG
            fprintf(stderr, "FILESEND_BUG: file_send(1): <%s>\n", data);
            #endif
            if(BUF_MAX < (int)strlen(data)){
               fprintf(stderr,"file_send(): file size over err. <%s>\n", filename);
               }

            swap_mem(data, '\n', (char)delim);         // '\n'を'0x05'に置き換え
            data = safe_strncat(data, "\n", BUF_MAX);               // 最後に改行追加
            if(1 < (int)strlen(data)){                              // data が1より大きい場合
               * stat = socket_send(sock_fd, data, interval);       // dataを送信
               }
            else{
               * stat = socket_send(sock_fd, "500 NG file read err.\n", interval);
               }

            fclose(fp);
            }

         else{                                                // file が読めない場合 
            /* * stat = -1; */
            data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
            fprintf(stderr,"-- CONF FILE NOT OPEN: filename = <%s>\n", filename);
            * stat = socket_send(sock_fd, "500 NG file not open.\n", interval);
            }

         lock_remove(lock_filename);                         // lock_file 削除
         fclose(lfp);
         break;
         }
      else{                                                  // lock_file が作れない場合
         data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
         fprintf(stderr,"file_send(): config lockfile is not open!. %s\n", lock_filename);
         * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
         break;
         }
      }
   else{                                                     // lock_fileがすでにあった場合
      fprintf(stderr,"file_send(): config lockfile extas wait 1sec %s\n", lock_filename);
      fclose(lfp);
      sleep(1);
      }
   }                                                         // for() loop

if(count >= 5){
   data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
   fprintf(stderr,"file_send(): config lockfile exeitas wait 5sec. loop out. %s\n", lock_filename);
   * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
   }

free(lock_filename);
free(backup_filename);

return data;
}




