

#include<stdio.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h>


#include"sitar.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"
#include<file_comp/file_comp.h>
#include"sitar_test_server.h"


struct my_server_sock ip;
// struct exec_id exid;

/* argv[1] = open ip
   argv[2] = open port
   argv[3] = max connection
   argv[4] = dns ip  */


int main(int argc, char * argv[])
{
int fdcount, i;
extern char *optarg;

// if(argc != 5){
//   fprintf(stdout,"%s\n", CL_VAR);
//   fprintf(stdout,"The number of arguments is different. %d\n", argc);
//   fprintf(stdout,"Please execute it referring to the following. \n");
//   fprintf(stdout,"sitar_proxy <open ip 1> <open port 2> <max connection 3> <dns ip 4>\n");
//   exit(1);
//   } 


sitar_test_server_mallocset();

while((i=getopt(argc,argv,"i:p:c:d:v"))!= EOF){
   switch(i){
      case 'i': if(optarg != NULL){
                   ip.ip_addr = safe_memcpy(ip.ip_addr, optarg, 1024);
                   }
                else{
                   ip.ip_addr = safe_memcpy(ip.ip_addr, "0", 1024);
                   }
              break;
      case 'p': if(optarg != NULL){
                   ip.ch_port = safe_memcpy(ip.ch_port, optarg, 1024);
                   ip.port = strtol( ip.ch_port, (char **)NULL, 10);
                   }
                else{
                   ip.ch_port = safe_memcpy(ip.ch_port, "8899", 1024);
                   ip.port = strtol( ip.ch_port, (char **)NULL, 10);
                   }
              break;
      case 'c': if(optarg != NULL){
                   ip.max_count = strtol( optarg, (char **)NULL, 10);
                   }
                else{
                   ip.max_count = 2; 
                   }
              break;
      case 'd': if(optarg != NULL){
                   ip.dns_ip = safe_memcpy(ip.dns_ip, optarg, 1024);
                   }
                else{
                   ip.dns_ip = safe_memcpy(ip.dns_ip, "127.0.0.1", 1024);
                   }
              break;

      default : 
              printf("sitar_test_server -i<ip addr> -p<open port> -c<thread count> -d<dns ip>\n");
              exit(1);
      } 
   }

if(0 >= strlen(ip.ip_addr)){
   ip.ip_addr = safe_memcpy(ip.ip_addr, "127.0.0.1", 1024);
   }
if(0 >= ip.port){
   ip.port = 8899;
   }
if(0 >= ip.max_count){
   ip.max_count = 2;
   }
if(0 >= strlen(ip.dns_ip)){
   ip.dns_ip = safe_memcpy(ip.dns_ip, "127.0.0.1", 1024);
   }

sitar_test_server_mallocset2();

printf("sitar_test_server -i<%s> -p<%d> -c<%d> -d<%s>\n", ip.ip_addr, ip.port, ip.max_count, ip.dns_ip);


socket_bind(&ip.my_addr, ip.port, ip.ip_addr, &ip.ls);

for(;;){

   /* ユニーク番号を探す */
   for(fdcount = 0; fdcount < ip.max_count; fdcount++){
      if(ip.fdstat[fdcount] != 1){
         ip.fdstat[fdcount] = 1;
         break;
         }
      } 

   /* fdcount ユニーク番号が上限に達していないのでaceeptでまってみる */
   if(fdcount < ip.max_count){
      socket_accept(&ip.my_addr, &ip.ls, &ip.sk[fdcount]);
      pthread_create( &ip.pt[fdcount], NULL, (void *)sitar_server_connect_open, (long int *)fdcount);
      }
   else {
      fprintf(stderr,"It waits for 10 seconds that exceeded connected number threshold.%d\n",fdcount);
      sleep(10); 
      }
   }

/* --- It doesn't reach. ---*/
close(ip.ls);
return 0;
}




int sitar_server_connect_open(int fdno)
{
int stat, pst;
char * backdata;
char * getdata;
char * senddata;

backdata = (char *)calloc(BUF_LEN, sizeof(char));
getdata = (char *)calloc(BUF_LEN, sizeof(char));
senddata = (char *)calloc(BUF_LEN, sizeof(char));

pst = 0;

pthread_detach(pthread_self());

getdata = select_fdcat(ip.sk[fdno], getdata, &stat, BUF_MAX, 7);

// getdata を最後のおまけ,で分ける、一番最後がIP列


if(stat >= 0){

   backdata = scan_test_server_command(backdata, getdata, ip.dns_ip, ip.ip_addr, 7, &pst);

   senddata = safe_sprintf(senddata, BUF_MAX,"%s\n", backdata);

   stat = socket_send(ip.sk[fdno], senddata, 7);
   if(stat < 0){
      fprintf(stderr,"sitar_server_connect_open(): socket_send()err.\n");
      }
   }
else{
   fprintf(stderr,"sitar_server_connect_open(): select_fdcat()err.\n");
   }

free(backdata);
free(getdata);
free(senddata);

close(ip.sk[fdno]);
ip.fdstat[fdno] = 0;

return 0;
}



