
#ifndef _SITAR_SCAN_H_
  #define _SITAR_SCAN_H_

  #include<time.h>
  #include<sys/types.h>

  #include<netinet/ip_icmp.h>
  #include<netinet/icmp6.h>
//  #include<arpa/inet.h>
  #include<netinet/udp.h>


  #define BUF_URL 1024

  #define DEFAULT_TIMEOUT 4

  /* RESOLV DEBUG */
//  #define RESOLV_DEBUG

  /* SMTP SCAN DEBUG */
//  #define SMTP_BUG

  /* URL SCAN DEBUG */
//  #define URL_BUG

  /* ICMP SCAN DEBUG */
//  #define ICMP_BUG

  /* UDP SCAN DEBUG */
//  #define UDP_BUG

  /* TCP DEBUG  */
//  #define TCP_BUG 

  /* TCP DHW BUG  */
//  #define DHW_BUG 

  /* SNTP BUG */
//  #define SNTP_BUG                   

  /* SSL/TSL BUG */
//  #define SSL_BUG



  /* --- scan_icmp.c --- */
  char * scan_icmp(unsigned long, char *, int, int *, int, char *, int, float *);
  char * scan_icmpav(char *, char *, int, int *, int, char *, int, int);
  char * scan_v6icmp(unsigned char *, char *, int, int *, int, char *, int, float *);
  char * scan_traceudpsetopt(char *, char *, int, int *, int, char *);
  int make_icmp8_packet(struct icmp *icmp, int len, int n, int id);
  int make_icmpv6_packet(struct icmp6_hdr *icmp6, int len, int n, int id);
  int make_udp_header(struct udphdr *udp, int port, int sport);
  int make_ip_header(struct ip * ip, int srcip, int dstip, int iplen);

  int tvsub(struct timeval *out, struct timeval *in);
  u_short checksum(u_short *data, int len);

  /* --- scan_udpportc --- */
  char * scan_udpav(char * url_data, int port, char * ch_info, int timeout, int * ret, int by, char * ch_id, int comax, int fa);
  char * scan_udp(int port, unsigned long resoip, char * backdata, int timeout, int * stat, char * chid, float * avrt);

  /* --- scan_tcpport.c --- */
  char * scan_tcpav(char * url_data, int port, char * ch_info, int timeout, int * ret, int by, char * ch_id, int comax, int fa);
  char * scan_tcp(unsigned long resoip, int port, char * backdata, int timeout, int * stat, int by, float * avrt, int mode, int * sk);
  char * scan_tcp6(unsigned char * resoip, int port, char * backdata, int timeout, int * stat, int by, float * avrt, int mode, int * sk);

  /* --- scan_url_connect.c --- */
  char * scan_urlav(char * url_data, int port, char * ch_info, int timeout, int * ret, int by, int comax, int fa, char head, char * ch_id);
  char * scan_url(int sk, char * url_dom, char * url_pass, char * backdata, int timeout, int * pst, float * avrt, char head, char * ch_id);
  int safe_filefdcat_tr(int, int, int);
  int safe_filefdcat_sha(int, int, int, char *);
  int diff_shadata(char * sha_hash, char * filename);

  /* --- scan_ssl_connect.c --- */
  char * scan_ssl_command(int, char *, char *, int, long int, int *, char *, int);
  int count_memcpy3(char out[], char * data, int start, int plus);

  char * scan_mysql_command(char * backdata, char * query, char * server, char * username, char * passwd, char * database, int port, int timeout, int * pst, char * plai);


  /* --- scan_smtpport.c --- */
  char * scan_smtpav(char * url_data, int port, char * ch_info, int timeout, int * ret, int by, int comax, int fa);
  char * scan_smtp(int sk, char * backdata, int timeout, int * pst, float * avrt, float * avrt2);
//char * scan_smtp_connect(int, char *, char *, int, int *);
  char * resolvename_th(char *, char *, int, unsigned long *);
  char * resolvename_sk(char *, char *, int, unsigned long *, char *, int *, char);
  char * out_resolvename(char *, char *, int, unsigned long *);
  unsigned long resolve_name(char *name);
  time_t cert_time_get(char * data);
  char * th_resolv(char * name, char * back, int interval, int out);

  /* --- scan_statport.c --- */
  char * scan_statav(char * url_data, int port, char * ch_info, int timeout, int * ret, char * stat, int stat_len, int by, int comax, int fa);
  char * scan_stat(int sk, char * backdata, char * stat, int stat_len, int timeout, int * pst, float * avrt2);

  /* --- scan_dhwport.c --- */
  char * scan_dhw_connect(char *, int, char *, char *, int, int *);

  /* --- scan_sntp --- */
  char * scan_sntp_connect(int, char [], char *, int, int *);

  /* --- scan_host.c --- */
  char * scan_host(char *, char *, char *, int, int *);

  /* scan_urlport() */
  int urldompass_port(char *, char *, char *, int); 
  char * set_request(char *, char *, char *);
  int self_set_request(char *, char *, char *, int, char *);
  char * check_recvdata(char *, char *, int *);
  int self_check_recvdata(char *, char *);

   char * scan_dns_connect(int, char *, char *, char *, int, int *, char);


#endif


