
// X509 証明書関係、HTTPSの接続テストコマンド

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<netdb.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/ip6.h>
#include<arpa/inet.h>
#include<fcntl.h>
#include<pthread.h>

#include<sys/stat.h>
#include<errno.h>

/* SSL/TSL 関係のヘッダーファイル */
#include <openssl/crypto.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>

#include"sitar_scan.h"
#include"sitar_com.h"
#include"sitar_ssl.h"
#include <almemsys/almemsys.h>
#include"jpreturn.h"
#include "version.h"


// 259200 = 3day 証明書の期限が切れる3日前の時間
#define AF_TIME 259200 

// char *  verify_ssl(char * data, SSL *ssl, int * err);

// DE BUG 用
// #define SSL_BUG
// #define SSL_READ_BUG


// SSL_CONNECT 排他処理
pthread_mutex_t ssl_mutex;
char gb_mu;
int gb_ret;


int ssl_connect_th(SSL * ssl)
{
/* SSL でコネクト、TCPではすでに確立しているが、ここではSSLでの話 */
SSL_set_connect_state(ssl);
gb_ret = SSL_connect(ssl);

safe_pthread_mutex_lock(&ssl_mutex);
gb_mu = 1;
pthread_mutex_unlock(&ssl_mutex);

return 0;
}



int ssl_check_th(int * timeout)
{
int co;
for(co = 0; co < (int)timeout; co++){
   safe_pthread_mutex_lock(&ssl_mutex);
   if(gb_mu == 1){
      pthread_mutex_unlock(&ssl_mutex);
      break;
      }
   pthread_mutex_unlock(&ssl_mutex);
   sleep(1);
   }
return 0;
}


// read() timeout 
struct th_sslstr {
  pthread_t t1;
  pthread_t t2;
  pthread_mutex_t read_mutex;
  int th_sk;
  int th_timeout;
  int th_out;
  int th_stat;
  int th_ret;
  int th_max;
  char * th_chp;
  SSL * th_ssl;
  } th_ssl;

struct th_sslstr * th_struct;


// t1
int sslread_check_th(void)
{
int co;
co = 0;
th_struct->t1 = pthread_self();

for(; th_struct->th_out < th_struct->th_timeout; ){

//   printf("---- out = %d\n", th_struct->th_out);

   usleep(1000);
   co++;
   if( co >= 1000 ){
      th_struct->th_out++;
      co = 0;
      }

   safe_pthread_mutex_lock(&th_struct->read_mutex);
   if(1 == th_struct->th_ret){
      pthread_mutex_unlock(&th_struct->read_mutex);
      break;
      }
   pthread_mutex_unlock(&th_struct->read_mutex);

   if(th_struct->th_out >= th_struct->th_timeout){

      safe_pthread_mutex_lock(&th_struct->read_mutex);
      th_struct->th_ret = -1;
      pthread_mutex_unlock(&th_struct->read_mutex);

//      printf("---CLOSE--- out = %d\n", th_struct->th_out);

      close(th_struct->th_sk);
      break;
      }
   }

return 0;
}



// t2
int sslread_get_th(void)
{
int stat;

stat = SSL_read(th_struct->th_ssl, th_struct->th_chp, th_struct->th_max);
th_struct->th_stat = stat;

// CLOSEされてない場合はret = 1
safe_pthread_mutex_lock(&th_struct->read_mutex);
if(th_struct->th_ret == -1){
   th_struct->th_stat = -2;
   }
else{
   th_struct->th_ret = 1;
   }
pthread_mutex_unlock(&th_struct->read_mutex);

return 0;
}



int ssl_read_timeout(SSL * ssl, char * recvdata, int interval, int maxc)
{

int fd, tret;
struct timeval tv;
int retval;
int ret;
fd_set rfds;

memset(&th_ssl, 0x00, sizeof(th_ssl));
th_struct = &th_ssl;

// SSL 構造体からselect()用にFDを取り出す
fd = SSL_get_fd(ssl);

th_struct->th_ret = 0;
th_struct->th_out = 0;
th_struct->th_sk = fd;
th_struct->th_timeout = interval;
th_struct->th_chp = recvdata;
th_struct->th_max = maxc;
th_struct->th_ssl = ssl;
tret = 0;

tv.tv_sec = interval;
tv.tv_usec = 0;
ret = 0;

#ifdef SSL_READ_BUG
printf("SSL_READ_BUG: ssl_read_timeout(1): interval time set %d\n", interval);
#endif

while(1){
   FD_ZERO(&rfds);
   FD_SET(fd, &rfds);
   retval = select(fd + 1, &rfds, NULL, NULL, &tv);
   if(retval < 0){
      #ifdef SSL_READ_BUG
      printf("SSL_READ_BUG: ssl_read_timeout(2): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      ret = -1;
      break;
      }
   if(retval == 0){
      #ifdef SSL_READ_BUG
      printf("SSL_READ_BUG: ssl_read_timeout(3): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      ret = -1;
      break;
      }
   if(retval >= 1){
//      ret = SSL_read(ssl, recvdata, maxc);
      #ifdef SSL_READ_BUG
      printf("SSL_READ_BUG: ssl_read_timeout(4): select break <%d> ERRNO: %d %s : %s\n",
        retval, errno, strerror(errno), recvdata);
      #endif

      pthread_mutex_init(&th_struct->read_mutex, NULL);

      th_struct->th_stat = 1024;
      if((tret = pthread_create(&th_struct->t1, NULL, (void *)sslread_check_th, NULL)) != 0){
         fprintf(stderr,"scanssl.c pthread_create(1): %d %d\n",tret, errno);
         }
      if((tret = pthread_create(&th_struct->t2, NULL, (void *)sslread_get_th, NULL)) != 0){
         fprintf(stderr,"scanssl.c pthread_create(1): %d %d\n",tret, errno);
         }

      pthread_join( th_struct->t1, NULL);
      pthread_join( th_struct->t2, NULL);

      pthread_mutex_destroy(&th_struct->read_mutex);

      ret = th_struct->th_stat;

      break;
      }
   } /* while */

return(ret);
}













int main(int argc, char * argv[])
{
pthread_t t1;
pthread_t t2;

int sk, re, stat, ret, tret, retval, dcount, arglen, sslerr, i, mode;
unsigned char resoip6[sizeof(struct in6_addr)];
char ipa[IP_LEN];
char dom[BUF_URL];
char pass[BUF_URL];
char rec[256];
char swa[2048];

char * ip_addr = ipa;
char * url_dom = dom;
char * url_pass = pass;
struct sockaddr_in6 my_addr;

fd_set rfds;
struct timeval tv;
char * senddata;
char * ssl_senddata;
char * backdata;
char * swapdata = swa;
char * recvdata = rec;
char bu[IP_LEN];
char * buff = bu;

extern char *optarg;

int port;
int timeout;
long int cert_lim;
char * url_data; 
char * dns_data; 
int resolv_ret;

double dtv1;
double dtv2;
float tcp_rtt;

double rdtv1;
double rdtv2;
float get_rtt;

time_t B_time, A_time, N_time, Na_time;
B_time =0; A_time =0; N_time =0;
ASN1_TIME * notBefore;
ASN1_TIME * notAfter;
SSL * ssl;
SSL_CTX * ctx;
#ifdef SSL_BUG
SSL_CIPHER * cipher;
#endif
X509 * cert;
int cert_length;
cert_length = 0;

dcount = 0;
arglen = sizeof(int);
ret = -1;
tret = -1;
errno = 0;
sslerr = 0;
port = 0;
timeout = 0;
cert_lim = 0;
resolv_ret = 0;
mode = 0;

pthread_mutex_init(&ssl_mutex, NULL);
gb_mu = 0;
gb_ret = -1;

if((senddata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}
if((url_data = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}
if((dns_data = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}
if((backdata = (char *)calloc(BUF_LEN, sizeof(char)))==NULL){ exit(1);}

memset(resoip6, 0x00, sizeof(struct in6_addr));
memset(recvdata, 0x00, 256);
memset(swapdata, 0x00, 2048);
memset(ip_addr, 0x00, IP_LEN);
memset(url_dom, 0x00, BUF_URL);
memset(url_pass, 0x00, BUF_URL);

// defaultのDNSを設定
dns_data = safe_memcpy(dns_data, "127.0.0.1", 1024);

// optionの処理
while((i=getopt(argc,argv,"a:p:t:c:u:v:d:m:z"))!= EOF){
   switch(i){
      case 'p': if(0 == ch_int2(optarg)){
                   port = strtol(optarg, (char **)NULL, 10);
                   }
              break;
      case 't': if(0 == ch_int2(optarg)){
                   timeout = strtol(optarg, (char **)NULL, 10);
                   }
              break;
      case 'm': if(0 == ch_int2(optarg)){
                   mode = strtol(optarg, (char **)NULL, 10);
                   }
              break;
      case 'c': if(0 == ch_int2(optarg)){
                   cert_lim = (long int)strtol(optarg, (char **)NULL, 10);
                   }
              break;
      case 'u': if(optarg != NULL){
                   url_data = safe_memcpy(url_data, optarg, 1024);
                   }
                else{
                   url_data = safe_memcpy(url_data, "http:///", 1024);
                   }
              break;
      case 'd': if(optarg != NULL){
                   dns_data = safe_memcpy(dns_data, optarg, 1024);
                   }
                else{
                   dns_data = safe_memcpy(dns_data, "127.0.0.1", 1024);
                   }
              break;

      default : printf("scanssl-%s $scanssl -d <DNS IP> -p <port> -t <timout> -c <cert time limmit> -u <https://URL> -m <print mode>\n",VERSION);
              free(senddata);
              free(url_data);
              free(dns_data);
              free(backdata);
              exit(1);
              break;
      }
   }

stat = urldompass_port(url_data, url_dom, url_pass, strlen(url_data)); 
if(stat > 0){
   port = stat;
   }


//#ifdef SSL_BUG
printf("SSL_BUG: scanssl(): url_data=<%s> url_dom=<%s> url_pass=<%s> url_port=<%d>\n", url_data, url_dom, url_pass, port);
//#endif

// ソケット生成
if((sk = socket(AF_INET6, SOCK_STREAM, 0))==-1){
   // ソケットつくれないので離脱
   printf("URL %s: Port %d: %s\n", url_data, port, SOCK_1);
   #ifdef SSL_BUG
   printf("SSL_BUG: scanssl(1): NOT CLEATE SOCKETS %s\n", backdata);
   #endif
   free(senddata);
   free(url_data);
   free(dns_data);
   free(backdata);
   exit(1);
   }


my_addr.sin6_family = AF_INET6;
my_addr.sin6_port = htons(port);


backdata = resolvename_sk(backdata, url_dom, timeout, (unsigned long * )&resoip6, dns_data, &resolv_ret, '6');


if(0 == (int)resoip6 || resoip6 == (int)NULL || resolv_ret < 0){
//if(resolv_ret < 0){
   // 名前解決出来ないので離脱
   printf("DNS %s: URL %s: %s\n", dns_data, url_dom, SOCK_12);
   #ifdef SSL_BUG
   fprintf(stderr,"RESOLV ERR: DNS name resolution failure <%s> <%s> <%s>\n", url_dom, backdata, dns_data);
   #endif
   free(senddata);
   free(url_data);
   free(dns_data);
   free(backdata);
   exit(1);
   }

memcpy(my_addr.sin6_addr.s6_addr, resoip6, sizeof(struct in6_addr));

ip_addr = (char *)inet_ntop(AF_INET6, &resoip6, buff, INET6_ADDRSTRLEN);


#ifdef SSL_BUG
printf("SSL_BUG: scanssl(3): %s\n", ip_addr);
#endif

// スタート時間をセット
dtv1 = gettimeofday_se();

// 非同期通信の開始 TCP ポートにコネ串ょん
fcntl(sk, F_SETFL, O_NONBLOCK);
re = connect(sk, (struct sockaddr *)(long)&my_addr, sizeof(my_addr));

// 速攻でつながった場合の処理
if(re >= 0){
   // 非同期通信から同期通信に
   fcntl(sk, F_SETFL, 0);
   dtv2 = gettimeofday_se();
   tcp_rtt = (dtv2 - dtv1) * 1000;
   #ifdef SSL_BUG
   printf("SSL_BUG: scan_url_connect(4): CONNECT SUCCESS %s\n", backdata);
   #endif
   goto notselect;
   }

// errno が EINPROGRESS なばやい
if(errno == EINPROGRESS){
   tv.tv_sec = timeout;
   tv.tv_usec = 0;
   while(1){
      FD_ZERO(&rfds);
      FD_SET(sk, &rfds);
      retval = select(sk + 1, NULL, &rfds, NULL, &tv);
      // select の異常終了
      if(retval < 0){
         printf("URL %s: Port %d: %s\n", url_data, port, SOCK_15);
         #ifdef SSL_BUG
         printf("SSL_BUG: scanssl(4): select error BREAK- %d - %s\n", retval, backdata);
         #endif
         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         close(sk);
         free(senddata);
         free(url_data);
         free(dns_data);
         free(backdata);
         // select へんなんで離脱
         exit(1);
         }

      // select のタイムアウト
      else if(retval == 0){
         dtv2 = gettimeofday_se();
         tcp_rtt = (dtv2 - dtv1) * 1000;
         printf("URL %s: Port %d: connect time=%7.4fms  %s\n", url_data, port, tcp_rtt, SOCK_16);
         #ifdef SSL_BUG
         printf("SSL_BUG: scanssl(5): select time out BREAK- %d - %s\n", retval, backdata);
         #endif
         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         close(sk);
         free(senddata);
         free(url_data);
         free(dns_data);
         free(backdata);
         // select timeout なので離脱
         exit(1);
         }
      // 時間内に接続出来たのでLoopOUTします
      else{
         dtv2 = gettimeofday_se();
         tcp_rtt = (dtv2 - dtv1) * 1000;
         #ifdef SSL_BUG
         printf("SSL_BUG: scanssl(6): select time succes BREAK-%d- %s\n", retval, backdata);
         #endif
         break;
         }
      }

   // 非同期通信から同期通信に
   fcntl(sk, F_SETFL, 0);

   // select を省いた GOTO
   notselect :;

   // ソケットに関するペンディングエラーを返す
   if(getsockopt(sk, SOL_SOCKET, SO_ERROR, (void *)&retval, (void *)&arglen) < 0){
      printf("URL %s: Port %d: %s\n", url_data, port, SOCK_13);
      #ifdef SSL_BUG
      printf("SSL_BUG: scanssl(): getsockopt(7) Errors!\n");
      #endif
      close(sk);
      free(senddata);
      free(url_data);
      free(dns_data);
      free(backdata);
      // getsockopt異常、離脱
      exit(1);
      }
   else{
      // エラーがある場合
      if(retval){

         printf("URL %s: Port %d: %s: %s\n", url_data, port, SOCK_23, (retval != 0) ? strerror(retval): "0");

//       printf("URL %s: Port %d: %s: %s\n", url_data, port, (retval != 0) ? strerror(retval): "0", SOCK_5);
         #ifdef SSL_BUG
         printf("SSL_BUG: scanssl(8): 1 SO_ERROR %d %s\n", retval, backdata);
         #endif
         close(sk);
         free(senddata);
         free(url_data);
         free(dns_data);
         free(backdata);
         // エラーがあるの
         exit(1);
         }

      // エラーが無い場合
      else{
         // SSL の初期化を実行
         /* SSL 用ディスクプリターの初期化 */
         SSL_load_error_strings();        // err を文字にする
         SSL_library_init();              // SSL/TLSの初期化
         ctx = SSL_CTX_new(SSLv23_client_method());
         if( ctx == NULL ){
            // ERR_print_errors_fp(stderr);
            printf("URL %s: Port %d: %s\n", url_data, port, "ssl_ctx object cannot be generated.");
            #ifdef SSL_BUG
            printf("SSL_BUG: scanssl(): SSL_CTX_new() failed:\n");
            #endif
            SSL_CTX_free(ctx);
            ERR_free_strings();
            close(sk);
            free(senddata);
            free(url_data);
            free(dns_data);
            free(backdata);
            // SSLライブラリが初期化できぬ
            exit(1);
            }

         // SSL幸三体の初期化
         ssl = SSL_new(ctx);

         if( ssl == NULL ){
            sslerr = SSL_get_error(ssl, ret);
            ERR_error_string(sslerr, swapdata);
            printf("URL %s: Port %d: %s: %s\n", url_data, port, swapdata, "structure cannot be initialized.");
            #ifdef SSL_BUG
            printf("SSL_BUG: scanssl(): SSL_new() failed: %s\n", swapdata);
            #endif
            SSL_free(ssl);
            SSL_CTX_free(ctx);
            ERR_free_strings();
            close(sk);
            free(senddata);
            free(url_data);
            free(dns_data);
            free(backdata);
            // SSL構造体が初期化できぬ
            exit(1);
            }

         /* SSL ディスクプリターとHTTPSのソケットディスクプリターの置き換え */
         ret = SSL_set_fd(ssl, sk);

         if( ret == 0 ){
            sslerr = SSL_get_error(ssl, ret);
            ERR_error_string(sslerr, swapdata);
            printf("URL %s: Port %d: %s: %s\n", url_data, port, swapdata, "descriptor cannot be made.");
            #ifdef SSL_BUG
            printf("SSL_BUG: scanssl(): SSL_set_fd() failed: %s\n", swapdata);
            #endif
            SSL_free(ssl);
            SSL_CTX_free(ctx);
            ERR_free_strings();
            close(sk);
            free(senddata);
            free(url_data);
            free(dns_data);
            free(backdata);
            // SSLディスクリプタのすり替えがしっぱい
            exit(1);
            }

         /* 擬似乱数 PRNG 初期化 */
         RAND_poll();
         while( RAND_status() == 0 ){
            unsigned short rand_ret = rand() % 65536;
            RAND_seed(&rand_ret, sizeof(rand_ret));
            }


         /* SSL でコネクト、TCPではすでに確立しているが、ここではSSLでの話 */

         if((tret = pthread_create( &t1, NULL, (void *)ssl_connect_th, (long int *)ssl)) != 0){
            fprintf(stderr,"scanssl.c pthread_create(0): %d %d\n",tret, errno);
            }
         if((tret = pthread_create( &t2, NULL, (void *)ssl_check_th, (long int *)timeout)) != 0){
            fprintf(stderr,"scanssl.c pthread_create(1): %d %d\n",tret, errno);
            }

          pthread_join( t2, NULL);

          safe_pthread_mutex_lock(&ssl_mutex);
          if(gb_mu == 0){
             pthread_mutex_unlock(&ssl_mutex);
             sslerr = SSL_get_error(ssl, ret);
             ERR_error_string(sslerr, swapdata);
             printf("URL %s: Port %d: connect time=%7.4fms: %s %s\n", url_data, port, tcp_rtt, swapdata, "SSL handshake err.");
             #ifdef SSL_BUG
             printf("SSL_BUG: scanssl(): SSL_connect() handshake failed: %d %s\n",ret, swapdata);
             #endif
             SSL_shutdown(ssl); 
             SSL_free(ssl);
             SSL_CTX_free(ctx);
             ERR_free_strings();
             close(sk);
             free(senddata);
             free(url_data);
             free(dns_data);
             free(backdata);
             exit(1);
             }
          pthread_mutex_unlock(&ssl_mutex);

          pthread_join( t1, NULL);

          ret = gb_ret;


         if( ret != 1 ){
            sslerr = SSL_get_error(ssl, ret);
            ERR_error_string(sslerr, swapdata);
            printf("URL %s: Port %d: %s: %s\n", url_data, port, swapdata, "SSL cannot be used.\n");
            #ifdef SSL_BUG
            printf("SSL_BUG: scanssl(): SSL_connect() failed: %d %s\n",ret, swapdata);
            #endif
            SSL_shutdown(ssl); 
            SSL_free(ssl);
            SSL_CTX_free(ctx);
            ERR_free_strings();
            close(sk);
            free(senddata);
            free(url_data);
            free(dns_data);
            free(backdata);
            // SSLでのコネクションが確立できぬ
            exit(1);
            }
         // SSL 初期化はここまで

/*
         // SSL 確認
         #ifdef SSL_BUG
         cipher  = SSL_get_current_cipher(ssl);

         backdata=safe_sprintf(backdata, BUF_MAX,
           "Cipher info:\n\tproversion=%s\n\tversion=%s\n\tname=%s\n\tbits=%d",
            SSL_get_version(ssl),
            SSL_CIPHER_get_version(cipher),
            SSL_CIPHER_get_name(cipher),
            SSL_CIPHER_get_bits(cipher, NULL));

         printf("SSL: scanssl(cipher): %s\n", backdata);
         #endif
*/

         // X509 の初期化 証明書関係の確認
         cert = SSL_get_peer_certificate (ssl);


/*
         backdata=safe_sprintf(backdata, BUF_MAX,
           "X509 info :\n\tsubject=%s\n\tissuer=%s\n\tcert length=%d\n\tPresent time=%d Before time=%d After time=%d\n\t%s",
            X509_NAME_oneline(X509_get_subject_name(cert), 0, 0),
            X509_NAME_oneline(X509_get_issuer_name(cert), 0, 0),
            cert_length, N_time, B_time, A_time,
            "It is outside the expiration date."); 

         #ifdef SSL_BUG
         printf("SSL_BUG: scanssl(cert): %s\n", backdata);
         #endif
*/


         if (cert != NULL) {
            cert_length = i2d_X509(cert, NULL);

            N_time = time(NULL);
            notBefore = X509_get_notBefore(cert);
            B_time = (int)cert_time_get((char *)notBefore->data);      // 期限開始
            notAfter  = X509_get_notAfter(cert);
            A_time = (int)cert_time_get((char *)notAfter->data);       // 期限終了
            Na_time = A_time - (time_t)cert_lim;                       // 期限しきい値


            // 証明書の有効期限を確認

            if(cert_lim != 0){                                            // 閾値が0で無い場合は詳細に
               if(B_time >= N_time){                                      // 有効期限に現在時間が達していない
                  /*                                                      // あまり意味を感じないのでとりあえずコメント 
                  printf("cert: %s=%d:%d:%d %s=%d:%d:%d %s=%d:%d:%d %s=%d:%d:%d info: %s\n",
                     X509_11,
                     utime_getr(N_time, 'y'),
                     utime_getr(N_time, 'm'),
                     utime_getr(N_time, 'd'),
                     X509_12,
                     utime_getr(B_time, 'y'),
                     utime_getr(B_time, 'm'),
                     utime_getr(B_time, 'd'),
                     X509_13,
                     utime_getr(A_time, 'y'),
                     utime_getr(A_time, 'm'),
                     utime_getr(A_time, 'd'),
                     X509_14,
                     utime_getr(Na_time, 'y'),
                     utime_getr(Na_time, 'm'),
                     utime_getr(Na_time, 'd'),
                     X509_1); 
                  #ifdef SSL_BUG
                  printf("SSL_BUG: scanssl(x509): %s\n", backdata);
                  #endif

                  X509_free(cert);
                  SSL_shutdown(ssl); 
                  close(sk);
                  SSL_free(ssl);
                  SSL_CTX_free(ctx);
                  ERR_free_strings();
                  free(senddata);
                  free(url_data);
                  free(dns_data);
                  free(backdata);
                  // 有効期限に達してないのでエラーはやすぎんだよ。
                  exit(1);
                  */
                  }
               else if(Na_time < N_time && (A_time - AF_TIME) > N_time){   // 現在時間が期限のしきい値内に入った
                  printf("cert: %s=%d:%d:%d %s=%d:%d:%d %s=%d:%d:%d %s=%d:%d:%d info: %s\n",
                     X509_11,
                     utime_getr(N_time, 'y'),
                     utime_getr(N_time, 'm'),
                     utime_getr(N_time, 'd'),
                     X509_12,
                     utime_getr(B_time, 'y'),
                     utime_getr(B_time, 'm'),
                     utime_getr(B_time, 'd'),
                     X509_13,
                     utime_getr(A_time, 'y'),
                     utime_getr(A_time, 'm'),
                     utime_getr(A_time, 'd'),
                     X509_14,
                     utime_getr(Na_time, 'y'),
                     utime_getr(Na_time, 'm'),
                     utime_getr(Na_time, 'd'),
                     X509_2); 
                  #ifdef SSL_BUG
                  printf("SSL_BUG: scanssl(x509): %s\n", backdata);
                  #endif
                  X509_free(cert);
                  SSL_shutdown(ssl); 
                  close(sk);
                  SSL_free(ssl);
                  SSL_CTX_free(ctx);
                  ERR_free_strings();
                  free(senddata);
                  free(url_data);
                  free(dns_data);
                  free(backdata);
                  // そろそろ注意だといってみる
                  exit(1);
                  }
               else if((A_time - AF_TIME) < N_time && A_time > N_time){   // 期限の残り3日いないに入った
                  printf("cert: %s=%d:%d:%d %s=%d:%d:%d %s=%d:%d:%d %s=%d:%d:%d info: %s\n",
                     X509_11,
                     utime_getr(N_time, 'y'),
                     utime_getr(N_time, 'm'),
                     utime_getr(N_time, 'd'),
                     X509_12,
                     utime_getr(B_time, 'y'),
                     utime_getr(B_time, 'm'),
                     utime_getr(B_time, 'd'),
                     X509_13,
                     utime_getr(A_time, 'y'),
                     utime_getr(A_time, 'm'),
                     utime_getr(A_time, 'd'),
                     X509_14,
                     utime_getr(Na_time, 'y'),
                     utime_getr(Na_time, 'm'),
                     utime_getr(Na_time, 'd'),
                     X509_3); 
                  #ifdef SSL_BUG
                  printf("SSL_BUG: scanssl(x509): %s\n", backdata);
                  #endif

                  X509_free(cert);
                  SSL_shutdown(ssl); 
                  close(sk);
                  SSL_free(ssl);
                  SSL_CTX_free(ctx);
                  ERR_free_strings();
                  free(senddata);
                  free(url_data);
                  free(dns_data);
                  free(backdata);
                  // のこり3日で離脱
                  exit(1);
                  }
               else if(A_time < N_time){                                // 期限を過ぎてしまいました
                  printf("cert: %s=%d:%d:%d %s=%d:%d:%d %s=%d:%d:%d %s=%d:%d:%d info: %s\n",
                     X509_11,
                     utime_getr(N_time, 'y'),
                     utime_getr(N_time, 'm'),
                     utime_getr(N_time, 'd'),
                     X509_12,
                     utime_getr(B_time, 'y'),
                     utime_getr(B_time, 'm'),
                     utime_getr(B_time, 'd'),
                     X509_13,
                     utime_getr(A_time, 'y'),
                     utime_getr(A_time, 'm'),
                     utime_getr(A_time, 'd'),
                     X509_14,
                     utime_getr(Na_time, 'y'),
                     utime_getr(Na_time, 'm'),
                     utime_getr(Na_time, 'd'),
                     X509_4); 
                  #ifdef SSL_BUG
                  printf("SSL_BUG: scanssl(x509): %s\n", backdata);
                  #endif

                  X509_free(cert);
                  SSL_shutdown(ssl); 
                  close(sk);
                  SSL_free(ssl);
                  SSL_CTX_free(ctx);
                  ERR_free_strings();
                  free(senddata);
                  free(url_data);
                  free(dns_data);
                  free(backdata);
                  // すぎちゃったの
                  exit(1);
                  }
               else {
                  #ifdef SSL_BUG
                  printf("SSL_BUG: scanssl(x509): %s\n", backdata);
                  #endif
                  }
               }
            else{                                                  // 閾値が0の場合はCERTの期限監視は行わない
//             fprintf(stderr,"SSL_BUG: scanssl(): 鍵の有効期限を過ぎていますが、閾値が0なので無視しています \n");
               }


            // X509 Verify 
            backdata = verify_ssl(backdata, ssl, &sslerr);

            if(sslerr != 0 && sslerr != 20){
               printf("509_verify NG: id %d: data %s\n", sslerr, backdata);
               #ifdef SSL_BUG
               printf("SSL_BUG: scanssl(x509_verify) NG: id=%d, data=%s\n", sslerr, backdata);
               #endif

               X509_free(cert);
               SSL_shutdown(ssl); 
               close(sk);
               SSL_free(ssl);
               SSL_CTX_free(ctx);
               ERR_free_strings();
               free(senddata);
               free(url_data);
               free(dns_data);
               free(backdata);
               // 証明書になにやら問題があるね。
               exit(1);
               }
            else{
               #ifdef SSL_BUG
               printf("SSL_BUG: scanssl(x509_verify) OK: id=%d, data=%s\n", sslerr, backdata);
               #endif
               }
            }
         else {
            printf("Server does not have certificate.\n");
            #ifdef SSL_BUG
            printf("SSL_BUG: scanssl(x509): %s\n", backdata);
            #endif
            X509_free(cert);
            SSL_shutdown(ssl); 
            close(sk);
            SSL_free(ssl);
            SSL_CTX_free(ctx);
            ERR_free_strings();
            free(senddata);
            free(url_data);
            free(dns_data);
            free(backdata);
            exit(1);
            }


         // cert の開放
         X509_free(cert);


         // SSL 確認はここまで

         backdata=safe_sprintf(backdata,BUF_MAX, "URL %s: Port %d: %s", url_data, port, SOCK_3);


//       senddata = set_request(senddata, url_dom, url_pass);
         self_set_request(senddata, url_dom, url_pass, BUF_LEN, "HEAD");

         #ifdef SSL_BUG
         printf("SSL_BUG: scanssl(9): set_request*send-%s- %s\n", senddata, backdata);
         #endif

         // 再度非同期通信の開始  SSL にした場合にFDはこれ使っていいのかな？？？
         fcntl(sk, F_SETFL, O_NONBLOCK);

         // スタート時間をセット
         rdtv1 = gettimeofday_se();

         // HEAD メソッドの送信 SSL専用の関数を使用。
         ret = SSL_write(ssl, senddata, strlen(senddata));

         tv.tv_sec = timeout;
         tv.tv_usec = 0;
         while(1){
            FD_ZERO(&rfds);
            FD_SET(sk, &rfds);
            retval = select(sk + 1, &rfds, NULL, NULL, &tv);
            // select 異常終了
            if(retval < 0){
               printf("URL %s: Port %d: %s: %s\n", url_data, port, SOCK_15, SELECT_5);
               #ifdef SSL_BUG
               printf("SSL_BUG: scanssl(10): select error %s\n", backdata);
               #endif 
               // 非同期通信から同期通信
               fcntl(sk, F_SETFL, 0);
               // SSL回りの開放
               SSL_shutdown(ssl); 
               close(sk);
               SSL_free(ssl);
               SSL_CTX_free(ctx);
               ERR_free_strings();
               free(senddata);
               free(url_data);
               free(dns_data);
               free(backdata);
               exit(1);
               }
            // select のタイムアウト
            else if(retval == 0){
               rdtv2 = gettimeofday_se();
               get_rtt = (rdtv2 - rdtv1) * 1000;
               printf("URL %s: Port %d: connect time=%7.4fms: read time=%7.4fms %s %s\n", url_data, port, tcp_rtt, get_rtt, SOCK_16, SELECT_6);
               #ifdef SSL_BUG
               printf("SSL_BUG: scanssl(11): select timed out %s\n", backdata); 
               #endif 
               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               // SSL回りの開放
               SSL_shutdown(ssl); 
               close(sk);
               SSL_free(ssl);
               SSL_CTX_free(ctx);
               ERR_free_strings();
               free(senddata);
               free(url_data);
               free(dns_data);
               free(backdata);
               exit(1);
               }
            else{
               // 受信 SSL専用の関数を使用。
               // dcount = SSL_read(ssl, recvdata, (256-1));
               dcount = ssl_read_timeout(ssl, recvdata, timeout, (256-1));
               recvdata[dcount] = 0x00;

               rdtv2 = gettimeofday_se();
               get_rtt = (rdtv2 - rdtv1) * 1000;

               // 受信量が異常
               if(dcount == 0){
                  printf("URL %s: Port %d: connect time=%7.4fms: read time=%7.4fms %s\n", url_data, port, tcp_rtt, get_rtt, SOCK_22);
                  // 非同期通信から同期通信に
                  fcntl(sk, F_SETFL, 0);
                  // SSL回りの開放
                  SSL_shutdown(ssl); 
                  close(sk);
                  SSL_free(ssl);
                  SSL_CTX_free(ctx);
                  ERR_free_strings();
                  free(senddata);
                  free(url_data);
                  free(dns_data);
                  free(backdata);
                  exit(1);
                  }
               else if(dcount == -1){
                  printf("URL %s: Port %d: connect time=%7.4fms: read time=%7.4fms %s\n", url_data, port, tcp_rtt, get_rtt, SOCK_21);
                  // 非同期通信から同期通信に
                  fcntl(sk, F_SETFL, 0);
                  // SSL回りの開放
                  SSL_shutdown(ssl); 
                  close(sk);
                  SSL_free(ssl);
                  SSL_CTX_free(ctx);
                  ERR_free_strings();
                  free(senddata);
                  free(url_data);
                  free(dns_data);
                  free(backdata);
                  exit(1);
                  }
               else if(dcount == -2){
                  printf("URL %s: Port %d: connect time=%7.4fms: read time=%7.4fms %s\n", url_data, port, tcp_rtt, get_rtt, SOCK_20);
                  // 非同期通信から同期通信に
                  fcntl(sk, F_SETFL, 0);
                  // SSL回りの開放
                  SSL_shutdown(ssl); 
                  close(sk);
                  SSL_free(ssl);
                  SSL_CTX_free(ctx);
                  ERR_free_strings();
                  free(senddata);
                  free(url_data);
                  free(dns_data);
                  free(backdata);
                  exit(1);
                  }
               else if(dcount < -2){
                  printf("URL %s: Port %d: connect time=%7.4fms: read time=%7.4fms %s\n", url_data, port, tcp_rtt, get_rtt, URL_2);
                  // 非同期通信から同期通信に
                  fcntl(sk, F_SETFL, 0);
                  // SSL回りの開放
                  SSL_shutdown(ssl); 
                  close(sk);
                  SSL_free(ssl);
                  SSL_CTX_free(ctx);
                  ERR_free_strings();
                  free(senddata);
                  free(url_data);
                  free(dns_data);
                  free(backdata);
                  exit(1);
                  }
               // 受信量が正常である
               else{
                  ssl_senddata = (char *)calloc((dcount + 10), sizeof(char));
                  // 200 番だいであることの確認
                  ssl_senddata = check_recvdata(recvdata, ssl_senddata, &ret);
                  swap_mem(ssl_senddata, ',', ' ');

                  if(ret < 0){
                     printf("URL %s: Port %d: connect time=%7.4fms: read time=%7.4fms %s\n", url_data, port, tcp_rtt, get_rtt, URL_1);
                     #ifdef SSL_BUG
                     printf("SSL_BUG: scanssl(13): url check. not 200. ret<%d> %s\n", ret, backdata);
                     #endif 
                     // 非同期通信から同期通信に
                     fcntl(sk, F_SETFL, 0);
                     // SSL回りの開放
                     SSL_shutdown(ssl); 
                     close(sk);
                     SSL_free(ssl);
                     SSL_CTX_free(ctx);
                     ERR_free_strings();
                     free(senddata);
                     free(url_data);
                     free(dns_data);
                     free(backdata);
                     free(ssl_senddata);
                     exit(1);
                     }
                  else{
                     if(mode != 0){
                        printf("URL %s: Port %d: connect time=%7.4fms: read time=%7.4fms %s %s\n", url_data, port, tcp_rtt, get_rtt, ssl_senddata, URL_4);
                        }
                     backdata = safe_sprintf(backdata, BUF_MAX,"%s: %s\n", ssl_senddata, URL_4);
                     #ifdef SSL_BUG
                     printf("SSL_BUG: scanssl(14): url check. all succesd. ret<%d> %s\n", ret, backdata);
                     #endif 
                     }

                  free(ssl_senddata);
                  }

               // 非同期通信から同期通信に
               fcntl(sk, F_SETFL, 0);
               // SSL回りの開放
               SSL_shutdown(ssl); 
               close(sk);
               SSL_free(ssl);
               SSL_CTX_free(ctx);
               ERR_free_strings();
               free(senddata);
               free(url_data);
               free(dns_data);
               free(backdata);
               exit(1);
               }
            }

         // 非同期通信から同期通信に
         fcntl(sk, F_SETFL, 0);
         // SSL回りの開放
         SSL_shutdown(ssl); 
         close(sk);
         SSL_free(ssl);
         SSL_CTX_free(ctx);
         ERR_free_strings();
         free(senddata);
         free(url_data);
         free(dns_data);
         free(backdata);
         exit(1);
         }
      }
   }

// 非同期通信
fcntl(sk, F_SETFL, 0);
backdata=safe_sprintf(backdata, BUF_MAX, "URL %s: Port %d errno=%d: %s", url_data, port, errno, SOCK_19);

#ifdef SSL_BUG
printf("SSL_BUG: scanssl(14): not connection err. %s\n", backdata); 
#endif 

close(sk);

free(senddata);
free(url_data);
free(dns_data);
free(backdata);
return 0;

}




