// #define V6ICMP_BUG

#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<sys/socket.h>
#include<sys/time.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/ip6.h>
#include<netinet/ip_icmp.h>
#include<netinet/icmp6.h>
#include<arpa/inet.h>

#include<sys/stat.h> 
#include<sys/un.h>

#include"sitar.h"
#include"sitar_scan.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"

extern global_data_t gd;





/*----------------- SCAN ICMP --------------------*/
char * scan_v6icmp(unsigned char * resoip, char * backdata, int timeout, int * stat, int coe, char * chid, int i, float * avrt)
{

int resolv_ret, seco;

int send_sk, hlen, id, recvin, ip_stat;
float rtt;
char send_buff[1024];
char recv_buff[1024];

char str[INET6_ADDRSTRLEN];

struct sockaddr_in6 send_addr;
struct timeval tv;
struct ip6_hdr *ip6;
struct icmp6_hdr *icmp6;
fd_set select_fd;

// http:// とかつけちゃった場合の救済
memset((char *)&send_addr, 0, sizeof(struct sockaddr_in6));
memset(send_buff, 0x00, 1024);
memset(recv_buff, 0x00, 1024);
memset(str, 0x00, INET6_ADDRSTRLEN);


// id は送信パケットの返事のものかを判別する。
id = (int)strtol(chid, (char **)NULL, 10);

// 初期化
rtt = 0.0;
// i = 2;
resolv_ret = 0;
seco = 0;


send_addr.sin6_family = AF_INET6;
memcpy(send_addr.sin6_addr.s6_addr, resoip, sizeof(struct in6_addr));


// RAW socketの生成
if((send_sk = socket(AF_INET6, SOCK_RAW, IPPROTO_ICMPV6)) < 0){
   backdata=safe_sprintf(backdata, BUF_MAX, "%s", ICMPA_1);
   #ifdef V6ICMP_BUG
   printf("V6ICMP: scan_v6icmp(2): SOCKET CREATE %s\n", backdata);
   #endif
   * stat = -10;
   return backdata;
   }

int offset = 2;
if(setsockopt(send_sk, IPPROTO_IPV6, IPV6_CHECKSUM, &offset, sizeof(offset))){
   #ifdef V6ICMP_BUG
   printf("V6ICMP: scan_v6icmp(3): socket option err\n");
   #endif
   }


// ICMPパケットの生成と送信
make_icmpv6_packet((struct icmp6_hdr *)&send_buff, 64, i, id);



if(sendto(send_sk, (char *)&send_buff, 64, 0, (struct sockaddr *)(long int)&send_addr, sizeof(send_addr)) < 0){
   backdata=safe_sprintf(backdata, BUF_MAX,"%s", ICMPA_2);
   #ifdef V6ICMP_BUG
   printf("V6ICMP: scan_v6icmp(4): SEND RAW SOCKET %s\n", backdata);
   #endif
   close(send_sk);
   * stat = -10;
   return backdata;
   }


tv.tv_sec = 0;
tv.tv_usec = 1000 * timeout;

while(1){

   ffread:

   FD_ZERO(&select_fd);
   FD_SET(send_sk, &select_fd);

   // select()でtime out をまつ
   if(select(send_sk + 1, &select_fd, NULL, NULL, &tv) <= 0){

      #ifdef V6ICMP_BUG
      printf("V6ICMP: scan_v6icmp(5): SELECT WAIT RAW SOCKET %s\n", backdata);
      #endif

      seco++;
      if(seco > 30000){
         backdata=safe_sprintf(backdata, BUF_MAX,"%s", ICMPA_3);
         break;
         }
      else{
         usleep(10);
         goto ffread;
         }
      }

   // FDに変化があった場合はrecvする
   if((recvin = recvfrom(send_sk, &recv_buff, 1024, 0, NULL, NULL)) < 0){
      backdata=safe_sprintf(backdata, BUF_MAX,"%s", ICMPA_4);
      #ifdef V6ICMP_BUG
      printf("V6ICMP: scan_v6icmp(6): RECVFROM RAW SOCKET %s\n", backdata);
      #endif
      close(send_sk);
      * stat = -10;
      return backdata;
      } 


   // 戻りデータからIPとICMPヘッダのポインターを得る
   ip6 = (struct ip6_hdr *)recv_buff;             // IP6 ヘッダ 先頭id
   hlen = sizeof(struct ip6_hdr);                 // IP6 ヘッダ 長さ
   icmp6 = (struct icmp6_hdr *)recv_buff;     // icmp6 ヘッダの先頭ID


   ip_stat = self_memcmp((char *)inet_ntop(AF_INET6, &send_addr.sin6_addr, str, INET6_ADDRSTRLEN),
     (char *)inet_ntop(AF_INET6, &ip6->ip6_src, str, INET6_ADDRSTRLEN));

   #ifdef V6ICMP_BUG
     printf("V6ICMP: scan_v6icmp(7): hlen=%d s_id=%d r_id=%d s_ip=%s r_srcip=%s r_dstip=%s r_nxt=%d r_type=%d r_seq=%d s_seq=%d\n",
     (recvin - hlen), id, ntohs(icmp6->icmp6_id), inet_ntop(AF_INET6, &send_addr.sin6_addr, str, INET6_ADDRSTRLEN),
     inet_ntop(AF_INET6, &ip6->ip6_src, str, INET6_ADDRSTRLEN),
     inet_ntop(AF_INET6, &ip6->ip6_dst, str, INET6_ADDRSTRLEN),
     ip6->ip6_nxt, icmp6->icmp6_type, ntohs(icmp6->icmp6_seq), i);
   #endif

   if(((recvin - hlen) >= 8) && (0 == ip_stat)){

      if(id == ntohs(icmp6->icmp6_id) && i == ntohs(icmp6->icmp6_seq)){

         gettimeofday(&tv, (struct timezone *)0);
         tvsub(&tv, (struct timeval *)(icmp6 + 1));
         rtt = tv.tv_sec * 1000.0 + tv.tv_usec / 1000.0;
         * avrt = rtt;

         // 戻ったパケットがエコーリプライの場合
         // 戻ったパケットのRTTを判断  RTTの時間は閾値が1の場合に100msec
         if(icmp6->icmp6_type == ICMP6_ECHO_REPLY){

            if(rtt > (timeout * coe)){
               backdata=safe_sprintf(backdata,BUF_MAX,"%s", ICMPA_5);
               #ifdef V6ICMP_BUG
               printf("V6ICMP: scan_v6icmp(8): ICMP6_ECHO_REPLY RECV RAW DATA NG! %s\n",  backdata);
               #endif
               close(send_sk);
               * stat = -2;
               return backdata;
               }

            else if(rtt <= (timeout * coe)){
               backdata=safe_sprintf(backdata,BUF_MAX,"%s", ICMPA_55);
               #ifdef V6ICMP_BUG
               printf("V6ICMP: scan_v6icmp(9): ICMP6_ECHO_REPLY RECV RAW DATA OK! %s\n", backdata);
               #endif
               close(send_sk);
               * stat = 0;
               return backdata;
               }
            else{
               backdata=safe_sprintf(backdata,BUF_MAX,"%s", ICMPA_5);
               #ifdef V6ICMP_BUG
               printf("V6ICMP: scan_v6icmp(10): ICMP6_ECHO_REPLY RTT err! %s\n",  backdata);
               #endif
               close(send_sk);
               * stat = -1;
               return backdata;
               }
            }

         // 戻ったパケットがエコーリクエストの場合、正常
         else if(icmp6->icmp6_type == ICMP6_ECHO_REQUEST){
            #ifdef V6ICMP_BUG
            printf("V6ICMP: scan_v6icmp(11): ICMP6_ECHO_REQUEST RECV RAW type<%d> sendip<%s> inip<%s>\n",
              icmp6->icmp6_type, 
              inet_ntop(AF_INET6, &send_addr.sin6_addr, str, INET6_ADDRSTRLEN),
              inet_ntop(AF_INET6, &ip6->ip6_src, str, INET6_ADDRSTRLEN));
            #endif
            }

         // 到達出来ないと帰った場合
         else if(icmp6->icmp6_type == ICMP6_DST_UNREACH){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_7, "dst_unreach");
            #ifdef V6ICMP_BUG
            printf("V6ICMP: scan_v6icmp(12): ICMP6_DST_UNREACH RECV RAW %s type<%d>\n", backdata, icmp6->icmp6_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            } 

         else if(icmp6->icmp6_type == ICMP6_DST_UNREACH_NOROUTE){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "no route to destination");
            #ifdef V6ICMP_BUG
            printf("V6ICMP: scan_v6icmp(13): ICMP6_DST_UNREACH_NOROUTE RECV RAW %s type<%d>\n", backdata, icmp6->icmp6_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp6->icmp6_type == ICMP6_DST_UNREACH_ADMIN){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "communication with destination");
            #ifdef V6ICMP_BUG
            printf("V6ICMP: scan_v6icmp(14): ICMP6_DST_UNREACH_ADMIN RECV RAW %s type<%d>\n", backdata, icmp6->icmp6_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp6->icmp6_type == ICMP6_DST_UNREACH_BEYONDSCOPE){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "beyond scope of source address");
            #ifdef V6ICMP_BUG
            printf("V6ICMP: scan_v6icmp(15): ICMP6_DST_UNREACH_BEYONDSCOPE RECV RAW %s type<%d>\n", backdata, icmp6->icmp6_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp6->icmp6_type == ICMP6_DST_UNREACH_ADDR){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "address unreachable");
            #ifdef V6ICMP_BUG
            printf("V6ICMP: scan_v6icmp(16): ICMP6_DST_UNREACH_ADDR RECV RAW %s type<%d>\n", backdata, icmp6->icmp6_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp6->icmp6_type == ICMP6_DST_UNREACH_NOPORT){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "bad port");
            #ifdef V6ICMP_BUG
            printf("V6ICMP: scan_v6icmp(17): ICMP6_DST_UNREACH_NOPORT RECV RAW %s type<%d>\n", backdata, icmp6->icmp6_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else{
            backdata=safe_sprintf(backdata,BUF_MAX,"%s", ICMPA_9);
            #ifdef V6ICMP_BUG
            printf("V6ICMP: scan_v6icmp(18): ather  RECV RAW %s type<%d>\n", backdata, icmp6->icmp6_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata; 
            }
         }
      }


   else{
      #ifdef V6ICMP_BUG
      printf("V6ICMP: scan_v6icmp(19): RECV RAW DATA sendip<%s> inip<%s>\n",
        inet_ntop(AF_INET6, &send_addr.sin6_addr, str, INET6_ADDRSTRLEN),
        inet_ntop(AF_INET6, &ip6->ip6_src, str, INET6_ADDRSTRLEN));
      #endif
      }
   }  // while(loop)


// 何もかえさずにタイムアウトした場合
rtt = tv.tv_sec*1000.0 + tv.tv_usec/1000.0;
* avrt = rtt;
backdata=safe_sprintf(backdata,BUF_MAX, "%s", ICMPA_01);
#ifdef V6ICMP_BUG
printf("V6ICMP: scan_v6icmp(20): END %s\n", backdata);
#endif

close(send_sk);
* stat = -1;
return backdata;
}




