// 2009/12/02
// このUDPチェックの仕組み
// 通常UDPのポートが開いているのかどうかを外部から確実に確認する術はないかもしれない
// でこの方法もかなりいい加減ですので、信用出来ません。
// このプログラムでは以下のことをしていますが、これ以外に対象がICMPをサポートしていることを確認して
// とりあえずポートの状態を見ています。あくまでかもしれないって程度です。
//
// UDPパケット送信用のソケットを作る
//       |
// ICMP受信用のソケットを作る
//       | 
// 対象のホスト、ポートに対してUDPパケットを送る
//       |                             |
// パケットが返ってこない       ICMPポート不達パケットが返る
//   |                                 |
//  ポートは開いているかも        ポートは開いてない
//

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<netdb.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/ip_icmp.h>
#include<errno.h>
#define __FAVOR_BSD

#include<netinet/udp.h>
#include<sys/stat.h>
#include<arpa/inet.h>

#include"sitar.h"
#include"sitar_scan.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"


extern global_data_t gd;

// #define UDP_BUG


/*----------------- SCAN UDP CONNECT --------------------*/
char * scan_udp(int port, unsigned long resoip, char * backdata, int timeout, int * stat, char * chid, float * avrt)
{

struct packet_udp {
   struct ip ip;
   struct udphdr udp;
   };
struct packet_udp sendpacket;

char recv_buff[1024];

int send_sk, recv_sk, select_stat, comax, retport, len, hlen1, portd, in_id;

struct icmp *icmp;
struct udphdr *udp;

struct ip *hip;
struct sockaddr_in send_addr;
struct timeval tv;
fd_set select_fd;

comax = 0;
portd = 0;


memset(recv_buff, 0x00, 1024);
memset((char *)&send_addr, 0, sizeof(struct sockaddr_in));

in_id = strtol(chid, (char **)NULL, 10);
retport = (34000 + in_id);

send_addr.sin_family = AF_INET;
send_addr.sin_addr.s_addr = resoip;



if((send_sk = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0){
   backdata=safe_sprintf(backdata,BUF_MAX, "%s %s", UDPA_1, strerror(errno));
   #ifdef UDP_BUG
   printf("UDP: scan_udp_connect(3): SEND UDP PACKET %s\n", backdata);
   #endif
   * stat = -10;
   return backdata;
   }
else{
   backdata=safe_sprintf(backdata,BUF_MAX, "%s", UDPA_11);
   }

if((recv_sk = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP)) < 0){
   backdata=safe_sprintf(backdata,BUF_MAX, "%s %s", UDPA_2, strerror(errno));
   * stat = -10;
   #ifdef UDP_BUG
   printf("UDP: scan_udp_connect(4): SEND ROW PACKET %s\n", backdata);
   #endif
   return backdata;
   }
else{
   backdata=safe_sprintf(backdata,BUF_MAX, "%s", UDPA_22);
   }


// RAW socket 
int on = 1;
if((setsockopt(send_sk, IPPROTO_IP, IP_HDRINCL, &on, sizeof(on))) <0){
   backdata=safe_sprintf(backdata,BUF_MAX, "%s", UDPA_3);
   }

len = sizeof(struct packet_udp);
memset((char *)&sendpacket, 0, sizeof(struct packet_udp));
make_udp_header(&(sendpacket.udp), port, retport);
make_ip_header(&(sendpacket.ip), 0, send_addr.sin_addr.s_addr, len);

if(sendto(send_sk, (char *)&sendpacket, len, 0, (struct sockaddr *)(long int)&send_addr, sizeof(send_addr)) < 0){
   backdata=safe_sprintf(backdata,BUF_MAX, "%s %s", UDPA_4, strerror(errno));
   #ifdef UDP_BUG
   printf("UDP: scan_udp_connect(4-1): %s\n", backdata);
   #endif
   close(send_sk);
   close(recv_sk);
   * stat = -1;
   return backdata;
   }
else{
   backdata=safe_sprintf(backdata,BUF_MAX, "%s", UDPA_44);
   }


tv.tv_sec = 0;
tv.tv_usec = 10000.0 * timeout;   // 1/100 秒

while(1){
   FD_ZERO(&select_fd);
   FD_SET(recv_sk, &select_fd);

   comax ++;

   // へんなパケットは拾う複数回recvがしくるとか とりあえず正常（ポートは開いていると判断）
   if(comax > 3000){
      backdata=safe_sprintf(backdata,BUF_MAX, "%s", UDPA_5);
      #ifdef UDP_BUG
      printf("UDP: scan_udp_connect(5): %s\n", backdata);
      #endif
      close(send_sk);
      close(recv_sk);
      * stat = 0;
      return backdata;
      }


   // selectで何か返った場合
   if((select_stat = select(recv_sk + 1, &select_fd, NULL, NULL, &tv)) > 0){
      struct ip *ip;
      int hlen;
      int ports;

      // 受信
      if(recvfrom(recv_sk, recv_buff, 1024, 0, NULL, NULL) != 56){
         #ifdef UDP_BUG
         printf("UDP: scan_udp_connect(5-1): ");
         #endif
         continue;   // 大きさが56でない場合はwhile()に戻る
         }

      // 受け取ったパケットからIP構造体に入れる
      ip = (struct ip *)(long int)recv_buff;
      hlen = ip->ip_hl << 2;

      // icmp 構造体の初期化
      icmp = (struct icmp*)(recv_buff + hlen);

      hip = (struct ip *)(long int)(recv_buff + hlen + 8);
      hlen1 = hip->ip_hl << 2;
      udp = (struct udphdr *)(long int)(recv_buff + hlen + 8 + hlen1);
      ports = (int)ntohs((u_short)udp->uh_dport);
      portd = (int)ntohs((u_short)udp->uh_sport);

      // 自分用のパケットで無い場合はwhile()に返る
      if((ports != port)
         || (ip->ip_p != IPPROTO_ICMP)
         || (retport != portd)
         || (hip->ip_p != IPPROTO_UDP)
         || (icmp->icmp_type != ICMP_UNREACH)
         || (icmp->icmp_code != ICMP_UNREACH_PORT)){
         #ifdef UDP_BUG
         printf("UDP: scan_udp_connect(6): retry SEND_ID=%d RECV_ID=%d PORT=%d PORTS=%d %s\n", retport, portd, port, ports, backdata);
         #endif
         continue; 
         }

      // 消去法で自分用のパケットunreachとからしい？ ステータス1正常で返るUDPチェック的にはエラーと判断。
      else{
         if(icmp->icmp_type == ICMP_UNREACH){
            backdata=safe_sprintf(backdata,BUF_MAX, "%s", UDPA_6);
            #ifdef UDP_BUG
            printf("UDP: scan_udp_connect(7): unreach? SEND_ID=%d RECV_ID=%d PORT=%d PORTS=%d %s\n", retport, portd, port, ports, backdata);
            #endif
            close(send_sk);
            close(recv_sk);
            * stat = -1;
            return backdata;
            }
         else if(icmp->icmp_type == ICMP_UNREACH_PORT){
            backdata=safe_sprintf(backdata,BUF_MAX, "%s", UDPA_7);
            #ifdef UDP_BUG
            printf("UDP: scan_udp_connect(17): unreach? SEND_ID=%d RECV_ID=%d PORT=%d PORTS=%d %s\n", retport, portd, port, ports, backdata);
            #endif
            close(send_sk);
            close(recv_sk);
            * stat = -1;
            return backdata;
            }
         else{
            backdata=safe_sprintf(backdata,BUF_MAX, "%s", UDPA_8);
            #ifdef UDP_BUG
            printf("UDP: scan_udp_connect(27): unreach? SEND_ID=%d RECV_ID=%d PORT=%d PORTS=%d %s\n", retport, portd, port, ports, backdata);
            #endif
            close(send_sk);
            close(recv_sk);
            * stat = -1;
            return backdata;
            }
         }
      }

   // selectでタイムアウトした場合エラーで終了(パケットが返ってこない）UDPチェック的には正常
   else{
      struct servent *se;
      se = getservbyport(htons(port), "udp");
      backdata=safe_sprintf(backdata,BUF_MAX, "%s %s", (se==NULL)?"unknown":se->s_name, UDPA_9);
      #ifdef UDP_BUG
      printf("UDP: scan_udp_connect(8): not recv %s\n", backdata);
      #endif
      close(send_sk);
      close(recv_sk);
      * stat = 0;
      return backdata;
      }

   #ifdef UDP_BUG
   printf("UDP: scan_udp_connect(9): else %s\n", backdata);
   #endif
   }


backdata=safe_sprintf(backdata,BUF_MAX, "%s", UDPA_01);
#ifdef UDP_BUG
printf("UDP: scan_udp_connect(10): END %s", backdata);
#endif


close(send_sk);
close(recv_sk);
* stat = -1;
return backdata;
}






