
#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<sys/socket.h>
#include<sys/time.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>

#define __FAVOR_BSD

#include<netinet/udp.h>
#include<netinet/ip_icmp.h>
#include<arpa/inet.h>

#include<sys/stat.h> 
#include<sys/un.h>
#include<pthread.h>

#include"sitar.h"
#include"sitar_scan.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"




extern pthread_mutex_t trace_mutex;
extern pthread_mutex_t traceport_mutex;

// #define TRACE_BUG

extern global_data_t gd;




#define COUNT_MAX 65

int make_counts(void)
{
int count, co, chk;
count = 0;
co = 0;
chk = 0;
while(1){
   for(co = 0; co < COUNT_MAX; co++){
      safe_pthread_mutex_lock(&traceport_mutex);
      if(gd.tr.uni[co] == 0){
         count = co;
         gd.tr.uni[co] = 1;
         pthread_mutex_unlock(&traceport_mutex);
         chk = 1;
         goto try;
         }
      pthread_mutex_unlock(&traceport_mutex);
      }
   try :
   if(chk == 0){
      fprintf(stderr, "make_counts(): wait count set ==%d==\n", count);
      sleep(4);
      }
   else{
      break;
      }
   }
return count;
}




int reset_counts(int count)
{
safe_pthread_mutex_lock(&traceport_mutex);
if(count >= 0 && count < COUNT_MAX){
   gd.tr.uni[count] = 0;
   }
else{
   count = -1;
   fprintf(stderr,"reset_count(): err\n");
   }
pthread_mutex_unlock(&traceport_mutex);
return count;
}



/*----------------- SCAN TRACE UDP --------------------*/
char * scan_traceudpsetopt(char * url_data, char * backdata, int timeout, int * stat, int coe, char * chid)
{
int resolv_ret;

struct packet_udp {
   struct ip ip;
   struct udphdr udp;
   };

struct packet_udp sendpacket;

int send_sk, recv_sk, hlen, hlen1, i, co, ttl, readc, ffreadc, con, cco, repo, ttlc, chklen, len;
int port, ports, portd, port_base, retport, in_id;
float rtt, rtttimeout, rtta, frttt;
float frtt[3];


unsigned long resoip;
char send_buff[1024];
char recv_buff[1024];
char ipa2[IP_LEN];
char ipa3[IP_LEN];
char ipa4[IP_LEN];
char ipax[BUF_URL];
char chkip[IP_LEN];
char chkip2[IP_LEN];
char ipx[BUF_URL];
char pas[BUF_URL];
char * ip_addr = ipx;
char * url_pass = pas;
char * ip_addr2 = ipa2;
char * ip_addr3 = ipa3;
char * ip_addrb = ipa4;
char * ip_addrx = ipax;
char * chkip_addr = chkip;
char * chkip_addr2 = chkip2;
char ip_addr4[64][IP_LEN];
char ntp[IP_LEN];
char * ntopbuff = ntp;

struct sockaddr_in send_addr;
struct timeval tv;
struct timeval tv0;
struct timeval tv1;
float outusec;
struct ip *ip;
struct ip *hip;
fd_set select_fd;

struct icmp *icmp;
struct udphdr *udp;

// 初期化

memset(ip_addr, 0x00, BUF_URL);
memset(ip_addrx, 0x00, BUF_URL);
memset(ip_addrb, 0x00, IP_LEN);
memset(ip_addr2, 0x00, IP_LEN);
memset(ip_addr3, 0x00, IP_LEN);
memset(chkip_addr, 0x00, IP_LEN);
memset(chkip_addr2, 0x00, IP_LEN);
memset(url_pass, 0x00, BUF_URL);
memset(ipa2, 0x00, IP_LEN);
memset(send_buff, 0x00, 1024);
memset(recv_buff, 0x00, 1024);

for(co = 0; co < 64; co++){
   memset(ip_addr4[co], 0x00, IP_LEN);
   }

rtt = 0.0;
rtta = 0.0;
rtttimeout = (float)(100 * timeout);
frtt[0] = 0.0;
frtt[1] = 0.0;
frtt[2] = 0.0;
frtt[3] = 0.0;
i = 0;
resolv_ret = 0;
readc = 0;
ffreadc = 0;
con = 0;
repo = 0;
outusec = 0.0;
ttlc = 0;

ports = 0;
portd = 0;

// traceroute用排他処理

port_base = make_counts();
port = port_base + 33434;

in_id = strtol(chid, (char **)NULL, 10);
retport = (33500 + in_id);

memset((char *)&send_addr, 0, sizeof(struct sockaddr_in));

// http:// とかつけちゃった場合の救済

urldompass_port(url_data, ip_addr, url_pass, strlen(url_data));

send_addr.sin_family = AF_INET;

// 名前解決

resoip = 0;
if(0 == self_memcmp(gd.di.dns_name, "RESOLV")){
   backdata = resolvename_th(backdata, ip_addr, timeout, &resoip);
   }
else{
   backdata = resolvename_sk(backdata, ip_addr, timeout, &resoip, gd.di.dns_name, &resolv_ret, '4');
   if(resolv_ret < 0){
      backdata = resolvename_sk(backdata, ip_addr, DEFAULT_TIMEOUT, &resoip, gd.di.dns_name2, &resolv_ret, '4');
      fprintf(stderr,"RESOLV ERR: DNS name resolution failure <%s> %s\n", ip_addr, backdata);
      }
   }

send_addr.sin_addr.s_addr = resoip;

if(0 == (int)send_addr.sin_addr.s_addr || resoip == (int)NULL){
   backdata = safe_sprintf(backdata,BUF_MAX, "%s %s\n", SOCK_2, ip_addr);
   #ifdef TRACE_BUG
   printf("TRACE: scan_traceudp(0): START %s\n", backdata);
   #endif
   * stat = -1;
   reset_counts(port_base);
   return backdata;
   }

ip_addr2 = (char *)inet_ntop(AF_INET, &send_addr.sin_addr, ntopbuff, IP_LEN);

// 目標IPを記憶

self_memcpy(ip_addr3, ip_addr2, IP_LEN);

// ID名をつける

self_memcpy(ip_addrx, chid, IP_LEN);
self_strncat(ip_addrx, "__", IP_LEN);
self_strncat(ip_addrx, ip_addr3, IP_LEN);

#ifdef TRACE_BUG
printf("TRACE: scan_traceudp(1): trace host<%s> ip<%s>\n", ip_addr, ip_addr2);
#endif


// 送信用 udp/ip RAW socketの生成

if((send_sk = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0){
   backdata=safe_sprintf(backdata, BUF_MAX, "HOST=%s IP=%s %s", ip_addr, ip_addr2, TRACE_1);
   #ifdef TRACE_BUG
   printf("TRACE: scan_traceudp(2): udp/ip send SOCKET NOT CREATE BREAK %s\n", backdata);
   #endif
   * stat = -2;
   reset_counts(port_base);
   return backdata;
   }

// 受信用 icmp RAW socketの生成

if((recv_sk = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP)) < 0){
   backdata=safe_sprintf(backdata, BUF_MAX, "HOST=%s IP=%s %s", ip_addr, ip_addr2, TRACE_1);
   #ifdef TRACE_BUG
   printf("TRACE: scan_traceudp(3): icmp recv SOCKET NOT CREATE BREAK %s\n", backdata);
   #endif
   * stat = -3;
   reset_counts(port_base);
   return backdata;
   }

int on = 1;
if((setsockopt(send_sk, IPPROTO_IP, IP_HDRINCL, &on, sizeof(on))) <0){
     printf("===============err\n");
     }


// 送信用 udp/ip RAW パケットの作成

len = sizeof(struct packet_udp);
memset((char *)&sendpacket, 0, sizeof(struct packet_udp));
make_udp_header(&(sendpacket.udp), port, retport);
make_ip_header(&(sendpacket.ip), 0, send_addr.sin_addr.s_addr, len);



// TTL のループ

for(ttl = 1, ttlc = 0; ttl <= 64; ttl++, ttlc++){
   sendpacket.ip.ip_ttl = ttl;

   frtt[0] = 0.0;
   frtt[1] = 0.0;
   frtt[2] = 0.0;
   frtt[3] = 0.0;

   // 3回送信するループ

   for(co = 0; co < 3; co++){

      // select から抜けた場合の戻り点

      ffreadc = 0;

      ffread: 

      if(ffreadc > 5){

         self_memcpy(ip_addr4[ttlc], (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN), IP_LEN);
         backdata=safe_sprintf(backdata, BUF_MAX,"(1)Target point %s Relay point %s %dhop id%d %s",
           ip_addr3, ip_addrb, ttlc, retport, TRACE_3);

         #ifdef TRACE_BUG
         printf("TRACE: scan_traceudp(4): SELECT TIME OUT RETRY %s %s %s %d %d\n",
           backdata, ip_addrx, ip_addr4[ttlc], port, retport);
         #endif

         close(send_sk);
         close(recv_sk);
         * stat = -4;
         reset_counts(port_base);
         return backdata;
         } 


      // 送信用 udp パケットの送信

      if(sendto(send_sk, (char *)&sendpacket, len, 0, (struct sockaddr *)(long int)&send_addr, sizeof(send_addr)) < 0){

         backdata=safe_sprintf(backdata, BUF_MAX,"HOST=%s IP=%s %s", ip_addr, ip_addr2, TRACE_2);

         #ifdef TRACE_BUG
         printf("TRACE: scan_traceudp(41): NOT SEND RAW SOCKET %s\n", backdata);
         #endif

         close(send_sk);
         close(recv_sk);
         * stat = -5;
         reset_counts(port_base);
         return backdata;
         }

      // パケット送信時刻の記録

      gettimeofday(&tv0, (struct timezone *)0);

      // select()の待ち時間をimeout * 1/10秒に設定

      tv.tv_sec = 0;
      tv.tv_usec = 100000.0 * timeout;
      outusec = 1000.0 * timeout;



      // 必要外パケットを受け取った場合の戻り点

      readc = 0;
      reread: 
      if(readc > 300){

         self_memcpy(ip_addr4[ttlc], (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN), IP_LEN);

         backdata=safe_sprintf(backdata, BUF_MAX,"ttl=%d HOST=%s IP=%s %s", ttlc, ip_addr, ip_addrb, TRACE_3);

         #ifdef TRACE_BUG
         printf("TRACE: scan_traceudp(5): NOT IPPROTO_ICMP PACKET BREAK %s\n", backdata);
         #endif

         close(send_sk);
         close(recv_sk);
         * stat = -6;
         reset_counts(port_base);
         return backdata;

         }

      FD_ZERO(&select_fd);
      FD_SET(recv_sk, &select_fd);


      // select()でtime out をまつ

      if(select(recv_sk + 1, &select_fd, NULL, NULL, &tv) <= 0){

         self_memcpy(ip_addr4[ttlc], (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN), IP_LEN);
         backdata=safe_sprintf(backdata, BUF_MAX,"(2)Target point %s Relay point %s %dhop id%d %s",
           ip_addr3, ip_addrb, ttlc, retport, TRACE_3);
         #ifdef TRACE_BUG
         printf("TRACE: scan_traceudp(4): SELECT TIME OUT  %s %s %s %d\n", backdata, ip_addrx, ip_addr4[ttlc], port);
         #endif

         ffreadc++;
         sleep((int)randdata(1, 4));
         goto ffread; 

         }


      // FDに変化があった場合はrecvする

      if(recvfrom(recv_sk, recv_buff, 1024, 0, NULL, NULL) < 0){
         backdata=safe_sprintf(backdata, BUF_MAX,"ttl=%d HOST=%s IP=%s %s", ttlc, ip_addr, ip_addr2, TRACE_3);

         #ifdef TRACE_BUG
         printf("TRACE: scan_traceudp(7): NOT RECV RAW PACKET BREAK %s\n", backdata);
         #endif

         close(send_sk);
         close(recv_sk);
         * stat = -7;
         reset_counts(port_base);
         return backdata;
         } 



      // 戻ったパケットのRTTを判断  RTTの時間は閾値が1の場合に100msec

      gettimeofday(&tv1, (struct timezone *)0);
      tvsub(&tv1, &tv0);
      frtt[co] = tv1.tv_sec * 1000.0 + tv1.tv_usec / 1000.0;


      // 受け取ったパケットからIP構造体に入れる

      ip = (struct ip *)(long int)recv_buff;
      hlen = ip->ip_hl << 2;




      // icmp 構造体の初期化

      icmp = (struct icmp *)(long int)(recv_buff + hlen);

      hip = (struct ip *)(long int)(recv_buff + hlen + 8);
      hlen1 = hip->ip_hl << 2;
      udp = (struct udphdr *)(long int)(recv_buff + hlen + 8 + hlen1);
      ports = (int)ntohs((u_short)udp->uh_dport);
      portd = (int)ntohs((u_short)udp->uh_sport);


      if((ports == port) && (ip->ip_p == IPPROTO_ICMP) && (retport == portd) && (hip->ip_p == IPPROTO_UDP)){

// printf("--udp packet ガッツ!!ポーズ ----DPORT=<%d> == SPORT=<%d> RETPORT=<%d> == PORTD=<%d> PROTO=%d\n",
//   port, ports, retport, portd, hip->ip_p);

         if(icmp->icmp_type == ICMP_TIMXCEED){
            self_memcpy(ip_addr4[ttlc], (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN), IP_LEN);

            self_memcpy(ip_addrb, ip_addr4[ttlc], IP_LEN);

            #ifdef TRACE_BUG
            printf("==%s==ICMP_TIMXCEED==%s= port=%d ports=%d ==%s==%s==%d==%d %d\n",
              chid, ip_addr, port, ports, ip_addrx, ip_addr4[ttlc], port, ttlc, retport);
            #endif

            frttt =  (frtt[0] + frtt[1] + frtt[2])/3;
            backdata=safe_sprintf(backdata,BUF_MAX,"ttl=%d %s :Average=%7.4fms %s",
               ttlc, (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
               frttt, TRACE_4);

            // RTTが閾値を越えた場合

            if(outusec < frttt){
               backdata=safe_sprintf(backdata,BUF_MAX,"ttl=%d %s :Average=%7.4fms > Limit=%7.4fms %s",
                  ttlc, (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
                  frttt, outusec, TRACE_7);
               close(send_sk);
               close(recv_sk);
               * stat = -20;
               reset_counts(port_base);
               return backdata;
               } 
            #ifdef TRACE_BUG
            printf("TRACE: scan_traceudp(8): TIMXCEED PACKET %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            }


         else if(icmp->icmp_type == ICMP_TIMXCEED_INTRANS){
            self_memcpy(ip_addr4[ttlc], (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN), IP_LEN);
            #ifdef TRACE_BUG
            printf("==%s==ICMP_TIMXCEED_INTRANS==%s= port=%d ports=%d ==%s==%s==%d==%d %d\n",
              chid, ip_addr, port, ports, ip_addrx, ip_addr4[ttlc], port, ttlc, retport);
            #endif
            frttt =  (frtt[0] + frtt[1] + frtt[2])/3;
            backdata=safe_sprintf(backdata,BUF_MAX,"ttl=%d %s :Average=%7.4fms %s",
               ttlc, (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
               frttt, TRACE_5);

            // RTTが閾値を越えた場合

            if(outusec < frttt){
               backdata=safe_sprintf(backdata,BUF_MAX,"ttl=%d %s :Average=%7.4fms > Limit=%7.4fms %s",
                  ttlc, (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
                  frttt, outusec, TRACE_8);
               close(send_sk);
               close(recv_sk);
               * stat = -20;
               reset_counts(port_base);
               return backdata;
               } 
            #ifdef TRACE_BUG
            printf("TRACE: scan_traceudp(9): TIMXCEED_INTRANS PACKET %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            }

         // おそらく目標地点に到達

         else if(icmp->icmp_type == ICMP_UNREACH_PORT){
            self_memcpy(ip_addr4[ttlc], (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN), IP_LEN);
            #ifdef TRACE_BUG
            printf("==%s==ttlc%d==ICMP_UNREACH_PORT==%s= port=%d ports=%d ==%s==%s==%d==%d %d\n",
              chid, ttlc, ip_addr, port, ports, ip_addrx, ip_addr4[ttlc], port, ttlc, retport);
            #endif
            frttt =  (frtt[0] + frtt[1] + frtt[2])/3;
            backdata=safe_sprintf(backdata,BUF_MAX,"ttl=%d %s :Average=%7.4fms %s",
               ttlc, (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
               frttt, TRACE_6);

            // RTTが閾値を越えた場合

            if(outusec < frttt){
               backdata=safe_sprintf(backdata,BUF_MAX,"ttl=%d %s :Average=%7.4fms > Limit=%7.4fms %s",
                  ttlc, (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
                  frttt, outusec, TRACE_9);
               close(send_sk);
               close(recv_sk);
               * stat = -20;
               reset_counts(port_base);
               return backdata;
               } 

            #ifdef TRACE_BUG
            printf("TRACE: scan_traceudp(10): REACH PACKET BREAK %s type<%d>\n", backdata, icmp->icmp_type);
            #endif

            repo++;

            // UN_REACHD_PORTで3回正常に戻った場合

            if(repo > 2){

               // 排他処理開始

               safe_pthread_mutex_lock(&trace_mutex);


               // 登録名を確認しあれば配列の番号をえる

               for(co = 0; co < gd.tr.trace_len; co++){

                  // 同じIPがすでに登録されている

                  if(0 == self_memcmp(gd.tr.trace_name[co], ip_addr3)){
                     #ifdef TRACE_BUG
                     printf("=======名前がすでに登録されている==%s==%s==%d====%s==%d\n",
                       url_data, ip_addrx, co, gd.tr.trace_name[co], port);
                     #endif
                     for(con = 0; con < 64; con++){
                        if(0x00 != ip_addr4[con][0]){
                           #ifdef TRACE_BUG
                           printf("===%s====配列の差異を確認==%s===%d==%d====%s ! %s==%d\n",
                             url_data, ip_addrx, co, con, gd.tr.trace_data[co][con], ip_addr4[con],port);
                           #endif

                           if(0 != self_memcmp(gd.tr.trace_data[co][con], ip_addr4[con])){

                              // 差異のある配列番号を帰して抜ける

                              #ifdef TRACE_BUG
                              printf("===差異あり==%s==%s===con=%d==%d====%s ! %s==%d\n",
                                url_data, ip_addrx, co, con, gd.tr.trace_data[co][con], ip_addr4[con], port);
                              #endif
                              self_memcpy(chkip_addr, gd.tr.trace_data[co][con], IP_LEN);
                              self_memcpy(chkip_addr2, ip_addr4[con], IP_LEN);
                              #ifdef TRACE_BUG
                              printf("===差異を記憶==%s=== %s\n", ip_addrx, chkip_addr);
                              #endif
                              for(cco = 0; cco < 64; cco++){
                                 gd.tr.trace_data[co][cco] = null_free(gd.tr.trace_data[co][cco]);
                                 }
                              for(cco = 0; cco <= ttlc; cco++){
                                 gd.tr.trace_data[co][cco] = safe_memcpy(gd.tr.trace_data[co][cco], ip_addr4[cco], IP_LEN);
                                 #ifdef TRACE_BUG
                                 printf("===違いをバッファに入れていく==%s==%d==%d==%s==%d\n",
                                   ip_addrx, co, cco, gd.tr.trace_data[co][cco], port);
                                 #endif
                                 }
                              #ifdef TRACE_BUG
                              printf("===差異あったので抜けます==%s===%d==%d====%s ! %s==%d\n",
                                ip_addrx, co, con, gd.tr.trace_data[co][con], ip_addr4[con], port);
                              #endif
                              chklen = con;
                              goto traout;
                              } 
                           }
                        }
                     #ifdef TRACE_BUG
                     printf("=======同じIPが登録されていた== %s == %s ==%d\n",
                       ip_addrx, ip_addr3, port);
                     #endif
                     chklen = -1;
                     goto traout;
                     }
                  }

               // 登録がないので新たに作る

               for(co = 0; co < gd.tr.trace_len; co++){

                  // 名前バッファの空の番号を探す

                  if(0x00 == gd.tr.trace_name[co][0]){

                     // 空の番号に名前を入れる

                     gd.tr.trace_name[co] = safe_memcpy(gd.tr.trace_name[co], ip_addr3, IP_LEN);
                     #ifdef TRACE_BUG
                     printf("=======名前を登録する==%s===%d====%s==%d\n",
                       ip_addrx, co, gd.tr.trace_name[co], port);
                     #endif

                     // 空の番号のデータバッファに情報を入れる

                     for(con = 0; con < ttlc; con++){
                        gd.tr.trace_data[co][con] = safe_memcpy(gd.tr.trace_data[co][con], ip_addr4[con], IP_LEN);
                        #ifdef TRACE_BUG
                        printf("==バッファにトレースIPを入れていく==%s==%d==%d==%s==%d\n",
                          ip_addrx, co, con, gd.tr.trace_data[co][con], port);
                        #endif
                        }
                     chklen = -1;
                     goto traout;
                     }
                  } 

               // バッファーが足らないので-10を帰す

               chklen = -10;

               // バッファーが足りて書き込めた場合の移動点
               traout:


               #ifdef TRACE_BUG
               printf("==CHKLEN=%d===%s\n", chklen, backdata);
               #endif

               // 排他処理終了

               pthread_mutex_unlock(&trace_mutex);

               // バッファーがたらない

               if(-10 == chklen){
                  * stat = -9;
                  backdata=safe_sprintf(backdata,BUF_MAX,"%s :Average=%7.4fms %s",
                     (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
                     frttt, TRACE_11);
                  #ifdef TRACE_BUG
                  printf("==-10 %s == chklen ====%s\n", url_data, backdata);
                  #endif
                  }

               // 差異がある

               else if(0 <= chklen){
                  * stat = -10;
                  backdata=safe_sprintf(backdata,BUF_MAX,"%s :Average=%7.4fms %dhop %s ! %s id=%s %s",
                     (char *)inet_ntop(AF_INET, (struct in_addr *)(long int)&(ip->ip_src.s_addr), ntopbuff, IP_LEN),
                     frttt, chklen, chkip_addr, chkip_addr2, chid, TRACE_10);
                  #ifdef TRACE_BUG
                  printf("== 0 <= %s chklen ====%s\n", url_data, backdata);
                  #endif
                  }

               // それ意外

               else{
                  * stat = 1;
                  #ifdef TRACE_BUG
                  printf("= それいがい ===%s==%s\n", url_data, backdata);
                  #endif
                  }

               close(send_sk);
               close(recv_sk);
               reset_counts(port_base);
               return backdata;
               }
            }  
         else{
            #ifdef TRACE_BUG
            printf("TRACE: scan_traceudp(11): These remains PACKET type<%d> %s %s %d\n", icmp->icmp_type, ip_addrx, ip_addr4[ttlc], port);
            #endif
            readc++;
            goto reread;
            }
         }
      else{

// printf("--udp packet 残念！！----DPORT=<%d> == SPORT=<%d> RETPORT=<%d> == PORTD=<%d> PROTO=%d\n",
//   port, ports, retport, portd, hip->ip_p);


         #ifdef TRACE_BUG
         printf("TRACE: scan_traceudp(): RE READING PACKET %s port %d != Ports %d || retport %d != portd %d PROTO=%d\n",
           ip_addr2, port, ports, retport, portd, hip->ip_p);
         #endif

         readc++;
         goto reread;
         }


      }  // for(3)

   } // TTL


close(send_sk);
close(recv_sk);
* stat = -8;
reset_counts(port_base);
return backdata;
}




