// #define TCP_BUG6

#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<fcntl.h>
#include<errno.h>

#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>

#include<arpa/inet.h>

#include<sys/stat.h>
#include<sys/socket.h>
#include<sys/time.h>

#include"sitar.h"
#include"sitar_scan.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"

extern global_data_t gd;


/*----------------- SCAN TCP CONNECT --------------------*/
char * scan_tcp6(unsigned char * resoip, int port, char * backdata, int timeout, int * stat, int by, float * avrt, int mode, int * sk)
{
char pas[BUF_URL];
char * url_pass = pas;
char bu[IP_LEN];
char * buff = bu;
char s_time[IP_LEN];
char * start_time = s_time;

int re, retval, arglen, resolv_ret, co;
struct sockaddr_in6 my_addr;

fd_set rfds;

double dtv1;
double dtv2;
struct timeval tv;
float rtt;

arglen = sizeof(int);

errno = 0;
resolv_ret = 0;
co = 0;
rtt = 0.0;

memset(url_pass, 0x00, BUF_URL);
memset(buff, 0x00, IP_LEN);
memset(start_time, 0x00, IP_LEN);

// ソケットを作る
if((* sk = socket(AF_INET6, SOCK_STREAM, 0))==-1){ 
   backdata=safe_sprintf(backdata,BUF_MAX, "TCP %s", SOCK_1);
   * stat = -10;
   #ifdef TCP_BUG6
   printf("TCP6: scan_tcp6(1): NOT CLEATE SOCKET %s\n", backdata);
   #endif
   return backdata;
   }

// スタート時間をセット
dtv1 = gettimeofday_se();

// IPヘッダのセット
my_addr.sin6_family = AF_INET6; 
my_addr.sin6_port = htons(port); 
memcpy(my_addr.sin6_addr.s6_addr, resoip, sizeof(struct in6_addr));


#ifdef TCP_BUG6
printf("TCP6: scan_tcp6(3): start TCPCHECK\n");
#endif

fcntl(* sk, F_SETFL, O_NONBLOCK);

// 即座にCONNECT出来た場合
if((re = connect(* sk, (struct sockaddr *)(long)&my_addr, sizeof(my_addr))) >= 0){
   // connectionまでの時間を得る
   dtv2 = gettimeofday_se();
   rtt = (dtv2 - dtv1) * 1000;
   * avrt = rtt;

   backdata=safe_sprintf(backdata,BUF_MAX, "TCP %s", SOCK_3);
   #ifdef TCP_BUG6
   printf("TCP6: scan_tcp6(4): CONNECT SUCCESS %s\n", backdata);
   #endif
   fcntl(* sk, F_SETFL, 0);
   if(mode == 0){
      close(* sk);
      }
   * stat = 1;
   return backdata;
   }
// 即座にCONNECT出来ない場合
else{
   if(errno == EINPROGRESS){
      tv.tv_sec = timeout;
      tv.tv_usec = 0;

      while(1){
         FD_ZERO(&rfds);
         FD_SET(* sk, &rfds);
         retval = select(* sk + 1, NULL, &rfds, NULL, &tv);

         // connectionまでの時間を得る
         dtv2 = gettimeofday_se();
         rtt = (dtv2 - dtv1) * 1000;
         * avrt = rtt;

         if(retval < 0){
            rtt = 0.0;
            * avrt = rtt;
            backdata=safe_sprintf(backdata,BUF_MAX, "%s %s", SOCK_15, SOCK_5);
            #ifdef TCP_BUG6
            printf("TCP6: scan_tcp6(5): select err BREAK-%d- %s %s\n", retval, backdata, strerror(errno));
            #endif
            fcntl(* sk, F_SETFL, 0);
            if(mode == 0){
               close(* sk);
               }
            * stat = -1;
            return backdata;
            }
         else if(retval == 0){
            rtt = 0.0;
            * avrt = rtt;
            backdata=safe_sprintf(backdata,BUF_MAX, "%s %s", SOCK_16, SOCK_5);
            #ifdef TCP_BUG6
            printf("TCP6: scan_tcp6(6): select time out BREAK-%d- %s %s\n", retval, backdata, strerror(errno));
            #endif
            fcntl(* sk, F_SETFL, 0);
            if(mode == 0){
               close(* sk);
               }
            * stat = -1;
            return backdata;
            }
         // CONNECT出来た
         else{
            backdata=safe_sprintf(backdata,BUF_MAX, "%s", SOCK_3);
            #ifdef TCP_BUG6
            printf("TCP6: scan_tcp6(7): select time succes BREAK-%d- %s\n", retval, backdata);
            #endif
            break;
            }
         }

      fcntl(* sk, F_SETFL, 0);

      if(getsockopt(* sk, SOL_SOCKET, SO_ERROR, (void *)&retval, (void *)&arglen) < 0){
         rtt = 0.0;
         * avrt = rtt;
         backdata=safe_sprintf(backdata,BUF_MAX, "%s %s", SOCK_13, strerror(errno));
         #ifdef TCP_BUG6
         printf("TCP6: scan_tcp6(8): getsockopt() Errors!\n");
         #endif
         if(mode == 0){
            close(* sk);
            }
         * stat = -1;
         return backdata;
         }
      else{
         if(retval){
            rtt = 0.0;
            * avrt = rtt;
            backdata=safe_sprintf(backdata,BUF_MAX, "%s: %s", SOCK_23, (retval != 0) ? strerror(retval): "0");
            #ifdef TCP_BUG6
            printf("TCP6: scan_tcp6(9): 1 SO_ERROR %d -\n", retval);
            printf("%s\n", backdata);
            #endif
            if(mode == 0){
               close(* sk);
               }
            * stat = -1;
            return backdata;
            }
         else{
            if(rtt > (timeout * by)){
               backdata=safe_sprintf(backdata,BUF_MAX,"%s", SOCK_24);
               #ifdef TCP_BUG6
               printf("TCP6: scan_tcp6(10-0): TIME OUT ERR AT=%7.4fms retval=%d\n", rtt, retval);
               #endif
               if(mode == 0){
                  close(* sk);
                  }
               * stat = -2;
               return backdata;
               }
           else if(rtt <= (timeout * by)){
               backdata=safe_sprintf(backdata,BUF_MAX,"%s", SOCK_3);
               #ifdef ICMP_BUG
               printf("TCP6: scan_tcp6(10-1): GOOD AT=%7.4fms retval=%d\n", rtt, retval);
               #endif
               if(mode == 0){
                  close(* sk);
                  }
               * stat = 1;
               return backdata;
               }
            else{
               backdata=safe_sprintf(backdata,BUF_MAX,"%s", SOCK_4);
               #ifdef TCP_BUG6
               printf("TCP6: scan_tcp6(10-2): TIME OUT ERR ? AT=%7.4fms retval=%d\n", rtt, retval);
               #endif
               if(mode == 0){
                  close(* sk);
                  }
               * stat = -2;
               return backdata;
               }
            }
         }
      }
   // errno が EINPROGRESS 意外の場合
   else{
      rtt = 0.0;
      * avrt = rtt;
      backdata=safe_sprintf(backdata,BUF_MAX, "%s %s", SOCK_25, strerror(errno));
      #ifdef TCP_BUG6
      printf("TCP6: scan_tcp6(10-2): CONNECT ERR ? %s\n", strerror(errno));
      #endif
      if(mode == 0){
         close(* sk);
         }
      * stat = -1;
      return backdata;
      } 
   }

fcntl(* sk, F_SETFL, 0);



backdata=safe_sprintf(backdata,BUF_MAX, "errno=%d: TCP %s AT=%7.4fms", errno, SOCK_19, rtt); 

#ifdef TCP_BUG6
printf("TCP6: scan_tcp6(11): --- LAST END ---\n");
printf("%s\n", backdata);
#endif
if(mode == 0){
   close(* sk);
   * stat = -1;
   }
else{
   * stat = -1;
   }

return backdata;

}





