
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<netdb.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<fcntl.h>

#include <sys/select.h>
#include <signal.h>

#include<sys/stat.h>
#include<errno.h>

#include"sitar.h"
#include"sitar_scan.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"

// #define STAT_BUG


extern global_data_t gd;


/*----------------- SCAN STAT CONNECT --------------------*/
char * scan_stat(int sk, char * backdata, char * stat, int stat_len, int timeout, int * pst, float * avrt)
{
int ret, retval, dcount, by;
fd_set rfds;
struct timeval tv;
char recvd[BUF_LEN];
char sendd[BUF_LEN];
char * recvdata = recvd;
char * senddata = sendd;
double dtv1;
double dtv2;
float rtt;

memset(recvdata, 0x00, BUF_LEN);
memset(senddata, 0x00, BUF_LEN);

// struct buf_data bd;

ret = -1;
errno = 0;
dcount = 0;
by = 1000;
dtv1 = 0.0;
dtv2 = 0.0;
rtt = 0.0;

// とりあえず、STATからの200番の返事をまちます

tv.tv_sec = timeout;
tv.tv_usec = 0;

FD_ZERO(&rfds);
FD_SET(sk, &rfds);

retval = select(sk + 1, &rfds, NULL, NULL, &tv);

// select 異常終了
if(retval < 0){
   backdata=safe_sprintf(backdata,BUF_MAX, "%s", STATA_1);
   #ifdef STAT_BUG
   printf("STAT: scan_stat(1): retval 0 ERR =%s==\n", backdata);
   #endif 
   * pst = -1;
   return backdata;
   }
// select のタイムアウト
else if(retval == 0){
   backdata = safe_sprintf(backdata,BUF_MAX, "%s", STATA_2);
   #ifdef STAT_BUG
   printf("STAT: scan_stat(2): retval 1 ERR %s\n", backdata); 
   #endif 
   * pst = -1;
   return backdata;
   }
else{

   // ファイル読み取り時間計測開始
   dtv1 = gettimeofday_se();

   // fdに変化があったので読んでみたりするテスト
   dcount = socket_readasth(sk, recvdata, BUF_LEN, timeout, 1);

   // ファイル読み取り時間の取得
   dtv2 = gettimeofday_se();
   rtt = (dtv2 - dtv1) * 1000;
   * avrt = rtt;


   #ifdef STAT_BUG
   printf("STAT: scan_stat(3): recv-- %s --\n", recvdata);
   #endif

   // 受信量が異常
   if(dcount == 0){
      backdata = safe_sprintf(backdata,BUF_MAX, "%s" , STATA_3);
      * pst = -1;
      return backdata;
      }
   else if(dcount == -1){
      backdata = safe_sprintf(backdata,BUF_MAX, "%s" , STATA_4);
      * pst = -1;
      return backdata;
      }
   else if(dcount == -2){
      backdata = safe_sprintf(backdata,BUF_MAX, "%s" , STATA_5);
      * pst = -1;
      return backdata;
      }
   else if(dcount < -2){
      backdata = safe_sprintf(backdata,BUF_MAX, "%s" , STATA_6);
      * pst = -1;
      return backdata;
      }
   // 受信量は正常
   else{

      // 受け取り時間を比較
      if(rtt > (float)(timeout * by)){
         backdata=safe_sprintf(backdata,BUF_MAX,"%s", STATA_7);
         #ifdef SMTP_BUG
         printf("STAT: scan_stat(4): TIME OUT ERR RTT=%7.4fms retval=%d\n", rtt, retval);
         #endif
         * pst = -2;
         return backdata;
         }
      else if(rtt <= (float)(timeout * by)){
         backdata=safe_sprintf(backdata,BUF_MAX,"%s", STATA_77);
         #ifdef SMTP_BUG
         printf("STAT: scan_stat(5): GOOD AT=%7.4fms retval=%d\n", rtt, retval);
         #endif
         * pst = 0;
         }
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,"%s", STATA_7);
         #ifdef SMTP_BUG
         printf("STAT: scan_stat(6): TIME OUT ERR ? AT=%7.4fms retval=%d\n", rtt, retval);
         #endif
         * pst = -2;
         return backdata;
         }

      ch_char(recvdata, senddata);

      rm_char(senddata, '\r');
      rm_char(senddata, '\n');
      swap_mem(senddata, '\t', ' ');
      swap_mem(senddata, ',', ' ');

      // 戻り値の比較
      if(0 == memcmp(recvdata, stat, stat_len)){
         ret = 0;
         }
      else{
         ret = -1;
         }

      // 戻り値が等しくない
      if(ret < 0){
         backdata = safe_sprintf(backdata, BUF_MAX,"%s: %s", senddata, STATA_8);
         #ifdef STAT_BUG
         printf("STAT: scan_stat(7): ret<%d><%d> recvdata<%s> backdata<%s>\n", ret, * pst, recvdata, backdata);
         #endif
         * pst = ret;
         return backdata;
         }
      // 戻り値が等しい
      else{
         backdata = safe_sprintf(backdata, BUF_MAX,"%s: %s", senddata, STATA_9);
         #ifdef STAT_BUG
         printf("STAT: scan_stat(8): ret<%d><%d> recvdata<%s> backdata<%s>\n",
           ret,*pst, recvdata, backdata);
         #endif
         * pst = ret;
         return backdata;
         }
      }
   }  // select()


backdata=safe_sprintf(backdata,BUF_MAX, "%s", SOCK_19);

* pst = -1;
return backdata;

}




