
#include<stdio.h>
#include<netinet/in.h>
#include<stdlib.h>
#include<string.h>
#include<time.h>
#include<unistd.h>

#include<pthread.h>
#include"sitar.h"
#include"sitar_scan.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"



/* ------ SCAN PORT --------- */
int scan_port(private_data_t *pd)
{
int st;
int ret;
int inA;
int inB;
int out;
int by;

float fld;

ret = -1;
inA = 0;
inB = 0;
out = 1;
by = 100; // ICMPのしきい値が1の場合、10msec (0.1秒)
fld =0.0;
// by = 10; // ICMPのしきい値が1の場合、10msec (0.01秒)


st = 0;

if((self_memcmp(pd->sb.ch_prot, "HOST")) == 0){
   pd->sb.ch_info = scan_host(pd->sb.ch_com, pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, &ret);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot, "SNTP")) == 0){
   pd->sb.ch_info = scan_sntp_connect(123, pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, &ret);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot, "TRAC")) == 0){

   pd->sb.ch_info=scan_traceudpsetopt(pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, &ret, by, pd->sb.ch_free3); 

   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot, "ICMP")) == 0){
   pd->sb.ch_info=scan_icmpav(pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, &ret, by, pd->sb.ch_free3, 10, 4);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot, "V6ICMP")) == 0){
   pd->sb.ch_info=scan_icmpav(pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, &ret, by, pd->sb.ch_free3, 10, 6);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
// 過去のICMP2の互換、現在はICMPと同じもの
else if((self_memcmp(pd->sb.ch_prot, "ICMP2")) == 0){
   pd->sb.ch_info=scan_icmpav(pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, &ret, by, pd->sb.ch_free3, 10, 4);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }



else if((self_memcmp(pd->sb.ch_prot,"URL")) == 0){
   pd->sb.ch_info=scan_urlav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 4, 0, pd->sb.ch_free3);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"GET")) == 0){
   pd->sb.ch_info=scan_urlav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 4, 1, pd->sb.ch_free3);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"DEF")) == 0){
   pd->sb.ch_info=scan_urlav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 4, 3, pd->sb.ch_free3);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"OPT")) == 0){
   pd->sb.ch_info=scan_urlav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 4, 2, pd->sb.ch_free3);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"URL6")) == 0){
   pd->sb.ch_info=scan_urlav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 6, 0, pd->sb.ch_free3);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"GET6")) == 0){
   pd->sb.ch_info=scan_urlav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 6, 1, pd->sb.ch_free3);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"DEF6")) == 0){
   pd->sb.ch_info=scan_urlav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 6, 3, pd->sb.ch_free3);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"OPT6")) == 0){
   pd->sb.ch_info=scan_urlav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 6, 2, pd->sb.ch_free3);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }


else if((self_memcmp(pd->sb.ch_prot,"SSL6")) == 0){
   //  1209600 = 2週間の秒　証明証が安全に更新出来る時間
   time_t lim;
   if(0 <= ch_int2(pd->sb.ch_com)){
      lim = (86400 * strtol(pd->sb.ch_com, (char **)NULL, 10));
      }
   else{
      lim = 1209600;
      }
   #ifdef SSL_BUG
   printf("SSL_BUG: scan_ssl_connect(x509): limit time = %ld\n", lim);
   #endif

   pd->sb.ch_info=scan_ssl_command(pd->sb.port, pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, lim, &ret, pd->sb.ch_plai, 6);

   if(0 == (int)strlen(pd->sb.ch_info)){
      if(ret > -1){
         pd->sb.ch_info=safe_sprintf(pd->sb.ch_info, BUF_MAX,"port=%d host_data=%s: %s\n", pd->sb.port, pd->sb.ch_host, HTTPS_1);
         }
      else{
         pd->sb.ch_info=safe_sprintf(pd->sb.ch_info, BUF_MAX,"port=%d host_data=%s: %s\n", pd->sb.port, pd->sb.ch_host, HTTPS_2);
         }
      }
   #ifdef SSL_BUG
   printf("SSL_BUG: scan_ssl_connect(): %d, %s, <%s>, %d, %d, %d, %s\n"
     ,pd->sb.port, pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, lim, ret, pd->sb.ch_plai);
   #endif
   }


else if((self_memcmp(pd->sb.ch_prot,"SSL")) == 0){
   //  1209600 = 2週間の秒　証明証が安全に更新出来る時間
   time_t lim;
   if(0 <= ch_int2(pd->sb.ch_com)){
      lim = (86400 * strtol(pd->sb.ch_com, (char **)NULL, 10));
      }
   else{
      lim = 1209600;
      }
   #ifdef SSL_BUG
   printf("SSL_BUG: scan_ssl_connect(x509): limit time = %ld\n", lim);
   #endif

   pd->sb.ch_info=scan_ssl_command(pd->sb.port, pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, lim, &ret, pd->sb.ch_plai, 4);

   if(0 == (int)strlen(pd->sb.ch_info)){
      if(ret > -1){
         pd->sb.ch_info=safe_sprintf(pd->sb.ch_info, BUF_MAX,"port=%d host_data=%s: %s\n", pd->sb.port, pd->sb.ch_host, HTTPS_1);
         }
      else{
         pd->sb.ch_info=safe_sprintf(pd->sb.ch_info, BUF_MAX,"port=%d host_data=%s: %s\n", pd->sb.port, pd->sb.ch_host, HTTPS_2);
         }
      }
   #ifdef SSL_BUG
   printf("SSL_BUG: scan_ssl_connect(): %d, %s, <%s>, %d, %d, %d, %s\n"
     ,pd->sb.port, pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout, lim, ret, pd->sb.ch_plai);
   #endif
   }



else if((self_memcmp(pd->sb.ch_prot,"MYSQL")) == 0){

   pd->sb.ch_info = db_data_delim(pd->sb.ch_info, pd->sb.ch_host, pd, &ret);

   if(ret > -1){

      if(pd->db.port == 0){
         pd->db.port = pd->sb.port;
         }
      if(pd->db.timeout == 0){
         pd->db.timeout = pd->sb.timeout;
         }

      pd->sb.ch_info = scan_mysql_command(pd->sb.ch_info,
                         pd->sb.ch_com, pd->db.server, pd->db.username, pd->db.passwd,
                         pd->db.database, pd->db.port, pd->db.timeout, &ret, pd->sb.ch_plai);

      if(0 == (int)strlen(pd->sb.ch_info)){
         if(ret > -1){
            pd->sb.ch_info=safe_sprintf(pd->sb.ch_info, BUF_MAX,"port=%d: pass=%s: user=%s: db=%s: Query=%s: %s\n",
               pd->db.port,pd->db.passwd, pd->db.username, pd->db.database, pd->sb.ch_com, MYSQL_1);
            }
         else{
            pd->sb.ch_info=safe_sprintf(pd->sb.ch_info, BUF_MAX,"port=%d: pass=%s: user=%s: db=%s: Query=%s: %s\n",
               pd->db.port, pd->db.passwd, pd->db.username, pd->db.database, pd->sb.ch_com, MYSQL_2);
            }

         }
      #ifdef MYSQL_BUG
      printf("port=%d: pass=%s: user=%s: db=%s: Query=%s: %s\n",
         pd->db.port, pd->db.passwd, pd->db.username, pd->db.database, pd->sb.ch_com, MYSQL_2);
      #endif
      }

   db_malloc_null(pd);
   }





else if((self_memcmp(pd->sb.ch_prot,"PGSQL")) == 0){

   pd->sb.ch_info = db_data_delim(pd->sb.ch_info, pd->sb.ch_host, pd, &ret);

   if(ret > -1){

      if(pd->db.port == 0){
         pd->db.port = pd->sb.port;
         }
      if(pd->db.timeout == 0){
         pd->db.timeout = pd->sb.timeout;
         }

      pd->sb.ch_info = scan_psql_command(pd->sb.ch_info,
                         pd->sb.ch_com, pd->db.server, pd->db.username, pd->db.passwd,
                         pd->db.database, pd->db.port, pd->db.timeout, &ret, pd->sb.ch_plai);

      if(0 == (int)strlen(pd->sb.ch_info)){
         if(ret > -1){
            pd->sb.ch_info=safe_sprintf(pd->sb.ch_info, BUF_MAX,"port=%d: pass=%s: user=%s: db=%s: Query=%s: %s\n",
               pd->db.port,pd->db.passwd, pd->db.username, pd->db.database, pd->sb.ch_com, PGSQL_1);
            }
         else{
            pd->sb.ch_info=safe_sprintf(pd->sb.ch_info, BUF_MAX,"port=%d: pass=%s: user=%s: db=%s: Query=%s: %s\n",
               pd->db.port, pd->db.passwd, pd->db.username, pd->db.database, pd->sb.ch_com, PGSQL_2);
            }

         }
      #ifdef PGSQL_BUG
      printf("port=%d: pass=%s: user=%s: db=%s: Query=%s: %s\n",
          pd->db.port,pd->db.passwd, pd->db.username, pd->db.database, pd->sb.ch_com, PGSQL_1);
      #endif
      }

   db_malloc_null(pd);
   }




else if((self_memcmp(pd->sb.ch_prot,"SMTP")) == 0){
   pd->sb.ch_info = scan_smtpav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 4);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot,"SMTP6")) == 0){
   pd->sb.ch_info = scan_smtpav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), 5, 6);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot,"FTP")) == 0){
   pd->sb.ch_info = scan_statav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, "220", 3, (by * 10), 5, 4);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"POP")) == 0){
   pd->sb.ch_info = scan_statav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, "+OK", 3, (by * 10), 5, 4);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"SSH")) == 0){
   pd->sb.ch_info = scan_statav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, "SSH", 3, (by * 10), 5, 4);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot,"FTP6")) == 0){
   pd->sb.ch_info = scan_statav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, "220", 3, (by * 10), 5, 6);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"POP6")) == 0){
   pd->sb.ch_info = scan_statav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, "+OK", 3, (by * 10), 5, 6);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
else if((self_memcmp(pd->sb.ch_prot,"SSH6")) == 0){
   pd->sb.ch_info = scan_statav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, "SSH", 3, (by * 10), 5, 6);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot,"DHW")) == 0){
   pd->sb.ch_info = scan_dhw_connect(pd->sb.ch_com, pd->sb.port, pd->sb.ch_host, pd->sb.ch_info, pd->sb.timeout,&ret);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot, "TCP")) == 0){
   pd->sb.ch_info=scan_tcpav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), pd->sb.ch_free3, 5, 4);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot, "TCP6")) == 0){
   pd->sb.ch_info=scan_tcpav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, (by * 10), pd->sb.ch_free3, 5, 6);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }

else if((self_memcmp(pd->sb.ch_prot, "UDP")) == 0){
   pd->sb.ch_info = scan_udpav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, by, pd->sb.ch_free3, 10, 4);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }
// 実装されてない
else if((self_memcmp(pd->sb.ch_prot, "UDP6")) == 0){
   pd->sb.ch_info = scan_udpav(pd->sb.ch_host, pd->sb.port, pd->sb.ch_info, pd->sb.timeout, &ret, by, pd->sb.ch_free3, 10, 6);
   if(0 == (int)strlen(pd->sb.ch_info)){
      pd->sb.ch_info=safe_memcpy(pd->sb.ch_info,"Information is a no bur error.\n",BUF_MAX);
      }
   }






// ret は各監視が正常かどうかの監視自体が返したステータス
// sb.check_statはretと同じになるが、条件による


// テストとログモードの処理
if(0 == self_memcmp(pd->sb.ch_plai, "4")){
   out = 4;
   #ifdef SCAN_PORT_DEBUG
   printf("SCAN_PORT: scan_port(): port chack out = %d\n", out);
   #endif
   if(2 > strlen(pd->sb.ch_info)){
      pd->sb.ch_info = safe_memcpy(pd->sb.ch_info, COM_3, BUF_MAX );
      }
   ret = -1;
   }
else if(0 == self_memcmp(pd->sb.ch_plai, "11")){
   if(2 > strlen(pd->sb.ch_info)){
      pd->sb.ch_info = safe_memcpy(pd->sb.ch_info, COM_4, BUF_MAX );
      }
   #ifdef SCAN_PORT_DEBUG
   printf("SCAN_PORT: scan_port(): plai = %s ret = %d\n", pd->sb.ch_plai, ret);
   #endif
   if(ret == -1){
      pd->sb.ch_plai = safe_memcpy(pd->sb.ch_plai, "1", BUF_MAX);
      }
   ret = -1;
   }
else if(0 == self_memcmp(pd->sb.ch_plai, "12")){
   if(2 > strlen(pd->sb.ch_info)){
      pd->sb.ch_info = safe_memcpy(pd->sb.ch_info, COM_4, BUF_MAX );
      }
   #ifdef SCAN_PORT_DEBUG
   printf("SCAN_PORT: scan_port(): plai = %s ret = %d\n", pd->sb.ch_plai, ret);
   #endif
   if(ret == -1){
      pd->sb.ch_plai = safe_memcpy(pd->sb.ch_plai, "2", BUF_MAX);
      }
   ret = -1;
   }
else if(0 == self_memcmp(pd->sb.ch_plai, "13")){
   if(2 > strlen(pd->sb.ch_info)){
      pd->sb.ch_info = safe_memcpy(pd->sb.ch_info, COM_4, BUF_MAX );
      }
   #ifdef SCAN_PORT_DEBUG
   printf("SCAN_PORT: scan_port(): plai = %s ret = %d\n", pd->sb.ch_plai, ret);
   #endif
   if(ret == -1){
      pd->sb.ch_plai = safe_memcpy(pd->sb.ch_plai, "3", BUF_MAX);
      }
   ret = -1;
   }



// check_statの設定 正か逆かで反転する。
// 監視の正逆の判断 check_stat == 1 はエラー 0は正常
if(ret < 0){

   if(0 == self_memcmp(pd->sb.ch_stat, "0")){
      pd->sb.check_stat = 1;
      }
   else if(0 == self_memcmp(pd->sb.ch_stat, "1")){
      pd->sb.check_stat = 0;
      }
   // 4は無制限でエラー
   if(0 == self_memcmp(pd->sb.ch_plai, "4")){
      pd->sb.check_stat = 1;
      }

   }

if(ret >= 0){

   if(0 == self_memcmp(pd->sb.ch_stat, "1")){
      pd->sb.check_stat = 1;
      }
   else if(0 == self_memcmp(pd->sb.ch_stat, "0")){
      pd->sb.check_stat = 0;
      }
   // 4は無制限でエラー
   if(0 == self_memcmp(pd->sb.ch_plai, "4")){
      pd->sb.check_stat = 1;
      }
   }

return 0;
}



