// #define ICMPAV_BUG

#include<stdio.h>
#include<string.h>
#include<unistd.h>

#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/ip_icmp.h>
#include<netinet/ip6.h>
#include<netinet/icmp6.h>

#include<arpa/inet.h>

#include<sys/socket.h>
#include<sys/time.h>
#include<sys/stat.h>
#include<sys/un.h>

#include<pthread.h>
#include"sitar.h"
#include"sitar_scan.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"

extern global_data_t gd;


/* url_data = 監視対象のアドレス、http://ms-n.com/index.htm とかでも良い
 * ch_info  = 監視の状態を返す文字列、戻り値も同じポインター
 * timeout  = 監視の時間的なしきい値
 * ret      = 良い ret == 0, 悪い ret < 0
 * by       = しきい値の倍率、100にした場合timeoutが1の場合に100.000mscをしきい値とする
 * ch_id    = ここで送信するICMPパケットの識別ID、ユニークである必要がある。
 * comax    = 送信回数
 * fa       = IPアドレスファミリーがV6の場合は6、V4の場合は4、それ以外だとV4になる。
 */

char * scan_icmpav(char * url_data, char * ch_info, int timeout, int * ret, int by, char * ch_id, int comax, int fa)
{
int co;
int errcount;
int rttcount;
int laststat;
int resolv_ret;
char * goodata;
char * errdata;
float avrt;
float rtt;
float toprtt;
float limrtt;

char ipa2[IP_LEN];
char ipx[BUF_URL];
char pas[BUF_URL];
char ntp[IP_LEN];
char * ip_addr2 = ipa2;
char * ip_addr = ipx;
char * url_pass = pas;
char * ntopbuff = ntp;
unsigned char resoip6[sizeof(struct in6_addr)];
unsigned long resoip;

// 変数の初期化
errdata = (char *)calloc(BUF_LEN, sizeof(char));
goodata = (char *)calloc(BUF_LEN, sizeof(char));

memset(ip_addr2, 0x00, IP_LEN);
memset(ip_addr, 0x00, BUF_URL);
memset(url_pass, 0x00, BUF_URL);
memset(resoip6, 0x00, sizeof(struct in6_addr));
memset(ntopbuff, 0x00, IP_LEN);

co=0;
errcount=0;
laststat=0;
avrt = 0.0;
rtt = 0.0;
toprtt = 0.0;
rttcount = 0;
resolv_ret = 0;
resoip = 0;
limrtt = (float)(timeout * by);


// URL からアドレスを取り出す
urldompass_port(url_data, ip_addr, url_pass, strlen(url_data));

// IPV6 の場合の名前解決
if(fa == 6){  // ipv6
   errdata = resolvename_sk(errdata, ip_addr, timeout, (unsigned long * )&resoip6, gd.di.dns_name, &resolv_ret, '6');
   if(resolv_ret < 0){
      errdata = resolvename_sk(errdata, ip_addr, DEFAULT_TIMEOUT, (unsigned long * )&resoip6, gd.di.dns_name2, &resolv_ret, '6');
      fprintf(stderr,"RESOLV ERR: DNS name resolution failure <%s> %s\n", ip_addr, errdata);
      }

   if(0 == (int)resoip6 || resoip6 == (int)NULL || resolv_ret < 0){
      ch_info = safe_sprintf(ch_info, BUF_LEN, "%s %s %s\n", ip_addr, SOCK_2, errdata);
      * ret = -1;
      free(errdata);
      free(goodata);
      return ch_info;
      }

   ip_addr2 = (char *)inet_ntop(AF_INET6, &resoip6, ntopbuff, INET6_ADDRSTRLEN);

   }
// IPV4 の場合の名前解決
else{  // ipv4 or else
   if(0 == self_memcmp(gd.di.dns_name, "RESOLV")){
      errdata = resolvename_th(errdata, ip_addr, timeout, &resoip);
      }
   else{
      errdata = resolvename_sk(errdata, ip_addr, timeout, (unsigned long * )&resoip, gd.di.dns_name, &resolv_ret, '4');
      if(resolv_ret < 0){
         errdata = resolvename_sk(errdata, ip_addr, DEFAULT_TIMEOUT, (unsigned long * )&resoip, gd.di.dns_name2, &resolv_ret, '4');
         fprintf(stderr,"RESOLV ERR: DNS name resolution failure <%s> %s\n", ip_addr, errdata);
         }
      }
   if(0 == (int)resoip || resoip == (int)NULL){
      ch_info = safe_sprintf(ch_info, BUF_LEN, "%s %s %s\n", ip_addr, SOCK_2, errdata);
      * ret = -1;
      free(errdata);
      free(goodata);
      return ch_info;
      }
   ip_addr2 = (char *)inet_ntop(AF_INET, &resoip, ntopbuff, IP_LEN);
   }



// パケット送信繰り返しループ
for(co = 1; co < comax; co++){

   // IPV6 の場合のパケット送信受信
   if(fa == 6){  
      ch_info = scan_v6icmp(resoip6, ch_info, timeout, ret, by, ch_id, co, &rtt);
      }
   // IPV4 の場合のパケット送信受信
   else{  
      ch_info = scan_icmp(resoip, ch_info, timeout, ret, by, ch_id, co, &rtt);
      }

   #ifdef ICMPAV_BUG
   printf("HOST:%s IP:%s :LIMIT RTT=%7.4fms AVERAGE RTT=%7.4fms rttcount=%d co=%d errcount=%d host=%s info=%s timeout=%d ret=%d by=%d ch_id=%s\n",
    ip_addr, ip_addr2, limrtt, rtt, rttcount, co, errcount, url_data, ch_info, timeout, * ret, by, ch_id); 
   #endif

   // エラーの解釈とその計測の条件分岐
   // 普通にエラー
   if(* ret ==  -1){
      // RTTの値がある場合はカウントする。
      if(rtt > 0.0){
         rttcount++;
         avrt = rtt + avrt;
         if(rtt > toprtt){ toprtt = rtt; }
         rtt = 0.0;
         }
      errcount++;
      errdata = safe_memcpy(errdata, ch_info, BUF_LEN);
      }
  // RTTがしきい値を越えている場合はLossのカウントをしない
  else if(* ret == -2){
      rttcount++;
      avrt = rtt + avrt;
      if(rtt > toprtt){ toprtt = rtt; }
      rtt = 0.0;
      errdata = safe_memcpy(errdata, ch_info, BUF_LEN);
      // 初めの回は大目に見る
      if(co > 1){
         laststat = 1;
         break;
         }
      }
  // send 出来ないとsoketが作れないとかの基本エラー
  else if(* ret == -10){
      errcount++;
      laststat = 2;
      errdata = safe_memcpy(errdata, ch_info, BUF_LEN);
      break;
      }
  // 問題がない場合 
  else{
      goodata = safe_memcpy(goodata, ch_info, BUF_LEN);
      rttcount++;
      avrt = rtt + avrt;
      if(rtt > toprtt){ toprtt = rtt; }
      rtt = 0.0;
      }
   usleep(10000);
   }


// 平均RTTの計算
if(rttcount > 0 && avrt > 0){
   rtt = avrt / rttcount;
   }
else{
   rtt = 0.0;
   }


// 戻り出力、テキストの生成
// RTTしきい値越え
if(laststat == 1){
   ch_info = safe_sprintf(ch_info, BUF_LEN, "%s: IP=%s: SEND PACKET=%d LOSS=%d : AVERAGE RTT=%7.4fms TOP=%7.4fms LIMIT=%7.4fms\n",
     errdata, ip_addr2, co, errcount, rtt, toprtt, limrtt);
   * ret = -1;
   }
// 名前解決などの基本エラー
else if(laststat == 2){
   ch_info = safe_sprintf(ch_info, BUF_LEN, "%s: IP=%s: HOST=%s\n", errdata, ip_addr2, ip_addr);
   * ret = -1;
   }
// その他エラーと正常な場合
else{
   // パケットロスが多い。
   if(errcount > (comax / 5)){
      ch_info = safe_sprintf(ch_info, BUF_LEN, "%s: IP=%s: SEND PACKET=%d LOSS=%d : AVERAGE RTT=%7.4fms TOP=%7.4fms LIMIT=%7.4fms\n",
        errdata, ip_addr2, co, errcount, rtt, toprtt, limrtt);
      * ret = -1;
      }
   else{
      ch_info = safe_sprintf(ch_info, BUF_LEN, "%s: IP=%s: SEND PACKET=%d LOSS=%d : AVERAGE RTT=%7.4fms TOP=%7.4fms LIMIT=%7.4fms\n",
        goodata, ip_addr2, co, errcount, rtt, toprtt, limrtt);
      * ret = 0;
      }
   }


free(errdata);
free(goodata);

return ch_info;
}


