// #define ICMP_BUG

#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<sys/socket.h>
#include<sys/time.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/ip_icmp.h>
#include<arpa/inet.h>
#include<errno.h>

#include<sys/stat.h> 
#include<sys/un.h>

#include"sitar.h"
#include"sitar_scan.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"

extern global_data_t gd;





/*----------------- SCAN ICMP --------------------*/
char * scan_icmp(unsigned long resoip, char * backdata, int timeout, int * stat, int coe, char * chid, int i, float * avrt)
{
int resolv_ret;

int send_sk, hlen, id, seco;
float rtt;
char send_buff[1024];
char recv_buff[1024];

struct sockaddr_in send_addr;
struct timeval tv;
struct ip *ip;
fd_set select_fd;

id = strtol(chid, (char **)NULL, 10);

// 初期化
rtt = 0.0;
// i = 128;
resolv_ret = 0;
seco = 0;

memset((char *)&send_addr, 0, sizeof(struct sockaddr_in));
memset(send_buff, 0x00, 1024);
memset(recv_buff, 0x00, 1024);

send_addr.sin_family = AF_INET;
send_addr.sin_addr.s_addr = resoip;

// RAW socketの生成
if((send_sk = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP)) < 0){
   backdata=safe_sprintf(backdata, BUF_MAX, "%s %s", ICMPA_1, strerror(errno));
   #ifdef ICMP_BUG
   printf("ICMP: scan_icmp(2): SOCKET CREATE %s\n", backdata);
   #endif
   * stat = -10;
   return backdata;
   }

// ICMPパケットの生成と送信 RTT計測の為にパケット内に時間を埋め込む
make_icmp8_packet((struct icmp *)(long int)send_buff, 72, i, id);

if(sendto(send_sk, (char *)&send_buff, 72, 0, (struct sockaddr *)(long int)&send_addr, sizeof(send_addr)) < 0){
   backdata=safe_sprintf(backdata, BUF_MAX,"%s %s", ICMPA_2, strerror(errno));
   #ifdef ICMP_BUG
   printf("ICMP: scan_icmp(3): SEND RAW SOCKET %s\n", backdata);
   #endif
   close(send_sk);
   * stat = -10;
   return backdata;
   }

tv.tv_sec = 0;
tv.tv_usec = 1000 * timeout;


while(1){

   ffread: 

   FD_ZERO(&select_fd);
   FD_SET(send_sk, &select_fd);

   // select()でtime out をまつ
   if(select(send_sk + 1, &select_fd, NULL, NULL, &tv) <= 0){
      seco++;
      if(seco > 30000){
         backdata=safe_sprintf(backdata, BUF_MAX,"%s", ICMPA_3);
         break;
         } 
      else{
         usleep(10);
         goto ffread;
         }
      }

   // FDに変化があった場合はrecvする
   if(recvfrom(send_sk, recv_buff, 1024, 0, NULL, NULL) < 0){
      backdata=safe_sprintf(backdata, BUF_MAX,"%s %s", ICMPA_4, strerror(errno));
      #ifdef ICMP_BUG
      printf("ICMP: scan_icmp(4): RECV RAW SOCKET %s\n", backdata);
      #endif
      close(send_sk);
      * stat = -10;
      return backdata;
      } 

   // 戻ったパケットを判断
   ip = (struct ip *)(long int)recv_buff;
   hlen = ip->ip_hl << 2;
   struct icmp *icmp;
   icmp = (struct icmp *)(long int)(recv_buff + hlen);

   #ifdef ICMP_BUG
   printf("send_id=%d recv_id=%d send_seq=%d recv_seq=%d\n", id, ntohs(icmp->icmp_id), i, ntohs(icmp->icmp_seq));
   #endif

   if(ip->ip_src.s_addr == send_addr.sin_addr.s_addr){

      if(id == ntohs(icmp->icmp_id) && i == ntohs(icmp->icmp_seq)){

         gettimeofday(&tv, (struct timezone *)0);
         tvsub(&tv, (struct timeval *)(icmp->icmp_data));
         rtt = tv.tv_sec * 1000.0 + tv.tv_usec / 1000.0;
         * avrt = rtt;

         // 戻ったパケットのRTTを判断  RTTの時間は閾値が1の場合に100msec
         if(icmp->icmp_type == ICMP_ECHOREPLY){

            if(rtt > (timeout * coe)){
               backdata=safe_sprintf(backdata,BUF_MAX,"%s", ICMPA_5);
               #ifdef ICMP_BUG
               printf("ICMP: scan_icmp(5): RECV RAW DATA NG! %s\n",  backdata);
               #endif
               close(send_sk);
               * stat = -2;
               return backdata;
               }

            else if(rtt <= (timeout * coe)){
               backdata=safe_sprintf(backdata,BUF_MAX,"%s", ICMPA_55);
               #ifdef ICMP_BUG
               printf("ICMP: scan_icmp(6): RECV RAW DATA OK! %s\n", backdata);
               #endif
               close(send_sk);
               * stat = 0;
               return backdata;
               }
            else{
               backdata=safe_sprintf(backdata,BUF_MAX,"%s", ICMPA_5);
               #ifdef ICMP_BUG
               printf("ICMP: scan_icmp(5): RTT err! %s\n",  backdata);
               #endif
               close(send_sk);
               * stat = -1;
               return backdata;
               }

            }

         // 戻ったパケットがエコーリプライの場合、正常
         else if(icmp->icmp_type == ICMP_ECHO){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s", ICMPA_66);
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(7): RECV RAW type<%d> sendip<%d> inip<%d>\n",
              icmp->icmp_type, send_addr.sin_addr.s_addr, ip->ip_src.s_addr);
            #endif
            }

         // 到達出来ないと帰った場合
         else if(icmp->icmp_type == ICMP_UNREACH){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_7, "icmp_unreach");
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(8): RECV RAW %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            } 

         else if(icmp->icmp_type == ICMP_UNREACH_NET){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "Network Unreachable");
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(8): RECV RAW %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_HOST){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "Host Unreachable");
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(8): RECV RAW %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_PROTOCOL){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "Protocol Unreachable");
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(8): RECV RAW %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_PORT){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "Port Unreachable");
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(8): RECV RAW %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_NEEDFRAG){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "Fragmentation Needed/DF set");
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(8): RECV RAW %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else if(icmp->icmp_type == ICMP_UNREACH_SRCFAIL){
            backdata=safe_sprintf(backdata,BUF_MAX,"%s %s", ICMPA_8, "Source Route failed");
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(8): RECV RAW %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         else{
            backdata=safe_sprintf(backdata,BUF_MAX,"%s", ICMPA_9);
            #ifdef ICMP_BUG
            printf("ICMP: scan_icmp(10): RECV RAW %s type<%d>\n", backdata, icmp->icmp_type);
            #endif
            close(send_sk);
            * stat = -1;
            return backdata;
            }

         }

      }


   else{
      #ifdef ICMP_BUG
      printf("ICMP: scan_icmp(11): RECV RAW DATA sendip<%d> inip<%d>\n",
        send_addr.sin_addr.s_addr, ip->ip_src.s_addr);
      #endif
      }
   }  // while(loop)


// 何もかえさずにタイムアウトした場合
rtt = tv.tv_sec*1000.0 + tv.tv_usec/1000.0;
* avrt = rtt;
backdata=safe_sprintf(backdata,BUF_MAX, "%s", ICMPA_01);
#ifdef ICMP_BUG
printf("ICMP: scan_icmp(12): LAST %s\n", backdata);
#endif

close(send_sk);
* stat = -1;
return backdata;
}




