// zither サーバ側にMIDのアカウントが登録済みかを確認する
// 無かった場合は -1, 対応していないバージョンは -2を、通常は現状のカウント数 0<* を返す。
//  -1 無い場合は新規で作る(0)、新規の場合はチェック
//  -2 Zitherが対応していない場合は変数にチェック

#include<stdio.h>
#include<unistd.h>
#include<sys/wait.h>
#include<netinet/in.h>
#include<string.h>
#include<stdlib.h>

#include"sitar.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"
#include<file_comp/file_comp.h>

extern global_data_t gd;
extern pthread_mutex_t fd_mutex;


char mid_chserver(char * midname, int interval)
{
int ret, stat;
char * buf;
char * back;

ret = -3;
stat = 0;
buf = (char *)calloc(BUF_LEN, sizeof(char));
back = (char *)calloc(BUF_LEN, sizeof(char));

// 送信データ作成
// buf = safe_sprintf(buf ,BUF_MAX, "%s :: COM: MIG DATA: %s\n", gd.bf.c_name, midname);
buf = safe_sprintf(buf ,BUF_MAX, "%s :: COM: NIG DATA: %s\n", gd.bf.c_name, midname);

// 送信してステータスを得る 歯痛処理初め
safe_pthread_mutex_lock(&fd_mutex);

if((stat = socket_send(gd.ip.sk, buf, interval)) > 0){
   back = select_fdcat(gd.ip.sk, back, &stat, BUF_MAX, interval);
   if(stat <= 0){
      fprintf(stderr,"mid_chserver(1): exit!! stat=<%d> not recv data\n", stat);
      safe_exit("mid_chserver(1):  socket err exit send data\n");
      }
   }
else{
   fprintf(stderr,"mid_chserver(1): exit!! stat=<%d> send data = <%s>\n", stat, buf);
   safe_exit("mid_chserver(1):  socket err exit send data\n");
   }

pthread_mutex_unlock(&fd_mutex);
// 歯痛処理おわり


if(0 == memcmp(back, "500", 3)){
   ret = -2;
   }
else if(0 == memcmp(back, "200 ", 4)){
   buf = delim_get(back, buf, ' ', &stat, 1);
   if(stat > -1){
      rm_crlf(buf, strlen(buf));
      ret = strtol(buf, (char **)NULL, 10);
      }
   else{
      ret = -2;
      }
   }
else if(0 == memcmp(back, "400 ", 4)){
   ret = -1;
   }
else{
   ret = -2;
   }

#ifdef MID_BUG
printf("MID_BUG: mid_chserver(): ret<%d> send<%s> back<%s>\n", ret, buf, back);
#endif

free(buf);
free(back);

return ret;
}







