
#include<stdio.h>
#include<fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include<pthread.h>


#include "almemsys.h"


// #define SOCKET_READBUG


/* struct th_str {
   pthread_t t1;
   pthread_t t2;
   pthread_mutex_t read_mutex;
   int th_sk; 
   int th_timeout;
   int th_out;
   int th_stat;
   int th_ret;
   char th_cha[64];
   }; */




// t1
int read_check_th(struct th_str * th_struct)
{
int co;
co = 0;
th_struct->t1 = pthread_self();

for(; th_struct->th_out < th_struct->th_timeout; ){

   usleep(1000);
   co++;
   if( co >= 1000 ){
      th_struct->th_out++;
      co = 0;
      }

   safe_pthread_mutex_lock(&th_struct->read_mutex);
   if(1 == th_struct->th_ret){
      pthread_mutex_unlock(&th_struct->read_mutex);
      break;
      }
   pthread_mutex_unlock(&th_struct->read_mutex);

   if(th_struct->th_out >= th_struct->th_timeout){

      safe_pthread_mutex_lock(&th_struct->read_mutex);
      th_struct->th_ret = -1;
      pthread_mutex_unlock(&th_struct->read_mutex);

      close(th_struct->th_sk);
      break;
      }
   }

return 0;
}



// t2
int read_get_th(struct th_str * th_struct)
{
int stat;

stat = read(th_struct->th_sk, th_struct->th_cha, 32);
th_struct->th_stat = stat;

// CLOSEされてない場合はret = 1
safe_pthread_mutex_lock(&th_struct->read_mutex);
if(th_struct->th_ret == -1){
   th_struct->th_stat = -2;
   }
else{
   th_struct->th_ret = 1;
   }
pthread_mutex_unlock(&th_struct->read_mutex);

return 0;
}




int socket_readasth(int sk, char * readdata, int max, int interval, int mode)
{
int ret, stat;
char cha[64];

// read() 用thread構造体の宣言

struct th_str * th_struct;
struct th_str th_s;
int tret;

struct timeval tv;
int retval;
fd_set rfds;

tv.tv_sec = interval;
tv.tv_usec = 0;


memset(&th_s, 0x00, sizeof(th_s));
th_struct = &th_s;

tret = 0;
th_struct->th_ret = 0;
th_struct->th_out = 0;
th_struct->th_sk = sk;
th_struct->th_timeout = interval;

memset(cha, 0x00, 64);
ret = 0;
stat = 0;


while(1){
   FD_ZERO(&rfds);
   FD_SET(sk, &rfds);

   retval = select(sk + 1, &rfds, NULL, NULL, &tv);

   if(retval < 0){
      #ifdef SOCKET_READBUG
      printf("SOCKET: socket_read(2): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      ret = -1;
      break;
      }
   if(retval == 0){
      #ifdef SOCKET_READBUG
      printf("SOCKET: socket_read(3): NG select. time out break <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      ret = -1;
      break;
      }
   if(retval >= 1){




      pthread_mutex_init(&th_struct->read_mutex, NULL);

      memset(th_struct->th_cha, 0x00, 64);
      th_struct->th_stat = 1024;
      if((tret = pthread_create(&th_struct->t1, NULL, (void *)read_check_th, (long int *)th_struct)) != 0){
         fprintf(stderr,"scanssl.c pthread_create(1): %d %d\n",tret, errno);
         }
      if((tret = pthread_create(&th_struct->t2, NULL, (void *)read_get_th, (long int *)th_struct)) != 0){
         fprintf(stderr,"scanssl.c pthread_create(1): %d %d\n",tret, errno);
         }

      pthread_join( th_struct->t1, NULL);
      pthread_join( th_struct->t2, NULL);

      pthread_mutex_destroy(&th_struct->read_mutex);

      stat = th_struct->th_stat;
      self_memcpy(cha, th_struct->th_cha, 64);

      #ifdef SOCKET_READBUG
      printf("===== addr = %d =====read_get_th()===th_struct->th_ret=%d ===th_struct->th_stat=%d data = <%s>\n",
       (int)&th_struct, th_struct->th_ret, th_struct->th_stat, cha);
      #endif


      #ifdef SOCKET_READBUG
      printf("stat = %d string = %s front_char = %02x %02x %02x %02x\n", stat, cha, cha[0], cha[1], cha[2], cha[3]);
      printf("rear_char = %02x %02x %02x\n",cha[stat -2], cha[stat -1], cha[stat]);
      #endif

      if(stat < 0){
         #ifdef SOCKET_READBUG
         printf("BREAK stat==0\n");
         #endif
         ret = stat;
         break;
         }

      if(stat == 0 && cha[0] == 0x00 && cha[1] == 0x00){
         #ifdef SOCKET_READBUG
         printf("BREAK stat==0 cha0=00 cha1=00\n");
         #endif
         break;
         }

      if(stat == 1 && cha[0] == 0x0a && cha[1] == 0x00){
         #ifdef SOCKET_READBUG
         printf("BREAK stat==1 cha0=0a cha1=00\n");
         #endif
         break;
         }

      if(stat >= 2){
         if(mode == 1){
            if(cha[stat - 1] == 0x0a){
               #ifdef SOCKET_READBUG
               printf("BREAK stat>1 0d [mode 1]\n");
               #endif
               strncat(readdata, cha, stat);
               memset(cha, 0x00, 33);
               ret = ret + stat;
               break;
               }
            }
         if(cha[stat - 2] == 0x0d && cha[stat - 1] == 0x0a){
            #ifdef SOCKET_READBUG
            printf("BREAK stat>1 0d 0a\n");
            #endif
            strncat(readdata, cha, stat);
            memset(cha, 0x00, 33);
            ret = ret + stat;
            break;
            }
         else{
            strncat(readdata, cha, stat);
            memset(cha, 0x00, 33);
            ret = ret + stat;
            if(ret > max - 32){
               #ifdef SOCKET_READBUG
               fprintf("socket_reada(): read size err.\n");
               #endif
               break;
               }
            }

         }
      }
   } // while()

return(ret);
}



