
#include<stdio.h>
#include<unistd.h>
#include<string.h>
#include<stdlib.h>
#include <ctype.h> 
#include<errno.h>

#include"sitar.h"
#include<almemsys/almemsys.h>


// この関数を使う場合はthreadで排他処理されていること

extern global_data_t gd;


int miname_install(void)
{
FILE * fp;
char * swap;
char * rec;
char * file_name;
int ppp, ret, stat, stat2, id;

swap = (char *)calloc(2, (sizeof(char)));
rec = (char *)calloc(2, (sizeof(char)));
file_name = (char *)calloc(2, (sizeof(char)));
ret = 0;
id = 0;
stat = 0;
stat2 = 0;

// 非常停止時のMIDファイルがない場合に定期出力のファイルから読み込む設定
if((fp = fopen(gd.fi.midump_filename, "r"))==NULL){
   file_name = safe_memcpy(file_name, gd.fi.midump_filename_2, BUF_LEN);
   }
else{
   fclose(fp); 
   file_name = safe_memcpy(file_name, gd.fi.midump_filename, BUF_LEN);
   }


// ファイルを開く
if((fp = fopen(file_name, "r"))!=NULL){
   fprintf(stderr, "miname_install(): open name list file <%s>\n", file_name);

   // 上限までのループ
   for(ppp = 0;  ppp < gd.td.midcount; ppp++){

      // ポインターから一行読む
      rec = safe_fpcat(fp, rec, &stat, BUF_MAX);

      // もし的もに読めない場合
      if(stat == -1){
         // 残りのメモリー領域を初期化（フォーマット）
         for(; ppp < gd.td.midcount; ppp++){
            gd.td.middle_id[ppp] = 0;
            gd.td.middle_name[ppp] = null_free(gd.td.middle_name[ppp]);
            }
         // ファイルを閉じて離脱 通常はこちらから離脱するはず。
         midump_remove(gd.fi.midump_filename);    // dumpファイルは正常に読み込んだら消す。
         fclose(fp); 
         free(swap);
         free(rec);
         free(file_name);
         return ret;
         }
      // ポインターから正常に読めた場合
      else{

         #ifdef MINAME_BUG
         printf("miname_install(): %s %d %d %d %c\n",
           rec, char_count(rec, ','), (int)strlen(rec), isdigit((int)rec[0]), (char)rec[1]);
         #endif

         // 読んだ行の正しさをチェック
         // ','が一個だけ含まれ、3文字以上で出来ている、そして先頭が数字である、2個めは','
         if(1 == char_count(rec, ',') && 3 < (int)strlen(rec) && 0 != isdigit((int)rec[0]) && ',' == (char)rec[1]){
            // ','で区切ったデータを取り出す
            swap = delim_get(rec, swap, ',', &stat2, 0);
            id = strtol(swap, (char **)NULL, 10);
            swap = delim_get(rec, swap, ',', &stat2, 1);
            #ifdef MINAME_BUG
            printf("<%d>, %s\n", id, swap);
            #endif
            // データをメモリーに入れていきます
            gd.td.middle_id[ppp] = id;
            id = 0;
            gd.td.middle_name[ppp] = safe_memcpy(gd.td.middle_name[ppp], swap, BUF_LEN);
            #ifdef MINAME_BUG
            printf("miname_install(): %d,%s\n", gd.td.middle_id[ppp], gd.td.middle_name[ppp]);
            #endif
            }
         else{
            // フォーマットが不正なので、何もしない
            }
         }
      }
   // 読み終わったのでFPの開放
   fclose(fp);
   }
// ファイルがない、または読めない
else{
   fprintf(stderr, "miname_dump(): <%s> not open.\n", gd.fi.midump_filename);
   ret = -1;
   }

free(swap);
free(rec);
free(file_name);
return ret;
}


