#!/bin/sh
# sitar client startup script
#
PATH=$PATH:/usr/sbin:/usr/local/zither/bin
CONF_PATH=/usr/local/zither/conf
TMP_PATH=/usr/local/zither/tmp
BIN_PATH=/usr/local/zither/bin
LOG_PATH=/usr/local/zither/log
USER_ID=`id -u root`
INT_TIME=60

start() {
        echo "start sitar client"
        if [ -e $CONF_PATH/sitar.conf ]
        then
           echo "OK sitar.config"
        else
           make_sitar_conf.sh > $CONF_PATH/sitar.conf
           chown zither:zither $CONF_PATH/sitar.conf
        fi

        if [ -e $TMP_PATH/sitar.bat ]
        then
           echo "OK sitar.bat"
        else
           make_sitar_comand.sh > $TMP_PATH/sitar.bat
           chown zither:zither $TMP_PATH/sitar.bat
        fi

        if [ -e $TMP_PATH/sitar.list ]
        then
           echo "OK sitar.list"
        else
           make_sitar_list.sh > $TMP_PATH/sitar.list
           chown zither:zither $TMP_PATH/sitar.list
        fi

        sitarctl $BIN_PATH/sitar $CONF_PATH/sitar.conf $USER_ID $INT_TIME 1>> $LOG_PATH/sitar.log 2>> $LOG_PATH/sitar.errlog &
}

stop() {
        echo "stop sitar client"
        killall sitarctl; killall -HUP sitar
}

case "$1" in
  start)
        start
        ;;
  stop)
        stop
        ;;
  restart|reload)
        stop
        sleep 20
        start
        ;;
  *)
        echo $"Usage: $0 {start|stop|restart}"
        exit 1
esac
 
exit 0  
 
