#ifdef SIGNATURE_MODE

#include<stdio.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h>
#include<time.h>
#include<errno.h>

#include"zither.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"

// #define SIG_MAXLEN 10

extern pthread_mutex_t sig_mutex;

extern  global_data_t gd;

// シグネチャ用ファイルの変更を確認する。

int mailsigfile_check(void)
{
FILE * fp;
int count, stat, stat1, co;
stat = 0;
stat1 = 0;
co = 0;
char * swapdata;

swapdata = (char *)calloc(BUF_DEFLEN, sizeof(char));


for(;;){

   safe_pthread_mutex_lock(&sig_mutex);

   gd.sig.sig_stat = stat_check(gd.sig.sig_stat, gd.sig.sig_filename, TIME_LEN, &stat);

   #ifdef SIG_DEBUG
   printf("SIG_DEBUG: data = %s: stat = %d\n", gd.sig.sig_stat, stat);
   #endif
 
   if(stat == -1){

      if((fp = fopen(gd.sig.sig_filename, "r+"))!=NULL){
         #ifdef SIG_DEBUG
         fprintf(stderr,"mailsigfile_check(1): file open success<%s>\n", gd.sig.sig_filename);
         #endif

         for(count = 0; count <= (SIG_MAXLEN); count++){
            gd.sig.sig_data[count] = null_free(gd.sig.sig_data[count]);
            }

         while(1){
            swapdata = safe_fpcat(fp, swapdata, &stat1, BUF_MAX);
            if(stat1 == -1){
               gd.sig.sig_len = co;
               co = 0; 
               stat1 = 0;
               #ifdef SIG_DEBUG
               fprintf(stderr,"mailsigfile_check(2): Terminal of file. <%s> len = <%d>\n", gd.sig.sig_filename, gd.sig.sig_len); 
               #endif
               break;
               }
            else{
               gd.sig.sig_data[co] = safe_memcpy(gd.sig.sig_data[co], swapdata, BUF_MAX);
               swap_mem(gd.sig.sig_data[co], '\\', '\n');
               #ifdef SIG_DEBUG
               fprintf(stderr,"mailsigfile_check(3): len = <%d>: data = <%s>\n", co, gd.sig.sig_data[co]);
               #endif
               co++;
               if(co > SIG_MAXLEN){
                  gd.sig.sig_len = co;
                  co = 0; 
                  stat1 = 0;
                  #ifdef SIG_DEBUG
                  fprintf(stderr,"mailsigfile_check(2): Terminal of file. <%s> len = <%d>\n", gd.sig.sig_filename, gd.sig.sig_len); 
                  #endif
                  break;
                  }
               }
            } // while()

         fclose(fp);
         } 
      else{
         fprintf(stderr,"mailsigfile_check(4): Not open file <%s>\n", gd.sig.sig_filename);
         }

      }

   #ifdef SIG_DEBUG
   fprintf(stderr,"mailsigfile_check(5): rand data test. <%s>\n", gd.sig.sig_data[randdata(0, (gd.sig.sig_len - 1))]); 
   #endif

   pthread_mutex_unlock(&sig_mutex);

   if(gd.sig.sig_interval < 60){
      gd.sig.sig_interval = 60;
      }
   for(count = 0; count < gd.sig.sig_interval; count++){
      #ifdef SIG_DEBUG
      printf("DEBUG: mailsigfile_check(6): sleep <%d>\n", count);
      #endif
      sleep(1);
      }

   } /* for(;;) */


free(swapdata);

return(stat);
}      



#endif



