

#include<stdio.h>
#include<unistd.h>
#include<sys/wait.h>
#include<netinet/in.h>
#include<string.h>
#include<stdlib.h>
#include<pthread.h>

#include"sitar.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"
#include<file_comp/file_comp.h>

extern global_data_t gd;

extern pthread_mutex_t fd_mutex;



// sitar 起動用***.config ファイルを持ってくる関数
int get_configfile(char * bat_filename, char * senddata)
{
FILE * fp;
int stat, fd, check, interval;

check = 0;
stat = 0;

char * rec = (char *)calloc(IP_LEN, sizeof(char));
char * recdata = (char *)calloc(IP_LEN, sizeof(char));
char * intr = (char *)calloc(IP_LEN, sizeof(char));
char * myfile = (char *)calloc(IP_LEN, sizeof(char));

interval = (gd.bf.life_int + gd.bf.life_los + INT_PLUS);

// 送信データの作成
// intr = safe_sprintf(intr, BUF_MAX, "%s :: COM: UNDIF DATA: %s\n", gd.bf.c_name, senddata);
intr = safe_sprintf(intr, BUF_MAX, "%s :: COM: SLGET DATA: %s\n", gd.bf.c_name, senddata);

// データ送信、戻りがないと死亡
//pthread_mutex_lock(&fd_mutex);
safe_pthread_mutex_lock(&fd_mutex);


// printf("GET_CONFIGFILE START data=%s\n", senddata);
if((stat = socket_send(gd.ip.sk, intr, interval)) > 0){
   rec = select_fdcat(gd.ip.sk, rec, &stat, BUF_MAX, interval); 
   }
if(stat < 0){
   safe_exit("get_configfile(1): socket err exit \n");
   }
// printf("GET_CONFIGFILE STOP data=%s\n", senddata);

pthread_mutex_unlock(&fd_mutex);

#ifdef CONFIGFILE_DEBUG
printf("CONFIGFILE: get_configfile(send):  %s %s\n", intr, bat_filename);
printf("CONFIGFILE: get_configfile(recv):  %s %s\n", rec, bat_filename);
#endif

// ファイルが正常に戻ってきた場合の処理
if(0 != (memcmp(rec, "500 NG", 6))){
   // 自分のファイルを読む
   if((fp = fopen(bat_filename, "r"))!=NULL){
      fd = fileno(fp);
      myfile = safe_filefdcat(fd, myfile, &stat, BUF_MAX, (gd.bf.life_int + gd.bf.life_los));
      swap_mem(myfile, '\n', (char)0x05);
//    fclose(fp);
      close(fd);
      #ifdef CONFIGFILE_DEBUG
      printf("CONFIGFILE: get_configfile():  %s\n", myfile);
      #endif
      }
   // 自分ファイルと受信ファイルの差分を確認
   if((check = (my_chmem(myfile, rec))) != 0){
      // 差があった場合にwで自分ファイルを開く
      if((fp = fopen(bat_filename, "w+"))!=NULL){
         swap_mem(rec, (char)0x05, '\n');
         fprintf(fp,"%s",rec);
         fclose(fp);
         #ifdef OCNFIGFILE_DEBUG
         printf("CONFIGFILE: get_configfile():  %s\n", rec);
         #endif
         safe_exit("get_configfile(): config file was edited. \n"); // It ends. 
         }
      else {
         fprintf(stderr,"get_configfile(): config file not write. %s\n", bat_filename);
         }
      }
   else{
      #ifdef CONFIGFILE_DEBUG
      printf("CONFIGFILE: get_configfile(): %d\n", check);
      #endif
      }
   }

// ファイルが正常に戻ってこない場合の処理
else {
   fprintf(stderr,"server side config file not open.\n");
   if((fp = fopen(gd.fi.conf_path, "r"))!=NULL){
      fd = fileno(fp);
      rec = safe_filefdcat(fd, rec, &stat, BUF_MAX, (gd.bf.life_int + gd.bf.life_los));

      swap_mem(rec, '\n', (char)0x05);

      intr = safe_sprintf(intr, BUF_MAX,
        "%s :: COM: UP DATA: CONF:%s\n", gd.bf.c_name, rec);

      if(1 < (int)strlen(rec)){
         //pthread_mutex_lock(&fd_mutex);
         safe_pthread_mutex_lock(&fd_mutex);
         if((stat = socket_send(gd.ip.sk, intr, interval)) > 0){
            recdata = select_fdcat(gd.ip.sk, recdata, &stat, BUF_MAX, interval); 
            }
         if(stat < 0){
            safe_exit("get_configfile(2): socket err exit \n");
            }
         pthread_mutex_unlock(&fd_mutex);

         }

      #ifdef CONFIGFILE_DEBUG
      printf("CONFIGFILE: get_configfile():pp %s\n", recdata);
      #endif

      close(fd);
      }
   else{
      fprintf(stderr,"get_configfile(): client side config file not open.\n");
      }
   }

#ifdef FREE_BUG
printf("FREE: single get_configfile(): rec %s\n", rec);
printf("FREE: single get_configfile(): recdata %s\n", recdata);
printf("FREE: single get_configfile(): intr %s\n", intr);
printf("FREE: single get_configfile(): myfile %s\n", myfile);
#endif

free(rec);
free(recdata);
free(intr);
free(myfile);

return stat;
}









