
#include<stdio.h>
#include<unistd.h>
#include<stdlib.h>
#include<string.h>
#include<sys/types.h>
#include<unistd.h>
#include<sys/time.h>
#include<signal.h>
#include<sys/resource.h>
#include<sys/wait.h>
#include<errno.h>

#include "sitar_com.h"


static int * pids[COM_LEN];

// static int *pids;

FILE * p_popen(FILE * iop, char * program, register char * type, int * pin, int *gin, int out, int count)
{
// static FILE * iop;
int pdes[2], fds, pid, fdno;
char *argv[4];
int tes = 0;
argv[0] = "sh";
argv[1] = "-c";
argv[2] = (char *)program;
argv[3] = NULL;

if(count < 0){
   fprintf(stderr,"POPEN: p_open(): out of size pids[%d][x] %s\n", count, program );
   return(NULL);
   }

// pids[count] = NULL;

if((*type != 'r' && *type != 'w') || type[1]){
   return(NULL);
   }

if(pids[count] == NULL){
   if((fds = getdtablesize()) <= 0){
      return(NULL);
      }
   #ifdef POPEN_DEBUG
   printf("p_open(): count=%d fds=%d  FDのバッファが初期化されていません、初期化します\n", count, fds);
   #endif
   if((pids[count] = (int *)malloc((u_int)(fds * sizeof(int)))) == NULL){
      return(NULL);
      bzero((char *)pids[count], fds * sizeof(int));
      }
   }

#ifdef POPEN_DEBUG
printf("p_open(): count=%d program=%s このプログラムを実行します \n", count, program);
#endif

if(pipe(pdes) < 0){
   return(NULL);
   }

switch(pid = vfork()){
   case -1:  /* error */
      (void)close(pdes[0]);
      (void)close(pdes[1]);
      return(NULL);
      /* NOTREACHED */
   case 0:   /* child */
      #ifdef POPEN_DEBUG
      printf("POPEN: p_open(): type %c\n", *type);
      printf("POPEN: p_open(): pdes stdout 1 %d %d\n", pdes[0], pdes[1]);
      #endif
      if(*type == 'r'){
         if(pdes[1] != fileno(stdout)){
            #ifdef POPEN_DEBUG
            printf("POPEN: p_open(): pdes stdout 2 %d %d\n", pdes[0], pdes[1]);
            #endif
            if(out < 1 || out > 2){
               tes = dup2(pdes[1], fileno(stdout));
               }
            if(out == 1){
               tes = dup2(pdes[1], fileno(stdout));
               }
            if(out == 2){
               tes = dup2(pdes[1], fileno(stderr));
               }
            #ifdef POPEN_DEBUG
            printf("POPEN: p_open(): 3dup2 stdout tes %d pdes %d %d\n", tes, pdes[0], pdes[1]);
            #endif
            (void)close(pdes[1]);
            }
         (void)close(pdes[0]);
         }
      else{
         if(pdes[0] != fileno(stdin)){
            (void)dup2(pdes[0], fileno(stdin));
            (void)close(pdes[0]);
            }
         (void)close(pdes[1]);
         }

      if(setpgid(pid, pid)){
         fprintf(stderr,"fork stpgid no chenge!");
         }

      execve("/bin/sh", argv, NULL);
      _exit(127);
      /* NOTREACHED */
   }

/* parent; assume fdopen can't fail...  */
if(*type == 'r'){
   iop = fdopen(pdes[0], type);
   #ifdef POPEN_DEBUG
   fprintf(stderr,"POPEN: p_open(): 4pdes stdout 4 %d %d iopfd %d\n", pdes[0], pdes[1], fileno(iop));
   #endif
   (void) close(pdes[1]);
   }
else{
   iop = fdopen(pdes[1], type);
   (void)close(pdes[0]);
   }

*pin = pid;
*gin = getpgid(pid);

if((fdno = fileno(iop)) < 0){
   fprintf(stderr,"POPEN: p_open(): fd return -1! 4 %d %d iopfd %d\n", pdes[0], pdes[1], fileno(iop));
   return(NULL);
   }

#ifdef POPEN_FD_DEBUG
printf("POPEN_FD: p_open(): fd return pids[%d][%d]=%d %s\n", count, fdno, pid, program);
#endif

pids[count][fdno] = pid;

return (iop);
}




int p_pclose(FILE *iop, int count)
{
register int fdes;
sigset_t omask, nmask;
// static int pstat;
int pstat;
register int pid;

/*
 * pclose returns -1 if stream is not associated with a
 * `popened' command, if already `pclosed', or waitpid
 * returns an error.
 */
if (pids[count] == NULL || pids[count][fdes = fileno(iop)] == 0){
   return (-1);
   }

(void)fclose(iop);
sigemptyset(&nmask);
sigaddset(&nmask, SIGINT);
sigaddset(&nmask, SIGQUIT);
sigaddset(&nmask, SIGHUP);
sigprocmask(SIG_BLOCK, &nmask, &omask);

do {
   pid = wait4(pids[count][fdes], &pstat, 0, (struct rusage *)0);
   } while (pid == -1 && errno == EINTR);

sigprocmask(SIG_SETMASK, &omask, NULL);
pids[count][fdes] = 0;

return (pid == -1 ? -1 : pstat);
}




