#!/bin/sh
# zither server startup script
#
# chkconfig: 2345 99 99
# description: zither
#
SERVER_NAME="localhost_127.0.0.1"
PATH=$PATH:/usr/sbin:/usr/local/zither/bin
CONF_PATH=/usr/local/zither/conf
LOG_PATH=/usr/local/zither/log
BIN_PATH=/usr/local/zither/bin/zither
MAIL_SERV=127.0.0.1
MAIL_FROM=zither@ms-n.com
MAIL_RCPTTO=masashi@dh.ms-n.com
INT_TIME=60
USER_ID=`id -u zither`
DATE_D=`date +%Y%m%d%H%M%S`

start() {
        echo "--- start zither server ---$DATE_D ---" 1>> $LOG_PATH/zither.log 2>> $LOG_PATH/zither.errlog &
        zitherctl $BIN_PATH $CONF_PATH/zither.conf $CONF_PATH/neg.conf $USER_ID $INT_TIME $MAIL_SERV $MAIL_FROM $MAIL_RCPTTO "$SERVER_NAME" 1>> $LOG_PATH/zither.log 2>> $LOG_PATH/zither.errlog &
}

stop() {
        echo "stop zither server"
        killall zitherctl; killall zither 
}

case "$1" in
  start)
        start
        ;;
  stop)
        stop
        ;;
  restart|reload)
        stop
        echo "wait 65 sec"
        sleep 65
        start
        ;;
  *)
        echo $"Usage: $0 {start|stop|restart}"
        exit 1
esac
 
exit 0  
 
