// file.c
// $Id: file.c,v 1.5 2007/11/06 12:27:17 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<pthread.h>
#include<stdlib.h>

#include"zither.h"
#include<almemsys/almemsys.h>


/*
char * filename_create(char *, char *, char *, char *);
int put_log(char *);
int fd_outopen(char *, char *);
int log_out(char *, char *, char *);
int log_out2(char *, char *, char *, char *);
cahr * file_send(char *, char *, int *, int);
cahr * diff_send(char *, char *, int *, int);
*/

char * command_check(char *);


/* ---------------- FILENAME CREATE ---------------- */
char * filename_create(char *log_filename, char *log_path, char *tailname, char * user)
{ 

log_filename = safe_memcpy(log_filename, log_path, BUF_SLEN);
log_filename = safe_strncat(log_filename, user, BUF_SLEN);
log_filename = safe_strncat(log_filename, tailname, BUF_SLEN);

#ifdef DEBUG
printf("LOG_FILENAME =%s\n", log_filename);
#endif

return log_filename;
}





/*---------------- PUT LOGFILE2 --------------------*/
int put_log2(int fd, char *data, char * user, unsigned char * chIpadd)
{
int ret, a;
char * putlog_data = (char *)calloc(BUF_DEFLEN, sizeof(char));

ret = 0;

swap_mem(data, '\n', ' ', (int)strlen(data));

putlog_data = safe_sprintf(putlog_data, BUF_MAX, "%d.%d.%d.%d,%s,%s\n",
  chIpadd[0],
  chIpadd[1],
  chIpadd[2],
  chIpadd[3],
  user, data);

#ifdef DEBUG
printf("put_log2(): ERR_LOG %s", putlog_data);
#endif

a = strlen(putlog_data);
ret = write(fd, putlog_data, a);

free(putlog_data);

return(ret);
}






/*----------------- LOG_OUT OPEN -------------------*/
int fd_outopen(char * log_filename, FILE * fp)
{
int fd;

if((fp=fopen(log_filename, "a+"))==NULL){ 
   fprintf(stderr,"fd_outopen(): CONNECT FILE NOT OPEN %s\n",log_filename);
   fd = 2;
   }
else {
   fd = fileno(fp);
   }

return(fd);
}





/*----------------- LOG_OUT2 -------------------*/
int log_out2(int fd, char * user, char * com, char * data1, char * data2, unsigned char * chIpadd)
{
static int ret;
int a;
char * outlog_data = (char *)calloc(BUF_DEFLEN, sizeof(char));
char * time_data = (char *)calloc(BUF_DEFLEN, sizeof(char));

ret = 0;

swap_mem(data1, '\n', ' ', (int)strlen(data1));
swap_mem(data2, '\n', ' ', (int)strlen(data2));

time_data = time_getr(time_data);

outlog_data = safe_sprintf(outlog_data, BUF_MAX, "%d.%d.%d.%d [%s] user:%s com:%s in:%s out:%s\n",
   chIpadd[0],
   chIpadd[1],
   chIpadd[2],
   chIpadd[3],
   time_data, user, com, data1, data2);

#ifdef DEBUG
fprintf(stderr,"%s\n", outlog_data);
#endif

a = strlen(outlog_data);
ret = write(fd, outlog_data, a);

free(outlog_data);
free(time_data);

return(ret);
}








/*---------------- COMMAND_CHECK --------------------*/
char * command_check(char * data)
{
char * chdata;

if(0 < (int)strlen(data)){
   if((chdata = (char *)strcasestr(data, "shutd")) != NULL){
      chdata[0] = 'X';
      chdata[1] = 'X';
      chdata[2] = 'X';
      chdata[3] = 'X';
      fprintf(stderr,"file.c: command_check(1): The following are included. 'SHUTD'\n");
      return data;
      }
   else if((chdata = (char *)strcasestr(data, "reboo")) != NULL){
      chdata[0] = 'Y';
      chdata[1] = 'Y';
      chdata[2] = 'Y';
      chdata[3] = 'Y';
      fprintf(stderr,"file.c: command_check(1): The following are included. 'REBOO'\n");
      return data;
      }
   else if((chdata = (char *)strcasestr(data, "init")) != NULL){
      chdata[0] = 'Z';
      chdata[1] = 'Z';
      chdata[2] = 'Z';
      fprintf(stderr,"file.c: command_check(1): The following are included. 'INIT'\n");
      return data;
      }
//   else if((chdata = (char *)strcasestr(data, "kill")) != NULL){
//      chdata[0] = 'A';
//      chdata[1] = 'A';
//      chdata[2] = 'A';
//      fprintf(stderr,"file.c: command_check(1): The following are included. 'KILL'\n");
//      return data;
//      }
   else{
      return data;
      }
   }

else{
   fprintf(stderr,"file.c: command_check(): not haystack data.\n");
   }

return data;
}





/*---------------- FILE SEND --------------------
char * diff_send(int sock_fd, char * filename, char * data, int * stat, int interval)
{
FILE * fp;
FILE * lfp;
FILE * bfp;
int count;

char * lock_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));
char * backup_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));

// lockfile 名を作る
lock_filename = safe_memcpy(lock_filename, filename, BUF_MAX);
lock_filename = safe_strncat(lock_filename, "_lock", BUF_MAX);

// backupfile 名を作る
backup_filename = safe_memcpy(backup_filename, filename, BUF_MAX);
backup_filename = safe_strncat(backup_filename, "_backup", BUF_MAX);


for(count = 0; count < 15; count++){
   if((lfp = fopen(lock_filename, "r"))==NULL){                      // lock_file が無い場合
      if((lfp = fopen(lock_filename, "w+"))!=NULL){                  // lock_file を作れた場合
         if((fp = fopen(filename, "r"))!=NULL){                      // file が読めた場合
            fclose(fp); 
            if((bfp = fopen(backup_filename, "r"))!=NULL){            // backupfile が読めた場合
               fclose(bfp); 

               // 差分データを出す
               data = difference_off(data, backup_filename, filename, stat, BUF_MAX);

               // 特定文字列の粛正
               data = command_check(data);

               if(0 > (file_copy(filename, backup_filename))){          // file の服制を作る
                  fprintf(stderr,"file.c : diff_send(): file copy err. <%s -> %s>\n",
                    filename, backup_filename);
                  }
               #ifdef FILESEND_DEBUG
               else{
                  fprintf(stdout,"OK file copy: %s -> %s \n", filename, backup_filename);
                  }
               #endif

               #ifdef FILESEND_DEBUG
               fprintf(stderr, "file.c : diff_send(1): <%s>\n", data);
               #endif
               if(BUF_MAX < (int)strlen(data)){
                  fprintf(stderr,"file.c : diff_send(): file size over err. <%s>\n", filename);
                  }

               swap_mem(data, '\n', ';', strlen(data));                // '\n'を';'に置き換え
               data = safe_strncat(data, "\n", BUF_MAX);               // 最後に改行追加
               if(1 < (int)strlen(data)){                              // data が1より大きい場合
                  * stat = socket_send(sock_fd, data, interval);       // dataを送信
                  }
               else{
                  * stat = socket_send(sock_fd, "500 NG file read err.\n", interval);
                  }

               }
            else{                                             // backupfile が読めない場合 
               // * stat = -1; 
               data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
               fprintf(stderr,"-- BACKUP FILE NOT OPEN: filename = <%s>\n", filename);
               * stat = socket_send(sock_fd, "500 NG file not open.\n", interval);
               }
            }
         else{                                                // file が読めない場合 
            // * stat = -1; 
            data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
            fprintf(stderr,"-- CONF FILE NOT OPEN: filename = <%s>\n", filename);
            * stat = socket_send(sock_fd, "500 NG file not open.\n", interval);
            }

         lock_remove(lock_filename);                         // lock_file 削除
         fclose(lfp);
         break;
         }
      else{                                                  // lock_file が作れない場合
         data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
         fprintf(stderr,"config lockfile is not open!. %s\n", lock_filename);
         * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
         break;
         }
      }
   else{                                                     // lock_fileがすでにあった場合
      fprintf(stderr,"config lockfile extas wait 1sec %s\n", lock_filename);
      fclose(lfp);
      sleep(1);
      }
   }                                                         // for() loop

if(count >= 5){
   data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
   fprintf(stderr,"config lockfile exeitas wait 5sec. loop out. %s\n", lock_filename);
   * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
   }

free(lock_filename);
free(backup_filename);

return data;
}

*/






/*---------------- FILE SEND --------------------*/
char * file_send(int sock_fd, char * filename, char * data, int * stat, int interval, char delim)
{
FILE * fp;
FILE * lfp;
int fd, count;

char * lock_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));
char * backup_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));

// lockfile 名を作る
lock_filename = safe_memcpy(lock_filename, filename, BUF_MAX);
lock_filename = safe_strncat(lock_filename, "_lock", BUF_MAX);

// backupfile 名を作る
backup_filename = safe_memcpy(backup_filename, filename, BUF_MAX);
backup_filename = safe_strncat(backup_filename, "_backup", BUF_MAX);


for(count = 0; count < 15; count++){
   if((lfp = fopen(lock_filename, "r"))==NULL){                      // lock_file が無い場合
      if((lfp = fopen(lock_filename, "w+"))!=NULL){                  // lock_file を作れた場合

         if((fp = fopen(filename, "r"))!=NULL){                      // file が読めた場合
            fd = fileno(fp); 

            if(0 > (file_copy(filename, backup_filename))){          // file の服制を作る
               fprintf(stderr,"file.c : file_send(): file copy err. <%s -> %s>\n",
                 filename, backup_filename);
               }
            #ifdef FILESEND_DEBUG
            else{
               fprintf(stdout,"OK file copy: %s -> %s \n", filename, backup_filename);
               }
            #endif

            data = safe_filefdcat(fd, data, stat, BUF_MAX, interval); // file をdataに読む

            // 特定文字列の粛正
            data = command_check(data);

            #ifdef FILESEND_DEBUG
            fprintf(stderr, "file.c : file_send(1): <%s>\n", data);
            #endif
            if(BUF_MAX < (int)strlen(data)){
               fprintf(stderr,"file.c : file_send(): file size over err. <%s>\n", filename);
               }

            swap_mem(data, '\n', (char)delim, strlen(data));         // '\n'を'0x05'に置き換え
            data = safe_strncat(data, "\n", BUF_MAX);               // 最後に改行追加
            if(1 < (int)strlen(data)){                              // data が1より大きい場合
               * stat = socket_send(sock_fd, data, interval);       // dataを送信
               }
            else{
               * stat = socket_send(sock_fd, "500 NG file read err.\n", interval);
               }

            fclose(fp);
            }

         else{                                                // file が読めない場合 
            /* * stat = -1; */
            data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
            fprintf(stderr,"-- CONF FILE NOT OPEN: filename = <%s>\n", filename);
            * stat = socket_send(sock_fd, "500 NG file not open.\n", interval);
            }

         lock_remove(lock_filename);                         // lock_file 削除
         fclose(lfp);
         break;
         }
      else{                                                  // lock_file が作れない場合
         data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
         fprintf(stderr,"config lockfile is not open!. %s\n", lock_filename);
         * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
         break;
         }
      }
   else{                                                     // lock_fileがすでにあった場合
      fprintf(stderr,"config lockfile extas wait 1sec %s\n", lock_filename);
      fclose(lfp);
      sleep(1);
      }
   }                                                         // for() loop

if(count >= 5){
   data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
   fprintf(stderr,"config lockfile exeitas wait 5sec. loop out. %s\n", lock_filename);
   * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
   }

free(lock_filename);
free(backup_filename);

return data;
}







/*---------------- FILE SEND2 --------------------*/
char * file_send2(int sock_fd, char * filename, char * data, int * stat, int interval, char delim)
{
FILE * fp;
FILE * lfp;
int fd, count, ch, counts;

ch = 0;
counts = 0;

char * lock_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));
char * backup_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));
char * swap = (char *)calloc(BUF_DEFLEN, sizeof(char));

// lockfile 名を作る
lock_filename = safe_memcpy(lock_filename, filename, BUF_MAX);
lock_filename = safe_strncat(lock_filename, "_lock", BUF_MAX);

// backupfile 名を作る
backup_filename = safe_memcpy(backup_filename, filename, BUF_MAX);
backup_filename = safe_strncat(backup_filename, "_backup", BUF_MAX);


for(count = 0; count < 15; count++){
   if((lfp = fopen(lock_filename, "r"))==NULL){                      // lock_file が無い場合
      if((lfp = fopen(lock_filename, "w+"))!=NULL){                  // lock_file を作れた場合

         if((fp = fopen(filename, "r"))!=NULL){                      // file が読めた場合
            fd = fileno(fp); 

            if(0 > (file_copy(filename, backup_filename))){          // file の服制を作る
               fprintf(stderr,"file.c : file_send(): file copy err. <%s -> %s>\n",
                 filename, backup_filename);
               }
            #ifdef FILESEND_DEBUG
            else{
               fprintf(stdout,"OK file copy: %s -> %s \n", filename, backup_filename);
               }
            #endif

            * stat = alget_write(sock_fd, fp, interval, (char)delim, FILE_LEN, 0);

            fclose(fp);                                       // file のclose
            }                                                 // file が読めた場合の終わり

         else{                                                // file が読めない場合 
            /* * stat = -1; */
            data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
            fprintf(stderr,"-- CONF FILE NOT OPEN: filename = <%s>\n", filename);
            * stat = socket_send(sock_fd, "500 NG file_send2(): not open.\n", interval);
            }                                                // fileが読めない場合の終わり

         lock_remove(lock_filename);                         // lock_file 削除
         fclose(lfp);
         break;
         }
      else{                                                  // lock_file が作れない場合
         data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
         fprintf(stderr,"config lockfile is not open!. %s\n", lock_filename);
         * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
         break;
         }
      }
   else{                                                     // lock_fileがすでにあった場合
      fprintf(stderr,"config lockfile extas wait 1sec %s\n", lock_filename);
      fclose(lfp);
      sleep(1);
      }
   }                                                         // for() loop

if(count >= 5){
   data = safe_memcpy(data, "NOT OPEN\n", BUF_MAX);
   fprintf(stderr,"config lockfile exeitas wait 5sec. loop out. %s\n", lock_filename);
   * stat = socket_send(sock_fd, "500 NG  lock file not open.\n", interval);
   }

free(lock_filename);
free(backup_filename);
free(swap);

return data;
}





