
#include<stdio.h>
#include<string.h>
#include<unistd.h>
#include<fcntl.h>

#include<errno.h>

#include"sitar_scan.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"

/* 1-> port No' 2-> Ipsddr 3-> return data,, return status code 0=open or=close
int scan_tcp_connect(int, char *, char *, int);
*/


/*----------------- SCAN TCP CONNECT --------------------*/
char * scan_tcp_connect(int port, char * ip_addr, char * backdata, int timeout, int * stat)
{
char ipa2[IP_LEN];
char * ip_addr2 = ipa2;
int sk, re, retval, arglen;
unsigned long resoip;
struct sockaddr_in my_addr;
fd_set rfds;
struct timeval tv;

arglen = sizeof(int);

errno = 0;

if((sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   backdata=safe_sprintf(backdata,BUF_MAX,
    "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_1);
   * stat = -1;
   #ifdef TCP_BUG
   printf("TCP: scan_tcp_connect(1): NOT CLEATE SOCKET %s\n", backdata);
   #endif
   return backdata;
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);

backdata = resolvename(backdata, ip_addr, timeout, &resoip);
my_addr.sin_addr.s_addr = resoip;

if(0 == (int)my_addr.sin_addr.s_addr || resoip == (int)NULL){
   backdata=safe_sprintf(backdata,BUF_MAX,"%s%s %d\n",
    SOCK_2, ip_addr, (int)my_addr.sin_addr.s_addr);
   #ifdef TCP_BUG
   printf("TCP: scan_tcp_connect(2): NOT RESOLV NAME %s\n", backdata);
   #endif
   close(sk);
   * stat = -1;
   return backdata;
   }

ip_addr2 = inet_ntoa(my_addr.sin_addr);

#ifdef TCP_BUG
printf("TCP: scan_tcp_connetc(3): start TCPCHECK host<%s> ip<%s>\n", ip_addr2, ip_addr);
#endif


// 非同期でTCPポートにコネクション
fcntl(sk, F_SETFL, O_NONBLOCK);
re = connect(sk, (struct sockaddr *)(long)&my_addr, sizeof(my_addr));


// 速攻で確立した場合
if(re >= 0){
   backdata=safe_sprintf(backdata,BUF_MAX,
    "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_3);
   #ifdef TCP_BUG
   printf("TCP: scan_tcp_connect(4): CONNECT SUCCESS %s\n", backdata);
   #endif
   // 非同期通信から同期通信に
   fcntl(sk, F_SETFL, 0);
   close(sk);
   * stat = 0;
   return backdata;
   }


// errnoが EINPROGRESS の場合はselectで待つ
if(errno == EINPROGRESS){
   tv.tv_sec = timeout;
   tv.tv_usec = 0;

   while(1){
      FD_ZERO(&rfds);
      FD_SET(sk, &rfds);
      retval = select(sk + 1, NULL, &rfds, NULL, &tv);
      // select エラー
      if(retval < 0){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "IP=%s Port=%d %s %s", ip_addr, port, SOCK_15, SOCK_5);
         #ifdef TCP_BUG
         printf("TCP: scan_tcp_connetc(5): select err BREAK-%d- %s\n", retval, backdata);
         #endif
         fcntl(sk, F_SETFL, 0);
         close(sk);
         * stat = -1;
         return backdata;
         }
      // select time out です
      else if(retval == 0){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "IP=%s Port=%d %s %s", ip_addr, port, SOCK_16, SOCK_5);
         #ifdef TCP_BUG
         printf("TCP: scan_tcp_connetc(6): select time out BREAK-%d- %s\n", retval, backdata);
         #endif
         fcntl(sk, F_SETFL, 0);
         close(sk);
         * stat = -1;
         return backdata;
         }
      // select のLoopOut
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,
          "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_3);
         #ifdef TCP_BUG
         printf("TCP: scan_tcp_connect(7): select time succes BREAK-%d- %s\n", retval, backdata);
         #endif
         break;
         }
      }

   // 非同期通信から同期通信に
   fcntl(sk, F_SETFL, 0);

   // ソケットに関するペンディングエラーを戻す
   if(getsockopt(sk, SOL_SOCKET, SO_ERROR, (void *)&retval, (void *)&arglen) < 0){
      backdata=safe_sprintf(backdata,BUF_MAX,
       "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_13);
      #ifdef TCP_BUG
      printf("TCP: scan_tcp_connect(8): getsockopt() Errors!\n");
      #endif
      close(sk);
      * stat = -1;
      return backdata;
      }
   else{
      // エラーがある場合
      if(retval){
         backdata=safe_sprintf(backdata,BUF_MAX,
          "IP=%s Port=%d %s: TCP %s", ip_addr, port, (retval != 0) ? strerror(retval): "0", SOCK_5);
         #ifdef TCP_BUG
         printf("TCP: scan_tcp_connect(9): 1 SO_ERROR %d -\n", retval);
         printf("%s\n", backdata);
         #endif
         close(sk);
         * stat = -1;
         return backdata;
         }
      // エラーが無い場合
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,
          "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_3);
         #ifdef TCP_BUG
         printf("TCP: scan_tcp_connect(10): -1 SO_ERROR %d -\n", retval);
         printf("%s\n", backdata);
         #endif
         close(sk);
         * stat = 0;
         return backdata;
         }
      }
   }

// ネットワークにIPやホストが存在しない場合の処理
// 非同期通信から同期通信に
fcntl(sk, F_SETFL, 0);

backdata=safe_sprintf(backdata,BUF_MAX,
 "IP=%s Port=%d TCP %s", ip_addr, port, SOCK_14); 
#ifdef TCP_BUG
printf("TCP: scan_tcp_connect(11): --- LAST END ---\n");
printf("%s\n", backdata);
#endif

close(sk);
* stat = -1;
return backdata;

}


