#include<unistd.h>
#include<arpa/inet.h>

#include<almemsys/almemsys.h>


//
// 200==日 201==月 202==火 203==水 204==木 205金 206==土
//
int hloop(int year_b, int month_b, int day_b, int hour_b, int min_b, int mmin)
{
int year, month, day, hour, min, week;
int ret;
time_t u_settime;
time_t u_present;
time_t m_present;

ret = -1; 
week = -1;

// year 2020 以上はなし、2008以下は2008に
if(year_b == 100){ year = ctime_getr('y'); }
else if(year_b >= 2020){ year = 2020; }
else if(year_b <= 2008){ year = 2008; }
else{ year = year_b; }

// month 13を12に 100の場合はmon_setを1に
if(month_b == 100){ month = ctime_getr('m'); }
else if(month_b >= 1){ month = 12; }
else if(month_b <= 0){ month = 1; }
else{ month = month_b; }

// hour 24を0に整理 100 の場合はh_set を1に
if(hour_b == 100){ hour = ctime_getr('h'); }
else if(hour_b >= 24){ hour = 0; }
else if(hour_b <= 0){ hour = 0; }
else{ hour = hour_b; }

// day 32を0に整理 100 の場合は d_set を1 に
if(day_b == 100){ day = ctime_getr('d'); }
else if(day_b == 200){ week = 0; day = 0; } // 日
else if(day_b == 201){ week = 1; day = 0; } // 月
else if(day_b == 202){ week = 2; day = 0; } // 火
else if(day_b == 203){ week = 3; day = 0; } // 水
else if(day_b == 204){ week = 4; day = 0; } // 木
else if(day_b == 205){ week = 5; day = 0; } // 金
else if(day_b == 206){ week = 6; day = 0; } // 土
else if(day_b >= 32){ day = 31; }
else if(day_b <= 0){ day = 1; }
else{ day = day_b; }

// min 60を0に整理
if(min_b >= 60){ min = 60; }
else if(min_b <= 0){ min = 0; }
else{ min = min_b; }


// 曜日が有効の場合、今日の曜日を得る、今日の曜日と設定の曜日が等しい場合今日の日日をdayに入れる
if(week >= 0){
   if(week == ctime_getr('w')){
      day = ctime_getr('d');
      #ifdef MUTEX_BUG
      printf("MUTEX: hloop(): 曜日設定が有効になりました week=%d day=%d\n", week, day);
      #endif
      }
   }

// 設定UNIX時間を得る
u_settime = get_unixtime(year, month, day, hour, min, 0);

// 現在のUNIX時間を得る
u_present = time(NULL);


#ifdef MUTEX_BUG
printf("------------\n");
printf("MUTEX:hloop():設定年=%d,設定月=%d,設定日=%d,曜日=%d,設定時=%d,設定分=%d,設定UNIX=%ld,現在UNIX=%ld,差=%ld,加算秒=%d\n",
        year, month, day, week, hour, min, u_settime, u_present, (u_settime - u_present), mmin);
printf("MUTEX: hloop():現在時=%d, 現在分=%d\n",
        ctime_getr('h'), ctime_getr('i'));
#endif


m_present = u_present - (u_settime - (mmin + 60));
if(m_present <= (mmin + 60) && m_present > 0){
   #ifdef MUTEX_BUG
   printf("MUTEX: hloop(): JUST の条件を満たしたので、LOOPに入ります UNIX<%ld> %d 秒かかるかもしれません 現在分=%d\n",
      u_present, (mmin + 60), ctime_getr('i'));
   #endif 
   while(1){ 
      sleep(10);
      // 現在のUNIX時間を得る
      u_present = time(NULL);
      #ifdef MUTEX_BUG
      printf("MUTEX: hloop(): JUST監視　UNIX<%ld>\n", u_present);
      #endif 
      if((u_settime - 15) < u_present && u_present >= u_settime){
         #ifdef MUTEX_BUG
         printf("MUTEX: hloop(): JUST の条件を満たしたLOOPから正常に抜けます、監視は実行されます 現在分=%d\n", ctime_getr('i'));
         #endif 
         ret = 1;
         break;
         }
      }
   }

return ret;
}










