--- baggins.pl	Mon May 27 15:16:51 2013
+++ baggins.pl	Tue Nov 05 15:18:20 2013
@@ -199,14 +199,14 @@
 #	@param	$Sys	MELKOR
 #	@param	$id		XbhID
 #	@param	$val	X
-#	@param	$age	ageȂ1
+#	@param	$updown	'', 'top', 'bottom', '+n', '-n'
 #	@return	Ȃ
 #
 #------------------------------------------------------------------------------------------------------------
 sub OnDemand
 {
 	my $this = shift;
-	my ($Sys, $id, $val, $age) = @_;
+	my ($Sys, $id, $val, $updown) = @_;
 	
 	my $subject = {};
 	$this->{'SUBJECT'} = $subject;
@@ -239,7 +239,15 @@
 		$this->{'RES'}->{$id} = $val;
 	}
 	
-	$this->AGE($id) if ($age);
+	# Xbhړ
+	if ($updown eq 'top') {
+		$this->AGE($id);
+	} elsif ($updown eq 'bottom') {
+		$this->DAME($id);
+	} elsif ($updown =~ /^([\+\-][0-9]+)$/) {
+		$this->UpDown($id, int($1));
+	}
+	
 	$this->CustomizeOrder();
 	
 	# subject
@@ -650,6 +658,34 @@
 		if ($id eq $sort->[$i]) {
 			splice @$sort, $i, 1;
 			push @$sort, $id;
+			last;
+		}
+	}
+}
+
+#------------------------------------------------------------------------------------------------------------
+#
+#	Xbhړ
+#	-------------------------------------------------------------------------------------
+#	@param	$id	XbhID
+#	@param	$n	ړ(+グ -)
+#	@return	Ȃ
+#
+#------------------------------------------------------------------------------------------------------------
+sub UpDown
+{
+	my $this = shift;
+	my ($id, $n) = @_;
+	
+	my $sort = $this->{'SORT'};
+	my $max = scalar(@$sort);
+	for (my $i = 0; $i < $max; $i++) {
+		if ($id eq $sort->[$i]) {
+			my $to = $i - $n;
+			$to = 0 if ($to < 0);
+			$to = $max-1 if ($to > $max-1);
+			splice @$sort, $i, 1;
+			splice @$sort, $to, 0, $id;
 			last;
 		}
 	}
