SET NAMES utf8;-- DROP TABLE IF EXISTS `zt_action`;
CREATE TABLE IF NOT EXISTS `zt_action` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `objectType` varchar(30) NOT NULL default '',
  `objectID` mediumint(8) unsigned NOT NULL default '0',
  `product` varchar(255) NOT NULL,
  `project` mediumint(9) NOT NULL,
  `actor` varchar(100) NOT NULL default '',
  `action` varchar(30) NOT NULL default '',
  `date` datetime NOT NULL,
  `comment` text NOT NULL,
  `extra` text NOT NULL,
  `read` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `objectID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_block`;
CREATE TABLE IF NOT EXISTS `zt_block` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `module` varchar(20) NOT NULL,
  `title` varchar(100) NOT NULL,
  `source` varchar(20) NOT NULL,
  `block` varchar(20) NOT NULL,
  `params` text NOT NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `grid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0',
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `accountModuleOrder` (`account`,`module`,`order`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_branch`;
CREATE TABLE IF NOT EXISTS `zt_branch` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `order` smallint unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_bug`;
CREATE TABLE IF NOT EXISTS `zt_bug` (
  `id` mediumint(8) NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `project` mediumint(8) unsigned NOT NULL default '0',
  `plan` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `task` mediumint(8) unsigned NOT NULL default '0',
  `toTask` mediumint(8) unsigned NOT NULL default '0',
  `toStory` mediumint(8) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `severity` tinyint(4) NOT NULL default '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `type` varchar(30) NOT NULL default '',
  `os` varchar(30) NOT NULL default '',
  `browser` varchar(30) NOT NULL default '',
  `hardware` varchar(30) NOT NULL,
  `found` varchar(30) NOT NULL default '',
  `steps` text NOT NULL,
  `status` enum('active','resolved','closed') NOT NULL default 'active',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `confirmed` tinyint(1) NOT NULL default '0',
  `activatedCount` smallint(6) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `mailto` text,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `openedBuild` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `deadline` date NOT NULL,
  `resolvedBy` varchar(30) NOT NULL default '',
  `resolution` varchar(30) NOT NULL default '',
  `resolvedBuild` varchar(30) NOT NULL default '',
  `resolvedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `duplicateBug` mediumint(8) unsigned NOT NULL,
  `linkBug` varchar(255) NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `caseVersion` smallint(6) NOT NULL DEFAULT '1',
  `result` mediumint(8) unsigned NOT NULL,
  `repo` mediumint(8) unsigned NOT NULL,
  `entry` varchar(255) NOT NULL,
  `lines` varchar(10) NOT NULL,
  `v1` varchar(40) NOT NULL,
  `v2` varchar(40) NOT NULL,
  `repoType` varchar(30) NOT NULL DEFAULT '',
  `testtask` mediumint(8) unsigned NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `project` (`project`),
  KEY `status` (`status`),
  KEY `plan` (`plan`),
  KEY `story` (`story`),
  KEY `case` (`case`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_build`;
CREATE TABLE IF NOT EXISTS `zt_build` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `project` mediumint(8) unsigned NOT NULL default '0',
  `name` char(150) NOT NULL,
  `scmPath` char(255) NOT NULL,
  `filePath` char(255) NOT NULL,
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `builder` char(30) NOT NULL default '',
  `desc` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `project` (`project`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_burn`;
CREATE TABLE IF NOT EXISTS `zt_burn` (
  `project` mediumint(8) unsigned NOT NULL,
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `estimate` float NOT NULL,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  PRIMARY KEY  (`project`,`date`,`task`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_case`;
CREATE TABLE IF NOT EXISTS `zt_case` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `lib` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `path` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(30) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `title` varchar(255) NOT NULL,
  `precondition` text NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `type` char(30) NOT NULL default '1',
  `auto` varchar(10) NOT NULL default 'no',
  `frame` varchar(10) NOT NULL,
  `stage` varchar(255) NOT NULL,
  `howRun` varchar(30) NOT NULL,
  `scriptedBy` varchar(30) NOT NULL,
  `scriptedDate` date NOT NULL,
  `scriptStatus` varchar(30) NOT NULL,
  `scriptLocation` varchar(255) NOT NULL,
  `status` char(30) NOT NULL default '1',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `frequency` enum('1','2','3') NOT NULL default '1',
  `order` tinyint(30) unsigned NOT NULL default '0',
  `openedBy` char(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` date NOT NULL,
  `lastEditedBy` char(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `version` tinyint(3) unsigned NOT NULL default '0',
  `linkCase` varchar(255) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL,
  `fromCaseID` mediumint(8) unsigned NOT NULL,
  `fromCaseVersion` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `story` (`story`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_casestep`;
CREATE TABLE IF NOT EXISTS `zt_casestep` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(3) unsigned NOT NULL default '0',
  `type` varchar(10) NOT NULL DEFAULT 'step',
  `desc` text NOT NULL,
  `expect` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_company`;
CREATE TABLE IF NOT EXISTS `zt_company` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(120) default NULL,
  `phone` char(20) default NULL,
  `fax` char(20) default NULL,
  `address` char(120) default NULL,
  `zipcode` char(10) default NULL,
  `website` char(120) default NULL,
  `backyard` char(120) default NULL,
  `guest` enum('1','0') NOT NULL default '0',
  `admins` char(255) default NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_compile`;
CREATE TABLE IF NOT EXISTS `zt_compile` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `job` mediumint(8) unsigned NOT NULL,
  `queue` mediumint(8) NOT NULL,
  `status` varchar(255) NOT NULL,
  `logs` text,
  `atTime` varchar(10) NOT NULL,
  `testtask` mediumint(8) unsigned NOT NULL,
  `tag` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `updateDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_config`;
CREATE TABLE IF NOT EXISTS `zt_config` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `owner` char(30) NOT NULL default '',
  `module` varchar(30) NOT NULL,
  `section` char(30) NOT NULL default '',
  `key` char(30) NOT NULL default '',
  `value` text NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `unique` (`owner`,`module`,`section`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_cron`;
CREATE TABLE IF NOT EXISTS `zt_cron` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL,
  `h` varchar(20) NOT NULL,
  `dom` varchar(20) NOT NULL,
  `mon` varchar(20) NOT NULL,
  `dow` varchar(20) NOT NULL,
  `command` text NOT NULL,
  `remark` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `buildin` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL,
  `lastTime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lastTime` (`lastTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lang`;
CREATE TABLE IF NOT EXISTS `zt_lang` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `lang` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `section` varchar(30) NOT NULL,
  `key` varchar(60) NOT NULL,
  `value` text NOT NULL,
  `system` enum('0','1') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `lang` (`lang`,`module`,`section`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dept`;
CREATE TABLE IF NOT EXISTS `zt_dept` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(60) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(4) unsigned NOT NULL default '0',
  `position` char(30) NOT NULL default '',
  `function` char(255) NOT NULL default '',
  `manager` char(30) NOT NULL default '',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doc`;
CREATE TABLE IF NOT EXISTS `zt_doc` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `lib` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL,
  `views` smallint(5) unsigned NOT NULL,
  `collector` text NOT NULL,
  `addedBy` varchar(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `version` smallint(5) unsigned NOT NULL DEFAULT '1',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `project` (`project`),
  KEY `lib` (`lib`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doccontent`;
CREATE TABLE IF NOT EXISTS `zt_doccontent` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `digest` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `files` text NOT NULL,
  `type` varchar(10) NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_version` (`doc`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doclib`;
CREATE TABLE IF NOT EXISTS `zt_doclib` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `type` varchar(30) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `name` varchar(60) NOT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `main` enum('0','1') NOT NULL default '0',
  `collector` text NOT NULL,
  `order` tinyint(5) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`),
  KEY `project` (`project`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_effort`;
CREATE TABLE IF NOT EXISTS `zt_effort` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `user` char(30) NOT NULL default '',
  `todo` enum('1','0') NOT NULL default '1',
  `date` date NOT NULL,
  `begin` datetime NOT NULL default '0000-00-00 00:00:00',
  `end` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` enum('1','2','3') NOT NULL default '1',
  `idvalue` mediumint(8) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `status` enum('1','2','3') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_extension`;
CREATE TABLE IF NOT EXISTS `zt_extension` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(150) NOT NULL,
  `code` varchar(30) NOT NULL,
  `version` varchar(50) NOT NULL,
  `author` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `license` text NOT NULL,
  `type` varchar(20) NOT NULL default 'extension',
  `site` varchar(150) NOT NULL,
  `zentaoCompatible` varchar(100) NOT NULL,
  `installedTime` datetime NOT NULL,
  `depends` varchar(100) NOT NULL,
  `dirs` mediumtext NOT NULL,
  `files` mediumtext NOT NULL,
  `status` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `installedTime` (`installedTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_file`;
CREATE TABLE IF NOT EXISTS `zt_file` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `pathname` char(50) NOT NULL,
  `title` char(255) NOT NULL,
  `extension` char(30) NOT NULL,
  `size` int(10) unsigned NOT NULL default '0',
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `addedBy` char(30) NOT NULL default '',
  `addedDate` datetime NOT NULL,
  `downloads` mediumint(8) unsigned NOT NULL default '0',
  `extra` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `objectID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_group`;
CREATE TABLE IF NOT EXISTS `zt_group` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `program` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` char(30) NOT NULL,
  `role` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `acl` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_grouppriv`;
CREATE TABLE IF NOT EXISTS `zt_grouppriv` (
  `group` mediumint(8) unsigned NOT NULL default '0',
  `module` char(30) NOT NULL default '',
  `method` char(30) NOT NULL default '',
  UNIQUE KEY `group` (`group`,`module`,`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_history`;
CREATE TABLE IF NOT EXISTS `zt_history` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `action` mediumint(8) unsigned NOT NULL default '0',
  `field` varchar(30) NOT NULL default '',
  `old` text NOT NULL,
  `new` text NOT NULL,
  `diff` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_jenkins`;
CREATE TABLE IF NOT EXISTS `zt_jenkins` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `account` varchar(30) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `token` varchar(255) DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_job`;
CREATE TABLE IF NOT EXISTS `zt_job` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `repo` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `frame` varchar(20) NOT NULL,
  `jkHost` mediumint(8) unsigned NOT NULL,
  `jkJob` varchar(500) NOT NULL,
  `triggerType` varchar(255) NOT NULL,
  `svnDir` varchar(255) NOT NULL,
  `atDay` varchar(255) DEFAULT NULL,
  `atTime` varchar(10) DEFAULT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `lastExec` datetime DEFAULT NULL,
  `lastStatus` varchar(255) DEFAULT NULL,
  `lastTag` varchar(255) DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_module`;
CREATE TABLE IF NOT EXISTS `zt_module` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `name` char(60) NOT NULL default '',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(5) unsigned NOT NULL default '0',
  `type` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `collector` text NOT NULL,
  `short` varchar(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `root` (`root`),
  KEY `type` (`type`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_notify`;
CREATE TABLE IF NOT EXISTS `zt_notify` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `objectType` varchar(50) NOT NULL,
  `objectID` mediumint unsigned NOT NULL,
  `action` mediumint NOT NULL,
  `toList` varchar(255) NOT NULL,
  `ccList` text NOT NULL,
  `subject` varchar(255) NOT NULL,
  `data` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `sendTime` datetime NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `failReason` text NOT NULL
) ENGINE='MyISAM' COLLATE 'utf8_general_ci';
-- DROP TABLE IF EXISTS `zt_oauth`;
CREATE TABLE IF NOT EXISTS `zt_oauth` (
  `account` varchar(30) NOT NULL,
  `openID` varchar(255) NOT NULL,
  `providerType` varchar(30) NOT NULL,
  `providerID` mediumint(8) unsigned NOT NULL,
  KEY `account` (`account`),
  KEY `providerType` (`providerType`),
  KEY `providerID` (`providerID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_product`;
CREATE TABLE IF NOT EXISTS `zt_product` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `line` mediumint(8) NOT NULL,
  `type` varchar(30) NOT NULL default 'normal',
  `status` varchar(30) NOT NULL default '',
  `subStatus` varchar(30) NOT NULL default '',
  `desc` text NOT NULL,
  `PO` varchar(30) NOT NULL,
  `QD` varchar(30) NOT NULL,
  `RD` varchar(30) NOT NULL,
  `acl` enum('open','private','custom') NOT NULL default 'open',
  `whitelist` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `createdVersion` varchar(20) NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_productplan`;
CREATE TABLE IF NOT EXISTS `zt_productplan` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `parent` mediumint(9) NOT NULL DEFAULT '0',
  `title` varchar(90) NOT NULL,
  `desc` text NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `order` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `end` (`end`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_project`;
CREATE TABLE IF NOT EXISTS `zt_project` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `isCat` enum('1','0') NOT NULL default '0',
  `catID` mediumint(8) unsigned NOT NULL,
  `type` varchar(20) NOT NULL default 'sprint',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `days` smallint(5) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `subStatus` varchar(30) NOT NULL default '',
  `statge` enum('1','2','3','4','5') NOT NULL default '1',
  `pri` enum('1','2','3','4') NOT NULL default '1',
  `desc` text NOT NULL,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `openedVersion` varchar(20) NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `canceledBy` varchar(30) NOT NULL default '',
  `canceledDate` datetime NOT NULL,
  `PO` varchar(30) NOT NULL default '',
  `PM` varchar(30) NOT NULL default '',
  `QD` varchar(30) NOT NULL default '',
  `RD` varchar(30) NOT NULL default '',
  `team` varchar(90) NOT NULL,
  `acl` enum('open','private','custom') NOT NULL default 'open',
  `whitelist` text NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `parent` (`parent`),
  KEY `begin` (`begin`),
  KEY `end` (`end`),
  KEY `status` (`status`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectproduct`;
CREATE TABLE IF NOT EXISTS `zt_projectproduct` (
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `plan` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`project`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectstory`;
CREATE TABLE IF NOT EXISTS `zt_projectstory` (
  `project` mediumint(8) unsigned NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(6) NOT NULL default '1',
  `order` smallint(6) unsigned NOT NULL,
  UNIQUE KEY `project` (`project`,`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_release`;
CREATE TABLE IF NOT EXISTS `zt_release` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `build` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL default '',
  `marker` enum('0','1') NOT NULL default '0',
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `leftBugs` text NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(20) NOT NULL default 'normal',
  `subStatus` varchar(30) NOT NULL default '',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repo`;
CREATE TABLE IF NOT EXISTS `zt_repo` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `encoding` varchar(20) NOT NULL,
  `SCM` varchar(10) NOT NULL,
  `client` varchar(100) NOT NULL,
  `commits` mediumint(8) unsigned NOT NULL,
  `account` varchar(30) NOT NULL,
  `password` varchar(30) NOT NULL,
  `encrypt` varchar(30) NOT NULL DEFAULT 'plain',
  `acl` text NOT NULL,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `lastSync` datetime NOT NULL,
  `desc` text NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repobranch`;
CREATE TABLE IF NOT EXISTS `zt_repobranch` (
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `branch` varchar(255) NOT NULL,
  UNIQUE KEY `repo_revision_branch` (`repo`,`revision`,`branch`),
  KEY `branch` (`branch`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repofiles`;
CREATE TABLE IF NOT EXISTS `zt_repofiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `path` varchar(255) NOT NULL,
  `parent` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `action` char(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `parent` (`parent`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repohistory`;
CREATE TABLE IF NOT EXISTS `zt_repohistory` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `repo` mediumint(9) NOT NULL,
  `revision` varchar(40) NOT NULL,
  `commit` mediumint(8) unsigned NOT NULL,
  `comment` text NOT NULL,
  `committer` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_story`;
CREATE TABLE IF NOT EXISTS `zt_story` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `parent` mediumint(9) NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `plan` text,
  `source` varchar(20) NOT NULL,
  `sourceNote` varchar(255) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL default 'story',
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `estimate` float unsigned NOT NULL,
  `status` enum('','changed','active','draft','closed') NOT NULL default '',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `stage` enum('','wait','planned','projected','developing','developed','testing','tested','verified','released', 'closed') NOT NULL DEFAULT 'wait',
  `stagedBy` char(30) NOT NULL,
  `mailto` text,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `toBug` mediumint(8) unsigned NOT NULL,
  `childStories` varchar(255) NOT NULL,
  `linkStories` varchar(255) NOT NULL,
  `duplicateStory` mediumint(8) unsigned NOT NULL,
  `version` smallint(6) NOT NULL default '1',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`),
  KEY `status` (`status`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyspec`;
CREATE TABLE IF NOT EXISTS `zt_storyspec` (
  `story` mediumint(9) NOT NULL,
  `version` smallint(6) NOT NULL,
  `title` varchar(255) NOT NULL,
  `spec` text NOT NULL,
  `verify` text NOT NULL,
  UNIQUE KEY `story` (`story`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storystage`;
CREATE TABLE IF NOT EXISTS `zt_storystage` (
  `story` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `stage` varchar(50) NOT NULL,
  `stagedBy` char(30) NOT NULL,
  UNIQUE KEY `story_branch` (`story`,`branch`),
  KEY `story` (`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_suitecase`;
CREATE TABLE IF NOT EXISTS `zt_suitecase` (
  `suite` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  UNIQUE KEY `suitecase` (`suite`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_task`;
CREATE TABLE IF NOT EXISTS `zt_task` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `parent` mediumint(8) NOT NULL DEFAULT '0',
  `project` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `estimate` float unsigned NOT NULL,
  `consumed` float unsigned NOT NULL,
  `left` float unsigned NOT NULL,
  `deadline` date NOT NULL,
  `status` enum('wait','doing','done','pause','cancel','closed') NOT NULL default 'wait',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `mailto` text,
  `desc` text NOT NULL,
  `openedBy` varchar(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `estStarted` date NOT NULL,
  `realStarted` date NOT NULL,
  `finishedBy` varchar(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `finishedList` text NOT NULL,
  `canceledBy` varchar(30) NOT NULL,
  `canceledDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
   PRIMARY KEY (`id`),
  KEY `project` (`project`),
  KEY `story` (`story`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskestimate`;
CREATE TABLE IF NOT EXISTS `zt_taskestimate` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `date` date NOT NULL,
  `left` float unsigned NOT NULL default '0',
  `consumed` float unsigned NOT NULL,
  `account` char(30) NOT NULL default '',
  `work` text,
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_team`;
CREATE TABLE IF NOT EXISTS `zt_team` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `type` enum('project','task') NOT NULL DEFAULT 'project',
  `account` char(30) NOT NULL default '',
  `role` char(30) NOT NULL default '',
  `limited` char(8) NOT NULL default 'no',
  `join` date NOT NULL default '0000-00-00',
  `days` smallint(5) unsigned NOT NULL,
  `hours` float(2,1) unsigned NOT NULL default '0',
  `estimate` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `consumed` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `left` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `order` TINYINT(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `team` (`root`,`type`,`account`)
  ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testreport`;
CREATE TABLE IF NOT EXISTS `zt_testreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `tasks` varchar(255) NOT NULL,
  `builds` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `owner` char(30) NOT NULL,
  `members` text NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `cases` text NOT NULL,
  `report` text NOT NULL,
  `objectType` varchar(20) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testresult`;
CREATE TABLE IF NOT EXISTS `zt_testresult` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `run` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  `job` mediumint(8) unsigned NOT NULL,
  `compile` mediumint(8) unsigned NOT NULL,
  `caseResult` char(30) NOT NULL,
  `stepResults` text NOT NULL,
  `lastRunner` varchar(30) NOT NULL,
  `date` datetime NOT NULL,
  `duration` float NOT NULL,
  `xml` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`),
  KEY `run` (`run`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testrun`;
CREATE TABLE IF NOT EXISTS `zt_testrun` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` tinyint(3) unsigned NOT NULL default '0',
  `assignedTo` char(30) NOT NULL default '',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `task` (`task`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testsuite`;
CREATE TABLE IF NOT EXISTS `zt_testsuite` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `type` varchar(20) NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testtask`;
CREATE TABLE IF NOT EXISTS `zt_testtask` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(90) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL default '0',
  `build` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `mailto` text,
  `desc` text NOT NULL,
  `report` text NOT NULL,
  `status` enum('blocked','doing','wait','done') NOT NULL DEFAULT 'wait',
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `subStatus` varchar(30) NOT NULL default '',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_todo`;
CREATE TABLE IF NOT EXISTS `zt_todo` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `begin` smallint(4) unsigned zerofill NOT NULL,
  `end` smallint(4) unsigned zerofill NOT NULL,
  `type` char(10) NOT NULL,
  `cycle` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `idvalue` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `name` char(150) NOT NULL,
  `desc` text NOT NULL,
  `status` enum('wait','doing','done','closed') NOT NULL DEFAULT 'wait',
  `private` tinyint(1) NOT NULL,
  `config` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NOT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `assignedTo` (`assignedTo`),
  KEY `finishedBy` (`finishedBy`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_user`;
CREATE TABLE IF NOT EXISTS `zt_user` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `dept` mediumint(8) unsigned NOT NULL default '0',
  `account` char(30) NOT NULL default '',
  `password` char(32) NOT NULL default '',
  `role` char(10) NOT NULL default '',
  `realname` varchar(100) NOT NULL default '',
  `nickname` char(60) NOT NULL default '',
  `commiter` varchar(100) NOT NULL,
  `avatar` char(30) NOT NULL default '',
  `birthday` date NOT NULL default '0000-00-00',
  `gender` enum('f','m') NOT NULL default 'f',
  `email` char(90) NOT NULL default '',
  `skype` char(90) NOT NULL default '',
  `qq` char(20) NOT NULL default '',
  `mobile` char(11) NOT NULL default '',
  `phone` char(20) NOT NULL default '',
  `weixin` varchar(90) NOT NULL default '',
  `dingding` varchar(90) NOT NULL default '',
  `slack` varchar(90) NOT NULL default '',
  `whatsapp` varchar(90) NOT NULL default '',
  `address` char(120) NOT NULL default '',
  `zipcode` char(10) NOT NULL default '',
  `join` date NOT NULL default '0000-00-00',
  `visits` mediumint(8) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  `last` int(10) unsigned NOT NULL default '0',
  `fails` tinyint(5) NOT NULL default '0',
  `locked` datetime NOT NULL default '0000-00-00 00:00:00',
  `ranzhi` char(30) NOT NULL default '',
  `score` INT(11) NOT NULL DEFAULT '0',
  `scoreLevel` INT(11) NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `dept` (`dept`),
  KEY `email` (`email`),
  KEY `commiter` (`commiter`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usercontact`;
CREATE TABLE IF NOT EXISTS `zt_usercontact` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `listName` varchar(60) NOT NULL,
  `userList` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usergroup`;
CREATE TABLE IF NOT EXISTS `zt_usergroup` (
  `account` char(30) NOT NULL default '',
  `group` mediumint(8) unsigned NOT NULL default '0',
  UNIQUE KEY `account` (`account`,`group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userquery`;
CREATE TABLE IF NOT EXISTS `zt_userquery` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(90) NOT NULL,
  `form` text NOT NULL,
  `sql` text NOT NULL,
  `shortcut` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usertpl`;
CREATE TABLE IF NOT EXISTS `zt_usertpl` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(150) NOT NULL,
  `content` text NOT NULL,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userview`;
CREATE TABLE IF NOT EXISTS `zt_userview` (
  `account` char(30) NOT NULL,
  `products` mediumtext NOT NULL,
  `projects` mediumtext NOT NULL,
  UNIQUE KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_entry`;
CREATE TABLE IF NOT EXISTS `zt_entry` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `account` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(20) NOT NULL,
  `key` varchar(32) NOT NULL,
  `freePasswd` enum('0','1') NOT NULL DEFAULT '0',
  `ip` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `calledTime` int(10) unsigned NOT NULL DEFAULT '0',
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_webhook`;
CREATE TABLE IF NOT EXISTS `zt_webhook` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) NOT NULL DEFAULT 'default',
  `name` varchar(50) NOT NULL,
  `url` varchar(255) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `secret` varchar(255) NOT NULL,
  `contentType` varchar(30) NOT NULL DEFAULT 'application/json',
  `sendType` enum('sync','async') NOT NULL DEFAULT 'sync',
  `products` text NOT NULL,
  `projects` text NOT NULL,
  `params` varchar(100) NOT NULL,
  `actions` text NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_log`;
CREATE TABLE IF NOT EXISTS `zt_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `action` mediumint(8) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `url` varchar(255) NOT NULL,
  `contentType` varchar(30) NOT NULL,
  `data` text NOT NULL,
  `result` text  NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `objectType` (`objectType`),
  KEY `obejctID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_score`;
CREATE TABLE `zt_score` (
  `id` bigint(12) unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL,
  `desc` varchar(250) NOT NULL DEFAULT '',
  `before` int(11) NOT NULL DEFAULT '0',
  `score` int(11) NOT NULL DEFAULT '0',
  `after` int(11) NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `model` (`module`),
  KEY `method` (`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_relation`;
CREATE TABLE IF NOT EXISTS `zt_relation` (
  `id` int(8) NOT NULL AUTO_INCREMENT PRIMARY KEY, 
  `program` mediumint(8) NOT NULL,
  `product` mediumint(8) NOT NULL,
  `project` mediumint(8) NOT NULL,
  `AType` char(30) NOT NULL,
  `AID` mediumint(8) NOT NULL,
  `AVersion` char(30) NOT NULL,
  `relation` char(30) NOT NULL,
  `BType` char(30) NOT NULL,
  `BID` mediumint(8) NOT NULL,
  `BVersion` char(30) NOT NULL,
  `extra` char(30) NOT NULL,
  UNIQUE KEY `relation` (`relation`,`AType`,`BType`, `AID`, `BID`)
) ENGINE='MyISAM' DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_repo`;
CREATE TABLE IF NOT EXISTS `zt_repo` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `encoding` varchar(20) NOT NULL,
  `SCM` varchar(10) NOT NULL,
  `client` varchar(100) NOT NULL,
  `commits` mediumint(8) unsigned NOT NULL,
  `account` varchar(30) NOT NULL,
  `password` varchar(30) NOT NULL,
  `encrypt` varchar(30) NOT NULL DEFAULT 'plain',
  `acl` text NOT NULL,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `lastSync` datetime NOT NULL,
  `desc` TEXT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_repobranch`;
CREATE TABLE IF NOT EXISTS `zt_repobranch` (
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `branch` varchar(255) NOT NULL,
  UNIQUE KEY `repo_revision_branch` (`repo`,`revision`,`branch`),
  KEY `branch` (`branch`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_repohistory`;
CREATE TABLE IF NOT EXISTS `zt_repohistory` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `repo` mediumint(9) NOT NULL,
  `revision` varchar(40) NOT NULL,
  `commit` mediumint(8) unsigned NOT NULL,
  `comment` text NOT NULL,
  `committer` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `repo` (`repo`,`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_repofiles`;
CREATE TABLE IF NOT EXISTS `zt_repofiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `path` varchar(255) NOT NULL,
  `parent` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `action` char(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `parent` (`parent`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('*',    '*',    '*',    '*',    '*',    '', '监控定时任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('30',   '23',   '*',    '*',    '*',    'moduleName=project&methodName=computeburn', '更新燃尽图',      'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('0',    '8',    '*',    '*',    '*',    'moduleName=report&methodName=remind',       '每日任务提醒',    'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=svn&methodName=run',             '同步SVN',         'zentao', 1, 'stop',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=git&methodName=run',             '同步GIT',         'zentao', 1, 'stop',   '0000-00-00 00:00:00'),
('30',   '0',    '*',    '*',    '*',    'moduleName=backup&methodName=backup',       '备份数据和附件',  'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=mail&methodName=asyncSend',      '异步发信',        'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=webhook&methodName=asyncSend',   '异步发送Webhook', 'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=admin&methodName=deleteLog',     '删除过期日志',    'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('1',    '1',    '*',    '*',    '*',    'moduleName=todo&methodName=createCycle',    '生成周期性待办',  'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('1',    '0',    '*',    '*',    '*',    'moduleName=ci&methodName=initQueue', '创建周期性任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=checkCompileStatus', '同步Jenkins任务状态', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=exec', '执行Jenkins任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00');

INSERT INTO `zt_group` (`id`, `name`, `role`, `desc`) VALUES
(1, 'ADMIN', 'admin', 'for administrator'),
(2, 'DEV', 'dev', 'for developers.'),
(3, 'QA', 'qa', 'for testers.'),
(4, 'PM', 'pm', 'for project managers.'),
(5, 'PO', 'po', 'for product owners.'),
(6, 'TD', 'td', 'for technical director.'),
(7, 'PD', 'pd', 'for product director.'),
(8, 'QD', 'qd', 'for quality director.'),
(9, 'TOP', 'top', 'for top manager.'),
(10, 'OTHERS', 'others', 'for others.'),
(11, 'guest', 'guest', 'For guest'),
(12, 'LIMITED', 'limited', 'For limited user');

INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'action', 'editComment'),
(1, 'action', 'hideAll'),
(1, 'action', 'hideOne'),
(1, 'action', 'trash'),
(1, 'action', 'undelete'),
(1, 'admin', 'checkDB'),
(1, 'admin', 'checkWeak'),
(1, 'admin', 'index'),
(1, 'admin', 'safe'),
(1, 'api', 'debug'),
(1, 'backup', 'backup'),
(1, 'backup', 'change'),
(1, 'backup', 'delete'),
(1, 'backup', 'index'),
(1, 'backup', 'restore'),
(1, 'bug', 'activate'),
(1, 'bug', 'assignTo'),
(1, 'bug', 'batchAssignTo'),
(1, 'bug', 'batchClose'),
(1, 'bug', 'batchActivate'),
(1, 'bug', 'batchConfirm'),
(1, 'bug', 'batchCreate'),
(1, 'bug', 'batchEdit'),
(1, 'bug', 'batchResolve'),
(1, 'bug', 'browse'),
(1, 'bug', 'close'),
(1, 'bug', 'confirmBug'),
(1, 'bug', 'confirmStoryChange'),
(1, 'bug', 'create'),
(1, 'bug', 'delete'),
(1, 'bug', 'deleteTemplate'),
(1, 'bug', 'edit'),
(1, 'bug', 'batchChangeModule'),
(1, 'bug', 'linkBugs'),
(1, 'bug', 'unlinkBug'),
(1, 'bug', 'export'),
(1, 'bug', 'index'),
(1, 'bug', 'report'),
(1, 'bug', 'resolve'),
(1, 'bug', 'saveTemplate'),
(1, 'bug', 'view'),
(1, 'build', 'batchUnlinkBug'),
(1, 'build', 'batchUnlinkStory'),
(1, 'build', 'create'),
(1, 'build', 'delete'),
(1, 'build', 'edit'),
(1, 'build', 'linkBug'),
(1, 'build', 'linkStory'),
(1, 'build', 'unlinkBug'),
(1, 'build', 'unlinkStory'),
(1, 'build', 'view'),
(1, 'company', 'browse'),
(1, 'company', 'dynamic'),
(1, 'company', 'edit'),
(1, 'company', 'index'),
(1, 'company', 'view'),
(1, 'convert', 'checkBugFree'),
(1, 'convert', 'checkConfig'),
(1, 'convert', 'checkRedmine'),
(1, 'convert', 'convertBugFree'),
(1, 'convert', 'convertRedmine'),
(1, 'convert', 'execute'),
(1, 'convert', 'index'),
(1, 'convert', 'selectSource'),
(1, 'convert', 'setBugfree'),
(1, 'convert', 'setConfig'),
(1, 'convert', 'setRedmine'),
(1, 'cron', 'create'),
(1, 'cron', 'delete'),
(1, 'cron', 'edit'),
(1, 'cron', 'index'),
(1, 'cron', 'toggle'),
(1, 'cron', 'turnon'),
(1, 'custom', 'flow'),
(1, 'custom', 'working'),
(1, 'custom', 'index'),
(1, 'custom', 'restore'),
(1, 'custom', 'set'),
(1, 'dept', 'browse'),
(1, 'dept', 'delete'),
(1, 'dept', 'edit'),
(1, 'dept', 'manageChild'),
(1, 'dept', 'updateOrder'),
(1, 'dev', 'api'),
(1, 'dev', 'db'),
(1, 'dev', 'editor'),
(1, 'dev', 'translate'),
(1, 'doc', 'browse'),
(1, 'doc', 'create'),
(1, 'doc', 'createLib'),
(1, 'doc', 'delete'),
(1, 'doc', 'deleteLib'),
(1, 'doc', 'deleteFile'),
(1, 'doc', 'edit'),
(1, 'doc', 'editLib'),
(1, 'doc', 'index'),
(1, 'doc', 'allLibs'),
(1, 'doc', 'objectLibs'),
(1, 'doc', 'showFiles'),
(1, 'doc', 'view'),
(1, 'doc', 'sort'),
(1, 'extension', 'activate'),
(1, 'extension', 'browse'),
(1, 'extension', 'deactivate'),
(1, 'extension', 'erase'),
(1, 'extension', 'install'),
(1, 'extension', 'obtain'),
(1, 'extension', 'structure'),
(1, 'extension', 'uninstall'),
(1, 'extension', 'upgrade'),
(1, 'extension', 'upload'),
(1, 'file', 'delete'),
(1, 'file', 'download'),
(1, 'file', 'edit'),
(1, 'file', 'uploadImages'),
(1, 'git', 'apiSync'),
(1, 'git', 'cat'),
(1, 'git', 'diff'),
(1, 'group', 'browse'),
(1, 'group', 'copy'),
(1, 'group', 'create'),
(1, 'group', 'delete'),
(1, 'group', 'edit'),
(1, 'group', 'manageMember'),
(1, 'group', 'managePriv'),
(1, 'group', 'manageView'),
(1, 'index', 'index'),
(1, 'mail', 'batchDelete'),
(1, 'mail', 'browse'),
(1, 'mail', 'delete'),
(1, 'mail', 'resend'),
(1, 'mail', 'detect'),
(1, 'mail', 'edit'),
(1, 'mail', 'index'),
(1, 'mail', 'reset'),
(1, 'mail', 'save'),
(1, 'mail', 'test'),
(1, 'message', 'index'),
(1, 'message', 'browser'),
(1, 'message', 'setting'),
(1, 'misc', 'ping'),
(1, 'my', 'bug'),
(1, 'my', 'changePassword'),
(1, 'my', 'dynamic'),
(1, 'my', 'editProfile'),
(1, 'my', 'index'),
(1, 'my', 'profile'),
(1, 'my', 'project'),
(1, 'my', 'story'),
(1, 'my', 'task'),
(1, 'my', 'testCase'),
(1, 'my', 'testTask'),
(1, 'my', 'todo'),
(1, 'my', 'calendar'),
(1, 'my', 'unbind'),
(1, 'my', 'manageContacts'),
(1, 'my', 'deleteContacts'),
(1, 'product', 'batchEdit'),
(1, 'product', 'browse'),
(1, 'product', 'close'),
(1, 'product', 'create'),
(1, 'product', 'delete'),
(1, 'product', 'doc'),
(1, 'product', 'dynamic'),
(1, 'product', 'edit'),
(1, 'product', 'index'),
(1, 'product', 'all'),
(1, 'product', 'order'),
(1, 'product', 'project'),
(1, 'product', 'roadmap'),
(1, 'product', 'view'),
(1, 'product', 'build'),
(1, 'product', 'updateOrder'),
(1, 'branch', 'manage'),
(1, 'branch', 'sort'),
(1, 'branch', 'delete'),
(1, 'productplan', 'batchUnlinkBug'),
(1, 'productplan', 'batchUnlinkStory'),
(1, 'productplan', 'browse'),
(1, 'productplan', 'create'),
(1, 'productplan', 'delete'),
(1, 'productplan', 'edit'),
(1, 'productplan', 'linkBug'),
(1, 'productplan', 'linkStory'),
(1, 'productplan', 'unlinkBug'),
(1, 'productplan', 'unlinkStory'),
(1, 'productplan', 'view'),
(1, 'project', 'activate'),
(1, 'project', 'batchedit'),
(1, 'project', 'batchUnlinkStory'),
(1, 'project', 'browse'),
(1, 'project', 'bug'),
(1, 'project', 'build'),
(1, 'project', 'burn'),
(1, 'project', 'close'),
(1, 'project', 'computeBurn'),
(1, 'project', 'create'),
(1, 'project', 'delete'),
(1, 'project', 'doc'),
(1, 'project', 'dynamic'),
(1, 'project', 'edit'),
(1, 'project', 'grouptask'),
(1, 'project', 'importBug'),
(1, 'project', 'importtask'),
(1, 'project', 'index'),
(1, 'project', 'all'),
(1, 'project', 'linkStory'),
(1, 'project', 'importPlanStories'),
(1, 'project', 'manageMembers'),
(1, 'project', 'manageProducts'),
(1, 'project', 'order'),
(1, 'project', 'putoff'),
(1, 'project', 'start'),
(1, 'project', 'story'),
(1, 'project', 'suspend'),
(1, 'project', 'task'),
(1, 'project', 'kanban'),
(1, 'project', 'tree'),
(1, 'project', 'treetask'),
(1, 'project', 'treestory'),
(1, 'project', 'team'),
(1, 'project', 'testtask'),
(1, 'project', 'unlinkMember'),
(1, 'project', 'unlinkStory'),
(1, 'project', 'view'),
(1, 'project', 'updateOrder'),
(1, 'qa', 'index'),
(1, 'release', 'batchUnlinkBug'),
(1, 'release', 'batchUnlinkStory'),
(1, 'release', 'browse'),
(1, 'release', 'create'),
(1, 'release', 'delete'),
(1, 'release', 'edit'),
(1, 'release', 'export'),
(1, 'release', 'linkBug'),
(1, 'release', 'linkStory'),
(1, 'release', 'unlinkBug'),
(1, 'release', 'unlinkStory'),
(1, 'release', 'view'),
(1, 'release', 'changeStatus'),
(1, 'repo', 'view'),
(1, 'repo', 'blame'),
(1, 'repo', 'revision'),
(1, 'repo', 'showSyncCommit'),
(1, 'repo', 'download'),
(1, 'repo', 'browse'),
(1, 'repo', 'diff'),
(1, 'repo', 'log'),
(1, 'repo', 'maintain'),
(1, 'repo', 'setRules'),
(1, 'repo', 'create'),
(1, 'repo', 'edit'),
(1, 'repo', 'delete'),
(1, 'compile', 'browse'),
(1, 'compile', 'logs'),
(1, 'jenkins', 'browse'),
(1, 'jenkins', 'create'),
(1, 'jenkins', 'edit'),
(1, 'jenkins', 'delete'),
(1, 'job', 'browse'),
(1, 'job', 'create'),
(1, 'job', 'edit'),
(1, 'job', 'delete'),
(1, 'job', 'exec'),
(1, 'report', 'bugAssign'),
(1, 'report', 'bugCreate'),
(1, 'report', 'index'),
(1, 'report', 'productSummary'),
(1, 'report', 'projectDeviation'),
(1, 'report', 'workload'),
(1, 'search', 'buildForm'),
(1, 'search', 'buildQuery'),
(1, 'search', 'deleteQuery'),
(1, 'search', 'saveQuery'),
(1, 'search', 'select'),
(1, 'story', 'activate'),
(1, 'story', 'batchAssignTo'),
(1, 'story', 'batchChangePlan'),
(1, 'story', 'batchChangeBranch'),
(1, 'story', 'batchChangeStage'),
(1, 'story', 'batchClose'),
(1, 'story', 'batchCreate'),
(1, 'story', 'batchEdit'),
(1, 'story', 'batchReview'),
(1, 'story', 'change'),
(1, 'story', 'close'),
(1, 'story', 'create'),
(1, 'story', 'delete'),
(1, 'story', 'edit'),
(1, 'story', 'assignTo'),
(1, 'story', 'batchChangeModule'),
(1, 'story', 'linkStory'),
(1, 'story', 'unlinkStory'),
(1, 'story', 'export'),
(1, 'story', 'report'),
(1, 'story', 'review'),
(1, 'story', 'tasks'),
(1, 'story', 'bugs'),
(1, 'story', 'cases'),
(1, 'story', 'view'),
(1, 'story', 'zeroCase'),
(1, 'svn', 'apiSync'),
(1, 'svn', 'cat'),
(1, 'svn', 'diff'),
(1, 'task', 'activate'),
(1, 'task', 'assignTo'),
(1, 'task', 'batchAssignTo'),
(1, 'task', 'batchClose'),
(1, 'task', 'batchCreate'),
(1, 'task', 'batchEdit'),
(1, 'task', 'cancel'),
(1, 'task', 'close'),
(1, 'task', 'confirmStoryChange'),
(1, 'task', 'create'),
(1, 'task', 'delete'),
(1, 'task', 'deleteEstimate'),
(1, 'task', 'edit'),
(1, 'task', 'batchChangeModule'),
(1, 'task', 'editEstimate'),
(1, 'task', 'export'),
(1, 'task', 'finish'),
(1, 'task', 'pause'),
(1, 'task', 'recordEstimate'),
(1, 'task', 'report'),
(1, 'task', 'restart'),
(1, 'task', 'start'),
(1, 'task', 'view'),
(1, 'testcase', 'batchCreate'),
(1, 'testcase', 'batchDelete'),
(1, 'testcase', 'batchEdit'),
(1, 'testcase', 'browse'),
(1, 'testcase', 'bugs'),
(1, 'testcase', 'confirmChange'),
(1, 'testcase', 'confirmStoryChange'),
(1, 'testcase', 'create'),
(1, 'testcase', 'createBug'),
(1, 'testcase', 'delete'),
(1, 'testcase', 'edit'),
(1, 'testcase', 'review'),
(1, 'testcase', 'batchReview'),
(1, 'testcase', 'batchCaseTypeChange'),
(1, 'testcase', 'batchConfirmStoryChange'),
(1, 'testcase', 'batchChangeModule'),
(1, 'testcase', 'linkCases'),
(1, 'testcase', 'unlinkCase'),
(1, 'testcase', 'export'),
(1, 'testcase', 'exportTemplet'),
(1, 'testcase', 'groupCase'),
(1, 'testcase', 'import'),
(1, 'testcase', 'index'),
(1, 'testcase', 'showImport'),
(1, 'testcase', 'view'),
(1, 'testcase', 'importFromLib'),
(1, 'testreport', 'browse'),
(1, 'testreport', 'create'),
(1, 'testreport', 'view'),
(1, 'testreport', 'delete'),
(1, 'testreport', 'edit'),
(1, 'testsuite', 'index'),
(1, 'testsuite', 'browse'),
(1, 'testsuite', 'create'),
(1, 'testsuite', 'view'),
(1, 'testsuite', 'edit'),
(1, 'testsuite', 'delete'),
(1, 'testsuite', 'linkCase'),
(1, 'testsuite', 'unlinkCase'),
(1, 'testsuite', 'batchUnlinkCases'),
(1, 'testsuite', 'library'),
(1, 'testsuite', 'createLib'),
(1, 'testsuite', 'createCase'),
(1, 'testsuite', 'exportTemplet'),
(1, 'testsuite', 'batchCreateCase'),
(1, 'testsuite', 'import'),
(1, 'testsuite', 'showImport'),
(1, 'testsuite', 'libView'),
(1, 'testtask', 'batchAssign'),
(1, 'testtask', 'batchRun'),
(1, 'testtask', 'browse'),
(1, 'testtask', 'cases'),
(1, 'testtask', 'close'),
(1, 'testtask', 'create'),
(1, 'testtask', 'delete'),
(1, 'testtask', 'edit'),
(1, 'testtask', 'groupCase'),
(1, 'testtask', 'index'),
(1, 'testtask', 'linkcase'),
(1, 'testtask', 'results'),
(1, 'testtask', 'runcase'),
(1, 'testtask', 'start'),
(1, 'testtask', 'activate'),
(1, 'testtask', 'block'),
(1, 'testtask', 'report'),
(1, 'testtask', 'unlinkcase'),
(1, 'testtask', 'view'),
(1, 'todo', 'activate'),
(1, 'todo', 'assignTo'),
(1, 'todo', 'batchClose'),
(1, 'todo', 'batchCreate'),
(1, 'todo', 'batchEdit'),
(1, 'todo', 'batchFinish'),
(1, 'todo', 'create'),
(1, 'todo', 'createCycle'),
(1, 'todo', 'close'),
(1, 'todo', 'delete'),
(1, 'todo', 'edit'),
(1, 'todo', 'export'),
(1, 'todo', 'finish'),
(1, 'todo', 'import2Today'),
(1, 'todo', 'view'),
(1, 'tree', 'browse'),
(1, 'tree', 'browseTask'),
(1, 'tree', 'delete'),
(1, 'tree', 'edit'),
(1, 'tree', 'fix'),
(1, 'tree', 'manageChild'),
(1, 'tree', 'updateOrder'),
(1, 'user', 'batchCreate'),
(1, 'user', 'batchEdit'),
(1, 'user', 'bug'),
(1, 'user', 'create'),
(1, 'user', 'delete'),
(1, 'user', 'deleteContacts'),
(1, 'user', 'dynamic'),
(1, 'user', 'edit'),
(1, 'user', 'manageContacts'),
(1, 'user', 'profile'),
(1, 'user', 'project'),
(1, 'user', 'story'),
(1, 'user', 'task'),
(1, 'user', 'testCase'),
(1, 'user', 'testTask'),
(1, 'user', 'todo'),
(1, 'user', 'unlock'),
(1, 'user', 'view'),
(1, 'user', 'unbind'),
(2, 'action', 'editComment'),
(2, 'bug', 'activate'),
(2, 'bug', 'assignTo'),
(2, 'bug', 'batchAssignTo'),
(2, 'bug', 'batchClose'),
(2, 'bug', 'batchActivate'),
(2, 'bug', 'batchConfirm'),
(2, 'bug', 'batchCreate'),
(2, 'bug', 'batchEdit'),
(2, 'bug', 'batchResolve'),
(2, 'bug', 'browse'),
(2, 'bug', 'close'),
(2, 'bug', 'confirmBug'),
(2, 'bug', 'confirmStoryChange'),
(2, 'bug', 'create'),
(2, 'bug', 'deleteTemplate'),
(2, 'bug', 'edit'),
(2, 'bug', 'batchChangeModule'),
(2, 'bug', 'linkBugs'),
(2, 'bug', 'unlinkBug'),
(2, 'bug', 'export'),
(2, 'bug', 'index'),
(2, 'bug', 'report'),
(2, 'bug', 'resolve'),
(2, 'bug', 'saveTemplate'),
(2, 'bug', 'view'),
(2, 'build', 'create'),
(2, 'build', 'delete'),
(2, 'build', 'edit'),
(2, 'build', 'view'),
(2, 'company', 'browse'),
(2, 'company', 'dynamic'),
(2, 'company', 'index'),
(2, 'company', 'view'),
(2, 'doc', 'browse'),
(2, 'doc', 'create'),
(2, 'doc', 'edit'),
(2, 'doc', 'index'),
(2, 'doc', 'allLibs'),
(2, 'doc', 'objectLibs'),
(2, 'doc', 'showFiles'),
(2, 'doc', 'view'),
(2, 'file', 'download'),
(2, 'file', 'edit'),
(2, 'git', 'apiSync'),
(2, 'git', 'cat'),
(2, 'git', 'diff'),
(2, 'group', 'browse'),
(2, 'index', 'index'),
(2, 'misc', 'ping'),
(2, 'my', 'bug'),
(2, 'my', 'changePassword'),
(2, 'my', 'dynamic'),
(2, 'my', 'editProfile'),
(2, 'my', 'index'),
(2, 'my', 'profile'),
(2, 'my', 'project'),
(2, 'my', 'story'),
(2, 'my', 'task'),
(2, 'my', 'todo'),
(2, 'my', 'calendar'),
(2, 'my', 'unbind'),
(2, 'my', 'manageContacts'),
(2, 'my', 'deleteContacts'),
(2, 'product', 'browse'),
(2, 'product', 'doc'),
(2, 'product', 'dynamic'),
(2, 'product', 'index'),
(2, 'product', 'all'),
(2, 'product', 'project'),
(2, 'product', 'roadmap'),
(2, 'product', 'view'),
(2, 'product', 'build'),
(2, 'productplan', 'browse'),
(2, 'productplan', 'view'),
(2, 'project', 'browse'),
(2, 'project', 'bug'),
(2, 'project', 'build'),
(2, 'project', 'burn'),
(2, 'project', 'computeBurn'),
(2, 'project', 'doc'),
(2, 'project', 'dynamic'),
(2, 'project', 'grouptask'),
(2, 'project', 'importBug'),
(2, 'project', 'importtask'),
(2, 'project', 'index'),
(2, 'project', 'all'),
(2, 'project', 'story'),
(2, 'project', 'task'),
(2, 'project', 'kanban'),
(2, 'project', 'tree'),
(2, 'project', 'treetask'),
(2, 'project', 'treestory'),
(2, 'project', 'team'),
(2, 'project', 'testtask'),
(2, 'project', 'view'),
(2, 'qa', 'index'),
(2, 'release', 'browse'),
(2, 'release', 'export'),
(2, 'release', 'view'),
(2, 'repo', 'view'),
(2, 'repo', 'blame'),
(2, 'repo', 'revision'),
(2, 'repo', 'showSyncCommit'),
(2, 'repo', 'download'),
(2, 'repo', 'browse'),
(2, 'repo', 'diff'),
(2, 'repo', 'log'),
(2, 'report', 'bugAssign'),
(2, 'report', 'bugCreate'),
(2, 'report', 'index'),
(2, 'report', 'productSummary'),
(2, 'report', 'projectDeviation'),
(2, 'report', 'workload'),
(2, 'search', 'buildForm'),
(2, 'search', 'buildQuery'),
(2, 'search', 'deleteQuery'),
(2, 'search', 'saveQuery'),
(2, 'search', 'select'),
(2, 'story', 'export'),
(2, 'story', 'report'),
(2, 'story', 'tasks'),
(2, 'story', 'bugs'),
(2, 'story', 'cases'),
(2, 'story', 'view'),
(2, 'svn', 'apiSync'),
(2, 'svn', 'cat'),
(2, 'svn', 'diff'),
(2, 'task', 'activate'),
(2, 'task', 'assignTo'),
(2, 'task', 'batchAssignTo'),
(2, 'task', 'batchClose'),
(2, 'task', 'batchCreate'),
(2, 'task', 'batchEdit'),
(2, 'task', 'cancel'),
(2, 'task', 'close'),
(2, 'task', 'confirmStoryChange'),
(2, 'task', 'create'),
(2, 'task', 'deleteEstimate'),
(2, 'task', 'edit'),
(2, 'task', 'batchChangeModule'),
(2, 'task', 'editEstimate'),
(2, 'task', 'export'),
(2, 'task', 'finish'),
(2, 'task', 'pause'),
(2, 'task', 'recordEstimate'),
(2, 'task', 'report'),
(2, 'task', 'restart'),
(2, 'task', 'start'),
(2, 'task', 'view'),
(2, 'testcase', 'browse'),
(2, 'testcase', 'bugs'),
(2, 'testcase', 'export'),
(2, 'testcase', 'groupCase'),
(2, 'testcase', 'index'),
(2, 'testcase', 'view'),
(2, 'testsuite', 'index'),
(2, 'testsuite', 'browse'),
(2, 'testsuite', 'view'),
(2, 'testtask', 'browse'),
(2, 'testtask', 'cases'),
(2, 'testtask', 'create'),
(2, 'testtask', 'edit'),
(2, 'testtask', 'groupCase'),
(2, 'testtask', 'index'),
(2, 'testtask', 'results'),
(2, 'testtask', 'view'),
(2, 'todo', 'activate'),
(2, 'todo', 'assignTo'),
(2, 'todo', 'batchClose'),
(2, 'todo', 'batchCreate'),
(2, 'todo', 'batchEdit'),
(2, 'todo', 'batchFinish'),
(2, 'todo', 'create'),
(2, 'todo', 'createCycle'),
(2, 'todo', 'close'),
(2, 'todo', 'delete'),
(2, 'todo', 'edit'),
(2, 'todo', 'export'),
(2, 'todo', 'finish'),
(2, 'todo', 'import2Today'),
(2, 'todo', 'view'),
(2, 'user', 'bug'),
(2, 'user', 'deleteContacts'),
(2, 'user', 'dynamic'),
(2, 'user', 'manageContacts'),
(2, 'user', 'profile'),
(2, 'user', 'project'),
(2, 'user', 'story'),
(2, 'user', 'task'),
(2, 'user', 'testCase'),
(2, 'user', 'testTask'),
(2, 'user', 'todo'),
(2, 'user', 'view'),
(3, 'action', 'editComment'),
(3, 'bug', 'activate'),
(3, 'bug', 'assignTo'),
(3, 'bug', 'batchClose'),
(3, 'bug', 'batchActivate'),
(3, 'bug', 'batchConfirm'),
(3, 'bug', 'batchCreate'),
(3, 'bug', 'batchEdit'),
(3, 'bug', 'batchResolve'),
(3, 'bug', 'browse'),
(3, 'bug', 'close'),
(3, 'bug', 'confirmBug'),
(3, 'bug', 'confirmStoryChange'),
(3, 'bug', 'create'),
(3, 'bug', 'deleteTemplate'),
(3, 'bug', 'edit'),
(3, 'bug', 'batchChangeModule'),
(3, 'bug', 'linkBugs'),
(3, 'bug', 'unlinkBug'),
(3, 'bug', 'export'),
(3, 'bug', 'index'),
(3, 'bug', 'report'),
(3, 'bug', 'resolve'),
(3, 'bug', 'saveTemplate'),
(3, 'bug', 'view'),
(3, 'build', 'create'),
(3, 'build', 'edit'),
(3, 'build', 'view'),
(3, 'company', 'browse'),
(3, 'company', 'dynamic'),
(3, 'company', 'index'),
(3, 'company', 'view'),
(3, 'doc', 'browse'),
(3, 'doc', 'create'),
(3, 'doc', 'edit'),
(3, 'doc', 'index'),
(3, 'doc', 'allLibs'),
(3, 'doc', 'objectLibs'),
(3, 'doc', 'showFiles'),
(3, 'doc', 'view'),
(3, 'file', 'download'),
(3, 'file', 'edit'),
(3, 'git', 'apiSync'),
(3, 'git', 'cat'),
(3, 'git', 'diff'),
(3, 'group', 'browse'),
(3, 'index', 'index'),
(3, 'misc', 'ping'),
(3, 'my', 'bug'),
(3, 'my', 'changePassword'),
(3, 'my', 'dynamic'),
(3, 'my', 'editProfile'),
(3, 'my', 'index'),
(3, 'my', 'profile'),
(3, 'my', 'project'),
(3, 'my', 'story'),
(3, 'my', 'task'),
(3, 'my', 'testCase'),
(3, 'my', 'testTask'),
(3, 'my', 'todo'),
(3, 'my', 'calendar'),
(3, 'my', 'unbind'),
(3, 'my', 'manageContacts'),
(3, 'my', 'deleteContacts'),
(3, 'product', 'browse'),
(3, 'product', 'doc'),
(3, 'product', 'dynamic'),
(3, 'product', 'index'),
(3, 'product', 'all'),
(3, 'product', 'project'),
(3, 'product', 'roadmap'),
(3, 'product', 'view'),
(3, 'product', 'build'),
(3, 'productplan', 'browse'),
(3, 'productplan', 'view'),
(3, 'project', 'browse'),
(3, 'project', 'bug'),
(3, 'project', 'build'),
(3, 'project', 'burn'),
(3, 'project', 'computeBurn'),
(3, 'project', 'doc'),
(3, 'project', 'dynamic'),
(3, 'project', 'grouptask'),
(3, 'project', 'importBug'),
(3, 'project', 'importtask'),
(3, 'project', 'index'),
(3, 'project', 'all'),
(3, 'project', 'story'),
(3, 'project', 'task'),
(3, 'project', 'kanban'),
(3, 'project', 'tree'),
(3, 'project', 'treetask'),
(3, 'project', 'treestory'),
(3, 'project', 'team'),
(3, 'project', 'testtask'),
(3, 'project', 'view'),
(3, 'qa', 'index'),
(3, 'release', 'browse'),
(3, 'release', 'export'),
(3, 'release', 'view'),
(3, 'repo', 'view'),
(3, 'repo', 'blame'),
(3, 'repo', 'revision'),
(3, 'repo', 'showSyncCommit'),
(3, 'repo', 'download'),
(3, 'repo', 'browse'),
(3, 'repo', 'diff'),
(3, 'repo', 'log'),
(3, 'report', 'bugAssign'),
(3, 'report', 'bugCreate'),
(3, 'report', 'index'),
(3, 'report', 'productSummary'),
(3, 'report', 'projectDeviation'),
(3, 'report', 'workload'),
(3, 'search', 'buildForm'),
(3, 'search', 'buildQuery'),
(3, 'search', 'deleteQuery'),
(3, 'search', 'saveQuery'),
(3, 'search', 'select'),
(3, 'story', 'export'),
(3, 'story', 'report'),
(3, 'story', 'tasks'),
(3, 'story', 'bugs'),
(3, 'story', 'cases'),
(3, 'story', 'view'),
(3, 'story', 'zeroCase'),
(3, 'svn', 'apiSync'),
(3, 'svn', 'cat'),
(3, 'svn', 'diff'),
(3, 'task', 'activate'),
(3, 'task', 'assignTo'),
(3, 'task', 'batchAssignTo'),
(3, 'task', 'batchClose'),
(3, 'task', 'batchCreate'),
(3, 'task', 'batchEdit'),
(3, 'task', 'cancel'),
(3, 'task', 'close'),
(3, 'task', 'confirmStoryChange'),
(3, 'task', 'create'),
(3, 'task', 'deleteEstimate'),
(3, 'task', 'edit'),
(3, 'task', 'batchChangeModule'),
(3, 'task', 'editEstimate'),
(3, 'task', 'export'),
(3, 'task', 'finish'),
(3, 'task', 'pause'),
(3, 'task', 'recordEstimate'),
(3, 'task', 'report'),
(3, 'task', 'restart'),
(3, 'task', 'start'),
(3, 'task', 'view'),
(3, 'testcase', 'batchCreate'),
(3, 'testcase', 'batchEdit'),
(3, 'testcase', 'browse'),
(3, 'testcase', 'bugs'),
(3, 'testcase', 'confirmChange'),
(3, 'testcase', 'confirmStoryChange'),
(3, 'testcase', 'create'),
(3, 'testcase', 'createBug'),
(3, 'testcase', 'edit'),
(3, 'testcase', 'review'),
(3, 'testcase', 'batchReview'),
(3, 'testcase', 'batchCaseTypeChange'),
(3, 'testcase', 'batchConfirmStoryChange'),
(3, 'testcase', 'batchChangeModule'),
(3, 'testcase', 'linkCases'),
(3, 'testcase', 'unlinkCase'),
(3, 'testcase', 'export'),
(3, 'testcase', 'exportTemplet'),
(3, 'testcase', 'groupCase'),
(3, 'testcase', 'import'),
(3, 'testcase', 'index'),
(3, 'testcase', 'showImport'),
(3, 'testcase', 'view'),
(3, 'testreport', 'browse'),
(3, 'testreport', 'view'),
(3, 'testsuite', 'index'),
(3, 'testsuite', 'browse'),
(3, 'testsuite', 'create'),
(3, 'testsuite', 'view'),
(3, 'testsuite', 'edit'),
(3, 'testsuite', 'delete'),
(3, 'testsuite', 'linkCase'),
(3, 'testsuite', 'unlinkCase'),
(3, 'testtask', 'batchAssign'),
(3, 'testtask', 'batchRun'),
(3, 'testtask', 'browse'),
(3, 'testtask', 'cases'),
(3, 'testtask', 'close'),
(3, 'testtask', 'create'),
(3, 'testtask', 'edit'),
(3, 'testtask', 'groupCase'),
(3, 'testtask', 'index'),
(3, 'testtask', 'linkcase'),
(3, 'testtask', 'results'),
(3, 'testtask', 'runcase'),
(3, 'testtask', 'start'),
(3, 'testtask', 'activate'),
(3, 'testtask', 'block'),
(3, 'testtask', 'report'),
(3, 'testtask', 'unlinkcase'),
(3, 'testtask', 'view'),
(3, 'todo', 'activate'),
(3, 'todo', 'assignTo'),
(3, 'todo', 'batchClose'),
(3, 'todo', 'batchCreate'),
(3, 'todo', 'batchEdit'),
(3, 'todo', 'batchFinish'),
(3, 'todo', 'create'),
(3, 'todo', 'createCycle'),
(3, 'todo', 'close'),
(3, 'todo', 'delete'),
(3, 'todo', 'edit'),
(3, 'todo', 'export'),
(3, 'todo', 'finish'),
(3, 'todo', 'import2Today'),
(3, 'todo', 'view'),
(3, 'user', 'bug'),
(3, 'user', 'deleteContacts'),
(3, 'user', 'dynamic'),
(3, 'user', 'manageContacts'),
(3, 'user', 'profile'),
(3, 'user', 'project'),
(3, 'user', 'story'),
(3, 'user', 'task'),
(3, 'user', 'testCase'),
(3, 'user', 'testTask'),
(3, 'user', 'todo'),
(3, 'user', 'view'),
(4, 'action', 'editComment'),
(4, 'action', 'hideAll'),
(4, 'action', 'hideOne'),
(4, 'action', 'trash'),
(4, 'action', 'undelete'),
(4, 'admin', 'index'),
(4, 'bug', 'activate'),
(4, 'bug', 'assignTo'),
(4, 'bug', 'batchAssignTo'),
(4, 'bug', 'batchClose'),
(4, 'bug', 'batchActivate'),
(4, 'bug', 'batchConfirm'),
(4, 'bug', 'batchCreate'),
(4, 'bug', 'batchEdit'),
(4, 'bug', 'batchResolve'),
(4, 'bug', 'browse'),
(4, 'bug', 'close'),
(4, 'bug', 'confirmBug'),
(4, 'bug', 'confirmStoryChange'),
(4, 'bug', 'create'),
(4, 'bug', 'delete'),
(4, 'bug', 'deleteTemplate'),
(4, 'bug', 'edit'),
(4, 'bug', 'batchChangeModule'),
(4, 'bug', 'linkBugs'),
(4, 'bug', 'unlinkBug'),
(4, 'bug', 'export'),
(4, 'bug', 'index'),
(4, 'bug', 'report'),
(4, 'bug', 'resolve'),
(4, 'bug', 'saveTemplate'),
(4, 'bug', 'view'),
(4, 'build', 'batchUnlinkBug'),
(4, 'build', 'batchUnlinkStory'),
(4, 'build', 'create'),
(4, 'build', 'delete'),
(4, 'build', 'edit'),
(4, 'build', 'linkBug'),
(4, 'build', 'linkStory'),
(4, 'build', 'unlinkBug'),
(4, 'build', 'unlinkStory'),
(4, 'build', 'view'),
(4, 'company', 'browse'),
(4, 'company', 'dynamic'),
(4, 'company', 'index'),
(4, 'company', 'view'),
(4, 'doc', 'browse'),
(4, 'doc', 'create'),
(4, 'doc', 'createLib'),
(4, 'doc', 'delete'),
(4, 'doc', 'deleteLib'),
(4, 'doc', 'deleteFile'),
(4, 'doc', 'edit'),
(4, 'doc', 'editLib'),
(4, 'doc', 'index'),
(4, 'doc', 'allLibs'),
(4, 'doc', 'objectLibs'),
(4, 'doc', 'showFiles'),
(4, 'doc', 'view'),
(4, 'extension', 'browse'),
(4, 'extension', 'obtain'),
(4, 'extension', 'structure'),
(4, 'file', 'delete'),
(4, 'file', 'download'),
(4, 'file', 'edit'),
(4, 'file', 'uploadImages'),
(4, 'git', 'apiSync'),
(4, 'git', 'cat'),
(4, 'git', 'diff'),
(4, 'group', 'browse'),
(4, 'index', 'index'),
(4, 'misc', 'ping'),
(4, 'my', 'bug'),
(4, 'my', 'changePassword'),
(4, 'my', 'dynamic'),
(4, 'my', 'editProfile'),
(4, 'my', 'index'),
(4, 'my', 'profile'),
(4, 'my', 'project'),
(4, 'my', 'story'),
(4, 'my', 'task'),
(4, 'my', 'testCase'),
(4, 'my', 'testTask'),
(4, 'my', 'todo'),
(4, 'my', 'calendar'),
(4, 'my', 'unbind'),
(4, 'my', 'manageContacts'),
(4, 'my', 'deleteContacts'),
(4, 'product', 'browse'),
(4, 'product', 'doc'),
(4, 'product', 'dynamic'),
(4, 'product', 'index'),
(4, 'product', 'all'),
(4, 'product', 'project'),
(4, 'product', 'roadmap'),
(4, 'product', 'view'),
(4, 'product', 'build'),
(4, 'productplan', 'browse'),
(4, 'productplan', 'view'),
(4, 'project', 'activate'),
(4, 'project', 'batchedit'),
(4, 'project', 'batchUnlinkStory'),
(4, 'project', 'browse'),
(4, 'project', 'bug'),
(4, 'project', 'build'),
(4, 'project', 'burn'),
(4, 'project', 'close'),
(4, 'project', 'computeBurn'),
(4, 'project', 'create'),
(4, 'project', 'delete'),
(4, 'project', 'doc'),
(4, 'project', 'dynamic'),
(4, 'project', 'edit'),
(4, 'project', 'grouptask'),
(4, 'project', 'importBug'),
(4, 'project', 'importtask'),
(4, 'project', 'index'),
(4, 'project', 'all'),
(4, 'project', 'linkStory'),
(4, 'project', 'importPlanStories'),
(4, 'project', 'manageMembers'),
(4, 'project', 'manageProducts'),
(4, 'project', 'order'),
(4, 'project', 'putoff'),
(4, 'project', 'start'),
(4, 'project', 'story'),
(4, 'project', 'suspend'),
(4, 'project', 'task'),
(4, 'project', 'kanban'),
(4, 'project', 'tree'),
(4, 'project', 'treetask'),
(4, 'project', 'treestory'),
(4, 'project', 'team'),
(4, 'project', 'testtask'),
(4, 'project', 'unlinkMember'),
(4, 'project', 'unlinkStory'),
(4, 'project', 'view'),
(4, 'project', 'updateOrder'),
(4, 'qa', 'index'),
(4, 'release', 'browse'),
(4, 'release', 'export'),
(4, 'release', 'view'),
(4, 'repo', 'view'),
(4, 'repo', 'blame'),
(4, 'repo', 'revision'),
(4, 'repo', 'showSyncCommit'),
(4, 'repo', 'download'),
(4, 'repo', 'browse'),
(4, 'repo', 'diff'),
(4, 'repo', 'log'),
(4, 'repo', 'create'),
(4, 'repo', 'edit'),
(4, 'repo', 'delete'),
(4, 'repo', 'maintain'),
(4, 'repo', 'setRules'),
(4, 'compile', 'browse'),
(4, 'compile', 'logs'),
(4, 'jenkins', 'browse'),
(4, 'jenkins', 'create'),
(4, 'jenkins', 'edit'),
(4, 'jenkins', 'delete'),
(4, 'job', 'browse'),
(4, 'job', 'create'),
(4, 'job', 'edit'),
(4, 'job', 'delete'),
(4, 'job', 'exec'),
(4, 'report', 'bugAssign'),
(4, 'report', 'bugCreate'),
(4, 'report', 'index'),
(4, 'report', 'productSummary'),
(4, 'report', 'projectDeviation'),
(4, 'report', 'workload'),
(4, 'search', 'buildForm'),
(4, 'search', 'buildQuery'),
(4, 'search', 'deleteQuery'),
(4, 'search', 'saveQuery'),
(4, 'search', 'select'),
(4, 'story', 'export'),
(4, 'story', 'report'),
(4, 'story', 'tasks'),
(4, 'story', 'bugs'),
(4, 'story', 'cases'),
(4, 'story', 'view'),
(4, 'story', 'zeroCase'),
(4, 'svn', 'apiSync'),
(4, 'svn', 'cat'),
(4, 'svn', 'diff'),
(4, 'task', 'activate'),
(4, 'task', 'assignTo'),
(4, 'task', 'batchAssignTo'),
(4, 'task', 'batchClose'),
(4, 'task', 'batchCreate'),
(4, 'task', 'batchEdit'),
(4, 'task', 'cancel'),
(4, 'task', 'close'),
(4, 'task', 'confirmStoryChange'),
(4, 'task', 'create'),
(4, 'task', 'delete'),
(4, 'task', 'deleteEstimate'),
(4, 'task', 'edit'),
(4, 'task', 'batchChangeModule'),
(4, 'task', 'editEstimate'),
(4, 'task', 'export'),
(4, 'task', 'finish'),
(4, 'task', 'pause'),
(4, 'task', 'recordEstimate'),
(4, 'task', 'report'),
(4, 'task', 'restart'),
(4, 'task', 'start'),
(4, 'task', 'view'),
(4, 'testcase', 'browse'),
(4, 'testcase', 'bugs'),
(4, 'testcase', 'createBug'),
(4, 'testcase', 'export'),
(4, 'testcase', 'groupCase'),
(4, 'testcase', 'index'),
(4, 'testcase', 'view'),
(4, 'testsuite', 'index'),
(4, 'testsuite', 'browse'),
(4, 'testsuite', 'view'),
(4, 'testtask', 'batchAssign'),
(4, 'testtask', 'browse'),
(4, 'testtask', 'cases'),
(4, 'testtask', 'create'),
(4, 'testtask', 'edit'),
(4, 'testtask', 'groupCase'),
(4, 'testtask', 'index'),
(4, 'testtask', 'results'),
(4, 'testtask', 'view'),
(4, 'todo', 'activate'),
(4, 'todo', 'assignTo'),
(4, 'todo', 'batchClose'),
(4, 'todo', 'batchCreate'),
(4, 'todo', 'batchEdit'),
(4, 'todo', 'batchFinish'),
(4, 'todo', 'create'),
(4, 'todo', 'createCycle'),
(4, 'todo', 'close'),
(4, 'todo', 'delete'),
(4, 'todo', 'edit'),
(4, 'todo', 'export'),
(4, 'todo', 'finish'),
(4, 'todo', 'import2Today'),
(4, 'todo', 'view'),
(4, 'tree', 'browse'),
(4, 'tree', 'browseTask'),
(4, 'tree', 'delete'),
(4, 'tree', 'edit'),
(4, 'tree', 'fix'),
(4, 'tree', 'manageChild'),
(4, 'tree', 'updateOrder'),
(4, 'user', 'bug'),
(4, 'user', 'deleteContacts'),
(4, 'user', 'dynamic'),
(4, 'user', 'manageContacts'),
(4, 'user', 'profile'),
(4, 'user', 'project'),
(4, 'user', 'story'),
(4, 'user', 'task'),
(4, 'user', 'testCase'),
(4, 'user', 'testTask'),
(4, 'user', 'todo'),
(4, 'user', 'view'),
(5, 'action', 'editComment'),
(5, 'action', 'hideAll'),
(5, 'action', 'hideOne'),
(5, 'action', 'trash'),
(5, 'action', 'undelete'),
(5, 'admin', 'index'),
(5, 'bug', 'activate'),
(5, 'bug', 'assignTo'),
(5, 'bug', 'batchAssignTo'),
(5, 'bug', 'batchClose'),
(5, 'bug', 'batchActivate'),
(5, 'bug', 'batchConfirm'),
(5, 'bug', 'batchCreate'),
(5, 'bug', 'batchEdit'),
(5, 'bug', 'batchResolve'),
(5, 'bug', 'browse'),
(5, 'bug', 'close'),
(5, 'bug', 'confirmBug'),
(5, 'bug', 'confirmStoryChange'),
(5, 'bug', 'create'),
(5, 'bug', 'deleteTemplate'),
(5, 'bug', 'edit'),
(5, 'bug', 'batchChangeModule'),
(5, 'bug', 'linkBugs'),
(5, 'bug', 'unlinkBug'),
(5, 'bug', 'export'),
(5, 'bug', 'index'),
(5, 'bug', 'report'),
(5, 'bug', 'resolve'),
(5, 'bug', 'saveTemplate'),
(5, 'bug', 'view'),
(5, 'build', 'view'),
(5, 'company', 'browse'),
(5, 'company', 'dynamic'),
(5, 'company', 'index'),
(5, 'company', 'view'),
(5, 'doc', 'browse'),
(5, 'doc', 'create'),
(5, 'doc', 'createLib'),
(5, 'doc', 'delete'),
(5, 'doc', 'deleteLib'),
(5, 'doc', 'deleteFile'),
(5, 'doc', 'edit'),
(5, 'doc', 'editLib'),
(5, 'doc', 'index'),
(5, 'doc', 'allLibs'),
(5, 'doc', 'objectLibs'),
(5, 'doc', 'showFiles'),
(5, 'doc', 'view'),
(5, 'extension', 'browse'),
(5, 'extension', 'obtain'),
(5, 'extension', 'structure'),
(5, 'file', 'delete'),
(5, 'file', 'download'),
(5, 'file', 'edit'),
(5, 'file', 'uploadImages'),
(5, 'git', 'apiSync'),
(5, 'git', 'cat'),
(5, 'git', 'diff'),
(5, 'group', 'browse'),
(5, 'index', 'index'),
(5, 'misc', 'ping'),
(5, 'my', 'bug'),
(5, 'my', 'changePassword'),
(5, 'my', 'dynamic'),
(5, 'my', 'editProfile'),
(5, 'my', 'index'),
(5, 'my', 'profile'),
(5, 'my', 'project'),
(5, 'my', 'story'),
(5, 'my', 'task'),
(5, 'my', 'testCase'),
(5, 'my', 'testTask'),
(5, 'my', 'todo'),
(5, 'my', 'calendar'),
(5, 'my', 'unbind'),
(5, 'my', 'manageContacts'),
(5, 'my', 'deleteContacts'),
(5, 'product', 'batchEdit'),
(5, 'product', 'browse'),
(5, 'product', 'close'),
(5, 'product', 'create'),
(5, 'product', 'delete'),
(5, 'product', 'doc'),
(5, 'product', 'dynamic'),
(5, 'product', 'edit'),
(5, 'product', 'index'),
(5, 'product', 'all'),
(5, 'product', 'order'),
(5, 'product', 'project'),
(5, 'product', 'roadmap'),
(5, 'product', 'view'),
(5, 'product', 'build'),
(5, 'product', 'updateOrder'),
(5, 'branch', 'manage'),
(5, 'branch', 'sort'),
(5, 'branch', 'delete'),
(5, 'productplan', 'batchUnlinkBug'),
(5, 'productplan', 'batchUnlinkStory'),
(5, 'productplan', 'browse'),
(5, 'productplan', 'create'),
(5, 'productplan', 'delete'),
(5, 'productplan', 'edit'),
(5, 'productplan', 'linkBug'),
(5, 'productplan', 'linkStory'),
(5, 'productplan', 'unlinkBug'),
(5, 'productplan', 'unlinkStory'),
(5, 'productplan', 'view'),
(5, 'project', 'activate'),
(5, 'project', 'batchedit'),
(5, 'project', 'batchUnlinkStory'),
(5, 'project', 'browse'),
(5, 'project', 'bug'),
(5, 'project', 'build'),
(5, 'project', 'burn'),
(5, 'project', 'close'),
(5, 'project', 'computeBurn'),
(5, 'project', 'create'),
(5, 'project', 'delete'),
(5, 'project', 'doc'),
(5, 'project', 'dynamic'),
(5, 'project', 'edit'),
(5, 'project', 'grouptask'),
(5, 'project', 'importBug'),
(5, 'project', 'importtask'),
(5, 'project', 'index'),
(5, 'project', 'all'),
(5, 'project', 'linkStory'),
(5, 'project', 'importPlanStories'),
(5, 'project', 'manageMembers'),
(5, 'project', 'manageProducts'),
(5, 'project', 'order'),
(5, 'project', 'putoff'),
(5, 'project', 'start'),
(5, 'project', 'story'),
(5, 'project', 'suspend'),
(5, 'project', 'task'),
(5, 'project', 'kanban'),
(5, 'project', 'tree'),
(5, 'project', 'treetask'),
(5, 'project', 'treestory'),
(5, 'project', 'team'),
(5, 'project', 'testtask'),
(5, 'project', 'unlinkMember'),
(5, 'project', 'unlinkStory'),
(5, 'project', 'view'),
(5, 'project', 'updateOrder'),
(5, 'qa', 'index'),
(5, 'release', 'batchUnlinkBug'),
(5, 'release', 'batchUnlinkStory'),
(5, 'release', 'browse'),
(5, 'release', 'create'),
(5, 'release', 'delete'),
(5, 'release', 'edit'),
(5, 'release', 'export'),
(5, 'release', 'linkBug'),
(5, 'release', 'linkStory'),
(5, 'release', 'unlinkBug'),
(5, 'release', 'unlinkStory'),
(5, 'release', 'view'),
(5, 'release', 'changeStatus'),
(5, 'repo', 'view'),
(5, 'repo', 'blame'),
(5, 'repo', 'revision'),
(5, 'repo', 'showSyncCommit'),
(5, 'repo', 'download'),
(5, 'repo', 'browse'),
(5, 'repo', 'diff'),
(5, 'repo', 'log'),
(5, 'repo', 'create'),
(5, 'repo', 'edit'),
(5, 'repo', 'delete'),
(5, 'repo', 'maintain'),
(5, 'repo', 'setRules'),
(5, 'compile', 'browse'),
(5, 'compile', 'logs'),
(5, 'jenkins', 'browse'),
(5, 'jenkins', 'create'),
(5, 'jenkins', 'edit'),
(5, 'jenkins', 'delete'),
(5, 'job', 'browse'),
(5, 'job', 'create'),
(5, 'job', 'edit'),
(5, 'job', 'delete'),
(5, 'job', 'exec'),
(5, 'report', 'bugAssign'),
(5, 'report', 'bugCreate'),
(5, 'report', 'index'),
(5, 'report', 'productSummary'),
(5, 'report', 'projectDeviation'),
(5, 'report', 'workload'),
(5, 'search', 'buildForm'),
(5, 'search', 'buildQuery'),
(5, 'search', 'deleteQuery'),
(5, 'search', 'saveQuery'),
(5, 'search', 'select'),
(5, 'story', 'activate'),
(5, 'story', 'batchChangePlan'),
(5, 'story', 'batchChangeBranch'),
(5, 'story', 'batchChangeStage'),
(5, 'story', 'batchClose'),
(5, 'story', 'batchCreate'),
(5, 'story', 'batchEdit'),
(5, 'story', 'batchReview'),
(5, 'story', 'change'),
(5, 'story', 'close'),
(5, 'story', 'create'),
(5, 'story', 'delete'),
(5, 'story', 'edit'),
(5, 'story', 'batchChangeModule'),
(5, 'story', 'linkStory'),
(5, 'story', 'unlinkStory'),
(5, 'story', 'export'),
(5, 'story', 'report'),
(5, 'story', 'review'),
(5, 'story', 'tasks'),
(5, 'story', 'bugs'),
(5, 'story', 'cases'),
(5, 'story', 'view'),
(5, 'story', 'zeroCase'),
(5, 'svn', 'apiSync'),
(5, 'svn', 'cat'),
(5, 'svn', 'diff'),
(5, 'task', 'confirmStoryChange'),
(5, 'task', 'deleteEstimate'),
(5, 'task', 'editEstimate'),
(5, 'task', 'export'),
(5, 'task', 'recordEstimate'),
(5, 'task', 'report'),
(5, 'task', 'view'),
(5, 'testcase', 'browse'),
(5, 'testcase', 'bugs'),
(5, 'testcase', 'createBug'),
(5, 'testcase', 'export'),
(5, 'testcase', 'groupCase'),
(5, 'testcase', 'index'),
(5, 'testcase', 'view'),
(5, 'testcase', 'importFromLib'),
(5, 'testsuite', 'index'),
(5, 'testsuite', 'browse'),
(5, 'testsuite', 'view'),
(5, 'testsuite', 'library'),
(5, 'testsuite', 'createLib'),
(5, 'testsuite', 'createCase'),
(5, 'testsuite', 'exportTemplet'),
(5, 'testsuite', 'batchCreateCase'),
(5, 'testsuite', 'import'),
(5, 'testsuite', 'showImport'),
(5, 'testsuite', 'libView'),
(5, 'testtask', 'browse'),
(5, 'testtask', 'cases'),
(5, 'testtask', 'groupCase'),
(5, 'testtask', 'index'),
(5, 'testtask', 'results'),
(5, 'testtask', 'view'),
(5, 'todo', 'activate'),
(5, 'todo', 'assignTo'),
(5, 'todo', 'batchClose'),
(5, 'todo', 'batchCreate'),
(5, 'todo', 'batchEdit'),
(5, 'todo', 'batchFinish'),
(5, 'todo', 'create'),
(5, 'todo', 'createCycle'),
(5, 'todo', 'close'),
(5, 'todo', 'delete'),
(5, 'todo', 'edit'),
(5, 'todo', 'export'),
(5, 'todo', 'finish'),
(5, 'todo', 'import2Today'),
(5, 'todo', 'view'),
(5, 'tree', 'browse'),
(5, 'tree', 'browseTask'),
(5, 'tree', 'delete'),
(5, 'tree', 'edit'),
(5, 'tree', 'fix'),
(5, 'tree', 'manageChild'),
(5, 'tree', 'updateOrder'),
(5, 'user', 'bug'),
(5, 'user', 'deleteContacts'),
(5, 'user', 'dynamic'),
(5, 'user', 'manageContacts'),
(5, 'user', 'profile'),
(5, 'user', 'project'),
(5, 'user', 'story'),
(5, 'user', 'task'),
(5, 'user', 'testCase'),
(5, 'user', 'testTask'),
(5, 'user', 'todo'),
(5, 'user', 'view'),
(6, 'action', 'editComment'),
(6, 'action', 'hideAll'),
(6, 'action', 'hideOne'),
(6, 'action', 'trash'),
(6, 'action', 'undelete'),
(6, 'admin', 'index'),
(6, 'bug', 'activate'),
(6, 'bug', 'assignTo'),
(6, 'bug', 'batchAssignTo'),
(6, 'bug', 'batchClose'),
(6, 'bug', 'batchActivate'),
(6, 'bug', 'batchConfirm'),
(6, 'bug', 'batchCreate'),
(6, 'bug', 'batchEdit'),
(6, 'bug', 'batchResolve'),
(6, 'bug', 'browse'),
(6, 'bug', 'close'),
(6, 'bug', 'confirmBug'),
(6, 'bug', 'confirmStoryChange'),
(6, 'bug', 'create'),
(6, 'bug', 'delete'),
(6, 'bug', 'deleteTemplate'),
(6, 'bug', 'edit'),
(6, 'bug', 'batchChangeModule'),
(6, 'bug', 'linkBugs'),
(6, 'bug', 'unlinkBug'),
(6, 'bug', 'export'),
(6, 'bug', 'index'),
(6, 'bug', 'report'),
(6, 'bug', 'resolve'),
(6, 'bug', 'saveTemplate'),
(6, 'bug', 'view'),
(6, 'build', 'batchUnlinkBug'),
(6, 'build', 'batchUnlinkStory'),
(6, 'build', 'create'),
(6, 'build', 'delete'),
(6, 'build', 'edit'),
(6, 'build', 'linkBug'),
(6, 'build', 'linkStory'),
(6, 'build', 'unlinkBug'),
(6, 'build', 'unlinkStory'),
(6, 'build', 'view'),
(6, 'company', 'browse'),
(6, 'company', 'dynamic'),
(6, 'company', 'index'),
(6, 'company', 'view'),
(6, 'doc', 'browse'),
(6, 'doc', 'create'),
(6, 'doc', 'createLib'),
(6, 'doc', 'delete'),
(6, 'doc', 'deleteLib'),
(6, 'doc', 'deleteFile'),
(6, 'doc', 'edit'),
(6, 'doc', 'editLib'),
(6, 'doc', 'index'),
(6, 'doc', 'allLibs'),
(6, 'doc', 'objectLibs'),
(6, 'doc', 'showFiles'),
(6, 'doc', 'view'),
(6, 'extension', 'browse'),
(6, 'extension', 'obtain'),
(6, 'extension', 'structure'),
(6, 'file', 'delete'),
(6, 'file', 'download'),
(6, 'file', 'edit'),
(6, 'file', 'uploadImages'),
(6, 'git', 'apiSync'),
(6, 'git', 'cat'),
(6, 'git', 'diff'),
(6, 'group', 'browse'),
(6, 'index', 'index'),
(6, 'misc', 'ping'),
(6, 'my', 'bug'),
(6, 'my', 'changePassword'),
(6, 'my', 'dynamic'),
(6, 'my', 'editProfile'),
(6, 'my', 'index'),
(6, 'my', 'profile'),
(6, 'my', 'project'),
(6, 'my', 'story'),
(6, 'my', 'task'),
(6, 'my', 'testCase'),
(6, 'my', 'testTask'),
(6, 'my', 'todo'),
(6, 'my', 'calendar'),
(6, 'my', 'unbind'),
(6, 'my', 'manageContacts'),
(6, 'my', 'deleteContacts'),
(6, 'product', 'browse'),
(6, 'product', 'doc'),
(6, 'product', 'dynamic'),
(6, 'product', 'index'),
(6, 'product', 'all'),
(6, 'product', 'project'),
(6, 'product', 'roadmap'),
(6, 'product', 'view'),
(6, 'product', 'build'),
(6, 'productplan', 'browse'),
(6, 'productplan', 'view'),
(6, 'project', 'activate'),
(6, 'project', 'batchedit'),
(6, 'project', 'batchUnlinkStory'),
(6, 'project', 'browse'),
(6, 'project', 'bug'),
(6, 'project', 'build'),
(6, 'project', 'burn'),
(6, 'project', 'close'),
(6, 'project', 'computeBurn'),
(6, 'project', 'create'),
(6, 'project', 'delete'),
(6, 'project', 'doc'),
(6, 'project', 'dynamic'),
(6, 'project', 'edit'),
(6, 'project', 'grouptask'),
(6, 'project', 'importBug'),
(6, 'project', 'importtask'),
(6, 'project', 'index'),
(6, 'project', 'all'),
(6, 'project', 'linkStory'),
(6, 'project', 'importPlanStories'),
(6, 'project', 'manageMembers'),
(6, 'project', 'manageProducts'),
(6, 'project', 'order'),
(6, 'project', 'putoff'),
(6, 'project', 'start'),
(6, 'project', 'story'),
(6, 'project', 'suspend'),
(6, 'project', 'task'),
(6, 'project', 'kanban'),
(6, 'project', 'tree'),
(6, 'project', 'treetask'),
(6, 'project', 'treestory'),
(6, 'project', 'team'),
(6, 'project', 'testtask'),
(6, 'project', 'unlinkMember'),
(6, 'project', 'unlinkStory'),
(6, 'project', 'view'),
(6, 'project', 'updateOrder'),
(6, 'qa', 'index'),
(6, 'release', 'browse'),
(6, 'release', 'export'),
(6, 'release', 'view'),
(6, 'repo', 'view'),
(6, 'repo', 'blame'),
(6, 'repo', 'revision'),
(6, 'repo', 'showSyncCommit'),
(6, 'repo', 'download'),
(6, 'repo', 'browse'),
(6, 'repo', 'diff'),
(6, 'repo', 'log'),
(6, 'report', 'bugAssign'),
(6, 'report', 'bugCreate'),
(6, 'report', 'index'),
(6, 'report', 'productSummary'),
(6, 'report', 'projectDeviation'),
(6, 'report', 'workload'),
(6, 'search', 'buildForm'),
(6, 'search', 'buildQuery'),
(6, 'search', 'deleteQuery'),
(6, 'search', 'saveQuery'),
(6, 'search', 'select'),
(6, 'story', 'export'),
(6, 'story', 'report'),
(6, 'story', 'tasks'),
(6, 'story', 'bugs'),
(6, 'story', 'cases'),
(6, 'story', 'view'),
(6, 'story', 'zeroCase'),
(6, 'svn', 'apiSync'),
(6, 'svn', 'cat'),
(6, 'svn', 'diff'),
(6, 'task', 'activate'),
(6, 'task', 'assignTo'),
(6, 'task', 'batchAssignTo'),
(6, 'task', 'batchClose'),
(6, 'task', 'batchCreate'),
(6, 'task', 'batchEdit'),
(6, 'task', 'cancel'),
(6, 'task', 'close'),
(6, 'task', 'confirmStoryChange'),
(6, 'task', 'create'),
(6, 'task', 'delete'),
(6, 'task', 'deleteEstimate'),
(6, 'task', 'edit'),
(6, 'task', 'batchChangeModule'),
(6, 'task', 'editEstimate'),
(6, 'task', 'export'),
(6, 'task', 'finish'),
(6, 'task', 'pause'),
(6, 'task', 'recordEstimate'),
(6, 'task', 'report'),
(6, 'task', 'restart'),
(6, 'task', 'start'),
(6, 'task', 'view'),
(6, 'testcase', 'browse'),
(6, 'testcase', 'bugs'),
(6, 'testcase', 'export'),
(6, 'testcase', 'groupCase'),
(6, 'testcase', 'index'),
(6, 'testcase', 'view'),
(6, 'testsuite', 'index'),
(6, 'testsuite', 'browse'),
(6, 'testsuite', 'view'),
(6, 'testtask', 'browse'),
(6, 'testtask', 'cases'),
(6, 'testtask', 'create'),
(6, 'testtask', 'edit'),
(6, 'testtask', 'groupCase'),
(6, 'testtask', 'index'),
(6, 'testtask', 'results'),
(6, 'testtask', 'view'),
(6, 'todo', 'activate'),
(6, 'todo', 'assignTo'),
(6, 'todo', 'batchClose'),
(6, 'todo', 'batchCreate'),
(6, 'todo', 'batchEdit'),
(6, 'todo', 'batchFinish'),
(6, 'todo', 'create'),
(6, 'todo', 'createCycle'),
(6, 'todo', 'close'),
(6, 'todo', 'delete'),
(6, 'todo', 'edit'),
(6, 'todo', 'export'),
(6, 'todo', 'finish'),
(6, 'todo', 'import2Today'),
(6, 'todo', 'view'),
(6, 'tree', 'browse'),
(6, 'tree', 'browseTask'),
(6, 'tree', 'delete'),
(6, 'tree', 'edit'),
(6, 'tree', 'fix'),
(6, 'tree', 'manageChild'),
(6, 'tree', 'updateOrder'),
(6, 'user', 'bug'),
(6, 'user', 'deleteContacts'),
(6, 'user', 'dynamic'),
(6, 'user', 'manageContacts'),
(6, 'user', 'profile'),
(6, 'user', 'project'),
(6, 'user', 'story'),
(6, 'user', 'task'),
(6, 'user', 'testCase'),
(6, 'user', 'testTask'),
(6, 'user', 'todo'),
(6, 'user', 'view'),
(7, 'action', 'editComment'),
(7, 'action', 'hideAll'),
(7, 'action', 'hideOne'),
(7, 'action', 'trash'),
(7, 'action', 'undelete'),
(7, 'admin', 'index'),
(7, 'bug', 'activate'),
(7, 'bug', 'assignTo'),
(7, 'bug', 'batchClose'),
(7, 'bug', 'batchActivate'),
(7, 'bug', 'batchConfirm'),
(7, 'bug', 'batchCreate'),
(7, 'bug', 'batchEdit'),
(7, 'bug', 'batchResolve'),
(7, 'bug', 'browse'),
(7, 'bug', 'close'),
(7, 'bug', 'confirmBug'),
(7, 'bug', 'confirmStoryChange'),
(7, 'bug', 'create'),
(7, 'bug', 'delete'),
(7, 'bug', 'deleteTemplate'),
(7, 'bug', 'edit'),
(7, 'bug', 'batchChangeModule'),
(7, 'bug', 'linkBugs'),
(7, 'bug', 'unlinkBug'),
(7, 'bug', 'export'),
(7, 'bug', 'index'),
(7, 'bug', 'report'),
(7, 'bug', 'resolve'),
(7, 'bug', 'saveTemplate'),
(7, 'bug', 'view'),
(7, 'build', 'view'),
(7, 'company', 'browse'),
(7, 'company', 'dynamic'),
(7, 'company', 'index'),
(7, 'company', 'view'),
(7, 'doc', 'browse'),
(7, 'doc', 'create'),
(7, 'doc', 'createLib'),
(7, 'doc', 'delete'),
(7, 'doc', 'deleteLib'),
(7, 'doc', 'deleteFile'),
(7, 'doc', 'edit'),
(7, 'doc', 'editLib'),
(7, 'doc', 'index'),
(7, 'doc', 'allLibs'),
(7, 'doc', 'objectLibs'),
(7, 'doc', 'showFiles'),
(7, 'doc', 'view'),
(7, 'extension', 'browse'),
(7, 'extension', 'obtain'),
(7, 'extension', 'structure'),
(7, 'file', 'delete'),
(7, 'file', 'download'),
(7, 'file', 'edit'),
(7, 'file', 'uploadImages'),
(7, 'git', 'apiSync'),
(7, 'git', 'cat'),
(7, 'git', 'diff'),
(7, 'group', 'browse'),
(7, 'index', 'index'),
(7, 'misc', 'ping'),
(7, 'my', 'bug'),
(7, 'my', 'changePassword'),
(7, 'my', 'dynamic'),
(7, 'my', 'editProfile'),
(7, 'my', 'index'),
(7, 'my', 'profile'),
(7, 'my', 'project'),
(7, 'my', 'story'),
(7, 'my', 'task'),
(7, 'my', 'testCase'),
(7, 'my', 'testTask'),
(7, 'my', 'todo'),
(7, 'my', 'calendar'),
(7, 'my', 'unbind'),
(7, 'my', 'manageContacts'),
(7, 'my', 'deleteContacts'),
(7, 'product', 'batchEdit'),
(7, 'product', 'browse'),
(7, 'product', 'close'),
(7, 'product', 'create'),
(7, 'product', 'delete'),
(7, 'product', 'doc'),
(7, 'product', 'dynamic'),
(7, 'product', 'edit'),
(7, 'product', 'index'),
(7, 'product', 'all'),
(7, 'product', 'order'),
(7, 'product', 'project'),
(7, 'product', 'roadmap'),
(7, 'product', 'view'),
(7, 'product', 'build'),
(7, 'product', 'updateOrder'),
(7, 'branch', 'manage'),
(7, 'branch', 'sort'),
(7, 'branch', 'delete'),
(7, 'productplan', 'batchUnlinkBug'),
(7, 'productplan', 'batchUnlinkStory'),
(7, 'productplan', 'browse'),
(7, 'productplan', 'create'),
(7, 'productplan', 'delete'),
(7, 'productplan', 'edit'),
(7, 'productplan', 'linkBug'),
(7, 'productplan', 'linkStory'),
(7, 'productplan', 'unlinkBug'),
(7, 'productplan', 'unlinkStory'),
(7, 'productplan', 'view'),
(7, 'project', 'browse'),
(7, 'project', 'bug'),
(7, 'project', 'build'),
(7, 'project', 'burn'),
(7, 'project', 'doc'),
(7, 'project', 'dynamic'),
(7, 'project', 'grouptask'),
(7, 'project', 'index'),
(7, 'project', 'all'),
(7, 'project', 'linkStory'),
(7, 'project', 'importPlanStories'),
(7, 'project', 'manageProducts'),
(7, 'project', 'story'),
(7, 'project', 'task'),
(7, 'project', 'kanban'),
(7, 'project', 'tree'),
(7, 'project', 'treetask'),
(7, 'project', 'treestory'),
(7, 'project', 'team'),
(7, 'project', 'testtask'),
(7, 'project', 'unlinkStory'),
(7, 'project', 'view'),
(7, 'qa', 'index'),
(7, 'release', 'batchUnlinkBug'),
(7, 'release', 'batchUnlinkStory'),
(7, 'release', 'browse'),
(7, 'release', 'create'),
(7, 'release', 'delete'),
(7, 'release', 'edit'),
(7, 'release', 'export'),
(7, 'release', 'linkBug'),
(7, 'release', 'linkStory'),
(7, 'release', 'unlinkBug'),
(7, 'release', 'unlinkStory'),
(7, 'release', 'view'),
(7, 'release', 'changeStatus'),
(7, 'repo', 'view'),
(7, 'repo', 'blame'),
(7, 'repo', 'revision'),
(7, 'repo', 'showSyncCommit'),
(7, 'repo', 'download'),
(7, 'repo', 'browse'),
(7, 'repo', 'diff'),
(7, 'repo', 'log'),
(7, 'report', 'bugAssign'),
(7, 'report', 'bugCreate'),
(7, 'report', 'index'),
(7, 'report', 'productSummary'),
(7, 'report', 'projectDeviation'),
(7, 'report', 'workload'),
(7, 'search', 'buildForm'),
(7, 'search', 'buildQuery'),
(7, 'search', 'deleteQuery'),
(7, 'search', 'saveQuery'),
(7, 'search', 'select'),
(7, 'story', 'activate'),
(7, 'story', 'batchAssignTo'),
(7, 'story', 'batchChangePlan'),
(7, 'story', 'batchChangeBranch'),
(7, 'story', 'batchChangeStage'),
(7, 'story', 'batchClose'),
(7, 'story', 'batchCreate'),
(7, 'story', 'batchEdit'),
(7, 'story', 'batchReview'),
(7, 'story', 'change'),
(7, 'story', 'close'),
(7, 'story', 'create'),
(7, 'story', 'delete'),
(7, 'story', 'edit'),
(7, 'story', 'assignTo'),
(7, 'story', 'batchChangeModule'),
(7, 'story', 'linkStory'),
(7, 'story', 'unlinkStory'),
(7, 'story', 'export'),
(7, 'story', 'report'),
(7, 'story', 'review'),
(7, 'story', 'tasks'),
(7, 'story', 'bugs'),
(7, 'story', 'cases'),
(7, 'story', 'view'),
(7, 'story', 'zeroCase'),
(7, 'svn', 'apiSync'),
(7, 'svn', 'cat'),
(7, 'svn', 'diff'),
(7, 'task', 'confirmStoryChange'),
(7, 'task', 'deleteEstimate'),
(7, 'task', 'editEstimate'),
(7, 'task', 'export'),
(7, 'task', 'recordEstimate'),
(7, 'task', 'report'),
(7, 'task', 'view'),
(7, 'testcase', 'browse'),
(7, 'testcase', 'bugs'),
(7, 'testcase', 'createBug'),
(7, 'testcase', 'export'),
(7, 'testcase', 'groupCase'),
(7, 'testcase', 'index'),
(7, 'testcase', 'view'),
(7, 'testcase', 'importFromLib'),
(7, 'testsuite', 'index'),
(7, 'testsuite', 'browse'),
(7, 'testsuite', 'view'),
(7, 'testsuite', 'library'),
(7, 'testsuite', 'createLib'),
(7, 'testsuite', 'createCase'),
(7, 'testsuite', 'exportTemplet'),
(7, 'testsuite', 'batchCreateCase'),
(7, 'testsuite', 'import'),
(7, 'testsuite', 'showImport'),
(7, 'testsuite', 'libView'),
(7, 'testtask', 'browse'),
(7, 'testtask', 'cases'),
(7, 'testtask', 'groupCase'),
(7, 'testtask', 'index'),
(7, 'testtask', 'results'),
(7, 'testtask', 'view'),
(7, 'todo', 'activate'),
(7, 'todo', 'assignTo'),
(7, 'todo', 'batchClose'),
(7, 'todo', 'batchCreate'),
(7, 'todo', 'batchEdit'),
(7, 'todo', 'batchFinish'),
(7, 'todo', 'create'),
(7, 'todo', 'createCycle'),
(7, 'todo', 'close'),
(7, 'todo', 'delete'),
(7, 'todo', 'edit'),
(7, 'todo', 'export'),
(7, 'todo', 'finish'),
(7, 'todo', 'import2Today'),
(7, 'todo', 'view'),
(7, 'tree', 'browse'),
(7, 'tree', 'browseTask'),
(7, 'tree', 'delete'),
(7, 'tree', 'edit'),
(7, 'tree', 'fix'),
(7, 'tree', 'manageChild'),
(7, 'tree', 'updateOrder'),
(7, 'user', 'bug'),
(7, 'user', 'deleteContacts'),
(7, 'user', 'dynamic'),
(7, 'user', 'manageContacts'),
(7, 'user', 'profile'),
(7, 'user', 'project'),
(7, 'user', 'story'),
(7, 'user', 'task'),
(7, 'user', 'testCase'),
(7, 'user', 'testTask'),
(7, 'user', 'todo'),
(7, 'user', 'view'),
(8, 'action', 'editComment'),
(8, 'action', 'hideAll'),
(8, 'action', 'hideOne'),
(8, 'action', 'trash'),
(8, 'action', 'undelete'),
(8, 'admin', 'index'),
(8, 'bug', 'activate'),
(8, 'bug', 'assignTo'),
(8, 'bug', 'batchAssignTo'),
(8, 'bug', 'batchClose'),
(8, 'bug', 'batchActivate'),
(8, 'bug', 'batchConfirm'),
(8, 'bug', 'batchCreate'),
(8, 'bug', 'batchEdit'),
(8, 'bug', 'batchResolve'),
(8, 'bug', 'browse'),
(8, 'bug', 'close'),
(8, 'bug', 'confirmBug'),
(8, 'bug', 'confirmStoryChange'),
(8, 'bug', 'create'),
(8, 'bug', 'delete'),
(8, 'bug', 'deleteTemplate'),
(8, 'bug', 'edit'),
(8, 'bug', 'batchChangeModule'),
(8, 'bug', 'linkBugs'),
(8, 'bug', 'unlinkBug'),
(8, 'bug', 'export'),
(8, 'bug', 'index'),
(8, 'bug', 'report'),
(8, 'bug', 'resolve'),
(8, 'bug', 'saveTemplate'),
(8, 'bug', 'view'),
(8, 'build', 'create'),
(8, 'build', 'delete'),
(8, 'build', 'edit'),
(8, 'build', 'view'),
(8, 'company', 'browse'),
(8, 'company', 'dynamic'),
(8, 'company', 'index'),
(8, 'company', 'view'),
(8, 'doc', 'browse'),
(8, 'doc', 'create'),
(8, 'doc', 'createLib'),
(8, 'doc', 'delete'),
(8, 'doc', 'deleteLib'),
(8, 'doc', 'deleteFile'),
(8, 'doc', 'edit'),
(8, 'doc', 'editLib'),
(8, 'doc', 'index'),
(8, 'doc', 'allLibs'),
(8, 'doc', 'objectLibs'),
(8, 'doc', 'showFiles'),
(8, 'doc', 'view'),
(8, 'extension', 'browse'),
(8, 'extension', 'obtain'),
(8, 'extension', 'structure'),
(8, 'file', 'delete'),
(8, 'file', 'download'),
(8, 'file', 'edit'),
(8, 'file', 'uploadImages'),
(8, 'git', 'apiSync'),
(8, 'git', 'cat'),
(8, 'git', 'diff'),
(8, 'group', 'browse'),
(8, 'index', 'index'),
(8, 'misc', 'ping'),
(8, 'my', 'bug'),
(8, 'my', 'changePassword'),
(8, 'my', 'dynamic'),
(8, 'my', 'editProfile'),
(8, 'my', 'index'),
(8, 'my', 'profile'),
(8, 'my', 'project'),
(8, 'my', 'story'),
(8, 'my', 'task'),
(8, 'my', 'testCase'),
(8, 'my', 'testTask'),
(8, 'my', 'todo'),
(8, 'my', 'calendar'),
(8, 'my', 'unbind'),
(8, 'my', 'manageContacts'),
(8, 'my', 'deleteContacts'),
(8, 'product', 'browse'),
(8, 'product', 'doc'),
(8, 'product', 'dynamic'),
(8, 'product', 'index'),
(8, 'product', 'all'),
(8, 'product', 'project'),
(8, 'product', 'roadmap'),
(8, 'product', 'view'),
(8, 'product', 'build'),
(8, 'productplan', 'browse'),
(8, 'productplan', 'view'),
(8, 'project', 'bug'),
(8, 'project', 'build'),
(8, 'project', 'burn'),
(8, 'project', 'doc'),
(8, 'project', 'dynamic'),
(8, 'project', 'grouptask'),
(8, 'project', 'importBug'),
(8, 'project', 'importtask'),
(8, 'project', 'index'),
(8, 'project', 'all'),
(8, 'project', 'story'),
(8, 'project', 'task'),
(8, 'project', 'kanban'),
(8, 'project', 'tree'),
(8, 'project', 'treetask'),
(8, 'project', 'treestory'),
(8, 'project', 'team'),
(8, 'project', 'testtask'),
(8, 'project', 'view'),
(8, 'qa', 'index'),
(8, 'release', 'browse'),
(8, 'release', 'export'),
(8, 'release', 'view'),
(8, 'repo', 'view'),
(8, 'repo', 'blame'),
(8, 'repo', 'revision'),
(8, 'repo', 'showSyncCommit'),
(8, 'repo', 'download'),
(8, 'repo', 'browse'),
(8, 'repo', 'diff'),
(8, 'repo', 'log'),
(8, 'report', 'bugAssign'),
(8, 'report', 'bugCreate'),
(8, 'report', 'index'),
(8, 'report', 'productSummary'),
(8, 'report', 'projectDeviation'),
(8, 'report', 'workload'),
(8, 'search', 'buildForm'),
(8, 'search', 'buildQuery'),
(8, 'search', 'deleteQuery'),
(8, 'search', 'saveQuery'),
(8, 'search', 'select'),
(8, 'story', 'export'),
(8, 'story', 'report'),
(8, 'story', 'tasks'),
(8, 'story', 'bugs'),
(8, 'story', 'cases'),
(8, 'story', 'view'),
(8, 'story', 'zeroCase'),
(8, 'svn', 'apiSync'),
(8, 'svn', 'cat'),
(8, 'svn', 'diff'),
(8, 'task', 'activate'),
(8, 'task', 'assignTo'),
(8, 'task', 'batchAssignTo'),
(8, 'task', 'batchClose'),
(8, 'task', 'batchCreate'),
(8, 'task', 'batchEdit'),
(8, 'task', 'cancel'),
(8, 'task', 'close'),
(8, 'task', 'confirmStoryChange'),
(8, 'task', 'create'),
(8, 'task', 'delete'),
(8, 'task', 'deleteEstimate'),
(8, 'task', 'edit'),
(8, 'task', 'batchChangeModule'),
(8, 'task', 'editEstimate'),
(8, 'task', 'export'),
(8, 'task', 'finish'),
(8, 'task', 'pause'),
(8, 'task', 'recordEstimate'),
(8, 'task', 'report'),
(8, 'task', 'restart'),
(8, 'task', 'start'),
(8, 'task', 'view'),
(8, 'testcase', 'batchCreate'),
(8, 'testcase', 'batchDelete'),
(8, 'testcase', 'batchEdit'),
(8, 'testcase', 'browse'),
(8, 'testcase', 'bugs'),
(8, 'testcase', 'confirmChange'),
(8, 'testcase', 'confirmStoryChange'),
(8, 'testcase', 'create'),
(8, 'testcase', 'createBug'),
(8, 'testcase', 'delete'),
(8, 'testcase', 'edit'),
(8, 'testcase', 'review'),
(8, 'testcase', 'batchReview'),
(8, 'testcase', 'batchCaseTypeChange'),
(8, 'testcase', 'batchConfirmStoryChange'),
(8, 'testcase', 'batchChangeModule'),
(8, 'testcase', 'linkCases'),
(8, 'testcase', 'unlinkCase'),
(8, 'testcase', 'export'),
(8, 'testcase', 'exportTemplet'),
(8, 'testcase', 'groupCase'),
(8, 'testcase', 'import'),
(8, 'testcase', 'index'),
(8, 'testcase', 'showImport'),
(8, 'testcase', 'view'),
(8, 'testcase', 'importFromLib'),
(8, 'testreport', 'browse'),
(8, 'testreport', 'create'),
(8, 'testreport', 'view'),
(8, 'testreport', 'delete'),
(8, 'testreport', 'edit'),
(8, 'testsuite', 'index'),
(8, 'testsuite', 'browse'),
(8, 'testsuite', 'create'),
(8, 'testsuite', 'view'),
(8, 'testsuite', 'edit'),
(8, 'testsuite', 'delete'),
(8, 'testsuite', 'linkCase'),
(8, 'testsuite', 'unlinkCase'),
(8, 'testsuite', 'library'),
(8, 'testsuite', 'createLib'),
(8, 'testsuite', 'createCase'),
(8, 'testsuite', 'exportTemplet'),
(8, 'testsuite', 'batchCreateCase'),
(8, 'testsuite', 'import'),
(8, 'testsuite', 'showImport'),
(8, 'testsuite', 'libView'),
(8, 'testtask', 'batchAssign'),
(8, 'testtask', 'batchRun'),
(8, 'testtask', 'browse'),
(8, 'testtask', 'cases'),
(8, 'testtask', 'close'),
(8, 'testtask', 'create'),
(8, 'testtask', 'delete'),
(8, 'testtask', 'edit'),
(8, 'testtask', 'groupCase'),
(8, 'testtask', 'index'),
(8, 'testtask', 'linkcase'),
(8, 'testtask', 'results'),
(8, 'testtask', 'runcase'),
(8, 'testtask', 'start'),
(8, 'testtask', 'activate'),
(8, 'testtask', 'block'),
(8, 'testtask', 'report'),
(8, 'testtask', 'unlinkcase'),
(8, 'testtask', 'view'),
(8, 'todo', 'activate'),
(8, 'todo', 'assignTo'),
(8, 'todo', 'batchClose'),
(8, 'todo', 'batchCreate'),
(8, 'todo', 'batchEdit'),
(8, 'todo', 'batchFinish'),
(8, 'todo', 'create'),
(8, 'todo', 'createCycle'),
(8, 'todo', 'close'),
(8, 'todo', 'delete'),
(8, 'todo', 'edit'),
(8, 'todo', 'export'),
(8, 'todo', 'finish'),
(8, 'todo', 'import2Today'),
(8, 'todo', 'view'),
(8, 'tree', 'browse'),
(8, 'tree', 'browseTask'),
(8, 'tree', 'delete'),
(8, 'tree', 'edit'),
(8, 'tree', 'fix'),
(8, 'tree', 'manageChild'),
(8, 'tree', 'updateOrder'),
(8, 'user', 'bug'),
(8, 'user', 'deleteContacts'),
(8, 'user', 'dynamic'),
(8, 'user', 'manageContacts'),
(8, 'user', 'profile'),
(8, 'user', 'project'),
(8, 'user', 'story'),
(8, 'user', 'task'),
(8, 'user', 'testCase'),
(8, 'user', 'testTask'),
(8, 'user', 'todo'),
(8, 'user', 'view'),
(9, 'action', 'editComment'),
(9, 'action', 'hideAll'),
(9, 'action', 'hideOne'),
(9, 'action', 'trash'),
(9, 'action', 'undelete'),
(9, 'admin', 'index'),
(9, 'bug', 'browse'),
(9, 'bug', 'export'),
(9, 'bug', 'index'),
(9, 'bug', 'report'),
(9, 'bug', 'view'),
(9, 'build', 'view'),
(9, 'company', 'browse'),
(9, 'company', 'dynamic'),
(9, 'company', 'edit'),
(9, 'company', 'index'),
(9, 'company', 'view'),
(9, 'dept', 'browse'),
(9, 'dept', 'delete'),
(9, 'dept', 'manageChild'),
(9, 'dept', 'updateOrder'),
(9, 'doc', 'browse'),
(9, 'doc', 'create'),
(9, 'doc', 'createLib'),
(9, 'doc', 'delete'),
(9, 'doc', 'deleteLib'),
(9, 'doc', 'deleteFile'),
(9, 'doc', 'edit'),
(9, 'doc', 'editLib'),
(9, 'doc', 'index'),
(9, 'doc', 'allLibs'),
(9, 'doc', 'objectLibs'),
(9, 'doc', 'showFiles'),
(9, 'doc', 'view'),
(9, 'extension', 'browse'),
(9, 'extension', 'obtain'),
(9, 'extension', 'structure'),
(9, 'file', 'delete'),
(9, 'file', 'download'),
(9, 'file', 'edit'),
(9, 'file', 'uploadImages'),
(9, 'git', 'apiSync'),
(9, 'git', 'cat'),
(9, 'git', 'diff'),
(9, 'group', 'browse'),
(9, 'index', 'index'),
(9, 'misc', 'ping'),
(9, 'my', 'bug'),
(9, 'my', 'changePassword'),
(9, 'my', 'dynamic'),
(9, 'my', 'editProfile'),
(9, 'my', 'index'),
(9, 'my', 'profile'),
(9, 'my', 'project'),
(9, 'my', 'story'),
(9, 'my', 'task'),
(9, 'my', 'testCase'),
(9, 'my', 'testTask'),
(9, 'my', 'todo'),
(9, 'my', 'calendar'),
(9, 'my', 'unbind'),
(9, 'my', 'manageContacts'),
(9, 'my', 'deleteContacts'),
(9, 'product', 'browse'),
(9, 'product', 'doc'),
(9, 'product', 'dynamic'),
(9, 'product', 'index'),
(9, 'product', 'all'),
(9, 'product', 'project'),
(9, 'product', 'roadmap'),
(9, 'product', 'view'),
(9, 'product', 'build'),
(9, 'productplan', 'browse'),
(9, 'productplan', 'view'),
(9, 'project', 'browse'),
(9, 'project', 'bug'),
(9, 'project', 'build'),
(9, 'project', 'burn'),
(9, 'project', 'computeBurn'),
(9, 'project', 'doc'),
(9, 'project', 'dynamic'),
(9, 'project', 'grouptask'),
(9, 'project', 'index'),
(9, 'project', 'all'),
(9, 'project', 'story'),
(9, 'project', 'task'),
(9, 'project', 'kanban'),
(9, 'project', 'tree'),
(9, 'project', 'treetask'),
(9, 'project', 'treestory'),
(9, 'project', 'team'),
(9, 'project', 'view'),
(9, 'qa', 'index'),
(9, 'release', 'browse'),
(9, 'release', 'export'),
(9, 'release', 'view'),
(9, 'repo', 'view'),
(9, 'repo', 'blame'),
(9, 'repo', 'revision'),
(9, 'repo', 'showSyncCommit'),
(9, 'repo', 'download'),
(9, 'repo', 'browse'),
(9, 'repo', 'diff'),
(9, 'repo', 'log'),
(9, 'report', 'bugAssign'),
(9, 'report', 'bugCreate'),
(9, 'report', 'index'),
(9, 'report', 'productSummary'),
(9, 'report', 'projectDeviation'),
(9, 'report', 'workload'),
(9, 'search', 'buildForm'),
(9, 'search', 'buildQuery'),
(9, 'search', 'deleteQuery'),
(9, 'search', 'saveQuery'),
(9, 'search', 'select'),
(9, 'story', 'export'),
(9, 'story', 'report'),
(9, 'story', 'review'),
(9, 'story', 'tasks'),
(9, 'story', 'bugs'),
(9, 'story', 'cases'),
(9, 'story', 'view'),
(9, 'story', 'zeroCase'),
(9, 'svn', 'apiSync'),
(9, 'svn', 'cat'),
(9, 'svn', 'diff'),
(9, 'task', 'deleteEstimate'),
(9, 'task', 'editEstimate'),
(9, 'task', 'export'),
(9, 'task', 'recordEstimate'),
(9, 'task', 'report'),
(9, 'task', 'view'),
(9, 'testcase', 'browse'),
(9, 'testcase', 'bugs'),
(9, 'testcase', 'export'),
(9, 'testcase', 'groupCase'),
(9, 'testcase', 'index'),
(9, 'testcase', 'view'),
(9, 'testsuite', 'index'),
(9, 'testsuite', 'browse'),
(9, 'testsuite', 'view'),
(9, 'testtask', 'browse'),
(9, 'testtask', 'cases'),
(9, 'testtask', 'groupCase'),
(9, 'testtask', 'index'),
(9, 'testtask', 'results'),
(9, 'testtask', 'view'),
(9, 'todo', 'activate'),
(9, 'todo', 'assignTo'),
(9, 'todo', 'batchClose'),
(9, 'todo', 'batchCreate'),
(9, 'todo', 'batchEdit'),
(9, 'todo', 'batchFinish'),
(9, 'todo', 'create'),
(9, 'todo', 'createCycle'),
(9, 'todo', 'close'),
(9, 'todo', 'delete'),
(9, 'todo', 'edit'),
(9, 'todo', 'export'),
(9, 'todo', 'finish'),
(9, 'todo', 'import2Today'),
(9, 'todo', 'view'),
(9, 'user', 'batchCreate'),
(9, 'user', 'batchEdit'),
(9, 'user', 'bug'),
(9, 'user', 'create'),
(9, 'user', 'delete'),
(9, 'user', 'deleteContacts'),
(9, 'user', 'dynamic'),
(9, 'user', 'edit'),
(9, 'user', 'manageContacts'),
(9, 'user', 'profile'),
(9, 'user', 'project'),
(9, 'user', 'story'),
(9, 'user', 'task'),
(9, 'user', 'testCase'),
(9, 'user', 'testTask'),
(9, 'user', 'todo'),
(9, 'user', 'unlock'),
(9, 'user', 'view'),
(9, 'user', 'unbind'),
(10, 'action', 'editComment'),
(10, 'bug', 'activate'),
(10, 'bug', 'browse'),
(10, 'bug', 'close'),
(10, 'bug', 'create'),
(10, 'bug', 'edit'),
(10, 'bug', 'batchChangeModule'),
(10, 'bug', 'linkBugs'),
(10, 'bug', 'unlinkBug'),
(10, 'bug', 'index'),
(10, 'bug', 'report'),
(10, 'bug', 'view'),
(10, 'build', 'view'),
(10, 'company', 'browse'),
(10, 'company', 'dynamic'),
(10, 'company', 'index'),
(10, 'company', 'view'),
(10, 'doc', 'browse'),
(10, 'doc', 'index'),
(10, 'doc', 'allLibs'),
(10, 'doc', 'objectLibs'),
(10, 'doc', 'showFiles'),
(10, 'doc', 'view'),
(10, 'file', 'download'),
(10, 'index', 'index'),
(10, 'misc', 'ping'),
(10, 'my', 'changePassword'),
(10, 'my', 'dynamic'),
(10, 'my', 'editProfile'),
(10, 'my', 'index'),
(10, 'my', 'profile'),
(10, 'my', 'task'),
(10, 'my', 'todo'),
(10, 'my', 'calendar'),
(10, 'my', 'unbind'),
(10, 'product', 'browse'),
(10, 'product', 'doc'),
(10, 'product', 'dynamic'),
(10, 'product', 'index'),
(10, 'product', 'all'),
(10, 'product', 'roadmap'),
(10, 'product', 'view'),
(10, 'product', 'build'),
(10, 'productplan', 'browse'),
(10, 'productplan', 'view'),
(10, 'project', 'browse'),
(10, 'project', 'bug'),
(10, 'project', 'build'),
(10, 'project', 'burn'),
(10, 'project', 'doc'),
(10, 'project', 'dynamic'),
(10, 'project', 'grouptask'),
(10, 'project', 'index'),
(10, 'project', 'all'),
(10, 'project', 'story'),
(10, 'project', 'task'),
(10, 'project', 'kanban'),
(10, 'project', 'tree'),
(10, 'project', 'treetask'),
(10, 'project', 'treestory'),
(10, 'project', 'team'),
(10, 'project', 'testtask'),
(10, 'project', 'view'),
(10, 'qa',      'index'),
(10, 'release', 'browse'),
(10, 'release', 'view'),
(10, 'repo', 'view'),
(10, 'repo', 'blame'),
(10, 'repo', 'revision'),
(10, 'repo', 'showSyncCommit'),
(10, 'repo', 'download'),
(10, 'repo', 'browse'),
(10, 'repo', 'diff'),
(10, 'repo', 'log'),
(10, 'report', 'bugAssign'),
(10, 'report', 'bugCreate'),
(10, 'report', 'index'),
(10, 'report', 'productSummary'),
(10, 'report', 'projectDeviation'),
(10, 'report', 'workload'),
(10, 'search', 'buildForm'),
(10, 'search', 'buildQuery'),
(10, 'search', 'deleteQuery'),
(10, 'search', 'saveQuery'),
(10, 'story', 'tasks'),
(10, 'story', 'bugs'),
(10, 'story', 'cases'),
(10, 'story', 'view'),
(10, 'task', 'deleteEstimate'),
(10, 'task', 'editEstimate'),
(10, 'task', 'recordEstimate'),
(10, 'task', 'view'),
(10, 'testsuite', 'index'),
(10, 'testsuite', 'browse'),
(10, 'testsuite', 'view'),
(10, 'todo', 'activate'),
(10, 'todo', 'assignTo'),
(10, 'todo', 'batchClose'),
(10, 'todo', 'batchCreate'),
(10, 'todo', 'batchEdit'),
(10, 'todo', 'batchFinish'),
(10, 'todo', 'create'),
(10, 'todo', 'createCycle'),
(10, 'todo', 'close'),
(10, 'todo', 'delete'),
(10, 'todo', 'edit'),
(10, 'todo', 'export'),
(10, 'todo', 'finish'),
(10, 'todo', 'import2Today'),
(10, 'todo', 'view'),
(10, 'user', 'bug'),
(10, 'user', 'dynamic'),
(10, 'user', 'profile'),
(10, 'user', 'project'),
(10, 'user', 'story'),
(10, 'user', 'task'),
(10, 'user', 'testCase'),
(10, 'user', 'testTask'),
(10, 'user', 'todo'),
(10, 'user', 'view'),
(11, 'bug', 'browse'),
(11, 'bug', 'index'),
(11, 'bug', 'report'),
(11, 'bug', 'view'),
(11, 'build', 'view'),
(11, 'company', 'browse'),
(11, 'company', 'dynamic'),
(11, 'company', 'index'),
(11, 'company', 'view'),
(11, 'doc', 'browse'),
(11, 'doc', 'index'),
(11, 'doc', 'allLibs'),
(11, 'doc', 'objectLibs'),
(11, 'doc', 'showFiles'),
(11, 'doc', 'view'),
(11, 'file', 'download'),
(11, 'git', 'cat'),
(11, 'git', 'diff'),
(11, 'group', 'browse'),
(11, 'index', 'index'),
(11, 'misc', 'ping'),
(11, 'my', 'index'),
(11, 'product', 'browse'),
(11, 'product', 'doc'),
(11, 'product', 'dynamic'),
(11, 'product', 'index'),
(11, 'product', 'all'),
(11, 'product', 'roadmap'),
(11, 'product', 'view'),
(11, 'product', 'build'),
(11, 'productplan', 'browse'),
(11, 'productplan', 'view'),
(11, 'project', 'browse'),
(11, 'project', 'bug'),
(11, 'project', 'build'),
(11, 'project', 'burn'),
(11, 'project', 'doc'),
(11, 'project', 'dynamic'),
(11, 'project', 'grouptask'),
(11, 'project', 'index'),
(11, 'project', 'all'),
(11, 'project', 'story'),
(11, 'project', 'task'),
(11, 'project', 'kanban'),
(11, 'project', 'tree'),
(11, 'project', 'treetask'),
(11, 'project', 'treestory'),
(11, 'project', 'team'),
(11, 'project', 'testtask'),
(11, 'project', 'view'),
(11, 'qa', 'index'),
(11, 'release', 'browse'),
(11, 'release', 'view'),
(11, 'report', 'bugAssign'),
(11, 'report', 'bugCreate'),
(11, 'report', 'index'),
(11, 'report', 'productSummary'),
(11, 'report', 'projectDeviation'),
(11, 'report', 'workload'),
(11, 'search', 'buildForm'),
(11, 'search', 'buildQuery'),
(11, 'story', 'tasks'),
(11, 'story', 'bugs'),
(11, 'story', 'cases'),
(11, 'story', 'view'),
(11, 'svn', 'cat'),
(11, 'svn', 'diff'),
(11, 'task', 'recordEstimate'),
(11, 'task', 'view'),
(11, 'testcase', 'browse'),
(11, 'testcase', 'bugs'),
(11, 'testcase', 'groupCase'),
(11, 'testcase', 'index'),
(11, 'testcase', 'view'),
(11, 'testsuite', 'index'),
(11, 'testsuite', 'browse'),
(11, 'testsuite', 'view'),
(11, 'testtask', 'browse'),
(11, 'testtask', 'cases'),
(11, 'testtask', 'groupCase'),
(11, 'testtask', 'index'),
(11, 'testtask', 'results'),
(11, 'testtask', 'view'),
(11, 'user', 'bug'),
(11, 'user', 'dynamic'),
(11, 'user', 'profile'),
(11, 'user', 'project'),
(11, 'user', 'story'),
(11, 'user', 'task'),
(11, 'user', 'testCase'),
(11, 'user', 'testTask'),
(11, 'user', 'todo'),
(11, 'user', 'view'),
(12, 'my', 'limited');
DROP TABLE IF EXISTS `zt_effort`;
CREATE TABLE IF NOT EXISTS `zt_effort` (
  `id` MEDIUMINT( 8 ) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
  `objectType` VARCHAR( 30 ) NOT NULL ,
  `objectID` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `product` VARCHAR( 255 ) NOT NULL ,
  `project` MEDIUMINT( 9 ) UNSIGNED NOT NULL ,
  `account` VARCHAR( 30 ) NOT NULL ,
  `work` text ,
  `date` DATE NOT NULL ,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  `begin` SMALLINT( 4 ) UNSIGNED ZEROFILL NOT NULL ,
  `end` SMALLINT( 4 ) UNSIGNED ZEROFILL NOT NULL,
  KEY `project` (`project`),
  KEY `objectID` (`objectID`),
  KEY `date` (`date`),
  KEY `account` (`account`)
) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci ;
ALTER TABLE  `zt_action` ADD  `efforted` BOOL NOT NULL DEFAULT  '0';
INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES ('30', '23', '*', '*', '*', 'moduleName=project&methodName=computeTaskEffort', '计算任务剩余工时', 'zentao', '1', 'normal', '0000-00-00 00:00:00');
INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES ('30', '7', '*', '*', '*', 'moduleName=effort&methodName=remindNotRecord', '提醒录入日志', 'zentao', '1', 'stop', '0000-00-00 00:00:00');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'company', 'effort'),
(2, 'company', 'effort'),
(3, 'company', 'effort'),
(4, 'company', 'effort'),
(5, 'company', 'effort'),
(6, 'company', 'effort'),
(7, 'company', 'effort'),
(8, 'company', 'effort'),
(9, 'company', 'effort'),
(10, 'company', 'effort'),
(1, 'effort', 'export'),
(2, 'effort', 'export'),
(3, 'effort', 'export'),
(4, 'effort', 'export'),
(5, 'effort', 'export'),
(6, 'effort', 'export'),
(7, 'effort', 'export'),
(8, 'effort', 'export'),
(9, 'effort', 'export'),
(10, 'effort', 'export'),
(1, 'effort', 'view'),
(2, 'effort', 'view'),
(3, 'effort', 'view'),
(4, 'effort', 'view'),
(5, 'effort', 'view'),
(6, 'effort', 'view'),
(7, 'effort', 'view'),
(8, 'effort', 'view'),
(9, 'effort', 'view'),
(10, 'effort', 'view'),
(1, 'effort', 'edit'),
(2, 'effort', 'edit'),
(3, 'effort', 'edit'),
(4, 'effort', 'edit'),
(5, 'effort', 'edit'),
(6, 'effort', 'edit'),
(7, 'effort', 'edit'),
(8, 'effort', 'edit'),
(9, 'effort', 'edit'),
(10, 'effort', 'edit'),
(1, 'effort', 'batchCreate'),
(2, 'effort', 'batchCreate'),
(3, 'effort', 'batchCreate'),
(4, 'effort', 'batchCreate'),
(5, 'effort', 'batchCreate'),
(6, 'effort', 'batchCreate'),
(7, 'effort', 'batchCreate'),
(8, 'effort', 'batchCreate'),
(9, 'effort', 'batchCreate'),
(10, 'effort', 'batchCreate'),
(1, 'effort', 'delete'),
(2, 'effort', 'delete'),
(3, 'effort', 'delete'),
(4, 'effort', 'delete'),
(5, 'effort', 'delete'),
(6, 'effort', 'delete'),
(7, 'effort', 'delete'),
(8, 'effort', 'delete'),
(9, 'effort', 'delete'),
(10, 'effort', 'delete'),
(1, 'effort', 'createForObject'),
(2, 'effort', 'createForObject'),
(3, 'effort', 'createForObject'),
(4, 'effort', 'createForObject'),
(5, 'effort', 'createForObject'),
(6, 'effort', 'createForObject'),
(7, 'effort', 'createForObject'),
(8, 'effort', 'createForObject'),
(9, 'effort', 'createForObject'),
(10, 'effort', 'createForObject'),
(1, 'my', 'effort'),
(2, 'my', 'effort'),
(3, 'my', 'effort'),
(4, 'my', 'effort'),
(5, 'my', 'effort'),
(6, 'my', 'effort'),
(7, 'my', 'effort'),
(8, 'my', 'effort'),
(9, 'my', 'effort'),
(10, 'my', 'effort'),
(1, 'project', 'effort'),
(2, 'project', 'effort'),
(3, 'project', 'effort'),
(4, 'project', 'effort'),
(5, 'project', 'effort'),
(6, 'project', 'effort'),
(7, 'project', 'effort'),
(8, 'project', 'effort'),
(9, 'project', 'effort'),
(10, 'project', 'effort'),
(1, 'user', 'effort');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'todo', 'calendar'),
(2, 'todo', 'calendar'),
(3, 'todo', 'calendar'),
(4, 'todo', 'calendar'),
(5, 'todo', 'calendar'),
(6, 'todo', 'calendar'),
(7, 'todo', 'calendar'),
(8, 'todo', 'calendar'),
(9, 'todo', 'calendar'),
(10, 'todo', 'calendar'),
(1, 'effort', 'calendar'),
(2, 'effort', 'calendar'),
(3, 'effort', 'calendar'),
(4, 'effort', 'calendar'),
(5, 'effort', 'calendar'),
(6, 'effort', 'calendar'),
(7, 'effort', 'calendar'),
(8, 'effort', 'calendar'),
(9, 'effort', 'calendar'),
(10, 'effort', 'calendar'),
(1, 'project', 'calendar'),
(2, 'project', 'calendar'),
(3, 'project', 'calendar'),
(4, 'project', 'calendar'),
(5, 'project', 'calendar'),
(6, 'project', 'calendar'),
(7, 'project', 'calendar'),
(8, 'project', 'calendar'),
(9, 'project', 'calendar'),
(10, 'project', 'calendar'),
(1, 'user', 'effortcalendar'),
(2, 'user', 'effortcalendar'),
(3, 'user', 'effortcalendar'),
(4, 'user', 'effortcalendar'),
(5, 'user', 'effortcalendar'),
(6, 'user', 'effortcalendar'),
(7, 'user', 'effortcalendar'),
(8, 'user', 'effortcalendar'),
(9, 'user', 'effortcalendar'),
(10, 'user', 'effortcalendar'),
(1, 'user', 'todocalendar'),
(2, 'user', 'todocalendar'),
(3, 'user', 'todocalendar'),
(4, 'user', 'todocalendar'),
(5, 'user', 'todocalendar'),
(6, 'user', 'todocalendar'),
(7, 'user', 'todocalendar'),
(8, 'user', 'todocalendar'),
(9, 'user', 'todocalendar'),
(10, 'user', 'todocalendar');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'bug', 'exportTemplet'),
(4, 'bug', 'exportTemplet'),
(1, 'bug', 'import'),
(4, 'bug', 'import'),
(1, 'bug', 'showImport'),
(4, 'bug', 'showImport'),
(1, 'story', 'exportTemplet'),
(4, 'story', 'exportTemplet'),
(1, 'story', 'import'),
(4, 'story', 'import'),
(1, 'story', 'showImport'),
(4, 'story', 'showImport'),
(1, 'task', 'exportTemplet'),
(4, 'task', 'exportTemplet'),
(1, 'task', 'import'),
(4, 'task', 'import'),
(1, 'task', 'showImport'),
(4, 'task', 'showImport');
 -- DROP TABLE IF EXISTS `zt_relationoftasks`;
CREATE TABLE IF NOT EXISTS `zt_relationoftasks` (
  `id` MEDIUMINT( 8 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `project` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `pretask` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `condition` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  `task` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `action` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  PRIMARY KEY (`id`),
  KEY `relationoftasks` (`project`,`task`)
) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci;
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'project', 'deleterelation'),
(1, 'project', 'gantt'),
(2, 'project', 'gantt'),
(3, 'project', 'gantt'),
(4, 'project', 'gantt'),
(5, 'project', 'gantt'),
(6, 'project', 'gantt'),
(7, 'project', 'gantt'),
(8, 'project', 'gantt'),
(9, 'project', 'gantt'),
(10, 'project', 'gantt'),
(1, 'project', 'relation'),
(2, 'project', 'relation'),
(3, 'project', 'relation'),
(4, 'project', 'relation'),
(5, 'project', 'relation'),
(6, 'project', 'relation'),
(7, 'project', 'relation'),
(8, 'project', 'relation'),
(9, 'project', 'relation'),
(10, 'project', 'relation');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'report', 'build'),
(2, 'report', 'build'),
(3, 'report', 'build'),
(4, 'report', 'build'),
(5, 'report', 'build'),
(6, 'report', 'build'),
(7, 'report', 'build'),
(8, 'report', 'build'),
(9, 'report', 'build'),
(10, 'report', 'build'),
(1, 'report', 'testcase'),
(2, 'report', 'testcase'),
(3, 'report', 'testcase'),
(4, 'report', 'testcase'),
(5, 'report', 'testcase'),
(6, 'report', 'testcase'),
(7, 'report', 'testcase'),
(8, 'report', 'testcase'),
(9, 'report', 'testcase'),
(10, 'report', 'testcase'),
(1, 'report', 'workSummary'),
(2, 'report', 'workSummary'),
(3, 'report', 'workSummary'),
(4, 'report', 'workSummary'),
(5, 'report', 'workSummary'),
(6, 'report', 'workSummary'),
(7, 'report', 'workSummary'),
(8, 'report', 'workSummary'),
(9, 'report', 'workSummary'),
(10, 'report', 'workSummary');
ALTER TABLE `zt_user` ADD `ldap` CHAR(30) NOT NULL AFTER `ranzhi`;

-- DROP TABLE IF EXISTS `zt_report`;
CREATE TABLE IF NOT EXISTS `zt_report` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL,
  `name` text NOT NULL,
  `module` varchar(100) NOT NULL,
  `sql` text NOT NULL,
  `vars` text NOT NULL,
  `langs` text NOT NULL,
  `params` text NOT NULL,
  `step` tinyint(1) NOT NULL DEFAULT '2',
  `desc` text NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE OR REPLACE VIEW `ztv_projectsummary` AS select `zt_task`.`project` AS `project`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`estimate`,0)) AS `estimate`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0)) AS `consumed`,sum(if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0)) AS `left`,count(0) AS `number`,sum(if(((`zt_task`.`status` != 'done') and (`zt_task`.`status` != 'closed')),1,0)) AS `undone`,sum((if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0) + if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0))) AS `totalReal` from `zt_task` where (`zt_task`.`deleted` = '0') group by `zt_task`.`project`;
CREATE OR REPLACE VIEW `ztv_projectstories` AS select `t1`.`project` AS `project`,count('*') AS `stories`,sum(if((`t2`.`status` = 'closed'),0,1)) AS `undone` from (`zt_projectstory` `t1` left join `zt_story` `t2` on((`t1`.`story` = `t2`.`id`))) where (`t2`.`deleted` = '0') group by `t1`.`project`;
CREATE OR REPLACE VIEW `ztv_projectteams` AS select `zt_team`.`root` AS `project`,count('*') AS `teams` from `zt_team` where `type` = 'project' group by `zt_team`.`root`;
CREATE OR REPLACE VIEW `ztv_projectbugs` AS select `zt_bug`.`project` AS `project`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`project`;
CREATE OR REPLACE VIEW `ztv_productbugs` AS select `zt_bug`.`product` AS `product`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`product`;
CREATE OR REPLACE VIEW `ztv_productstories` AS select `zt_story`.`product` AS `product`,count('*') AS `stories`,sum(if((`zt_story`.`status` = 'closed'),0,1)) AS `undone` from `zt_story` where (`zt_story`.`deleted` = '0') group by `zt_story`.`product`;
CREATE OR REPLACE VIEW `ztv_dayuserlogin` AS select count(*) AS `userlogin`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'user') and (`zt_action`.`action` = 'login')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_dayeffort` AS select round(sum(`zt_effort`.`consumed`),1) AS `consumed`,`zt_effort`.`date` AS `date` from `zt_effort` group by `zt_effort`.`date`;
CREATE OR REPLACE VIEW `ztv_daystoryopen` AS select count(*) AS `storyopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daystoryclose` AS select count(*) AS `storyclose`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'closed')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daytaskopen` AS select count(*) AS `taskopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daytaskfinish` AS select count(*) AS `taskfinish`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'finished')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daybugopen` AS select count(*) AS `bugopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daybugresolve` AS select count(*) AS `bugresolve`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'resolved')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_dayactions` AS select count(*) AS `actions`,left(`zt_action`.`date`,10) AS `day` from `zt_action` group by left(`zt_action`.`date`,10);

REPLACE INTO `zt_report` (`code`, `name`, `module`, `sql`, `vars`, `langs`, `params`, `step`, `desc`, `addedBy`, `addedDate`) VALUES
('product-invest',       '{\"zh-cn\":\"\\u4ea7\\u54c1\\u6295\\u5165\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u6295\\u5165\\u8868\",\"en\":\"Product Investment\"}',',product','select t1.id,t1.name,1 as projects, round(t3.consumed,2) as consumed from TABLE_PRODUCT as t1 left join TABLE_PROJECTPRODUCT as t2 on t1.id=t2.product left join ztv_projectsummary as t3 on t2.project=t3.project left join TABLE_PROJECT as t4 on t2.project=t4.id where t1.deleted=\'0\' and t4.deleted=\'0\'','','{\"projects\":{\"zh-cn\":\"\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\\u9879\\u76ee\\u6570\",\"en\":\"Projects\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost(h)\"}}','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"projects\",\"consumed\"],\"reportType\":[\"sum\",\"sum\"],\"sumAppend\":[\"projects\",\"consumed\"],\"contrast\":[\"\",\"\"]}',2,'{\"zh-cn\":\"\\u5217\\u51fa\\u6bcf\\u4e2a\\u4ea7\\u54c1\\u7684\\u9879\\u76ee\\u603b\\u6570\\uff0c\\u5df2\\u7ecf\\u6d88\\u8017\\u7684\\u5de5\\u65f6\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u6bcf\\u500b\\u7522\\u54c1\\u7684\\u9805\\u76ee\\u7e3d\\u6578\\uff0c\\u5df2\\u7d93\\u6d88\\u8017\\u7684\\u5de5\\u6642\\u3002 \",\"en\":\"Number of projects and consumed hours.\"}','admin','2015-07-20 14:21:30'),
('product-progress',     '{\"zh-cn\":\"\\u4ea7\\u54c1\\u5b8c\\u6210\\u5ea6\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u5b8c\\u6210\\u5ea6\\u7d71\\u8a08\\u8868\",\"en\":\"Product Progress\"}',',product','select t1.*,t2.name, (case when t1.status = \'closed\' or t1.stage = \'released\' then 1 else 0 end) as done, 1 as count from TABLE_STORY as t1 left join TABLE_PRODUCT as t2 on t1.product=t2.id where t1.deleted=\'0\' and t2.deleted=\'0\'','','{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"count\",\"done\"],\"reportType\":[\"sum\",\"sum\"],\"sumAppend\":[\"count\",\"done\"],\"percent\":{\"1\":\"1\"},\"contrast\":{\"1\":\"count\"},\"showAlone\":{\"1\":\"1\"}}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u603b\\u6570(\\u72b6\\u6001\\u662f\\u5173\\u95ed\\uff0c\\u6216\\u8005\\u7814\\u53d1\\u9636\\u6bb5\\u662f\\u53d1\\u5e03)\\uff0c\\u5b8c\\u6210\\u7684\\u767e\\u5206\\u6bd4\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u5b8c\\u6210\\u7684\\u7e3d\\u6578\\uff08\\u72c0\\u614b\\u662f\\u95dc\\u9589\\uff0c\\u6216\\u8005\\u7814\\u767c\\u968e\\u6bb5\\u662f\\u767c\\u4f48\\uff09\\uff0c\\u5b8c\\u6210\\u7684\\u767e\\u5206\\u6bd4\\u3002\",\"en\":\"Number of total stories,done stories(state is closed, or stage is released), percent of completion.\"}','admin','2015-07-21 15:07:48'),
('story-status',         '{\"zh-cn\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u9700\\u6c42\\u72c0\\u614b\\u5206\\u4f48\\u8868\",\"en\":\"Story Status\"}',',product','select t1.*,t2.name from TABLE_STORY as t1 left join TABLE_PRODUCT as t2 on t1.product=t2.id where t1.deleted=\'0\' and t2.deleted=\'0\'','','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u72b6\\u6001\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u72c0\\u614b\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"en\":\"Total number and status distribution of stories.\"}','admin','2015-07-21 15:35:38'),
('story-stage',          '{\"zh-cn\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u9700\\u6c42\\u968e\\u6bb5\\u5206\\u4f48\\u8868\",\"en\":\"Story Stage\"}',',product','select t1.*,t2.name from TABLE_STORY as t1 left join TABLE_PRODUCT as t2 on t1.product=t2.id where t1.deleted=\'0\' and t2.deleted=\'0\'','','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stage\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u7814\\u53d1\\u9636\\u6bb5\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u7814\\u767c\\u968e\\u6bb5\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002 \",\"en\":\"Total number and stage distribution of stories \"}','admin','2015-07-21 15:38:34'),
('product-release',      '{\"zh-cn\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6570\\u91cf\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u767c\\u4f48\\u6578\\u91cf\\u7d71\\u8a08\\u8868\",\"en\":\"Product Release\"}',',product','select t2.name, 1 as releases from TABLE_RELEASE as t1 left join TABLE_PRODUCT as t2 on t1.product=t2.id where t1.deleted=\'0\' and t2.deleted=\'0\'','','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"releases\"],\"reportType\":[\"sum\"],\"sumAppend\":[\"releases\"],\"contrast\":[\"\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u53d1\\u5e03\\u7684\\u6570\\u91cf\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u767c\\u4f48\\u7684\\u6578\\u91cf\\u3002\",\"en\":\"Product Release.\"}','admin','2015-07-21 16:00:52'),
('task-status',          '{\"zh-cn\":\"\\u4efb\\u52a1\\u72b6\\u6001\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u4efb\\u52d9\\u72c0\\u614b\\u7d71\\u8a08\\u8868\",\"en\":\"Task Status\"}',',project','select t1.id,t1.name,t2.status,t2.project,t2.id as taskID, if($status=\'\',\'\', t1.status) as projectstatus, (case when t2.deadline < CURDATE() and t2.deadline != \'0000-00-00\' and t2.status != \'closed\' and t2.status != \'done\' and t2.status != \'cancel\' then 1 else 0 end) as timeout from TABLE_PROJECT as t1 left join TABLE_TASK as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and if($beginDate=\'\', 1, t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate) having projectstatus=$status','{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u5f00\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\",\"timeout\"],\"reportType\":[\"count\",\"sum\"],\"sumAppend\":[\"\",\"timeout\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u4efb\\u52d9\\u7684\\u72c0\\u614b\\u5206\\u5e03\\u60c5\\u51b5\\u3002 \",\"en\":\"Status distribution of project tasks.\"}','admin','2015-07-22 11:28:33'),
('task-type',            '{\"zh-cn\":\"\\u4efb\\u52a1\\u7c7b\\u578b\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u4efb\\u52d9\\u985e\\u578b\\u7d71\\u8a08\\u8868\",\"en\":\"Task Type\"}',',project','select t1.id,t1.name,t2.type,t2.project,t2.id as taskID, if($status=\'\',\'\', t1.status) as projectstatus from TABLE_PROJECT as t1 left join TABLE_TASK as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,end<=$endDate) having projectstatus=$status','{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u4efb\\u52d9\\u7684\\u985e\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002 \",\"en\":\"Type distribution of task.\"}','admin','2015-07-22 13:06:46'),
('task-assign',          '{\"zh-cn\":\"\\u9879\\u76ee\\u4efb\\u52a1\\u6307\\u6d3e\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u4efb\\u52d9\\u6307\\u6d3e\\u7d71\\u8a08\\u9336\",\"en\":\"Task Assignment\"}',',project','select t1.id,t1.name,if(t3.account is not null, t3.account,t2.assignedTo) as assignedTo,t2.project,t2.id as taskID, if($status=\'\',\'\', t1.status) as projectstatus from TABLE_PROJECT as t1 left join TABLE_TASK as t2 on t1.id=t2.project left join TABLE_TEAM as t3 on t3.type=\'task\' && t3.root=t2.id where t1.deleted=\'0\' and t2.deleted=\'0\' and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate) having projectstatus=$status','{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"assignedTo\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u4efb\\u52d9\\u7684\\u6307\\u6d3e\\u7d66\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"en\":\"Assignment distribution of task.\"}','admin','2015-07-22 13:13:28'),
('task-finish',          '{\"zh-cn\":\"\\u9879\\u76ee\\u4efb\\u52a1\\u5b8c\\u6210\\u8005\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u4efb\\u52d9\\u5b8c\\u6210\\u8005\\u7d71\\u8a08\\u8868\",\"en\":\"Task Completer\"}',',project','select t1.id,t1.name,t2.finishedBy,t2.project,t2.id as taskID, if($status=\'\',\'\', t1.status) as projectstatus from TABLE_PROJECT as t1 left join TABLE_TASK as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and t2.finishedBy!=\'\' and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate) having projectstatus=$status','{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"finishedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u5b8c\\u6210\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u4efb\\u52d9\\u7684\\u5b8c\\u6210\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"en\":\"Completer distribution of task.\"}','admin','2015-07-22 13:16:21'),
('project-invest',       '{\"zh-cn\":\"\\u9879\\u76ee\\u6295\\u5165\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u6295\\u5165\\u7d71\\u8a08\\u8868\",\"en\":\"Project Investment\"}',',project','select t1.id,t1.name,CONCAT(t1.begin,\' ~ \',t1.end) as timeLimit,t2.teams,t3.stories,round(t4.consumed,1) as consumed,t4.number,if($status=\'\',\'\',t1.status) as projectstatus from TABLE_PROJECT as t1 left join ztv_projectteams as t2 on t1.id=t2.project left join ztv_projectstories as t3 on t1.id=t3.project left join ztv_projectsummary as t4 on t1.id=t4.project where t1.deleted=\'0\' and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate) having projectstatus=$status','{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}','{\"timeLimit\":{\"zh-cn\":\"\\u5de5\\u671f\",\"zh-tw\":\"\\u5de5\\u671f\",\"en\":\"Period\"},\"teams\":{\"zh-cn\":\"\\u4eba\\u6570\",\"zh-tw\":\"\\u4eba\\u6570\",\"en\":\"Memebers\"},\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"consumed\":{\"zh-cn\":\"\\u603b\\u6d88\\u8017\",\"zh-tw\":\"\\u603b\\u6d88\\u8017\",\"en\":\"Cost(h)\"},\"number\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u6570\",\"en\":\"Tasks\"}}','{\"group1\":\"name\",\"group2\":\"timeLimit\",\"reportField\":[\"number\",\"stories\",\"teams\",\"consumed\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"number\",\"stories\",\"teams\",\"consumed\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u5217\\u51fa\\uff1a\\u4efb\\u52a1\\u6570\\uff0c\\u9700\\u6c42\\u6570\\uff0c\\u4eba\\u6570\\uff0c\\u5de5\\u671f\\uff0c\\u603b\\u6d88\\u8017\\u5de5\\u65f6\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u5217\\u51fa\\uff1a\\u4efb\\u52d9\\u6578\\uff0c\\u9700\\u6c42\\u6578\\uff0c\\u4eba\\u6578\\uff0c\\u5de5\\u671f\\uff0c\\u7e3d\\u6d88\\u8017\\u5de5\\u6642\\u3002 \",\"en\":\" Investment of projects. \"}','admin','2015-07-22 16:37:38'),
('projectstory-status',  '{\"zh-cn\":\"\\u9879\\u76ee\\u9700\\u6c42\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u9700\\u6c42\\u72c0\\u614b\\u5206\\u4f48\\u8868\",\"en\":\"Story Status\"}',',project','select t2.id,t2.name,t3.status from TABLE_PROJECTSTORY as t1 left join TABLE_PROJECT as t2 on t1.project=t2.id left join TABLE_STORY as t3 on t1.story=t3.id where t2.deleted=\'0\' and if($status=\'\',1,t2.status=$status)','{\"varName\":[\"status\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\"],\"requestType\":[\"select\"],\"selectList\":[\"project.status\"],\"default\":[\"\"]}','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u9700\\u6c42\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u9700\\u6c42\\u7684\\u72c0\\u614b\\u5206\\u4f48\\u60c5\\u51b5\\u3002\",\"en\":\"State distribution of project story.\"}','admin','2015-07-23 15:35:08'),
('projectstory-stage',   '{\"zh-cn\":\"\\u9879\\u76ee\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u9700\\u6c42\\u968e\\u6bb5\\u5206\\u4f48\\u8868\",\"en\":\"Story Stage\"}',',project','select t2.id,t2.name,t3.stage from TABLE_PROJECTSTORY as t1 left join TABLE_PROJECT as t2 on t1.project=t2.id left join TABLE_STORY as t3 on t1.story=t3.id where t2.deleted=\'0\' and if($status=\'\',1,t2.status=$status)','{\"varName\":[\"status\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\"],\"requestType\":[\"select\"],\"selectList\":[\"project.status\"],\"default\":[\"\"]}','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stage\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u9700\\u6c42\\u968e\\u6bb5\\u5206\\u4f48\\u60c5\\u51b5\\u3002 \",\"en\":\"Stage distribution of project story.\"}','admin','2015-07-23 15:38:18'),
('projectbug-status',    '{\"zh-cn\":\"\\u9879\\u76eeBug\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u72c0\\u614b\\u5206\\u4f48\\u8868\",\"en\":\"Bug Status\"}',',project,test','select t1.id,t1.name,t1.id as bugID,t2.status from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\'','','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\" \\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u72c0\\u614b\\u5206\\u4f48\\u60c5\\u51b5\\u3002\",\"en\":\"State distribution of project bugs.\"}','admin','2015-07-23 15:48:03'),
('projectbug-resolution','{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u89e3\\u6c7a\\u65b9\\u5206\\u4f48\\u8868\",\"en\":\"Bug Solution of Project\"}',',project,test','select t1.id,t1.name,t1.id as bugID,t2.resolution from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and t2.resolution!=\'\' having bugID!=\'\'','','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u89e3\\u6c7a\\u65b9\\u6848\\u5206\\u4f48\\u60c5\\u51b5\\u3002\",\"en\":\"Solution distribution of project bugs\"}','admin','2015-07-23 16:04:46'),
('projectbug-opened',    '{\"zh-cn\":\"\\u9879\\u76eeBug\\u521b\\u5efa\\u8005\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u5275\\u5efa\\u8005\\u5206\\u4f48\\u8868\",\"en\":\"Bug Creator\"}',',project,test','select t1.id,t1.name,t1.id as bugID,t2.openedBy from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\'','','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"openedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u521b\\u5efa\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u5275\\u5efa\\u8005\\u5206\\u4f48\\u60c5\\u51b5\\u3002\",\"en\":\"Creator distributed of project bugs.\"}','admin','2015-07-23 16:08:10'),
('projectbug-resolve',   '{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u8005\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u89e3\\u6c7a\\u8005\\u5206\\u4f48\\u8868\",\"en\":\"Bug Solver\"}',',project,test','select t1.id,t1.name,t1.id as bugID,t2.resolvedBy from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and t2.status!=\'active\' and t2.resolvedBy!=\'\' having bugID!=\'\'','','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"resolvedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u89e3\\u51b3\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u89e3\\u51b3\\u8005\\u5206\\u4f48\\u60c5\\u51b5\\u3002 \",\"en\":\"Solver distribution of project bugs.\"}','admin','2015-07-23 16:13:16'),
('projectbug-assign',    '{\"zh-cn\":\"\\u9879\\u76eeBug\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u6307\\u6d3e\\u5206\\u4f48\\u8868\",\"en\":\"Bug Assignee\"}',',project,test','select t1.id,t1.name,t1.id as bugID,t2.assignedTo from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\'','','','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"assignedTo\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u6307\\u6d3e\\u7d66\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"en\":\"Assignee distribution of project bugs.\"}','admin','2015-07-23 16:29:10'),
('project-quality',      '{\"zh-cn\":\"\\u9879\\u76ee\\u8d28\\u91cf\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u8cea\\u91cf\\u8868\",\"en\":\"Project Quality\"}',',project','select t1.id,t1.name,t2.stories,(t2.stories-t2.undone) as doneStory,t3.number,(t3.number-t3.undone) as doneTask,t4.bugs,t4.resolutions, round(t4.bugs/(t2.stories-t2.undone),2) as bugthanstory,round(t4.bugs/(t3.number-t3.undone),2) as bugthantask,t4.seriousBugs from TABLE_PROJECT as t1 left join ztv_projectstories as t2 on t1.id=t2.project left join ztv_projectsummary as t3 on t1.id=t3.project left join ztv_projectbugs as t4 on t1.id=t4.project where t1.deleted=\'0\'','','{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u603b\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u603b\\u6570\",\"en\":\"Stories\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"en\":\"Finished Stories\"},\"number\":{\"zh-cn\":\"\\u4efb\\u52a1\\u603b\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u603b\\u6570\",\"en\":\"Tasks\"},\"doneTask\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"en\":\"Finished Tasks\"},\"bugs\":{\"zh-cn\":\"Bug\\u6570\",\"zh-tw\":\"Bug\\u6570\",\"en\":\"Bugs\"},\"resolutions\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u89e3\\u51b3Bug\\u6570\",\"en\":\"Solutions\"},\"bugthanstory\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"zh-tw\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"en\":\"Bugs\\/FinishedStories\"},\"bugthantask\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u4efb\\u52a1\",\"zh-tw\":\"Bug\\/\\u5b8c\\u6210\\u4efb\\u52a1\",\"en\":\"Bug\\/FinishedTasks\"},\"seriousBugs\":{\"zh-cn\":\"\\u91cd\\u8981Bug\\u6570\",\"zh-tw\":\"\\u91cd\\u8981Bug\\u6570\",\"en\":\"Serious Bugs\"},\"seriousBugsPercent\":{\"zh-cn\":\"\\u4e25\\u91cdBug\\u6bd4\\u7387\",\"zh-tw\":\"\\u4e25\\u91cdBug\\u6bd4\\u7387\",\"en\":\"Severe bug ratio\"}}','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stories\",\"doneStory\",\"number\",\"doneTask\",\"bugs\",\"resolutions\",\"bugthanstory\",\"bugthantask\",\"seriousBugs\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"doneStory\",\"number\",\"doneTask\",\"bugs\",\"resolutions\",\"bugthanstory\",\"bugthantask\",\"seriousBugs\"],\"percent\":{\"8\":\"1\"},\"contrast\":{\"8\":\"bugs\"},\"showAlone\":{\"8\":\"1\"}}',2,'{\"zh-cn\":\"\\u5217\\u51fa\\u9879\\u76ee\\u7684\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u9700\\u6c42\\u6570\\uff0c\\u4efb\\u52a1\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\uff0cBug\\u6570\\uff0c\\u89e3\\u51b3\\u7684Bug\\u6570\\uff0cBug\\/\\u9700\\u6c42\\uff0cBug\\/\\u4efb\\u52a1\\uff0c\\u91cd\\u8981Bug\\u6570\\u91cf(\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u4e8e3\\uff09\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u9805\\u76ee\\u7684\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u5b8c\\u6210\\u9700\\u6c42\\u6578\\uff0c\\u4efb\\u52d9\\u7e3d\\u6578\\uff0c\\u5b8c\\u6210\\u7684\\u4efb\\u52d9\\u6578\\uff0cBug\\u6578\\uff0c\\u89e3\\u51b3\\u7684Bug\\u6578\\uff0cBug\\/\\u9700\\u6c42\\uff0cBug\\/\\u4efb\\u52d9\\uff0c\\u91cd\\u8981Bug\\u6578\\u91cf\\uff08\\u56b4\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u65bc3\\uff09\\u3002\",\"en\":\"Serious Bugs(severity is little than 3).\"}','admin','2015-07-23 17:03:10'),
('product-quality',      '{\"zh-cn\":\"\\u4ea7\\u54c1\\u8d28\\u91cf\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u8cea\\u91cf\\u8868\",\"en\":\"Product Quality\"}',',product','select t1.id,t1.name,t2.stories,(t2.stories-t2.undone) as doneStory,t3.bugs,t3.resolutions,round(t3.bugs/(t2.stories-t2.undone),2) as bugthanstory,t3.seriousBugs from TABLE_PRODUCT as t1 left join ztv_productstories as t2 on t1.id=t2.product left join ztv_productbugs as t3 on t1.id=t3.product where t1.deleted=\'0\'','','{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u603b\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u603b\\u6570\",\"en\":\"Stories\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"en\":\"Finished Stories\"},\"bugs\":{\"zh-cn\":\"Bug\\u6570\",\"zh-tw\":\"Bug\\u6570\",\"en\":\"Bugs\"},\"resolutions\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u89e3\\u51b3Bug\\u6570\",\"en\":\"Solved Bugs\"},\"bugthanstory\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"zh-tw\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"en\":\"Bug\\/Finished Story\"},\"seriousBugs\":{\"zh-cn\":\"\\u91cd\\u8981Bug\\u6570\",\"zh-tw\":\"\\u91cd\\u8981Bug\\u6570\",\"en\":\"Serious Bugs\"},\"seriousBugsPercent\":{\"zh-cn\":\"\\u4e25\\u91cdbug\\u6bd4\\u7387\",\"zh-tw\":\"\\u4e25\\u91cdbug\\u6bd4\\u7387\",\"en\":\"Serious Bugs %\"}}','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stories\",\"doneStory\",\"bugs\",\"resolutions\",\"bugthanstory\",\"seriousBugs\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"doneStory\",\"bugs\",\"resolutions\",\"bugthanstory\",\"seriousBugs\"],\"percent\":{\"5\":\"1\"},\"contrast\":{\"5\":\"bugs\"},\"showAlone\":{\"5\":\"1\"}}',2,'{\"zh-cn\":\"\\u5217\\u51fa\\u4ea7\\u54c1\\u7684\\u9700\\u6c42\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u603b\\u6570\\uff0cBug\\u6570\\uff0c\\u89e3\\u51b3\\u7684Bug\\u603b\\u6570\\uff0cBug\\/\\u9700\\u6c42\\uff0c\\u91cd\\u8981Bug\\u6570\\u91cf(\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u4e8e3)\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u7522\\u54c1\\u7684\\u9700\\u6c42\\u6578\\uff0c\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u7e3d\\u6578\\uff0cBug\\u6578\\uff0c\\u89e3\\u51b3\\u7684Bug\\u7e3d\\u6578\\uff0cBug\\/\\u9700\\u6c42\\uff0c\\u91cd\\u8981Bug\\u6578\\u91cf\\uff08\\u56b4\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u65bc3\\uff09\\u3002\",\"en\":\"Serious Bug (severity is less than 3).\"}','admin','2015-07-23 17:17:40'),
('productbug-type',      '{\"zh-cn\":\"\\u4ea7\\u54c1Bug\\u7c7b\\u578b\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1Bug\\u985e\\u578b\\u7d71\\u8a08\\u8868\",\"en\":\"Bug Type of Product\"}',',product,test','select t1.id,t1.name,t2.id as bugID,t2.type from TABLE_PRODUCT as t1 left join TABLE_BUG as t2 on t1.id=t2.product where t1.deleted=\'0\' and t2.deleted=\'0\'','','{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u7edf\\u8ba1Bug\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u7d71\\u8a08Bug\\u7684\\u985e\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"en\":\"Type distribution of Bugs.\"}','admin','2015-07-24 13:48:22'),
('productbug-resolve',   '{\"zh-cn\":\"\\u4ea7\\u54c1Bug\\u89e3\\u51b3\\u65b9\\u6848\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1Bug\\u89e3\\u6c7a\\u65b9\\u6848\\u7d71\\u8a08\\u8868\",\"en\":\"Bug Solution of Product\"}',',product,test','select t1.id,t1.name,t2.id as bugID,t2.resolution from TABLE_PRODUCT as t1 left join TABLE_BUG as t2 on t1.id=t2.product where t1.deleted=\'0\' and t2.deleted=\'0\'','','{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u7edf\\u8ba1Bug\\u7684\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u7d71\\u8a08Bug\\u7684\\u89e3\\u6c7a\\u65b9\\u6848\\u5206\\u4f48\\u60c5\\u51b5\\u3002\",\"en\":\"Solution distribution of bugs.\"}','admin','2015-07-24 13:55:46'),
('user-login',           '{\"zh-cn\":\"\\u5458\\u5de5\\u767b\\u5f55\\u6b21\\u6570\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u54e1\\u5de5\\u767b\\u9304\\u6b21\\u6578\\u7d71\\u8a08\\u8868\",\"en\":\"Login Times\"}',',staff','select actor,LEFT(`date`,10) as `day` from TABLE_ACTION where `action`=\'login\' and if($startDate=\'\',1,`date`>=$startDate) and if($endDate=\'\',1,`date`<=$endDate) order by `date` asc, actor asc','{\"varName\":[\"startDate\",\"endDate\"],\"showName\":[\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"date\",\"date\"],\"selectList\":[\"user\",\"user\"],\"default\":[\"$MONTHBEGIN\",\"$MONTHEND\"]}','{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}','{\"group1\":\"actor\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"day\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u5b9e\\u73b0\\u5458\\u5de5\\u767b\\u5f55\\u6b21\\u6570\\u7edf\\u8ba1\\u62a5\\u8868\\uff0c\\u6309\\u7167\\u5929\\u7edf\\u8ba1\\u6bcf\\u5929\\u6bcf\\u4e2a\\u4eba\\u7684\\u767b\\u5f55\\u6b21\\u6570\\uff0c\\u4ee5\\u53ca\\u603b\\u6570\\u3002\",\"zh-tw\":\"\\u5be6\\u73fe\\u54e1\\u5de5\\u767b\\u9304\\u6b21\\u6578\\u7d71\\u8a08\\u5831\\u8868\\uff0c\\u6309\\u5929\\u7d71\\u8a08\\u6bcf\\u5929\\u6bcf\\u500b\\u4eba\\u7684\\u767b\\u9304\\u6b21\\u6578\\uff0c\\u4ee5\\u53ca\\u7e3d\\u6578\\u3002 \",\"en\":\"The summary of user login times.\"}','admin','2015-07-24 14:28:11'),
('effort',               '{\"zh-cn\":\"\\u65e5\\u5fd7\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u65e5\\u8a8c\\u5f59\\u7e3d\\u8868\",\"en\":\"Effort Summary\"}',',staff','select t1.account,t1.consumed,t1.`date`,if($dept=\'0\',0,t2.dept) as dept from TABLE_EFFORT as t1 left join TABLE_USER as t2 on t1.account=t2.account where if($startDate=\'\',1,t1.`date`>=$startDate) and if($endDate=\'\',1,t1.`date`<=$endDate) having dept=$dept order by `date` asc','{\"varName\":[\"dept\",\"startDate\",\"endDate\"],\"showName\":[\"\\u90e8\\u95e8\",\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"dept\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}','{\"date\":{\"zh-cn\":\"\\u65e5\\u671f\",\"zh-tw\":\"\\u65e5\\u671f\",\"en\":\"Date\"},\"consumed\":{\"zh-cn\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost\"}}','{\"group1\":\"account\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"date\"],\"reportType\":[\"sum\"],\"sumAppend\":[\"consumed\"]}',2,'{\"zh-cn\":\"\\u67e5\\u770b\\u67d0\\u4e2a\\u65f6\\u95f4\\u6bb5\\u5185\\u7684\\u65e5\\u5fd7\\u60c5\\u51b5\\uff0c\\u53ef\\u4ee5\\u6309\\u7167\\u90e8\\u95e8\\u9009\\u62e9\\u3002\",\"zh-tw\":\" \\u67e5\\u770b\\u67d0\\u500b\\u6642\\u9593\\u6bb5\\u5167\\u7684\\u65e5\\u8a8c\\u60c5\\u51b5\\uff0c\\u53ef\\u4ee5\\u6309\\u7167\\u90e8\\u9580\\u9078\\u64c7\\u3002 \",\"en\":\"Effort summary of users.\"}','admin','2015-07-27 13:53:32'),
('company-dynamic',      '{\"zh-cn\":\"\\u516c\\u53f8\\u52a8\\u6001\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u516c\\u53f8\\u52d5\\u614b\\u5f59\\u7e3d\\u8868\",\"en\":\"Company Dynamics\"}', ',staff',  'select t1.day,t2.userlogin,t3.consumed,t4.storyopen,t5.storyclose,t6.taskopen,t7.taskfinish,t8.bugopen,t9.bugresolve,t1.actions from ztv_dayactions as t1 left join ztv_dayuserlogin as t2 on t1.day=t2.day left join ztv_dayeffort as t3 on t1.day=t3.date left join ztv_daystoryopen as t4 on t1.day=t4.day left join ztv_daystoryclose as t5 on t1.day=t5.day left join ztv_daytaskopen as t6 on t1.day=t6.day left join ztv_daytaskfinish as t7 on t1.day=t7.day left join ztv_daybugopen as t8 on t1.day=t8.day left join ztv_daybugresolve as t9 on t1.day=t9.day where if($startDate=\'\',1,t1.day>=$startDate) and if($endDate=\'\',1,t1.day<=$endDate)',      '{\"varName\":[\"startDate\",\"endDate\"],\"showName\":[\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"date\",\"date\"],\"selectList\":[\"user\",\"user\"],\"default\":[\"$MONTHBEGIN\",\"$MONTHEND\"]}',        '{\"day\":{\"zh-cn\":\"\\u65e5\\u671f\",\"zh-tw\":\"\\u65e5\\u671f\",\"en\":\"Date\"},\"userlogin\":{\"zh-cn\":\"\\u767b\\u5f55\\u6b21\\u6570\",\"zh-tw\":\"\\u767b\\u9304\\u6b21\\u6578\",\"en\":\"Login\"},\"consumed\":{\"zh-cn\":\"\\u65e5\\u5fd7\\u5de5\\u65f6\",\"zh-tw\":\"\\u65e5\\u8a8c\\u5de5\\u6642\",\"en\":\"Cost(h)\"},\"storyopen\":{\"zh-cn\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6578\",\"en\":\"Open Story\"},\"storyclose\":{\"zh-cn\":\"\\u5173\\u95ed\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u95dc\\u9589\\u9700\\u6c42\\u6578\",\"en\":\"Closed Story\"},\"taskopen\":{\"zh-cn\":\"\\u65b0\\u589e\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u65b0\\u589e\\u4efb\\u52d9\\u6578\",\"en\":\"Open Task\"},\"taskfinish\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u4efb\\u52d9\\u6578\",\"en\":\"Finished Task\"},\"bugopen\":{\"zh-cn\":\"\\u65b0\\u589eBug\\u6570\",\"zh-tw\":\"\\u65b0\\u589eBug\\u6578\",\"en\":\"Open Bug\"},\"bugresolve\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u89e3\\u51b3Bug\\u6578\",\"en\":\"Resolved bug\"},\"actions\":{\"zh-cn\":\"\\u52a8\\u6001\\u6570\",\"zh-tw\":\"\\u52d5\\u614b\\u6578\",\"en\":\"Dynamics\"}}', '{\"group1\":\"day\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"userlogin\",\"consumed\",\"storyopen\",\"storyclose\",\"taskopen\",\"taskfinish\",\"bugopen\",\"bugresolve\",\"actions\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"userlogin\",\"consumed\",\"storyopen\",\"storyclose\",\"taskopen\",\"taskfinish\",\"bugopen\",\"bugresolve\",\"actions\"]}',        2,      '{\"zh-cn\":\"\\u53ef\\u4ee5\\u6307\\u5b9a\\u4e00\\u4e2a\\u65f6\\u671f\\uff0c\\u5217\\u51fa\\u76f8\\u5e94\\u7684\\u6570\\u636e\\uff1a1. \\u6bcf\\u5929\\u7684\\u767b\\u5f55\\u6b21\\u6570\\u30022. \\u6bcf\\u5929\\u7684\\u65e5\\u5fd7\\u5de5\\u65f6\\u91cf\\u30023. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u9700\\u6c42\\u6570\\u30024. \\u6bcf\\u5929\\u5173\\u95ed\\u7684\\u9700\\u6c42\\u6570\\u30025. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u4efb\\u52a1\\u6570\\u30026. \\u6bcf\\u5929\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\u30027. \\u6bcf\\u5929\\u65b0\\u589e\\u7684Bug\\u6570\\u30028. \\u6bcf\\u5929\\u89e3\\u51b3\\u7684Bug\\u6570\\u30029. \\u6bcf\\u5929\\u7684\\u52a8\\u6001\\u6570\\u3002\",\"zh-tw\":\"\\u53ef\\u4ee5\\u6307\\u5b9a\\u4e00\\u500b\\u6642\\u671f\\uff0c\\u5217\\u51fa\\u76f8\\u61c9\\u7684\\u6578\\u64da\\uff1a1.\\u6bcf\\u5929\\u7684\\u767b\\u9304\\u6b21\\u6578\\u30022.\\u6bcf\\u5929\\u7684\\u65e5\\u8a8c\\u5de5\\u6642\\u91cf\\u30023.\\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u9700\\u6c42\\u6578\\u30024.\\u6bcf\\u5929\\u95dc\\u9589\\u7684\\u9700\\u6c42\\u6578\\u30025.\\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u4efb\\u52d9\\u6578\\u30026.\\u6bcf\\u5929\\u5b8c\\u6210\\u7684\\u4efb\\u52d9\\u6578\\u30027.\\u6bcf\\u5929\\u65b0\\u589e\\u7684Bug\\u6578\\u30028.\\u6bcf\\u5929\\u89e3\\u51b3\\u7684Bug\\u6578\\u30029.\\u6bcf\\u5929\\u7684\\u52d5\\u614b\\u6578\\u3002\",\"en\":\"The summary of company dynamics\"}', 'admin', '2015-07-27 15:09:42'),
('bug-resolve',          '{\"zh-cn\":\"Bug\\u89e3\\u51b3\\u8868\",\"zh-tw\":\"Bug\\u89e3\\u6c7a\\u8868\",\"en\":\"Solved Bugs\"}',',test','select *,if($product=\'\',0,product) as customproduct from TABLE_BUG where deleted=\'0\' and resolution!=\'\' and if($startDate=\'\',1,resolvedDate>=$startDate) and if($endDate=\'\',1,resolvedDate<=$endDate) having customproduct=$product','{\"varName\":[\"product\",\"startDate\",\"endDate\"],\"showName\":[\"\\u4ea7\\u54c1\",\"\\u89e3\\u51b3\\u65e5\\u671f\\u5f00\\u59cb\",\"\\u89e3\\u51b3\\u65e5\\u671f\\u7ed3\\u675f\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"product\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}','{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}','{\"group1\":\"resolvedBy\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"percent\":[\"1\"],\"contrast\":[\"crystalTotal\"],\"showAlone\":[\"1\"]}',2,'{\"zh-cn\":\"\\u5217\\u51fa\\u89e3\\u51b3\\u7684Bug\\u603b\\u6570\\uff0c\\u89e3\\u51b3\\u65b9\\u6848\\u7684\\u5206\\u5e03\\uff0c\\u5360\\u7684\\u6bd4\\u4f8b\\uff08\\u8be5\\u7528\\u6237\\u89e3\\u51b3\\u7684Bug\\u7684\\u6570\\u91cf\\u5360\\u6240\\u6709\\u7684\\u89e3\\u51b3\\u7684Bug\\u7684\\u6570\\u91cf)\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u89e3\\u51b3\\u7684Bug\\u7e3d\\u6578\\uff0c\\u89e3\\u6c7a\\u65b9\\u6848\\u7684\\u5206\\u4f48\\uff0c\\u5360\\u7684\\u6bd4\\u4f8b\\uff08\\u8a72\\u7528\\u6236\\u89e3\\u51b3\\u7684Bug\\u7684\\u6578\\u91cf\\u5360\\u6240\\u6709\\u7684\\u89e3\\u51b3\\u7684Bug\\u7684\\u6578\\u91cf\\uff09\\u3002\",\"en\":\"percentage:self resolved / all resolved\"}','admin','2015-07-24 13:44:25'),
('project-progress',     '{\"zh-cn\":\"\\u9879\\u76ee\\u8fdb\\u5c55\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u9032\\u5c55\\u8868\",\"en\":\"Project Progress\"}',',project','select t1.id,t1.name,t2.number as tasks,round(t2.consumed,2) as consumed,round(t2.`left`,2) as `left`,t3.stories,t2.undone as undoneTask,t3.undone as undoneStory,if($status=\'\',\'\',t1.status) as projectStatus,t2.totalReal from TABLE_PROJECT as t1 left join ztv_projectsummary as t2 on t1.id=t2.project left join ztv_projectstories as t3 on t1.id=t3.project where t1.deleted=\'0\' having projectStatus=$status','{\"varName\":[\"status\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\"],\"requestType\":[\"select\"],\"selectList\":[\"project.status\"],\"default\":[\"\"]}','{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"tasks\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u6570\",\"en\":\"Tasks\"},\"undoneStory\":{\"zh-cn\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"en\":\"Undone Story\"},\"undoneTask\":{\"zh-cn\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"en\":\"Undone Task\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost(h)\"},\"left\":{\"zh-cn\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"zh-tw\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"en\":\"Left(h)\"},\"consumedPercent\":{\"zh-cn\":\"\\u8fdb\\u5ea6\",\"zh-tw\":\"\\u8fdb\\u5ea6\",\"en\":\"Process\"}}','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stories\",\"undoneStory\",\"tasks\",\"undoneTask\",\"left\",\"consumed\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"undoneStory\",\"tasks\",\"undoneTask\",\"left\",\"consumed\"],\"percent\":{\"5\":\"1\"},\"contrast\":{\"5\":\"totalReal\"},\"showAlone\":{\"5\":\"1\"}}',2,'{\"zh-cn\":\"\\u9879\\u76ee\\u7684\\u9700\\u6c42\\u6570\\uff0c\\u4efb\\u52a1\\u6570\\uff0c\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\\uff0c\\u5269\\u4f59\\u5de5\\u65f6\\uff0c\\u5269\\u4f59\\u9700\\u6c42\\u6570\\uff0c\\u5269\\u4f59\\u4efb\\u52a1\\u6570\\uff0c\\u8fdb\\u5ea6\\u3002\",\"zh-tw\":\"\\u9805\\u76ee\\u7684\\u9700\\u6c42\\u6578\\uff0c\\u4efb\\u52d9\\u6578\\uff0c\\u5df2\\u6d88\\u8017\\u5de5\\u6642\\uff0c\\u5269\\u9918\\u5de5\\u6642\\uff0c\\u5269\\u9918\\u9700\\u6c42\\u6578\\uff0c\\u5269\\u9918\\u4efb\\u52d9\\u6578\\uff0c\\u9032\\u5ea6\\u3002\",\"en\":\"Progress of project.\"}','admin','2015-07-23 14:03:06'),
('projectbug-type',      '{\"zh-cn\":\"\\u9879\\u76eeBug\\u7c7b\\u578b\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u985e\\u578b\\u7d71\\u8a08\\u8868\",\"en\":\"Bug Type of Project\"}',',project,test','select t1.id,t1.name,t2.id as bugID,t2.type from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\'','','{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}','{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',2,'{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u985e\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002 \",\"en\":\"Type distribution of project bugs.\"}','admin','2015-08-04 13:54:22');
-- DROP TABLE IF EXISTS `zt_searchindex`;
CREATE TABLE IF NOT EXISTS `zt_searchindex` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` char(20) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `content` (`content`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_searchdict`;
CREATE TABLE IF NOT EXISTS `zt_searchdict` (
  `key` smallint(5) unsigned NOT NULL,
  `value` char(3) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'search', 'index'),
(2, 'search', 'index'),
(3, 'search', 'index'),
(4, 'search', 'index'),
(5, 'search', 'index'),
(6, 'search', 'index'),
(7, 'search', 'index'),
(8, 'search', 'index'),
(9, 'search', 'index'),
(10, 'search', 'index'),
(1, 'search', 'buildIndex');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'report', 'export'),
(4, 'report', 'export'),
(5, 'report', 'export'),
(6, 'report', 'export'),
(7, 'report', 'export'),
(8, 'report', 'export'),
(9, 'report', 'export');
-- DROP TABLE IF EXISTS `zt_im_chat`;
CREATE TABLE IF NOT EXISTS `zt_im_chat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'group',
  `admins` varchar(255) NOT NULL DEFAULT '',
  `committers` varchar(255) NOT NULL DEFAULT '',
  `subject` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastActiveTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `dismissDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `public` (`public`),
  KEY `createdBy` (`createdBy`),
  KEY `editedBy` (`editedBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_chatuser`;
CREATE TABLE IF NOT EXISTS `zt_im_chatuser` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `order` smallint(5) NOT NULL DEFAULT 0,
  `star` enum('0', '1') NOT NULL DEFAULT '0',
  `hide` enum('0', '1') NOT NULL DEFAULT '0',
  `mute` enum('0', '1') NOT NULL DEFAULT '0',
  `freeze` enum('0', '1') NOT NULL DEFAULT '0',
  `join` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `quit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `category` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `cgid` (`cgid`),
  KEY `user` (`user`),
  KEY `order` (`order`),
  KEY `star` (`star`),
  KEY `hide` (`hide`),
  UNIQUE KEY `chatuser` (`cgid`, `user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_client`;
CREATE TABLE IF NOT EXISTS `zt_im_client` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` char(30) NOT NULL DEFAULT '',
  `desc` varchar(100) NOT NULL DEFAULT '',
  `changeLog` text NOT NULL,
  `strategy` varchar(10) NOT NULL DEFAULT '',
  `downloads` text NOT NULL,
  `createdDate` datetime NOT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `status` enum('released','wait') NOT NULL DEFAULT 'wait',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message`;
CREATE TABLE IF NOT EXISTS `zt_im_message` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `order` bigint(8) unsigned NOT NULL,
  `type` enum('normal', 'broadcast', 'notify') NOT NULL DEFAULT 'normal',
  `content` text NOT NULL DEFAULT '',
  `contentType` enum('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') NOT NULL DEFAULT 'text',
  `data` text NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mgid` (`gid`),
  KEY `mcgid` (`cgid`),
  KEY `muser` (`user`),
  KEY `mtype` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_messagestatus`;
CREATE TABLE IF NOT EXISTS `zt_im_messagestatus` (
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `message` int(11) unsigned NOT NULL,
  `status` enum('waiting','sent','readed','deleted') NOT NULL DEFAULT 'waiting',
  UNIQUE KEY `user` (`user`,`message`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_queue`;
CREATE TABLE IF NOT EXISTS `zt_im_queue` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `type` char(30) NOT NULL,
  `content` text NOT NULL,
  `addDate` datetime NOT NULL,
  `processDate` datetime NOT NULL,
  `result` text NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conference`;
CREATE TABLE IF NOT EXISTS `zt_im_conference` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(24) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `status` enum('closed','open') NOT NULL DEFAULT 'closed',
  `participants` text NOT NULL,
  `openedBy` mediumint(8) NOT NULL DEFAULT 0,
  `openedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conferenceaction`;
CREATE TABLE IF NOT EXISTS `zt_im_conferenceaction` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(24) NOT NULL DEFAULT '',
  `type` enum('create','join','leave','close') NOT NULL DEFAULT 'create',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

ALTER TABLE `zt_file` CHANGE `pathname` `pathname` char(100) NOT NULL;
ALTER TABLE `zt_user` ADD `clientStatus` enum('online', 'away', 'busy', 'offline') NOT NULL DEFAULT 'offline';
ALTER TABLE `zt_user` ADD `clientLang` varchar(10) NOT NULL DEFAULT 'zh-cn';
-- DROP TABLE IF EXISTS `zt_feedback`;
CREATE TABLE IF NOT EXISTS `zt_feedback` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `module` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL,
  `subStatus` varchar(30) NOT NULL default '',
  `public` enum('0','1') NOT NULL DEFAULT '0',
  `notify` enum('0','1') NOT NULL DEFAULT '0',
  `likes` text NOT NULL,
  `result` mediumint(8) unsigned NOT NULL,
  `faq` mediumint(8) unsigned NOT NULL,
  `openedBy` char(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  `processedBy` char(30) NOT NULL,
  `processedDate` datetime NOT NULL,
  `closedBy` char(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` varchar(255) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `mailto` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_bug`   ADD `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0' AFTER `caseVersion`;
ALTER TABLE `zt_story` ADD `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0' AFTER `fromBug`;
ALTER TABLE `zt_user`  ADD `feedback` enum('0', '1') NOT NULL DEFAULT '0' AFTER `locked`;
ALTER TABLE `zt_group` ADD `developer` enum('0', '1') NOT NULL DEFAULT '1' AFTER `acl`;

INSERT INTO `zt_group` (`name`, `role`, `desc`, `acl`, `developer`) VALUES ('FEEDBACK', 'feedback', 'Feedback', '', '0');

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'feedback', 'admin'),
(4, 'feedback', 'admin'),
(5, 'feedback', 'admin'),
(8, 'feedback', 'admin'),
(1, 'feedback', 'adminview'),
(4, 'feedback', 'adminview'),
(5, 'feedback', 'adminview'),
(8, 'feedback', 'adminview'),
(1, 'feedback', 'close'),
(4, 'feedback', 'close'),
(5, 'feedback', 'close'),
(8, 'feedback', 'close'),
(1, 'faq', 'browse'),
(4, 'faq', 'browse'),
(5, 'faq', 'browse'),
(8, 'faq', 'browse'),
(1, 'host', 'browse'),
(1, 'host', 'create'),
(1, 'host', 'edit'),
(1, 'host', 'view'),
(1, 'host', 'delete'),
(1, 'host', 'treemap'),
(4, 'host', 'browse'),
(4, 'host', 'create'),
(4, 'host', 'edit'),
(4, 'host', 'view'),
(4, 'host', 'delete'),
(4, 'host', 'treemap'),
(6, 'host', 'browse'),
(6, 'host', 'create'),
(6, 'host', 'edit'),
(6, 'host', 'view'),
(6, 'host', 'delete'),
(6, 'host', 'treemap'),
(8, 'host', 'browse'),
(8, 'host', 'create'),
(8, 'host', 'edit'),
(8, 'host', 'view'),
(8, 'host', 'delete'),
(8, 'host', 'treemap'),
(1, 'tree', 'browsehost'),
(4, 'tree', 'browsehost'),
(6, 'tree', 'browsehost'),
(8, 'tree', 'browsehost'),
(13,'attend','edit'),
(13,'attend','personal'),
(13,'doc','alllibs'),
(13,'doc','browse'),
(13,'doc','create'),
(13,'doc','createLib'),
(13,'doc','delete'),
(13,'doc','diff'),
(13,'doc','edit'),
(13,'doc','editLib'),
(13,'doc','showFiles'),
(13,'doc','view'),
(13,'effort','batchCreate'),
(13,'effort','batchEdit'),
(13,'effort','calendar'),
(13,'effort','createForObject'),
(13,'effort','delete'),
(13,'effort','edit'),
(13,'effort','export'),
(13,'effort','view'),
(13,'feedback','browse'),
(13,'feedback','close'),
(13,'feedback','comment'),
(13,'feedback','create'),
(13,'feedback','delete'),
(13,'feedback','edit'),
(13,'feedback','index'),
(13,'feedback','view'),
(13,'faq','browse'),
(13,'faq','create'),
(13,'faq','edit'),
(13,'faq','delete'),
(13,'file','delete'),
(13,'file','download'),
(13,'file','edit'),
(13,'holiday','browse'),
(13,'index','index'),
(13,'leave','back'),
(13,'leave','create'),
(13,'leave','delete'),
(13,'leave','edit'),
(13,'leave','personal'),
(13,'leave','switchstatus'),
(13,'leave','view'),
(13,'lieu','create'),
(13,'lieu','delete'),
(13,'lieu','edit'),
(13,'lieu','personal'),
(13,'lieu','switchstatus'),
(13,'lieu','view'),
(13,'makeup','create'),
(13,'makeup','delete'),
(13,'makeup','edit'),
(13,'makeup','personal'),
(13,'makeup','switchstatus'),
(13,'makeup','view'),
(13,'my','changePassword'),
(13,'my','editProfile'),
(13,'my','effort'),
(13,'my','profile'),
(13,'my','todo'),
(13,'overtime','create'),
(13,'overtime','delete'),
(13,'overtime','edit'),
(13,'overtime','personal'),
(13,'overtime','switchstatus'),
(13,'overtime','view'),
(13,'search','buildForm'),
(13,'search','buildQuery'),
(13,'search','deleteQuery'),
(13,'search','saveQuery'),
(13,'search','select'),
(13,'todo','batchCreate'),
(13,'todo','batchEdit'),
(13,'todo','batchFinish'),
(13,'todo','calendar'),
(13,'todo','create'),
(13,'todo','delete'),
(13,'todo','edit'),
(13,'todo','export'),
(13,'todo','finish'),
(13,'todo','import2Today'),
(13,'todo','view'),
(13,'tree','browse'),
(13,'tree','delete'),
(13,'tree','manageChild'),
(13,'tree','updateOrder');

-- DROP TABLE IF EXISTS `zt_feedbackproduct`;
CREATE TABLE IF NOT EXISTS `zt_feedbackview` (
  `account` char(30) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `account_product` (`account`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_serverroom`;
CREATE TABLE IF NOT EXISTS `zt_serverroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `city` varchar(128) NOT NULL,
  `line` varchar(20) NOT NULL,
  `bandwidth` varchar(128) NOT NULL,
  `provider` varchar(128) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_asset`;
CREATE TABLE IF NOT EXISTS `zt_asset` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `status` varchar(30) NOT NULL,
  `type` varchar(30) NOT NULL,
  `group` varchar(128) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_host`;
CREATE TABLE IF NOT EXISTS `zt_host` (
  `id` mediumint(8) unsigned  NOT NULL AUTO_INCREMENT,
  `assetID`      mediumint(8) unsigned NOT NULL,
  `serverRoom`   mediumint(8) unsigned NOT NULL,
  `cabinet`      varchar(128) NOT NULL,
  `serverModel`  varchar(256) NOT NULL,
  `hardwareType` varchar(64)  NOT NULL,
  `hostType`     enum('physical','virtual') NOT NULL,
  `cpuBrand`     varchar(128) NOT NULL,
  `cpuModel`     varchar(128) NOT NULL,
  `cpuNumber`    varchar(16)  NOT NULL,
  `cpuCores`     varchar(30)  NOT NULL,
  `cpuRate`      varchar(30)  NOT NULL,
  `memory`       varchar(30)  NOT NULL,
  `diskType`     varchar(30)  NOT NULL,
  `diskSize`     varchar(30)  NOT NULL,
  `privateIP`    varchar(128) NOT NULL,
  `publicIP`     varchar(128) NOT NULL,
  `nic`          varchar(128) NOT NULL,
  `mac`          varchar(128) NOT NULL,
  `osName`       varchar(64)  NOT NULL,
  `osVersion`    varchar(64)  NOT NULL,
  `webserver`    varchar(128) NOT NULL,
  `database`     varchar(128) NOT NULL,
  `language`     varchar(16)  NOT NULL,
  `status`       enum('online','offline') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_service`;
CREATE TABLE IF NOT EXISTS `zt_service` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `version` varchar(64) NOT NULL,
  `color` char(7) NOT NULL,
  `desc` text,
  `dept` varchar(128) NOT NULL,
  `devel` varchar(30) NOT NULL,
  `qa` varchar(30) NOT NULL,
  `ops` varchar(30) NOT NULL,
  `hosts` text,
  `softName` varchar(128) NOT NULL,
  `softVersion` varchar(128) NOT NULL,
  `type` varchar(20) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0', 
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0', 
  `order` smallint(5) unsigned NOT NULL default '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES (1, 'tree', 'editHost');

-- DROP TABLE IF EXISTS `zt_attend`;
CREATE TABLE IF NOT EXISTS `zt_attend` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `signIn` time NOT NULL,
  `signOut` time NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL,
  `device` varchar(30) NOT NULL,
  `client` varchar(20) NOT NULL,
  `manualIn` time NOT NULL,
  `manualOut` time NOT NULL,
  `reason` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `reviewStatus` varchar(30) NOT NULL DEFAULT '',
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `reason` (`reason`),
  KEY `reviewStatus` (`reviewStatus`),
  KEY `reviewedBy` (`reviewedBy`),
  UNIQUE KEY `attend` (`date`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_attendstat`;
CREATE TABLE IF NOT EXISTS `zt_attendstat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `month` char(10) NOT NULL DEFAULT '',
  `normal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `late` decimal(12,2) NOT NULL DEFAULT 0.00,
  `early` decimal(12,2) NOT NULL DEFAULT 0.00,
  `absent` decimal(12,2) NOT NULL DEFAULT 0.00,
  `trip` decimal(12,2) NOT NULL DEFAULT 0.00,
  `egress` decimal(12,2) NOT NULL DEFAULT 0.00,
  `lieu` decimal(12,2) NOT NULL DEFAULT 0.00,
  `paidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `unpaidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `timeOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `restOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `holidayOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deserve` decimal(12,2) NOT NULL DEFAULT 0.00,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `month` (`month`),
  KEY `status` (`status`),
  UNIQUE KEY `attend` (`month`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_overtime`;
CREATE TABLE IF NOT EXISTS `zt_overtime` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `leave` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `rejectReason` varchar(100) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_holiday`;
CREATE TABLE IF NOT EXISTS `zt_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday', 'working') NOT NULL DEFAULT 'holiday',
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_leave`;
CREATE TABLE IF NOT EXISTS `zt_leave` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `backDate` datetime NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lieu`;
CREATE TABLE IF NOT EXISTS `zt_lieu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `overtime` char(255) NOT NULL,
  `trip` char(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_trip`;
CREATE TABLE IF NOT EXISTS `zt_trip` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('trip', 'egress') NOT NULL DEFAULT 'trip',
  `customers` varchar(20) NOT NULL,
  `name` char(30) NOT NULL,
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `from` char(50) NOT NULL,
  `to` char(50) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_deploy`;
CREATE TABLE IF NOT EXISTS `zt_deploy` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(20) NOT NULL,
  `owner` char(30) NOT NULL,
  `members` text NOT NULL,
  `notify` text NOT NULL,
  `cases` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `result` varchar(20) NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deployproduct`;
CREATE TABLE IF NOT EXISTS `zt_deployproduct` (
  `deploy` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `release` mediumint(8) unsigned NOT NULL,
  `package` varchar(255) NOT NULL,
  UNIQUE KEY `deploy_product_release` (`deploy`,`product`,`release`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deploystep`;
CREATE TABLE IF NOT EXISTS `zt_deploystep` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `deploy` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `stage` varchar(30) NOT NULL,
  `content` text NOT NULL,
  `status` varchar(30) NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `finishedBy` char(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE `zt_testresult` ADD `deploy` mediumint(8) unsigned NOT NULL;
-- DROP TABLE IF EXISTS `zt_deployscope`;
CREATE TABLE IF NOT EXISTS `zt_deployscope` (
  `deploy` mediumint(8) unsigned NOT NULL,
  `service` mediumint(8) unsigned NOT NULL,
  `hosts` text NOT NULL,
  `remove` text NOT NULL,
  `add` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_doc`
ADD `parent` smallint(5) unsigned NOT NULL DEFAULT '0' AFTER `type`,
ADD `path` char(255) COLLATE 'utf8_general_ci' NOT NULL DEFAULT '' AFTER `parent`,
ADD `grade` tinyint(3) unsigned NOT NULL DEFAULT '0' AFTER `path`,
ADD `order` smallint(5) unsigned NOT NULL DEFAULT '0' AFTER `grade`;

ALTER TABLE `zt_product` ADD `feedback` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `RD`;

ALTER TABLE `zt_leave`       ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_leave`       ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_leave`       ADD `reviewers` text NOT NULL;  
ALTER TABLE `zt_leave`       ADD `backReviewers` text NOT NULL;
ALTER TABLE `zt_lieu`        ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_lieu`        ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_lieu`        ADD `reviewers` text NOT NULL;  
ALTER TABLE `zt_overtime`    ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_overtime`    ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_overtime`    ADD `reviewers` text NOT NULL;  

-- DROP TABLE IF EXISTS `zt_faq`;
CREATE TABLE IF NOT EXISTS `zt_faq` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
`module` mediumint(9) NOT NULL,
`product` mediumint(9) NOT NULL,
`question` varchar(255) NOT NULL,
`answer` text NOT NULL,
`addedtime` datetime NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

ALTER TABLE `zt_task` ADD `feedback` mediumint(8) unsigned NOT NULL AFTER `fromBug`;
ALTER TABLE `zt_todo` ADD `feedback` mediumint(8) unsigned NOT NULL AFTER `end`;
-- DROP TABLE IF EXISTS `zt_workflow`;
CREATE TABLE IF NOT EXISTS `zt_workflow` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` varchar(30) NOT NULL, 
  `child` varchar(30) NOT NULL, 
  `type` varchar(10) NOT NULL DEFAULT 'flow',
  `app` varchar(20) NOT NULL,
  `position` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `table` varchar(50) NOT NULL,
  `name` varchar(30) NOT NULL,
  `flowchart` text NOT NULL,
  `js` text NOT NULL,
  `css` text NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `administrator` text NOT NULL,
  `desc` text NOT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1.0',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `type` (`type`),
  KEY `app` (`app`),
  KEY `module` (`module`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`app`, `module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowaction`;
CREATE TABLE IF NOT EXISTS `zt_workflowaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` enum('single', 'batch') NOT NULL DEFAULT 'single',
  `batchMode` enum('same', 'different') NOT NULL DEFAULT 'different',
  `extensionType` varchar(10) NOT NULL DEFAULT 'override' COMMENT 'none | extend | override',
  `open` varchar(20) NOT NULL,
  `position` enum('menu', 'browseandview', 'browse', 'view') NOT NULL DEFAULT 'browseandview',
  `layout` char(20) NOT NULL,
  `show` enum('dropdownlist', 'direct') NOT NULL DEFAULT 'dropdownlist',
  `order` smallint(5) unsigned NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `conditions` text NOT NULL,
  `verifications` text NOT NULL,
  `hooks` text NOT NULL,
  `linkages` text NOT NULL,
  `js` text NOT NULL,
  `css` text NOT NULL,
  `toList` char(255) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowdatasource`;
CREATE TABLE IF NOT EXISTS `zt_workflowdatasource` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system', 'sql', 'func', 'option', 'lang') NOT NULL DEFAULT 'option',
  `name` varchar(30) NOT NULL,
  `datasource` text NOT NULL, 
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowfield`;
CREATE TABLE IF NOT EXISTS `zt_workflowfield` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'varchar',
  `length` varchar(10) NOT NULL,
  `name` varchar(50) NOT NULL,
  `control` varchar(20) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(100) NOT NULL,
  `rules` varchar(255) NOT NULL,
  `placeholder` varchar(100) NOT NULL,
  `canExport` enum('0', '1') NOT NULL DEFAULT '0',
  `canSearch` enum('0', '1') NOT NULL DEFAULT '0',
  `isKey` enum('0', '1') NOT NULL DEFAULT '0',
  `isValue` enum('0', '1') NOT NULL DEFAULT '0',
  `order` smallint(5) unsigned NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `desc` text NOT NULL,
  `readonly` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlayout`;
CREATE TABLE IF NOT EXISTS `zt_workflowlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `width` smallint(5) NOT NULL,
  `position` text NOT NULL,
  `readonly` enum('0', '1') NOT NULL DEFAULT '0',
  `mobileShow` enum('0', '1') NOT NULL DEFAULT '1',
  `totalShow` enum('0', '1') NOT NULL DEFAULT '0',
  `defaultValue` text NOT NULL,
  `layoutRules` varchar(255) NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlabel`;
CREATE TABLE IF NOT EXISTS `zt_workflowlabel` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `code` varchar(30) NOT NULL,
  `label` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `order` tinyint(3) NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlinkdata`;
CREATE TABLE IF NOT EXISTS `zt_workflowlinkdata` (
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `linkedType` varchar(30) NOT NULL,
  `linkedID` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  UNIQUE KEY `unique` (`objectType`, `objectID`, `linkedType`, `linkedID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrelation`;
CREATE TABLE IF NOT EXISTS `zt_workflowrelation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL, 
  `next` varchar(30) NOT NULL,
  `field` varchar(50) NOT NULL,
  `actions` varchar(20) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrelationlayout`;
CREATE TABLE IF NOT EXISTS `zt_workflowrelationlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL,
  `next` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `field` varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `prev` (`prev`),
  KEY `next` (`next`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`prev`, `next`, `action`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrule`;
CREATE TABLE IF NOT EXISTS `zt_workflowrule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system', 'regex', 'func') NOT NULL DEFAULT 'regex',
  `name` varchar(30) NOT NULL,
  `rule` text NOT NULL, 
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowsql`;
CREATE TABLE IF NOT EXISTS `zt_workflowsql` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `sql` text NOT NULL,
  `vars` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowversion`;
CREATE TABLE IF NOT EXISTS `zt_workflowversion` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `version` varchar(10) NOT NULL,
  `fields` text NOT NULL,
  `actions` text NOT NULL,
  `layouts` text NOT NULL,
  `sqls` text NOT NULL,
  `labels` text NOT NULL,
  `table` text NOT NULL,
  `datas` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `moduleversion` (`module`, `version`),
  KEY `module` (`module`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_action` CHANGE `action` `action` varchar(80) NOT NULL DEFAULT '';
ALTER TABLE `zt_action` CHANGE `extra` `extra` text;
ALTER TABLE `zt_file`   CHANGE `objectType` `objectType` char(30) NOT NULL;

INSERT INTO `zt_workflowrule` VALUES (1,'system','必填','notempty','admin','2020-07-09 21:05:50','','0000-00-00 00:00:00'),(2,'system','唯一','unique','admin','2020-07-09 21:05:50','','0000-00-00 00:00:00'),(3,'system','日期','date','admin','2020-07-09 21:05:50','','0000-00-00 00:00:00'),(4,'system','email','email','admin','2020-07-09 21:05:50','','0000-00-00 00:00:00'),(5,'system','数字','float','admin','2020-07-09 21:05:50','','0000-00-00 00:00:00'),(6,'system','电话','phone','admin','2020-07-09 21:05:50','','0000-00-00 00:00:00'),(7,'system','IP','ip','admin','2020-07-09 21:05:50','','0000-00-00 00:00:00');

REPLACE INTO `zt_grouppriv` VALUES
(1,'apppriv','flow'),
(1,'workflow','activate'),
(1,'workflow','backup'),
(1,'workflow','browseDB'),
(1,'workflow','browseFlow'),
(1,'workflow','copy'),
(1,'workflow','create'),
(1,'workflow','css'),
(1,'workflow','deactivate'),
(1,'workflow','delete'),
(1,'workflow','edit'),
(1,'workflow','flowchart'),
(1,'workflow','js'),
(1,'workflow','release'),
(1,'workflow','ui'),
(1,'workflow','upgrade'),
(1,'workflow','view'),
(1,'workflowaction','browse'),
(1,'workflowaction','create'),
(1,'workflowaction','css'),
(1,'workflowaction','delete'),
(1,'workflowaction','edit'),
(1,'workflowaction','js'),
(1,'workflowaction','setNotice'),
(1,'workflowaction','setVerification'),
(1,'workflowaction','view'),
(1,'workflowcondition','browse'),
(1,'workflowcondition','create'),
(1,'workflowcondition','delete'),
(1,'workflowcondition','edit'),
(1,'workflowdatasource','browse'),
(1,'workflowdatasource','create'),
(1,'workflowdatasource','delete'),
(1,'workflowdatasource','edit'),
(1,'workflowfield','browse'),
(1,'workflowfield','create'),
(1,'workflowfield','delete'),
(1,'workflowfield','edit'),
(1,'workflowfield','setExport'),
(1,'workflowfield','setSearch'),
(1,'workflowfield','sort'),
(1,'workflowhook','browse'),
(1,'workflowhook','create'),
(1,'workflowhook','delete'),
(1,'workflowhook','edit'),
(1,'workflowlabel','browse'),
(1,'workflowlabel','create'),
(1,'workflowlabel','delete'),
(1,'workflowlabel','edit'),
(1,'workflowlabel','sort'),
(1,'workflowlayout','admin'),
(1,'workflowlinkage','browse'),
(1,'workflowlinkage','create'),
(1,'workflowlinkage','delete'),
(1,'workflowlinkage','edit'),
(1,'workflowrelation','admin'),
(1,'workflowrule','browse'),
(1,'workflowrule','create'),
(1,'workflowrule','delete'),
(1,'workflowrule','edit'),
(1,'workflowrule','view');

ALTER TABLE `zt_workflow` ADD `navigator` varchar(10) NOT NULL AFTER `type`;

INSERT INTO `zt_workflowdatasource` (`type`, `name`, `datasource`) VALUES 
('system','产品','{\"app\":\"system\",\"module\":\"product\",\"method\":\"getPairs\",\"methodDesc\":\"Get product pairs.\",\"params\":[{\"name\":\"mode\",\"type\":\"string\",\"desc\":\"\",\"value\":\"noclosed\"}]}'),
('system','项目','{\"app\":\"system\",\"module\":\"project\",\"method\":\"getPairs\",\"methodDesc\":\"Get project pairs.\",\"params\":[{\"name\":\"mode\",\"type\":\"string\",\"desc\":\"all|noclosed or empty\",\"value\":\"noclosed\"}]}'),
('system','产品线','{\"app\":\"system\",\"module\":\"tree\",\"method\":\"getLinePairs\",\"methodDesc\":\"Get line pairs.\",\"params\":[{\"name\":\"useShort\",\"type\":\"bool\",\"desc\":\"\",\"value\":\"\"}]}'),
('sql','需求','select id,title from zt_story where deleted=\"0\"'),
('sql','任务','select id,name from zt_task where deleted=\"0\"'),
('sql','Bug','select id,title from zt_bug where deleted=\"0\"'),
('system','权限分组','{\"app\":\"system\",\"module\":\"group\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[]}'),
('system','用户','{\"app\":\"system\",\"module\":\"user\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[{\"name\":\"params\",\"type\":\"\",\"desc\":\"\",\"value\":\"noclosed|noletter\"},{\"name\":\"usersToAppended\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}'),
('system','产品分支','{\"app\":\"system\",\"module\":\"branch\",\"method\":\"getAllPairs\",\"methodDesc\":\"Get pairs.\",\"params\":[{\"name\":\"params\",\"type\":\"string\",\"desc\":\"\",\"value\":\"\"}]}'),
('sql','版本','select id,name from zt_build where deleted=\"0\"'),
('sql','模块','select id,name from zt_module where deleted=\"0\"'),
('sql','计划','select id,title from zt_productplan where deleted=\"0\"'),
('lang','产品类型','productType'),
('lang','产品状态','productStatus'),
('lang','产品访问控制','productAcl'),
('lang','项目类型','projectType'),
('lang','项目状态','projectStatus'),
('lang','项目访问控制','projectAcl'),
('lang','发布状态','releaseStatus'),
('lang','需求来源','storySource'),
('lang','需求优先级','storyPri'),
('lang','需求状态','storyStatus'),
('lang','需求阶段','storyStage'),
('lang','Bug严重程度','bugSeverity'),
('lang','Bug优先级','bugPri'),
('lang','Bug类型','bugType'),
('lang','Bug操作系统','bugOs'),
('lang','Bug浏览器','bugBrowser'),
('lang','Bug状态','bugStatus'),
('lang','任务类型','taskType'),
('lang','任务优先级','taskPri'),
('lang','任务状态','taskStatus'),
('lang','测试用例优先级','testcasePri'),
('lang','测试用例类型','testcaseType'),
('lang','测试用例阶段','testcaseStage'),
('lang','测试用例状态','testcaseStatus'),
('lang','测试单优先级','testtaskPri'),
('lang','测试单状态','testtaskStatus'),
('lang','反馈状态','feedbackStatus'),
('lang','Bug解决方案','bugResolution'),
('sql','用例','select id,title from zt_case where deleted=\"0\"'),
('system', '反馈分支',  '{\"app\":\"system\",\"module\":\"tree\",\"method\":\"getOptionMenu\",\"methodDesc\":\"Create an option menu in html.\",\"params\":[{\"name\":\"rootID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"type\",\"type\":\"string\",\"desc\":\"\",\"value\":\"feedback\"},{\"name\":\"startModule\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"branch\",\"type\":\"\",\"desc\":\"\",\"value\":\"0\"}]}'),
('lang','需求类型','storyType');
