package client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 * @author zenjiro
 * 2007/03/18 1.1.0
 * - GPX形式にも変換するようにしました。ただし、日付を出力しないので不正な形式かもしれません。
 * - パネルの幅を固定にしました。
 * - 出力文字列から最後の改行記号を取り除きました。
 * - 入力テキストエリアでクリックリスナ、変更リスナを使うのをやめました。
 * 2007/03/17 1.0.0
 * - 初版です。GPS-CS1KのログをKML形式に変換します。
 */
public class GPS implements EntryPoint {

	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {
		final VerticalPanel panel = new VerticalPanel();
		panel.setWidth("40em");
		panel.add(new HTML("<h1>GPS-CS1K→ALPSLAB route</h1>"));
		panel.add(new Label("変換前（NMEA-0183形式）"));
		final TextArea inputText = new TextArea();
		inputText.setSize("40em", "10em");
		panel.add(inputText);
		panel.add(new Label("変換後（GPX形式）"));
		final TextArea gpxText = new TextArea();
		gpxText.setSize("40em", "10em");
		gpxText.setText(toGPX(inputText.getText()));
		panel.add(gpxText);
		panel.add(new Label("変換後（KML形式）"));
		final TextArea kmlText = new TextArea();
		kmlText.setSize("40em", "10em");
		kmlText.setText(toKML(inputText.getText()));
		panel.add(kmlText);
		final StringBuffer message = new StringBuffer();
		message.append("<ul>");
		message
				.append("<li><a href=\"http://www.sony.jp/products/Consumer/Peripheral/GPS/GPS-CS1K/\">GPS-CS1K</a>のログ（NMEA-0813形式）を<a href=\"http://route.alpslab.jp/\">ALPSLAB route</a>に貼り付けられるGPX形式、KML形式に変換します。</li>");
		message.append("<ul>");
		message.append("<li>GGAセンテンスの時刻、緯度、経度、高度のみを利用します。</li>");
		message.append("<li>GPS-CS1Kのログには日付の情報がないため、GPX形式の時刻に日付を出力しません。このために何か問題が起きるかもしれません。</li>");
		message.append("</ul>");
		message.append("<li>サーバとの通信は行いません。クライアント上のJavaScriptのみで動作します。</li>");
		message.append("<li><span style=\"color: red;\">大きなデータを貼り付けると長時間ブラウザが固まることがあります。</span>私の環境（Fedora Core 6、Firefox 2、Celeron 2GHz、メモリ1GB）では1時間分のデータが我慢の限界でした。少しずつデータを増やして試してからお使いください。</li>");
		message.append("<li>ライセンスはGPSとします。</li>");
		message.append("<ul>");
		message
				.append("<li><a href=\"http://prdownloads.sourceforge.jp/zenjiro/24524/GPS-1.1.0.zip\">GPS-1.1.0.zip</a>（展開すればローカルで動きます。）</li>");
		message
				.append("<li><a href=\"http://zenjiro.sourceforge.jp/gps/GPS.java\">GPS.java</a>（コンパイルには<a href=\"http://code.google.com/webtoolkit/\">GWT</a>が必要です。）</li>");
		message.append("</ul>");
		message.append("<li>コメントは<a href=\"http://zenjiro.sourceforge.jp/?p=1003\">こちら</a>にお願いします。</li>");
		message.append("</ul>");
		panel.add(new HTML(message.toString()));
		RootPanel.get("slot1").add(panel);
		inputText.setFocus(true);

		inputText.addKeyboardListener(new KeyboardListener() {
			public void onKeyPress(final Widget sender, final char keyCode, final int modifiers) {
			}

			public void onKeyDown(final Widget sender, final char keyCode, final int modifiers) {
			}

			public void onKeyUp(final Widget sender, final char keyCode, final int modifiers) {
				gpxText.setText(toGPX(inputText.getText()));
				kmlText.setText(toKML(inputText.getText()));
			}
		});
	}

	/**
	 * GPS-CS1KのログをKML形式に変換します。
	 * @param string 入力（NMEA-0183形式）
	 * @return 出力（KML形式）
	 */
	public String toKML(final String string) {
		final StringBuffer ret = new StringBuffer();
		ret.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		ret.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
		ret.append("<Placemark>\n");
		ret.append("<Style>\n");
		ret.append("<LineStyle>\n");
		ret.append("<color>99ff0000</color>\n");
		ret.append("<width>6</width>\n");
		ret.append("</LineStyle>\n");
		ret.append("</Style>\n");
		ret.append("<LineString>\n");
		ret.append("<coordinates>\n");
		final String[] lines = string.split("[\r\n]+");
		for (int i = 0; i < lines.length; i++) {
			final String line = lines[i];
			final String[] items = line.split(",");
			if (items[0].equals("$GPGGA")) {
				final double latitude = Double.parseDouble(items[2]);
				final double longitude = Double.parseDouble(items[4]);
				final double height = Double.parseDouble(items[8]);
				ret.append(((int) longitude / 100 + (longitude % 100) / 60) + ","
						+ ((int) latitude / 100 + (latitude % 100) / 60) + "," + height + "\n");
			}
		}
		ret.append("</coordinates>\n");
		ret.append("</LineString>\n");
		ret.append("</Placemark>\n");
		ret.append("</kml>");
		return ret.toString();
	}

	/**
	 * GPS-CS1KのログをGPX形式に変換します。
	 * @param string 入力（NMEA-0183形式）
	 * @return 出力（GPX形式）
	 */
	public String toGPX(final String string) {
		final StringBuffer ret = new StringBuffer();
		ret.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		ret.append("<gpx version=\"1.1\" xmlns=\"http://www.topografix.com/GPX/1/1\">\n");
		ret.append("<trk>\n");
		ret.append("<trkseg>\n");
		final String[] lines = string.split("[\r\n]+");
		for (int i = 0; i < lines.length; i++) {
			final String line = lines[i];
			final String[] items = line.split(",");
			if (items[0].equals("$GPGGA")) {
				final double rawTime = Double.parseDouble(items[1]);
				final double rawLatitude = Double.parseDouble(items[2]);
				final double rawLongitude = Double.parseDouble(items[4]);
				final double rawHeight = Double.parseDouble(items[8]);
				final int hour = (int) rawTime / 10000;
				final int minute = (int) (rawTime % 10000) / 100;
				final double second = rawTime % 100;
				final double longitude = (int) rawLongitude / 100 + (rawLongitude % 100) / 60;
				final double latitude = (int) rawLatitude / 100 + (rawLatitude % 100) / 60;
				ret.append("<trkpt lat=\"" + latitude + "\" lon=\"" + longitude + "\">\n");
				ret.append("<ele>" + rawHeight + "</ele>\n");
				ret.append("<time>" + hour + ":" + minute + ":" + second + "Z</time>\n");
				ret.append("</trkpt>\n");
			}
		}
		ret.append("</trkseg>\n");
		ret.append("</trk>\n");
		ret.append("</gpx>");
		return ret.toString();
	}
}
