import java.awt.Image;
import java.awt.Toolkit;

/**
 * 定数を集めたクラスです。
 * @author Kumano Tatsuo
 * 2006/03/17
 */
public class Const {
	/**
	 * ドット絵の幅[px]
	 */
	public static final int GRID_WIDTH = 32;

	/**
	 * ドット絵のxオフセット[px]
	 */
	public static final int PIVOT_X = 13;

	/**
	 * ドット絵のyオフセット[px]
	 */
	public static final int PIVOT_Y = 9;

	/**
	 * 最も長い辺
	 */
	public static final int LONG_EDGE = 18;
	
	/**
	 * 中間の長さの辺
	 */
	public static final int MIDLE_EDGE = 13;
	
	/**
	 * 最も短い辺
	 */
	public static final int SHORT_EDGE = 9;
	
	/**
	 * a.png
	 */
	public static final Image A = Toolkit.getDefaultToolkit().createImage(
		Const.class.getResource("a.png"));

	/**
	 * b.png
	 */
	public static final Image B = Toolkit.getDefaultToolkit().createImage(
		Const.class.getResource("b.png"));

	/**
	 * right.png
	 */
	public static final Image RIGHT = Toolkit.getDefaultToolkit().createImage(
		Const.class.getResource("right.png"));

	/**
	 * left.png
	 */
	public static final Image LEFT = Toolkit.getDefaultToolkit().createImage(
		Const.class.getResource("left.png"));

	/**
	 * down.png
	 */
	public static final Image DOWN = Toolkit.getDefaultToolkit().createImage(
		Const.class.getResource("down.png"));
	
	/**
	 * up.png
	 */
	public static final Image UP= Toolkit.getDefaultToolkit().createImage(
		Const.class.getResource("up.png"));
}
