package shop;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

/**
 * @author Kumano Tatsuo
 * 2005/11/29
 */
public interface Emap {
	/**
	 * 市区町村別のページを解析して住所の一覧を取得します。
	 * @param url URL
	 * @return 住所の一覧
	 * @throws UnsupportedEncodingException 
	 * @throws IOException 
	 */
	public Map<String, String> getAddresses(final URL url) throws UnsupportedEncodingException,
			IOException;

	/**
	 * 都道府県別ページを解析して市区町村のURL一覧を取得します。
	 * @param url 都道府県別ページのURL
	 * @return 市区町村の一覧
	 * @throws MalformedURLException 
	 * @throws IOException 
	 */
	public Map<String, URL> getCities(final URL url) throws MalformedURLException, IOException;

	/**
	 * トップページを解析して都道府県のURL一覧を取得します。
	 * @return 都道府県の一覧
	 * @throws MalformedURLException 
	 * @throws IOException 
	 */
	public Map<String, URL> getPrefectures() throws MalformedURLException, IOException;
}
