import java.awt.Color;
import java.awt.Font;


/*
 * 作成日：2004年1月7日
 */

/**
 * デフォルトの地図の設定を扱うクラスです。
 * @author Kumano Tatsuo
 */
class DefaultMapPreferences implements MapPreferences {
    private Preferences highwayPreferences = new Preferences(new Color(160,
                220, 160), new Color(160, 220, 160).darker(), 17, null, null);
    private Preferences kokudoPreferences = new Preferences(new Color(250, 180,
                180), new Color(250, 180, 180).darker(), 13, null, null);
    private Preferences kendoPreferences = new Preferences(new Color(255, 255,
                180), new Color(255, 255, 180).darker(), 7, null, null);
    private Preferences chihodoPreferences = new Preferences(new Color(255,
                255, 180), new Color(255, 255, 180).darker(), 13, null, null);
    private Preferences majorRoadPreferences = new Preferences(Color.WHITE,
            Color.GRAY, 13, null, null);
    private Preferences normalRoadPreferences = new Preferences(Color.WHITE,
            Color.GRAY, 7, Color.BLUE, new Font("MS UI GOthic", Font.PLAIN, 15));
    private Preferences jrPreferences = new Preferences(Color.WHITE,
            Color.GRAY, 6, null, null);
    private Preferences jrShinkansenPreferences = new Preferences(Color.WHITE,
            Color.GRAY, 6, null, null);
    private Preferences railwayPreferences = new Preferences(Color.WHITE,
            Color.GRAY, 4, Color.BLUE, new Font("MS UI GOthic", Font.PLAIN, 16));
    private Preferences mizuPreferences = new Preferences(new Color(200, 210,
                250), new Color(200, 210, 250).darker(), 1, Color.BLACK,
            new Font("ＭＳ Ｐ明朝", Font.PLAIN, 14));
    private Preferences zyoutiPreferences = new Preferences(new Color(220, 220,
                220), new Color(220, 220, 220).darker(), 1, Color.BLACK,
            new Font("MS UI Gothic", Font.PLAIN, 15));
    private Preferences parkPreferences = new Preferences(new Color(200, 250,
                160), new Color(200, 250, 160).darker(), 1, Color.BLACK,
            new Font("MS UI Gothic", Font.PLAIN, 15));
    private Preferences tatemonoPreferences = new Preferences(new Color(180,
                180, 180), new Color(180, 180, 180).darker(), 1, Color.BLACK,
            new Font("MS UI Gothic", Font.PLAIN, 12));
    private Preferences ekiPreferences = new Preferences(Color.RED,
            Color.BLACK, 8, Color.BLACK,
            new Font("MS UI Gothic", Font.PLAIN, 20));
    private Preferences tyomePreferences = new Preferences(null, Color.BLACK,
            1, new Color(0, 0, 160), null);
    private Preferences si_tyoPreferences = new Preferences(null, Color.BLACK,
            4, new Color(0, 0, 160), new Font("MS UI Gothic", Font.PLAIN, 40));

    /**
     * 丁目を塗り分ける色を取得します。
     * @param index 何色目か
     * @return 色
     */
    public Color getTyomeFillColor(int index) {
        if (index == 0) {
            return Color.WHITE; // 白
        } else if (index == 1) {
            return new Color(250, 250, 230); // 黄色
        } else if (index == 2) {
            return new Color(230, 250, 250); // 水色
        } else if (index == 3) {
            return new Color(240, 250, 230); // 緑色
        } else if (index == 4) {
            return new Color(230, 230, 250); // 青色
        } else if (index == 5) {
            return new Color(250, 230, 255); // 赤紫色
        } else if (index == 6) {
            return new Color(250, 230, 230); // サーモンピンク色
        } else if (index == 7) {
            return new Color(255, (255 + 230) / 2, 230); // 橙色
        } else {
            return new Color(220, 240, 220); // 暗い緑色
        }
    }

    /* (非 Javadoc)
     * @see MapColor#getBackGroundColor()
     */
    public Color getBackGroundColor() {
        return Color.WHITE;
    }

    /* (非 Javadoc)
     * @see MapColor#getBoundsColor()
     */
    public Color getMapBoundsColor() {
        return Color.BLACK;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getChihodoPreferences()
     */
    public Preferences getChihodoPreferences() {
        return chihodoPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getCityBorderPreferences()
     */
    public Preferences getSi_tyoPreferences() {
        return si_tyoPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getHighwayPreferences()
     */
    public Preferences getHighwayPreferences() {
        return highwayPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getJRPreferences()
     */
    public Preferences getJRPreferences() {
        return jrPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getJRShinkansenPreferences()
     */
    public Preferences getJRShinkansenPreferences() {
        return jrShinkansenPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getKendoPreferences()
     */
    public Preferences getKendoPreferences() {
        return kendoPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getKokudoPreferences()
     */
    public Preferences getKokudoPreferences() {
        return kokudoPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getMajorRoadPreferences()
     */
    public Preferences getMajorRoadPreferences() {
        return majorRoadPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getNormalRoadPreferences()
     */
    public Preferences getNormalRoadPreferences() {
        return normalRoadPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getParkPreferences()
     */
    public Preferences getParkPreferences() {
        return parkPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getRailwayPreferences()
     */
    public Preferences getRailwayPreferences() {
        return railwayPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getTatemonoPreferences()
     */
    public Preferences getTatemonoPreferences() {
        return tatemonoPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getTyomeBorderPreferences()
     */
    public Preferences getTyomePreferences() {
        return tyomePreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getWaterPreferences()
     */
    public Preferences getMizuPreferences() {
        return mizuPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getZyoutiPreferences()
     */
    public Preferences getZyoutiPreferences() {
        return zyoutiPreferences;
    }

    /* (非 Javadoc)
     * @see MapPreferences#getEkiPreferences()
     */
    public Preferences getEkiPreferences() {
        return ekiPreferences;
    }
}
