import java.awt.geom.*;
import java.io.*;
import java.util.*;
import java.util.Map.*;
import java.util.regex.*;

/*
 * : 2003/12/11
 */

/**
 * Ͽޥǡ򰷤饹Ǥ
 * @author Kumano Tatsuo
 */
class MapData implements Comparable {

	/**
	 * ƥѤΥ᥽åɤǤ
	 * @param args ޥɥ饤
	 * @throws Exception 㳰
	 */
	public static void main(String[] args) throws Exception {
		MapData mapData = new MapData("/home/kumano/map_data/suchi_chizu_2500/hyougo/", "05OF833");
		System.out.println("eki = " + mapData.getEki());
	}

	private Map adjacentGraph; // String -> Colleciton<Polygon>  Map
	private Map arcPolygonMap; // Arc -> Collection<String>  Map
	private String baseDir;
	private Map edgePolygons; // String -> String  Map
	private Map eki; // String -> Point  Map
	private Map gyousei; // String  -> Arc  Map
	private String mapName;
	private Map mizu; // String -> Polygon  Map
	private Map mizuArc; // String -> Arc  Map
	private Map others; // String -> Arc  Map
	private Rectangle2D rectangle; // Ͽޤɽΰʲۺɸ
	private Map roadArc; // String -> Arc  Map
	private Map si_tyo; // String -> Polygon  Map
	private Map tatemono; // String -> Tatemono  Map
	private Map tatemonoArc; // String -> Arc  Map
	private Map tyome; // String -> Polygon  Map
	private Map zyouti; // String -> Polygon  Map

	/** Ͽޤޤ
	 * @param baseDir ϿޥǡΤǥ쥯ȥ
	 * @param mapName Ͽޤ̾
	 * @throws Exception 㳰
	 */
	MapData(String baseDir, String mapName) throws Exception {
		setBaseDir(baseDir);
		setMapName(mapName);
		loadRectangle();
		edgePolygons = new HashMap();
		arcPolygonMap = new HashMap();
	}

	/** ܤܥդ׻ޤ
	 * @throws Exception 㳰
	 */
	private void calcAdjacencyGraph() throws Exception {
		adjacentGraph = new HashMap();
		if (tyome == null) {
			loadTyome();
		}
		for (Iterator iter = arcPolygonMap.entrySet().iterator(); iter.hasNext();) {
			Entry entry = ((Map.Entry) iter.next());
			Collection polygonNames = (Collection) entry.getValue(); // Collection<String>
			Collection adjacencyPolygons = new ArrayList(); // Collection<Polygon>
			for (Iterator iter2 = polygonNames.iterator(); iter2.hasNext();) {
				String polygonName = (String) iter2.next();
				if (tyome.containsKey(polygonName)) {
					PolygonData polygon = (PolygonData) tyome.get(polygonName);
					adjacencyPolygons.add(polygon);
				}
			}
			if (adjacencyPolygons.size() == 2) {
				Iterator iter2 = adjacencyPolygons.iterator();
				PolygonData polygon = (PolygonData) iter2.next();
				PolygonData polygon2 = (PolygonData) iter2.next();
				if (!adjacentGraph.containsKey(polygon.getPolygonName())) {
					adjacentGraph.put(polygon.getPolygonName(), new ArrayList());
				}
				if (!adjacentGraph.containsKey(polygon2.getPolygonName())) {
					adjacentGraph.put(polygon2.getPolygonName(), new ArrayList());
				}
				((Collection) adjacentGraph.get(polygon.getPolygonName())).add(polygon2);
				((Collection) adjacentGraph.get(polygon2.getPolygonName())).add(polygon);
			}
		}
	}

	/** Υ֥Ȥ¾Υ֥Ȥ羮طӤޤ
	 * @param o оݤΥ֥
	 * @return 羮ط
	 */
	public int compareTo(Object o) {
		return mapName.compareTo(((MapData) o).getMapName());
	}

	/**
	 * ؤǡޤ
	 */
	void freeEki() {
		eki = null;
	}

	/**
	 * θ̥ǡޤ
	 */
	void freeGyousei() {
		gyousei = null;
	}

	/**
	 * Υݥꥴǡޤ
	 */
	void freeMizu() {
		mizu = null;
	}

	/**
	 * ̳θ̥ǡޤ
	 */
	void freeMizuArc() {
		mizuArc = null;
	}

	/**
	 * Ŵƻϳθ̥ǡޤ
	 */
	void freeOthers() {
		others = null;
	}

	/**
	 * ƻϩθ̥ǡޤ
	 */
	void freeRoadArc() {
		roadArc = null;
	}

	/**
	 * Į¼Υݥꥴǡޤ
	 */
	void freeSi_tyo() {
		si_tyo = null;
	}

	/**
	 * ʪΥݥꥴǡޤ
	 */
	void freeTatemono() {
		tatemono = null;
	}

	/**
	 * ʪθ̥ǡޤ
	 */
	void freeTatemonoArc() {
		tatemonoArc = null;
	}

	/**
	 * ĮܤΥݥꥴǡޤ
	 */
	void freeTyome() {
		tyome = null;
	}

	/**
	 * ϳΥݥꥴǡޤ
	 */
	void freeZyouti() {
		zyouti = null;
	}

	/** ܤܥդޤ
	 * @return ܤܥ
	 * @throws Exception 㳰
	 */
	Map getAdjacentGraph() throws Exception {
		if (adjacentGraph == null) {
			calcAdjacencyGraph();
		}
		return adjacentGraph;
	}

	/**
	 * ̤ȥݥꥴ Map ޤ
	 * @return ̤ȥݥꥴ Map
	 */
	Map getArcPolygonMap() {
		return arcPolygonMap;
	}

	/**
	 * ϿޥǡΤǥ쥯ȥޤ
	 * @return ǥ쥯ȥ
	 */
	String getBaseDir() {
		return baseDir;
	}

	/**
	 * Ͽޤɽΰޤ
	 * @return ΰ
	 */
	Rectangle2D getBounds() {
		return rectangle;
	}

	/**
	 * ޳Ԥˤޤݥꥴΰޤ
	 * Map ΥϿ޳Ծʬʸɽ
	 * ͤϥݥꥴ̾Ǥ
	 * @return ޳Ԥˤޤݥꥴΰ
	 */
	Map getEdgePolygons() {
		return edgePolygons;
	}

	/**
	 * ؤǡޤ
	 * @throws Exception 㳰
	 * @return ؤǡ
	 */
	Map getEki() throws Exception {
		if (eki == null) {
			loadEki();
		}
		return eki;
	}

	/**
	 * θ̥ǡޤ
	 * @return θ̥ǡ
	 * @throws Exception 㳰
	 */
	Map getGyousei() throws Exception {
		if (gyousei == null) {
			loadGyousei();
		}
		return gyousei;
	}

	/**
	 * ϿޤΥե̾ޤ
	 * @return ϿޤΥե̾
	 */
	String getMapName() {
		return mapName;
	}

	/** ̤Υݥꥴǡޤ
	 * @return ̤Υݥꥴǡ
	 * @throws Exception 㳰
	 */
	Map getMizu() throws Exception {
		if (mizu == null && mizuArc != null) {
			loadMizu();
		}
		return mizu;
	}

	/**
	 * ̳θ̥ǡޤ
	 * @return ̳θ̥ǡ
	 * @throws Exception 㳰
	 */
	Map getMizuArc() throws Exception {
		if (mizuArc == null) {
			loadMizuArc();
		}
		return mizuArc;
	}

	/**
	 * Ŵƻϳθ̥ǡޤ
	 * @throws Exception Ŵƻϳθ̥ǡ
	 * @return 㳰
	 */
	Map getOthers() throws Exception {
		if (others == null) {
			loadOthers();
		}
		return others;
	}

	/**
	 * ƻϩθ̥ǡޤ
	 * @throws Exception 㳰
	 * @return ƻϩθ̥ǡ
	 */
	Map getRoadArc() throws Exception {
		if (roadArc == null) {
			loadRoadArc();
		}
		return roadArc;
	}

	/**
	 * Į¼Υݥꥴǡޤ
	 * @return Į¼Υݥꥴǡ
	 * @throws Exception 㳰
	 */
	Map getSi_tyo() throws Exception {
		if (gyousei == null) {
			loadGyousei();
		}
		if (si_tyo == null) {
			loadSi_tyo();
		}
		return si_tyo;
	}

	/**
	 * ʪΥݥꥴǡޤ
	 * @throws Exception 㳰
	 * @return ʪΥݥꥴǡ
	 */
	Map getTatemono() throws Exception {
		if (tatemonoArc == null) {
			loadTatemonoArc();
		}
		if (tatemono == null) {
			loadTatemono();
		}
		return tatemono;
	}

	/**
	 * ʪθ̥ǡޤ
	 * @throws Exception 㳰
	 * @return ʪθ̥ǡ
	 */
	Map getTatemonoArc() throws Exception {
		if (tatemonoArc == null) {
			loadTatemonoArc();
		}
		return tatemonoArc;
	}

	/**
	 * ĮܳΥݥꥴǡޤ
	 * @return ĮܳΥݥꥴǡ
	 * @throws Exception 㳰
	 */
	Map getTyome() throws Exception {
		if (gyousei == null) {
			loadGyousei();
		}
		if (tyome == null) {
			loadTyome();
		}
		return tyome;
	}

	/**
	 * ϤΥݥꥴǡޤ
	 * @throws Exception 㳰
	 * @return ϤΥݥꥴǡ
	 */
	Map getZyouti() throws Exception {
		if (others == null) {
			loadOthers();
		}
		if (zyouti == null) {
			loadZyouti();
		}
		return zyouti;
	}

	/**
	 * ؤǡäƤ뤫ɤޤ
	 * @return ؤǡäƤ뤫ɤ
	 */
	boolean hasEki() {
		return eki != null;
	}

	/**
	 * θ̥ǡäƤ뤫ɤޤ
	 * @return θ̥ǡäƤ뤫
	 */
	boolean hasGyousei() {
		return gyousei != null;
	}

	/**
	 * ̤ΥݥꥴǡäƤ뤫ɤޤ
	 * @return ̤ΥݥꥴǡäƤ뤫ɤ
	 */
	boolean hasMizu() {
		return mizu != null;
	}

	/**
	 * ̳θ̥ǡäƤ뤫ɤޤ
	 * @return ̳θ̥ǡäƤ뤫ɤ
	 */
	boolean hasMizuArc() {
		return mizuArc != null;
	}

	/**
	 * Ŵƻϳθ̥ǡäƤ뤫ɤޤ
	 * @return Ŵƻϳθ̥ǡäƤ뤫ɤ
	 */
	boolean hasOthers() {
		return others != null;
	}

	/**
	 * ƻθ̥ǡäƤ뤫ɤޤ
	 * @return ƻθ̥ǡäƤ뤫ɤ
	 */
	boolean hasRoadArc() {
		return roadArc != null;
	}

	/**
	 * Į¼ΥݥꥴǡäƤ뤫ɤޤ
	 * @return Į¼ΥݥꥴǡäƤ뤫ɤ
	 */
	boolean hasSi_tyo() {
		return si_tyo != null;
	}

	/**
	 * ʪΥݥꥴǡäƤ뤫ɤޤ
	 * @return ʪΥݥꥴǡäƤ뤫ɤ
	 */
	boolean hasTatemono() {
		return tatemono != null;
	}

	/**
	 * ʪθ̥ǡäƤ뤫ɤޤ
	 * @return ʪθ̥ǡäƤ뤫ɤ
	 */
	boolean hasTatemonoArc() {
		return tatemonoArc != null;
	}

	/**
	 * ĮܤΥݥꥴǡäƤ뤫ɤޤ
	 * @return ĮܤΥݥꥴǡäƤ뤫ɤ
	 */
	boolean hasTyome() {
		return tyome != null;
	}

	/**
	 * ϳΥݥꥴǡäƤ뤫ɤޤ
	 * @return ϳΥݥꥴǡäƤ뤫ɤ
	 */
	boolean hasZyouti() {
		return zyouti != null;
	}

	/** ̤ξե뤫ɤ߹ߤޤ
	 * @param arcs 
	 * @param in ϥȥ꡼
	 * @throws IOException 㳰
	 */
	private void loadArc(Map arcs, BufferedReader in) throws IOException {
		String line;
		String arcName = null;
		int type = 0;
		int tag = 0;
		GeneralPath path = null;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 4) {
				// ̤ϤޤȤ
				if (path != null) {
					arcs.put(arcName, new ArcData(arcName, path, type, tag));
				}
				String code = tokenizer.nextToken(); // ޼ʬॳ
				if (code.equals("L1101")) {
					type = ArcData.TYPE_GYOUSEI_PREFECTURE;
				} else if (code.equals("L1103")) {
					type = ArcData.TYPE_GYOUSEI_CITY;
				} else if (code.equals("L1104")) {
					type = ArcData.TYPE_GYOUSEI_VILLAGE;
				} else if (code.equals("L1106")) {
					type = ArcData.TYPE_GYOUSEI_CHOME;
				} else if (code.equals("L2300")) {
					type = ArcData.TYPE_RAILWAY;
				} else if (code.equals("L2110")) {
					type = ArcData.TYPE_ROAD;
				} else if (code.equals("L6241")) {
					type = ArcData.TYPE_ZYOTI_RAILROAD;
				} else if (code.equals("L6242")) {
					type = ArcData.TYPE_ZYOTI_PARK;
				} else if (code.equals("L6243")) {
					type = ArcData.TYPE_ZYOTI_SCHOOL;
				} else if (code.equals("L6244")) {
					type = ArcData.TYPE_ZYOTI_TEMPLE;
				} else if (code.equals("L6215")) {
					type = ArcData.TYPE_ZYOTI_GRAVEYARD;
				} else if (code.equals("L6200")) {
					type = ArcData.TYPE_ZYOTI_OTHER;
				} else if (code.equals("L5101")) {
					type = ArcData.TYPE_MIZU_INSIDE;
				} else if (code.equals("L5106")) {
					type = ArcData.TYPE_MIZU_SEASHORE;
				} else {
					type = ArcData.TYPE_UNKNOWN;
				}
				tag = Integer.parseInt(tokenizer.nextToken()); // 勵
				arcName = tokenizer.nextToken(); // ֹ
				path = null;
			} else if (tokenizer.countTokens() == 2) {
				// ̤ɸΤȤ
				float y = -Float.parseFloat(tokenizer.nextToken()); // y ɸ
				float x = Float.parseFloat(tokenizer.nextToken()); // x ɸ
				if (path != null) {
					path.lineTo(x + (float) getBounds().getX(), y + (float) getBounds().getMaxY());
				} else {
					path = new GeneralPath();
					path.moveTo(x + (float) getBounds().getX(), y + (float) getBounds().getMaxY());
				}
			}
		}
		if (path != null) {
			arcs.put(arcName, new ArcData(arcName, path, type, tag));
		}
	}

	/**
	 * ̤ξ°ե뤫ɤ߹ߤޤ
	 * @param arcs 
	 * @param in ϥȥ꡼
	 * @throws Exception 㳰
	 */
	private void loadArcAttribute(Map arcs, BufferedReader in) throws Exception {
		String line;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() > 0) {
				String firstToken = tokenizer.nextToken(); // FHor ޼ʬॳ
				if (!firstToken.equals("FH")) {
					// °쥳ɤΤȤ
					if (tokenizer.countTokens() > 2) {
						String name = tokenizer.nextToken(); // ֹ
						tokenizer.nextToken(); // °եɤθĿ
						String attribute = tokenizer.nextToken(); // °
						if (arcs.containsKey(name)) {
							ArcData arc = ((ArcData) arcs.get(name));
							arc.setAttribute(attribute);
							if (attribute.indexOf("®") > 0) {
								arc.setRoadType(ArcData.ROAD_HIGHWAY);
							} else if (attribute.startsWith("ƻ")) {
								arc.setRoadType(ArcData.ROAD_KOKUDO);
							} else if (attribute.startsWith("ƻ")) {
								arc.setRoadType(ArcData.ROAD_KENDO);
							} else if (attribute.startsWith("ƻ")) {
								arc.setRoadType(ArcData.ROAD_CHIHODO);
							} else {
								arc.setRoadType(ArcData.ROAD_MAJOR);
							}
						}
					}
				}
			}
		}
	}

	/** ؤǡɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadEki() throws Exception {
		String fileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "others" + File.separator + "eki.pnt";
		eki = new HashMap();
		if (new File(fileName).canRead()) {
			loadPoint(eki, new BufferedReader(new InputStreamReader(new FileInputStream(fileName))));
			String attributeFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "others" + File.separator + "eki.atr";
			if (new File(attributeFileName).canRead()) {
				loadPointAttribute(eki, new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")), PointData.CLASSIFICATION_STATION);
			}
		}
	}

	/** θ̥եɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadGyousei() throws Exception {
		String fileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "gyousei" + File.separator + "gyousei.arc";
		gyousei = new HashMap();
		if (new File(fileName).canRead()) {
			loadArc(gyousei, new BufferedReader(new InputStreamReader(new FileInputStream(fileName))));
		}
	}

	/** ̤Υݥꥴեɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadMizu() throws Exception {
		String polygonFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "mizu" + File.separator + "mizu.pgn";
		if (new File(polygonFileName).canRead()) {
			mizu = new HashMap();
			loadPolygon(mizu, mizuArc, new BufferedReader(new InputStreamReader(new FileInputStream(polygonFileName))));
			String attributeFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "mizu" + File.separator + "mizu.atr";
			if (new File(attributeFileName).canRead()) {
				loadPolygonAttribute(mizu, new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")), PolygonData.CLASSIFICATION_RIVER);
			}
		}
	}

	/** 峦θ̥եɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadMizuArc() throws Exception {
		String fileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "mizu" + File.separator + "mizu.arc";
		if (new File(fileName).canRead()) {
			mizuArc = new HashMap();
			loadArc(mizuArc, new BufferedReader(new InputStreamReader(new FileInputStream(fileName))));
		}
	}

	/**
	 * Ŵƻϳθ̥ǡɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadOthers() throws Exception {
		others = new HashMap();
		BufferedReader in =
			new BufferedReader(new InputStreamReader(new FileInputStream(baseDir + File.separator + mapName.toUpperCase() + File.separator + "others" + File.separator + "others.arc")));
		loadArc(others, in);
	}

	/** ξե뤫ɤ߹ߤޤ
	 * @param points 
	 * @param in ϥȥ꡼
	 * @throws IOException 㳰
	 */
	private void loadPoint(Map points, BufferedReader in) throws IOException {
		String line;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 4) {
				String classificationCode = tokenizer.nextToken(); // ޼ʬॳ
				int code;
				if (classificationCode.equals("P2420")) {
					code = PointData.CLASSIFICATION_STATION;
				} else if (classificationCode.equalsIgnoreCase("P7301")) {
					code = PointData.CLASSIFICATION_DATUMS;
				} else {
					code = PointData.CLASSIFICATION_UNKNOWN;
				}
				String name = tokenizer.nextToken(); // ֹ
				double y = -Double.parseDouble(tokenizer.nextToken()); // y ɸ
				double x = Double.parseDouble(tokenizer.nextToken()); // x ɸ
				PointData point = new PointData(name, code, x + getBounds().getX(), y + getBounds().getMaxY());
				points.put(name, point);
			}
		}
	}

	/** ǡ°ե뤫ɤ߹ߤޤ
	 * @param points 
	 * @param in ϥȥ꡼
	 * @param classificationCode ޼ʬॳɤ
	 * @throws Exception 㳰
	 */
	private void loadPointAttribute(Map points, BufferedReader in, int classificationCode) throws Exception {
		String line;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() > 0) {
				String firstToken = tokenizer.nextToken(); // FHor ޼ʬॳ
				if (!firstToken.equals("FH")) {
					// °쥳ɤΤȤ
					if (classificationCode == PointData.CLASSIFICATION_STATION) {
						// 
						if (tokenizer.countTokens() == 3) {
							String name = tokenizer.nextToken(); // ֹ
							tokenizer.nextToken(); // °եɤθĿ
							String attribute = tokenizer.nextToken(); // °
							if (!attribute.endsWith("")) {
								attribute = attribute + "";
							}
							if (points.containsKey(name)) {
								((PointData) points.get(name)).setAttribute(attribute);
							}
						}
					} else if (classificationCode == PointData.CLASSIFICATION_DATUMS) {
						// 
						if (tokenizer.countTokens() == 13) {
							String name = tokenizer.nextToken(); // ֹ
							tokenizer.nextToken(); // °եɤθĿ
							tokenizer.nextToken(); // 3 å女
							tokenizer.nextToken(); // 
							String attribute = tokenizer.nextToken(); // °
							if (points.containsKey(name)) {
								((PointData) points.get(name)).setAttribute(attribute);
							}
						}
					}
				}
			}
		}
	}

	/** ݥꥴξե뤫ɤ߹ߤޤ
	 * @param polygons ݥꥴ
	 * @param arcs ݥꥴ
	 * @param in ϥȥ꡼
	 * @throws IOException 㳰
	 */
	private void loadPolygon(Map polygons, Map arcs, BufferedReader in) throws IOException {
		String line;
		String polygonName = null;
		GeneralPath path = null;
		int type = 0;
		double x = 0;
		double y = 0;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 5) {
				// ݥꥴ󤬻ϤޤȤ
				if (path != null && polygonName != null) {
					polygons.put(polygonName, new PolygonData(polygonName, new Area(path), type, x + getBounds().getX(), y + getBounds().getMaxY()));
				}
				type = parsePolygonType(tokenizer.nextToken()); // ޼ʬॳ
				polygonName = tokenizer.nextToken(); // ֹ
				tokenizer.nextToken(); // ݥꥴ륢쥳ɤο
				y = -Double.parseDouble(tokenizer.nextToken()); // ɽ y ɸ
				x = Double.parseDouble(tokenizer.nextToken()); // ɽ x ɸ
				path = new GeneralPath();
			} else if (tokenizer.countTokens() == 1) {
				// ݥꥴ̤ΤȤ
				int arcIndex = Integer.parseInt(tokenizer.nextToken()); // 쥳
				String arcName = new Integer(Math.abs(arcIndex)).toString();
				ArcData arc = ((ArcData) arcs.get(arcName));
				if (arcIndex < 0) {
					path.append(arc.getReversalPath(), true);
				} else {
					path.append(arc.getPath(), true);
				}
				if (!arcPolygonMap.containsKey(arc)) {
					arcPolygonMap.put(arc, new ArrayList());
				}
				((Collection) arcPolygonMap.get(arc)).add(polygonName);
				if (arc.getTag() == ArcData.TAG_EDGE_OF_MAP) {
					PathIterator iter = arc.getPath().getPathIterator(new AffineTransform());
					double[] coords = new double[6];
					iter.currentSegment(coords);
					int x1 = (int) coords[0];
					int y1 = (int) coords[1];
					if (!iter.isDone()) {
						iter.next();
						if (iter.currentSegment(coords) == PathIterator.SEG_LINETO) {
							int x2 = (int) coords[0];
							int y2 = (int) coords[1];
							if (x1 < x2 || y1 < y2) {
								edgePolygons.put(x1 + "_" + y1 + "_" + x2 + "_" + y2, polygonName);
							} else {
								edgePolygons.put(x2 + "_" + y2 + "_" + x1 + "_" + y1, polygonName);
							}
							if (!iter.isDone()) {
								iter.next();
								if (iter.currentSegment(coords) == PathIterator.SEG_LINETO) {
									int x3 = (int) coords[0];
									int y3 = (int) coords[1];
									if (x2 < x3 || y2 < y3) {
										edgePolygons.put(x2 + "_" + y2 + "_" + x3 + "_" + y3, polygonName);
									} else {
										edgePolygons.put(x3 + "_" + y3 + "_" + x2 + "_" + y2, polygonName);
									}
									if (!iter.isDone()) {
										iter.next();
										if (iter.currentSegment(coords) == PathIterator.SEG_LINETO) {
											int x4 = (int) coords[0];
											int y4 = (int) coords[1];
											if (x3 < x4 || y3 < y4) {
												edgePolygons.put(x3 + "_" + y3 + "_" + x4 + "_" + y4, polygonName);
											} else {
												edgePolygons.put(x4 + "_" + y4 + "_" + x3 + "_" + y3, polygonName);
											}
										}
									}
								}
							}
						}
					}
				}
			}
			if (path != null && polygonName != null) {
				polygons.put(polygonName, new PolygonData(polygonName, new Area(path), type, x + getBounds().getX(), y + getBounds().getMaxY()));
			}
		}
	}

	/** ݥꥴ°ե뤫ɤ߹ߤޤ
	 * @param polygons ݥꥴ
	 * @param in ϥȥ꡼
	 * @param classificationCode ޼ʬॳɤ
	 * @throws Exception 㳰
	 */
	private void loadPolygonAttribute(Map polygons, BufferedReader in, int classificationCode) throws Exception {
		String line;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() > 0) {
				String firstToken = tokenizer.nextToken(); // FHor ޼ʬॳ
				if (!firstToken.equals("FH")) {
					// °쥳ɤΤȤ
					int type = parsePolygonType(firstToken);
					String polygonName = tokenizer.nextToken(); // ֹ
					if (tokenizer.hasMoreTokens()) {
						tokenizer.nextToken(); // °եɤο
					}
					StringBuffer stringBuffer = new StringBuffer();
					if (tokenizer.hasMoreTokens()) {
						if (classificationCode == PolygonData.CLASSIFICATION_SI_TYO || classificationCode == PolygonData.CLASSIFICATION_TYOME) {
							tokenizer.nextToken(); // °ե 1
						} else if (classificationCode == PolygonData.CLASSIFICATION_BUILDING) {
							// °ե 1
							 ((PolygonData) polygons.get(polygonName)).setTatemonoCode(Integer.parseInt(tokenizer.nextToken()));
						} else {
							stringBuffer.append(tokenizer.nextToken()); // °ե 1
						}
					}
					if (tokenizer.hasMoreTokens()) {
						stringBuffer.append(tokenizer.nextToken()); // °ե 2
					}
					String attribute = stringBuffer.toString();
					if (classificationCode == PolygonData.CLASSIFICATION_TYOME) {
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("20");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("19");
						attribute = Pattern.compile("Ȭ$").matcher(attribute).replaceFirst("18");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("17");
						attribute = Pattern.compile("ϻ$").matcher(attribute).replaceFirst("16");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("15");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("14");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("13");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("12");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("11");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("10");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("Ȭ$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("ϻ$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					} else if (classificationCode == PolygonData.CLASSIFICATION_BUILDING) {
						attribute = Pattern.compile("͹ض$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("ٻ$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("ɽ$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("ߥ˥ƥ󥿡$").matcher(attribute).replaceFirst("ߥ");
						attribute = Pattern.compile("ع$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("ع$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("⹻$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("ع$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("ȹع$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("û$").matcher(attribute).replaceFirst("û");
						attribute = Pattern.compile("ع$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("󥿡$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("Ȱ$").matcher(attribute).replaceFirst("");
					} else if (
						classificationCode == PolygonData.CLASSIFICATION_RAILROAD
							|| classificationCode == PolygonData.CLASSIFICATION_PARK
							|| classificationCode == PolygonData.CLASSIFICATION_SCHOOL
							|| classificationCode == PolygonData.CLASSIFICATION_TEMPLE
							|| classificationCode == PolygonData.CLASSIFICATION_GRAVEYARD
							|| classificationCode == PolygonData.CLASSIFICATION_OTHER) {
						attribute = Pattern.compile("ع$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("ع").matcher(attribute).replaceAll("");
						attribute = Pattern.compile("⹻").matcher(attribute).replaceAll("");
						attribute = Pattern.compile("ع").matcher(attribute).replaceAll("");
						attribute = Pattern.compile("ȹع$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("û$").matcher(attribute).replaceFirst("û");
						attribute = Pattern.compile("ع$").matcher(attribute).replaceFirst("");
						attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					}
					((PolygonData) polygons.get(polygonName)).setAttribute(attribute);
				}
			}
		}
	}

	/** Ͽޤΰե뤫ɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	private void loadRectangle() throws Exception {
		BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(baseDir + File.separator + mapName.toUpperCase() + File.separator + mapName.toLowerCase() + ".txt")));
		String line;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 10) {
				tokenizer.nextToken();
				double y2 = -Double.parseDouble(tokenizer.nextToken());
				double x1 = Double.parseDouble(tokenizer.nextToken());
				double y1 = -Double.parseDouble(tokenizer.nextToken());
				double x2 = Double.parseDouble(tokenizer.nextToken());
				setRectangle(new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1));
				break;
			}
		}
		in.close();
	}

	/** ƻθ̥ǡɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadRoadArc() throws Exception {
		String fileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "road" + File.separator + "roadntwk.arc";
		if (new File(fileName).canRead()) {
			roadArc = new HashMap();
			loadArc(roadArc, new BufferedReader(new InputStreamReader(new FileInputStream(fileName))));
			String attributeFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "road" + File.separator + "road.atr";
			if (new File(attributeFileName).canRead()) {
				loadArcAttribute(roadArc, new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")));
			}
		}
	}

	/** ĮΥݥꥴեɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadSi_tyo() throws Exception {
		String polygonFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "gyousei" + File.separator + "si_tyo.pgn";
		if (new File(polygonFileName).canRead()) {
			si_tyo = new HashMap();
			loadPolygon(si_tyo, gyousei, new BufferedReader(new InputStreamReader(new FileInputStream(polygonFileName))));
			/*
			String attributeFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "gyousei" + File.separator + "si_tyo.atr";
			if (new File(attributeFileName).canRead()) {
			        loadPolygonAttribute(
			                si_tyo,
			                new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")),
			                Polygon.CLASSIFICATION_SI_TYO);
			}
			 */
		}
	}

	/** ʪΥݥꥴեɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadTatemono() throws Exception {
		String polygonFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "tatemono" + File.separator + "tatemono.pgn";
		if (new File(polygonFileName).canRead()) {
			tatemono = new HashMap();
			loadPolygon(tatemono, tatemonoArc, new BufferedReader(new InputStreamReader(new FileInputStream(polygonFileName))));
			String attributeFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "tatemono" + File.separator + "tatemono.atr";
			if (new File(attributeFileName).canRead()) {
				loadPolygonAttribute(tatemono, new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")), PolygonData.CLASSIFICATION_BUILDING);
			}
		}
	}

	/** ʪθ̥եɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadTatemonoArc() throws Exception {
		String fileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "tatemono" + File.separator + "tatemono.arc";
		if (new File(fileName).canRead()) {
			tatemonoArc = new HashMap();
			loadArc(tatemonoArc, new BufferedReader(new InputStreamReader(new FileInputStream(fileName))));
		}
	}

	/** ܳΥݥꥴեɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadTyome() throws Exception {
		tyome = new HashMap();
		loadPolygon(
			tyome,
			gyousei,
			new BufferedReader(new InputStreamReader(new FileInputStream(baseDir + File.separator + mapName.toUpperCase() + File.separator + "gyousei" + File.separator + "tyome.pgn"))));
		loadPolygonAttribute(
			tyome,
			new BufferedReader(new InputStreamReader(new FileInputStream(baseDir + File.separator + mapName.toUpperCase() + File.separator + "gyousei" + File.separator + "tyome.atr"), "SJIS")),
			PolygonData.CLASSIFICATION_TYOME);
	}

	/**
	 * ϤΥݥꥴǡɤ߹ߤޤ
	 * @throws Exception 㳰
	 */
	void loadZyouti() throws Exception {
		String polygonFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "others" + File.separator + "zyouti.pgn";
		if (new File(polygonFileName).canRead()) {
			zyouti = new HashMap();
			loadPolygon(zyouti, others, new BufferedReader(new InputStreamReader(new FileInputStream(polygonFileName))));
			String attributeFileName = baseDir + File.separator + mapName.toUpperCase() + File.separator + "others" + File.separator + "zyouti.atr";
			if (new File(attributeFileName).canRead()) {
				loadPolygonAttribute(zyouti, new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")), PolygonData.CLASSIFICATION_PARK);
			}
		}
	}

	/**
	 * ݥꥴο޼ʬॳɤѴޤ
	 * @param code ޼ʬॳ
	 * @return 
	 */
	private int parsePolygonType(String code) {
		if (code.equals("A1105")) {
			return PolygonData.CLASSIFICATION_SI_TYO;
		} else if (code.equals("A1106")) {
			return PolygonData.CLASSIFICATION_TYOME;
		} else if (code.equals("A6241")) {
			return PolygonData.CLASSIFICATION_RAILROAD;
		} else if (code.equals("A6242")) {
			return PolygonData.CLASSIFICATION_PARK;
		} else if (code.equals("A6243")) {
			return PolygonData.CLASSIFICATION_SCHOOL;
		} else if (code.equals("A6244")) {
			return PolygonData.CLASSIFICATION_TEMPLE;
		} else if (code.equals("A6215")) {
			return PolygonData.CLASSIFICATION_GRAVEYARD;
		} else if (code.equals("A6200")) {
			return PolygonData.CLASSIFICATION_OTHER;
		} else if (code.equals("A5101")) {
			return PolygonData.CLASSIFICATION_RIVER;
		} else if (code.equals("A5105")) {
			return PolygonData.CLASSIFICATION_LAKE;
		} else if (code.equals("A3500")) {
			return PolygonData.CLASSIFICATION_BUILDING;
		} else {
			return PolygonData.CLASSIFICATION_UNKNOWN;
		}
	}

	/**
	 * @param string
	 */
	private void setBaseDir(String string) {
		baseDir = string;
	}

	/**
	 * @param string
	 */
	private void setMapName(String string) {
		mapName = string;
	}

	/**
	 * @param rectangle2D
	 */
	private void setRectangle(Rectangle2D rectangle2D) {
		rectangle = rectangle2D;
	}

	/**
	 * Ͽޤʸɽޤ
	 * @return ʸɽ
	 */
	public String toString() {
		return "[MapData name=" + mapName + "]";
	}

}
