import java.awt.*;
import java.awt.geom.*;
import java.util.*;

/*
 * : 2004/01/16
 */

/**
 * °褹ɸ׻륯饹Ǥ
 * @author Kumano Tatsuo
 */
class FixAttributeLocation {

	private boolean isChanged; // ľη׻°褹ɸѲɤ

	/**
	 * °褹ɸꤷޤ
	 * @param maps Ͽ
	 * @param panel ѥͥ
	 */
	void fixAttributeLocation(Map maps, MapPanel panel) throws Exception {
		isChanged = false;
		Font tatemonoFont = new Font("MS UI Gothic", Font.PLAIN, 12);
		Font zyoutiFont = new Font("MS UI Gothic", Font.PLAIN, 15);
		Font mizuFont = new Font("ͣ ī", Font.PLAIN, 14);
		Font tyomeFont = new Font("MS UI Gothic", Font.PLAIN, 18);
		Area usedArea = new Area(); // °ˤäƻѺѤߤΰ
		Rectangle2D visibleRectangle = panel.getVisibleRectangle(); // ߲̤ɽƤϰϡʲۺɸ
		int loopCount = 4;
		double size = 4; // ʪɽľ
		double zoom = panel.getZoom();
		double x = panel.getVisibleRectangle().getX();
		double y = panel.getVisibleRectangle().getY();
		double w = panel.getVisibleRectangle().getWidth();
		double h = panel.getVisibleRectangle().getHeight();
		// ʪ°ɽ֤׻
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTatemono()) {
if(panel.isVisible(mapData.getBounds())){
				FontMetrics metrics = panel.getFontMetrics(tatemonoFont);
				double attributeHeight = metrics.getHeight() / zoom;
				for (Iterator iter2 = mapData.getTatemono().values().iterator(); iter2.hasNext();) {
					Polygon polygon = (Polygon) iter2.next();
					fixTatemonoAttributeLocation(polygon, usedArea, visibleRectangle, zoom, attributeHeight, metrics, size);
				}
			}
		}
		}
		// Ϥ°ɽ֤׻
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasZyouti()) {
				if(panel.isVisible(mapData.getBounds())){
				FontMetrics metrics = panel.getFontMetrics(zyoutiFont);
				double attributeHeight = metrics.getHeight() / zoom;
				for (Iterator iter2 = mapData.getZyouti().values().iterator(); iter2.hasNext();) {
					Polygon polygon = (Polygon) iter2.next();
					fixPolygonAttributeLocation(polygon, usedArea, visibleRectangle, zoom, attributeHeight, metrics, size);
				}}
			}
		}
		// ̤°ɽ֤׻
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasMizu()) {
				if(panel.isVisible(mapData.getBounds())){
				FontMetrics metrics = panel.getFontMetrics(mizuFont);
				double attributeHeight = metrics.getHeight() / zoom;
				for (Iterator iter2 = mapData.getMizu().values().iterator(); iter2.hasNext();) {
					Polygon polygon = (Polygon) iter2.next();
					fixPolygonAttributeLocation(polygon, usedArea, visibleRectangle, zoom, attributeHeight, metrics, size);
				}}
			}
		}
		// ܤ°ɽ֤׻
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTyome()) {
				if(panel.isVisible(mapData.getBounds())){
				FontMetrics metrics = panel.getFontMetrics(tyomeFont);
				double attributeHeight = metrics.getHeight() / zoom;
				for (Iterator iter2 = mapData.getTyome().values().iterator(); iter2.hasNext();) {
					Polygon polygon = (Polygon) iter2.next();
					fixTyomeAttributeLocation(polygon, usedArea, visibleRectangle, zoom, attributeHeight, metrics, size);
				}}
			}
		}
		isChanged = true;
	}

	private void fixTatemonoAttributeLocation(Polygon polygon, Area usedArea, Rectangle2D visibleRectangle, double zoom, double attributeHeight, FontMetrics metrics, double size) {
		if (polygon.getAttribute() != null) {
			polygon.setAttributeLocation(0, 0);
			double attributeWidth = metrics.stringWidth(polygon.getAttribute()) / zoom;
			Rectangle2D pointRectangle = new Rectangle2D.Double(polygon.getX() - size / zoom, polygon.getY() - size / zoom, size * 2 / zoom, size * 2 / zoom);
			Rectangle2D attributeRectangle;
			// α
			attributeRectangle = new Rectangle2D.Double(polygon.getX() + size / zoom, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// α
			attributeRectangle = new Rectangle2D.Double(polygon.getX() + size / 2 / zoom, polygon.getY() - attributeHeight, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// α
			attributeRectangle = new Rectangle2D.Double(polygon.getX() + size / 2 / zoom, polygon.getY(), attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// κ
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth - size / zoom, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// κ
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth - size / 2 / zoom, polygon.getY() - attributeHeight, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// κ
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth - size / 2 / zoom, polygon.getY(), attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
		}
	}

	private void fixPolygonAttributeLocation(Polygon polygon, Area usedArea, Rectangle2D visibleRectangle, double zoom, double attributeHeight, FontMetrics metrics, double size) {
		if (polygon.getAttribute() != null) {
			polygon.setAttributeLocation(0, 0);
			double attributeWidth = metrics.stringWidth(polygon.getAttribute()) / zoom;
			Rectangle2D pointRectangle = new Rectangle2D.Double(polygon.getX() - size / zoom, polygon.getY() - size / zoom, size * 2 / zoom, size * 2 / zoom);
			Rectangle2D attributeRectangle;
			// ݥꥴ濴
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
		}
	}

	private void fixTyomeAttributeLocation(Polygon polygon, Area usedArea, Rectangle2D visibleRectangle, double zoom, double attributeHeight, FontMetrics metrics, double size) {
		if (polygon.getAttribute() != null) {
			polygon.setAttributeLocation(0, 0);
			double attributeWidth = metrics.stringWidth(polygon.getAttribute()) / zoom;
			Rectangle2D pointRectangle = new Rectangle2D.Double(polygon.getX() - size / zoom, polygon.getY() - size / zoom, size * 2 / zoom, size * 2 / zoom);
			Rectangle2D attributeRectangle;
			// ݥꥴ濴
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// ݥꥴ濴龯
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY() - attributeHeight, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// ݥꥴ濴龯
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY(), attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// ݥꥴ濴° 1 ʬ
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY() - attributeHeight * 3 / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// ݥꥴ濴° 1 ʬ
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2, polygon.getY() + attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// ݥꥴ濴龯
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2 + attributeHeight, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
			// ݥꥴ濴龯
			attributeRectangle = new Rectangle2D.Double(polygon.getX() - attributeWidth / 2 - attributeHeight, polygon.getY() - attributeHeight / 2, attributeWidth, attributeHeight);
			if (isPutable(pointRectangle, attributeRectangle, usedArea, visibleRectangle)) {
				polygon.setAttributeLocation(attributeRectangle.getX(), attributeRectangle.getMaxY());
				usedArea.add(new Area(pointRectangle));
				usedArea.add(new Area(attributeRectangle));
			}
		}
	}

	private boolean isPutable(Rectangle2D pointRectangle, Rectangle2D attributeRectangle, Area usedArea, Rectangle2D visibleRectangle) {
		return visibleRectangle.contains(pointRectangle) && visibleRectangle.contains(attributeRectangle) && !usedArea.intersects(pointRectangle) && !usedArea.intersects(attributeRectangle);
	}

	/**
	 * ľη׻°褹ɸѲɤޤ
	 * @return ɸѲɤ
	 */
	boolean isChanged() {
		return isChanged;
	}

}
