import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

/*
 * ֿϿ2500ʶ֥ǡסɽեȡʲˡ
 * οϿ2500ʶ֥ǡסˤɤ߹ɽץǤ
 * Copyright (C) 2003-2004 Kumano Tatsuo
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/**
 * ϿޤɽץǤ
 * @author  Kumano Tatsuo
 */
public class Main {

	private static MapFrame frame;
	private static Map maps;

	/**
	 * @param args the command line arguments
	 */
	public static void main(String[] args) throws Exception {
		maps = new TreeMap();

		frame = new MapFrame();
		frame.show();
		MapPanel panel = (MapPanel) frame.shapePanel;

		System.out.println("Loading map infomation...");
		String baseDir = "data";
		String files[] = new File(baseDir).list();
		Pattern pattern = Pattern.compile("[0-9][0-9][a-zA-Z][a-zA-Z][0-9][0-9][0-9]");
		for (int i = 0; i < files.length; i++) {
			if (pattern.matcher(files[i]).matches()) {
				String mapName = files[i].toLowerCase();
				maps.put(mapName, new MapData(baseDir, mapName));
			}
		}
		System.out.println("Map information loading finished.");

		Thread.sleep(1000);
		panel.setMapData(maps);
		panel.zoomAutomaticaly();
		panel.moveToCenter();
		panel.repaint();
		
		Thread loadMapThread = new LoadMapThread(maps, panel);
		loadMapThread.start();
		panel.addMouseListener(new MouseListener() {
			public void mouseClicked(MouseEvent e) {

			}

			public void mouseEntered(MouseEvent e) {

			}

			public void mouseExited(MouseEvent e) {

			}

			public void mousePressed(MouseEvent e) {

			}

			public void mouseReleased(MouseEvent e) {

			}
		});
	}
	
}
