import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import java.util.Map.*;

/*
 * : 2003/12/13
 */

/**
 * ϿޤХå饦ɤɤ߹ॹåɤǤ
 * @author Kumano Tatsuo
 */
class LoadMapThread extends Thread {

	private double keepCoefficient; // ̲ʬΥǡ¸Ƥ
	private Map maps;
	private MapPanel panel;
	private double preLoadCoefficient; // ̲ʬΥǡɤߤ뤫

	LoadMapThread(Map maps, MapPanel panel) {
		this.maps = maps;
		this.panel = panel;
		preLoadCoefficient = 0;
		keepCoefficient = 0;
	}

	public void run() {
		while (true) {
			try {
				double zoom = ((MapPanel) panel).getZoom();
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					Map.Entry entry = (Map.Entry) iter.next();
					MapData mapData = ((MapData) entry.getValue());
					if (panel.isIdle()) {
						Rectangle2D visibleRectangle = ((MapPanel) panel).getVisibleArea();
						Rectangle2D preLoadRectangle =
							new Rectangle2D.Double(
								visibleRectangle.getX() - visibleRectangle.getWidth() * preLoadCoefficient,
								visibleRectangle.getY() - visibleRectangle.getHeight() * preLoadCoefficient,
								visibleRectangle.getWidth() + visibleRectangle.getWidth() * preLoadCoefficient * 2,
								visibleRectangle.getHeight() + visibleRectangle.getHeight() * preLoadCoefficient * 2);
						Rectangle2D keepRectangle =
							new Rectangle2D.Double(
								visibleRectangle.getX() - visibleRectangle.getWidth() * keepCoefficient,
								visibleRectangle.getY() - visibleRectangle.getHeight() * keepCoefficient,
								visibleRectangle.getWidth() + visibleRectangle.getWidth() * keepCoefficient * 2,
								visibleRectangle.getHeight() + visibleRectangle.getHeight() * keepCoefficient * 2);
						if (visibleRectangle.intersects(mapData.getBounds())) {
							// ǡ
							boolean isChanged = false;
							if (zoom < 0.2) {
								if (mapData.hasGyousei()) {
									mapData.freeSi_tyo();
									mapData.freeTyome();
									mapData.freeGyousei();
									isChanged = true;
								}
								if (mapData.hasMizuArc()) {
									mapData.freeMizu();
									mapData.freeMizuArc();
									isChanged = true;
								}
								if (mapData.hasOthers()) {
									mapData.freeZyouti();
									mapData.freeOthers();
									isChanged = true;
								}
								if (mapData.hasTatemonoArc()) {
									mapData.freeTatemono();
									mapData.freeTatemonoArc();
									isChanged = true;
								}
							}
							if (zoom < 0.3) {
								if (mapData.hasRoadArc()) {
									mapData.freeRoadArc();
									isChanged = true;
								}
							}
							if (visibleRectangle.intersects(mapData.getBounds()) && isChanged) {
								panel.repaint();
							}
						}
						if (preLoadRectangle.intersects(mapData.getBounds())) {
							// ǡɤ߹
							if (zoom > 0.2) {
								boolean isChanged = false;
								if (!mapData.hasGyousei()) {
									mapData.loadGyousei();
									mapData.loadSi_tyo();
									mapData.loadTyome();
									joinTyome();
									paintTyome();
									isChanged = true;
								}
								if (!mapData.hasMizuArc()) {
									mapData.loadMizuArc();
									mapData.loadMizu();
									isChanged = true;
								}
								if (!mapData.hasOthers()) {
									mapData.loadOthers();
									mapData.loadZyouti();
									isChanged = true;
								}
								if (!mapData.hasTatemonoArc()) {
									mapData.loadTatemonoArc();
									mapData.loadTatemono();
									isChanged = true;
								}
								if (visibleRectangle.intersects(mapData.getBounds()) && isChanged) {
									panel.repaint();
								}
							}
							if (zoom > 0.3) {
								boolean isChanged = false;
								if (!mapData.hasRoadArc()) {
									mapData.loadRoadArc();
									isChanged = true;
								}
								if (visibleRectangle.intersects(mapData.getBounds()) && isChanged) {
									panel.repaint();
								}
							}
						} else if (!keepRectangle.intersects(mapData.getBounds())) {
							// ǡ
							if (mapData.hasGyousei()) {
								mapData.freeSi_tyo();
								mapData.freeTyome();
								mapData.freeGyousei();
							}
							if (mapData.hasMizuArc()) {
								mapData.freeMizu();
								mapData.freeMizuArc();
							}
							if (mapData.hasOthers()) {
								mapData.freeZyouti();
								mapData.freeOthers();
							}
							if (mapData.hasTatemonoArc()) {
								mapData.freeTatemono();
								mapData.freeTatemonoArc();
							}
							if (mapData.hasRoadArc()) {
								mapData.freeRoadArc();
							}
						}
					}
				}
				Thread.sleep(1000);
			} catch (Exception exception) {
				System.err.println("Failed to load map.");
				exception.printStackTrace(System.err);
			}
			((MapPanel) panel).setMapData(maps);
		}
	}

	/**
	 * ޳Ԥˤޤݥꥴ礷ޤ
	 */
	private void joinTyome() throws Exception {
		Map joiningPolygons = new HashMap(); // Map<Polygon = Set>
		for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) ((Entry) iter.next()).getValue();
			Map edgePolygons = mapData.getEdgePolygons();
			if (edgePolygons != null) {
				for (Iterator iter2 = maps.entrySet().iterator(); iter2.hasNext();) {
					MapData mapData2 = (MapData) ((Entry) iter2.next()).getValue();
					Map edgePolygons2 = mapData2.getEdgePolygons();
					if (edgePolygons2 != null) {
						if (mapData.hashCode() != mapData2.hashCode()) {
							//System.out.println("1 = " + mapData.getMapName() + ", 2 = " + mapData2.getMapName());
							//System.out.println("edgePolygons = " + edgePolygons);
							//System.out.println("edgePolygons2 = " + edgePolygons2);
							for (Iterator iter3 = edgePolygons.entrySet().iterator(); iter3.hasNext();) {
								Entry entry3 = (Entry) iter3.next();
								String key = (String) entry3.getKey();
								String polygonName = (String) entry3.getValue();
								if (mapData.hasTyome()) {
									Polygon polygon = (Polygon) mapData.getTyome().get(polygonName);
									if (edgePolygons2.containsKey(key)) {
										String polygonName2 = (String) edgePolygons2.get(key);
										if (mapData2.hasTyome()) {
											Polygon polygon2 = (Polygon) mapData2.getTyome().get(polygonName2);
											//System.out.println(polygonName + " is joining to " + polygonName2);
											if (!joiningPolygons.containsKey(polygon)) {
												joiningPolygons.put(polygon, new HashSet());
											}
											((Set) joiningPolygons.get(polygon)).add(polygon2);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		//System.out.println("joining polygons: " + joiningPolygons);
		ArrayList finalPolygons = new ArrayList(); // ArrayList<Set>
		for (Iterator iter = joiningPolygons.entrySet().iterator(); iter.hasNext();) {
			Entry entry = (Entry) iter.next();
			Polygon key = (Polygon) entry.getKey();
			Set values = (Set) entry.getValue();
			boolean isKeyFound = false;
			for (Iterator iter2 = finalPolygons.iterator(); iter2.hasNext();) {
				Set set = (Set) iter2.next();
				if (set.contains(key)) {
					set.addAll(values);
					isKeyFound = true;
				}
			}
			// 
			for (Iterator iter2 = values.iterator(); iter2.hasNext();) {
				Polygon value = (Polygon) iter2.next();
				for (Iterator iter3 = finalPolygons.iterator(); iter3.hasNext();) {
					Set set = (Set) iter3.next();
					if (set.contains(value)) {
						set.add(key);
						set.addAll(values);
						isKeyFound = true;
					}
				}
			}
			// ޤ
			if (!isKeyFound) {
				Set set = new LinkedHashSet();
				set.add(key);
				set.addAll(values);
				finalPolygons.add(set);
			}
		}
		//System.out.println("final polygons: " + finalPolygons);
		for (Iterator iter = finalPolygons.iterator(); iter.hasNext();) {
			Set polygons = (Set) iter.next();
			GeneralPath path = new GeneralPath();
			for (Iterator iter2 = polygons.iterator(); iter2.hasNext();) {
				Polygon polygon = (Polygon) iter2.next();
				if (polygon != null) {
					path.append(polygon.getPath(), false);
				}
			}
			for (Iterator iter2 = polygons.iterator(); iter2.hasNext();) {
				Polygon polygon = (Polygon) iter2.next();
				if (polygon != null) {
					polygon.setX(path.getBounds().getCenterX());
					polygon.setY(path.getBounds().getCenterY());
				}
			}
		}
	}

	/**
	 * ܤΥݥꥴɤʬޤ
	 */
	private void paintTyome() throws Exception {
		Map attributePolygonMap = new HashMap(); // String -> Collection<Polygon>  Map
		// °򥭡ݥꥴνͤȤ Map 
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTyome()) {
				for (Iterator iter2 = mapData.getTyome().values().iterator(); iter2.hasNext();) {
					Polygon polygon = (Polygon) iter2.next();
					if (polygon.getAttribute() != null) {
						if (!attributePolygonMap.containsKey(polygon.getAttribute())) {
							attributePolygonMap.put(polygon.getAttribute(), new ArrayList());
						}
						((Collection) attributePolygonMap.get(polygon.getAttribute())).add(polygon);
					}
				}
			}
		}
		// Ʊ°ΥݥꥴƱˤ
		/*
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTyome()) {
				for (Iterator iter2 = mapData.getTyome().values().iterator(); iter2.hasNext();) {
					Polygon polygon = (Polygon) iter2.next();
					if (polygon.getAttribute() != null && polygon.getFillColor() != null) {
						if (attributePolygonMap.containsKey(polygon.getAttribute())) {
							for (Iterator iter3 =
								((Collection) attributePolygonMap.get(polygon.getAttribute())).iterator();
								iter3.hasNext();
								) {
								Polygon polygon2 = (Polygon) iter3.next();
								if (polygon2.getFillColor() == null) {
									polygon2.setFillColor(polygon.getFillColor());
								}
							}
						}
					}
				}
			}
		}
		*/
		// ٤礦ݥꥴƱʤ顢Ƥɤʬ
		boolean isConflict = false;
		/*
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTyome()) {
				Map adjacentGraph = mapData.getAdjacentGraph();
				for (Iterator iter2 = mapData.getTyome().values().iterator(); iter2.hasNext();) {
					Polygon polygon = (Polygon) iter2.next();
					if (polygon.getFillColor() != null) {
						if (adjacentGraph.containsKey(polygon.getPolygonName())) {
							System.out.println(polygon + "ܤƤݥꥴ" + adjacentGraph.get(polygon.getPolygonName()));
							for (Iterator iter3 = ((Collection) adjacentGraph.get(polygon.getPolygonName())).iterator();
								iter3.hasNext();
								) {
								Polygon polygon2 = (Polygon) iter3.next();
								if (polygon2.getFillColor() != null) {
									if (polygon.getFillColor().equals(polygon2.getFillColor())) {
										System.out.println(polygon + "" + polygon2 + "ϾͤƤޤ");
										isConflict = true;
										while (iter3.hasNext()) {
											iter3.next();
										}
										while (iter2.hasNext()) {
											iter2.next();
										}
										while (iter.hasNext()) {
											iter.next();
										}
									}
								}
							}
						}
					}
				}
			}
		}
		*/
		//if (isConflict) {
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTyome()) {
				for (Iterator iter2 = mapData.getTyome().values().iterator(); iter2.hasNext();) {
					Polygon polygon = (Polygon) iter2.next();
					polygon.setFillColor(null);
				}
			}
		}
		//}
		// Polygon 򥭡Collection<Polygon> ͤȤ Map 
		Map adjacentGraph = new HashMap();
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTyome()) {
				Map adjacentPolygons = mapData.getAdjacentGraph();
				for(Iterator iter2 = adjacentPolygons.keySet().iterator(); iter2.hasNext();){
					String polygonName = (String)iter2.next();
					adjacentGraph.put(mapData.getTyome().get(polygonName), adjacentPolygons.get(polygonName));
				}
			}
		}
		// ɤʬ
		for (Iterator iter = maps.values().iterator(); iter.hasNext();) {
			MapData mapData = (MapData) iter.next();
			if (mapData.hasTyome()) {
				for (Iterator iter2 = mapData.getTyome().values().iterator(); iter2.hasNext();) {
					Polygon polygon = (Polygon) iter2.next();
					if (polygon.getPolygonName() != null) {
						fixColorRecursively(polygon, adjacentGraph, attributePolygonMap);
					}
				}
			}
		}
		panel.repaint();
	}

	/**
	 * ꤷݥꥴοƵŪ˷ꤷޤ
	 * red, green, blue, yellow, magenda, cyan ν˿ޤ 
	 * @param polygon ݥꥴ
	 * @param adjacentGraph ܥ
	 * @param attributePolygonMap °ȥݥꥴδϢŤ
	 */
	private void fixColorRecursively(Polygon polygon, Map adjacentGraph, Map attributePolygonMap) {
		if (polygon.getFillColor() != null) {
			return;
		}
		if (adjacentGraph.containsKey(polygon)) {
			Collection usedColors = new HashSet();
			if (adjacentGraph.containsKey(polygon)) {
				for (Iterator iter1 = ((Collection) adjacentGraph.get(polygon)).iterator();
					iter1.hasNext();
					) {
					Polygon polygon21 = (Polygon) iter1.next();
					Color color = polygon21.getFillColor();
					if (color != null) {
						usedColors.add(color);
					}
				}
			}
			if (!usedColors.contains(Color.RED)) {
				polygon.setFillColor(Color.RED);
			} else if (!usedColors.contains(Color.GREEN)) {
				polygon.setFillColor(Color.GREEN);
			} else if (!usedColors.contains(Color.BLUE)) {
				polygon.setFillColor(Color.BLUE);
			} else if (!usedColors.contains(Color.YELLOW)) {
				polygon.setFillColor(Color.YELLOW);
			} else if (!usedColors.contains(Color.MAGENTA)) {
				polygon.setFillColor(Color.MAGENTA);
			} else if (!usedColors.contains(Color.CYAN)) {
				polygon.setFillColor(Color.CYAN);
			} else {
				System.err.println(polygon + " Ͽ­ޤ");
			}
			for (Iterator iter = ((Collection) adjacentGraph.get(polygon)).iterator();
				iter.hasNext();
				) {
				Polygon polygon2 = (Polygon) iter.next();
				fixColorRecursively(polygon2, adjacentGraph, attributePolygonMap);
			}
		} else {
			polygon.setFillColor(Color.BLACK);
		}
	}

}
