import java.awt.geom.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

/*
 * : 2003/12/11
 */

/**
 * Ͽޥǡ򰷤饹Ǥ
 * @author Kumano Tatsuo
 */
class MapData {

	public static void main(String[] args) throws Exception {
		MapData mapData = new MapData("/home/kumano/map_data/suchi_chizu_2500/hyougo/", "05OF833");
		System.out.println(mapData.getGyousei());
		System.out.println(mapData.getSi_tyo());
		System.out.println(mapData.getTyome());
		System.out.println(mapData.getMizuArc());
		System.out.println(mapData.getMizu());
	}

	private String baseDir;
	private Map edgePolygons; // String -> String  Map
	private Map eki;
	private Map gyousei; // String  -> Arc  Map
	private String mapName;
	private Map mizu; // String -> Polygon  Map
	private Map mizuArc; // String -> Arc  Map
	private Map others; // String -> Arc  Map
	private Rectangle2D rectangle; // Ͽޤɽΰʲۺɸ
	private Map roadArc; // String -> Arc  Map
	private Map si_tyo; // String -> Polygon  Map
	private Map tatemono; // String -> Polygon  Map
	private Map tatemonoArc; // String -> Arc  Map
	private Map tyome; // String -> Polygon  Map
	private Map zyouti; // String -> Polygon  Map

	/**
	 * Ͽޤޤ
	 * @param baseDir ϿޥǡΤǥ쥯ȥ
	 * @param mapName Ͽޤ̾
	 */
	MapData(String baseDir, String mapName) throws Exception {
		setBaseDir(baseDir);
		setMapName(mapName);
		loadRectangle();
		edgePolygons = new HashMap();
	}

	void freeGyousei() {
		gyousei = null;
	}

	void freeMizu() {
		mizu = null;
	}

	void freeMizuArc() {
		mizuArc = null;
	}

	void freeOthers() {
		others = null;
	}

	void freeRoadArc() {
		roadArc = null;
	}

	void freeSi_tyo() {
		si_tyo = null;
	}

	void freeTatemono() {
		tatemono = null;
	}

	void freeTatemonoArc() {
		tatemonoArc = null;
	}

	void freeTyome() {
		tyome = null;
	}

	void freeZyouti() {
		zyouti = null;
	}

	/**
	 * @return
	 */
	String getBaseDir() {
		return baseDir;
	}

	/**
	 * @return
	 */
	Rectangle2D getBounds() {
		return rectangle;
	}

	/**
	 * ޳Ԥˤޤݥꥴΰޤ
	 * Map ΥϿ޳Ծʬʸɽ
	 * ͤϥݥꥴ̾Ǥ
	 * @return ޳Ԥˤޤݥꥴΰ
	 */
	Map getEdgePolygons() {
		return edgePolygons;
	}

	/**
	 * @return
	 */
	Map getGyousei() throws Exception {
		if (gyousei == null) {
			loadGyousei();
		}
		return gyousei;
	}

	/**
	 * @return
	 */
	String getMapName() {
		return mapName;
	}

	/**
	 * @return
	 */
	Map getMizu() throws Exception {
		if (mizu == null && mizuArc != null) {
			loadMizu();
		}
		return mizu;
	}

	/**
	 * @return
	 */
	Map getMizuArc() throws Exception {
		if (mizuArc == null) {
			loadMizuArc();
		}
		return mizuArc;
	}

	Map getOthers() throws Exception {
		if (others == null) {
			loadOthers();
		}
		return others;
	}

	Map getRoadArc() throws Exception {
		if (roadArc == null) {
			loadRoadArc();
		}
		return roadArc;
	}

	/**
	 * @return
	 */
	Map getSi_tyo() throws Exception {
		if (gyousei == null) {
			loadGyousei();
		}
		if (si_tyo == null) {
			loadSi_tyo();
		}
		return si_tyo;
	}

	Map getTatemono() throws Exception {
		if (tatemonoArc == null) {
			loadTatemonoArc();
		}
		if (tatemono == null) {
			loadTatemono();
		}
		return tatemono;
	}

	Map getTatemonoArc() throws Exception {
		if (tatemonoArc == null) {
			loadTatemonoArc();
		}
		return tatemonoArc;
	}

	/**
	 * @return
	 */
	Map getTyome() throws Exception {
		if (gyousei == null) {
			loadGyousei();
		}
		if (tyome == null) {
			loadTyome();
		}
		return tyome;
	}

	Map getZyouti() throws Exception {
		if (others == null) {
			loadOthers();
		}
		if (zyouti == null) {
			loadZyouti();
		}
		return zyouti;
	}

	boolean hasGyousei() {
		return gyousei != null;
	}

	boolean hasMizu() {
		return mizu != null;
	}

	boolean hasMizuArc() {
		return mizuArc != null;
	}

	boolean hasOthers() {
		return others != null;
	}

	boolean hasRoadArc() {
		return roadArc != null;
	}

	boolean hasSi_tyo() {
		return si_tyo != null;
	}

	boolean hasTatemono() {
		return tatemono != null;
	}

	boolean hasTatemonoArc() {
		return tatemonoArc != null;
	}

	boolean hasTyome() {
		return tyome != null;
	}

	boolean hasZyouti() {
		return zyouti != null;
	}

	/**
	 * ̤ξե뤫ɤ߹ߤޤ
	 * @param arcs 
	 * @param in ϥȥ꡼
	 * @throws IOException
	 */
	private void loadArc(Map arcs, BufferedReader in) throws IOException {
		String line;
		String arcName = null;
		int type = 0;
		int tag = 0;
		GeneralPath path = null;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 4) {
				// ̤ϤޤȤ
				if (path != null) {
					arcs.put(arcName, new Arc(arcName, path, type, tag));
				}
				String code = tokenizer.nextToken(); // ޼ʬॳ
				if (code.equals("L1101")) {
					type = Arc.TYPE_GYOUSEI_PREFECTURE;
				} else if (code.equals("L1103")) {
					type = Arc.TYPE_GYOUSEI_CITY;
				} else if (code.equals("L1104")) {
					type = Arc.TYPE_GYOUSEI_VILLAGE;
				} else if (code.equals("L1106")) {
					type = Arc.TYPE_GYOUSEI_CHOME;
				} else if (code.equals("L2300")) {
					type = Arc.TYPE_RAILWAY;
				} else if (code.equals("L2110")) {
					type = Arc.TYPE_ROAD;
				} else if (code.equals("L6241")) {
					type = Arc.TYPE_ZYOTI_RAILROAD;
				} else if (code.equals("L6242")) {
					type = Arc.TYPE_ZYOTI_PARK;
				} else if (code.equals("L6243")) {
					type = Arc.TYPE_ZYOTI_SCHOOL;
				} else if (code.equals("L6244")) {
					type = Arc.TYPE_ZYOTI_TEMPLE;
				} else if (code.equals("L6215")) {
					type = Arc.TYPE_ZYOTI_GRAVEYARD;
				} else if (code.equals("L6200")) {
					type = Arc.TYPE_ZYOTI_OTHER;
				} else if (code.equals("L5101")) {
					type = Arc.TYPE_MIZU_INSIDE;
				} else if (code.equals("L5106")) {
					type = Arc.TYPE_MIZU_SEASHORE;
				} else {
					type = Arc.TYPE_UNKNOWN;
				}
				tag = Integer.parseInt(tokenizer.nextToken()); // 勵
				arcName = tokenizer.nextToken(); // ֹ
				path = null;
			} else if (tokenizer.countTokens() == 2) {
				// ̤ɸΤȤ
				float y = -Float.parseFloat(tokenizer.nextToken()); // y ɸ
				float x = Float.parseFloat(tokenizer.nextToken()); // x ɸ
				if (path != null) {
					path.lineTo(x + (float) getBounds().getX(), y + (float) getBounds().getMaxY());
				} else {
					path = new GeneralPath();
					path.moveTo(x + (float) getBounds().getX(), y + (float) getBounds().getMaxY());
				}
			}
		}
		if (path != null) {
			arcs.put(arcName, new Arc(arcName, path, type, tag));
		}
	}

	/**
	 * θ̥եɤ߹ߤޤ
	 * @throws Exception
	 */
	void loadGyousei() throws Exception {
		String fileName =
			baseDir
				+ File.separator
				+ mapName.toUpperCase()
				+ File.separator
				+ "gyousei"
				+ File.separator
				+ "gyousei.arc";
		gyousei = new HashMap();
		if (new File(fileName).canRead()) {
			loadArc(gyousei, new BufferedReader(new InputStreamReader(new FileInputStream(fileName))));
		}
	}

	/**
	 * ̤Υݥꥴեɤ߹ߤޤ
	 * @throws Exception
	 */
	void loadMizu() throws Exception {
		String polygonFileName =
			baseDir + File.separator + mapName.toUpperCase() + File.separator + "mizu" + File.separator + "mizu.pgn";
		if (new File(polygonFileName).canRead()) {
			mizu = new HashMap();
			loadPolygon(mizu, mizuArc, new BufferedReader(new InputStreamReader(new FileInputStream(polygonFileName))));
			String attributeFileName =
				baseDir
					+ File.separator
					+ mapName.toUpperCase()
					+ File.separator
					+ "mizu"
					+ File.separator
					+ "mizu.atr";
			if (new File(attributeFileName).canRead()) {
				loadPolygonAttribute(
					mizu,
					new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")));
			}
		}
	}

	/**
	 * 峦θ̥եɤ߹ߤޤ
	 * @throws Exception
	 */
	void loadMizuArc() throws Exception {
		String fileName =
			baseDir + File.separator + mapName.toUpperCase() + File.separator + "mizu" + File.separator + "mizu.arc";
		if (new File(fileName).canRead()) {
			mizuArc = new HashMap();
			loadArc(mizuArc, new BufferedReader(new InputStreamReader(new FileInputStream(fileName))));
		}
	}

	void loadOthers() throws Exception {
		others = new HashMap();
		BufferedReader in =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ "others"
							+ File.separator
							+ "others.arc")));
		loadArc(others, in);
	}

	/**
	 * ݥꥴξե뤫ɤ߹ߤޤ
	 * @param polygons ݥꥴ
	 * @param ars ݥꥴ
	 * @param in ϥȥ꡼
	 * @throws IOException
	 */
	private void loadPolygon(Map polygons, Map arcs, BufferedReader in) throws IOException {
		String line;
		String polygonName = null;
		GeneralPath path = null;
		int type = 0;
		double x = 0;
		double y = 0;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 5) {
				// ݥꥴ󤬻ϤޤȤ
				if (path != null) {
					polygons.put(
						polygonName,
						new Polygon(polygonName, path, type, x + getBounds().getX(), y + getBounds().getMaxY()));
				}
				type = parsePolygonType(tokenizer.nextToken()); // ޼ʬॳ
				polygonName = tokenizer.nextToken(); // ֹ
				tokenizer.nextToken(); // ݥꥴ륢쥳ɤο
				y = -Double.parseDouble(tokenizer.nextToken()); // ɽ y ɸ
				x = Double.parseDouble(tokenizer.nextToken()); // ɽ x ɸ
				path = new GeneralPath();
			} else if (tokenizer.countTokens() == 1) {
				// ݥꥴ̤ΤȤ
				int arcIndex = Integer.parseInt(tokenizer.nextToken()); // 쥳
				String arcName = new Integer(Math.abs(arcIndex)).toString();
				Arc arc = ((Arc) arcs.get(arcName));
				if (arcIndex < 0) {
					path.append(arc.getReversalPath(), true);
				} else {
					path.append(arc.getPath(), true);
				}
				if (arc.getTag() == Arc.TAG_EDGE_OF_MAP) {
					PathIterator iter = arc.getPath().getPathIterator(new AffineTransform());
					double[] coords = new double[6];
					iter.currentSegment(coords);
					int x1 = (int) coords[0];
					int y1 = (int) coords[1];
					if (!iter.isDone()) {
						iter.next();
						if (iter.currentSegment(coords) == PathIterator.SEG_LINETO) {
							int x2 = (int) coords[0];
							int y2 = (int) coords[1];
							if (x1 < x2 || y1 < y2) {
								edgePolygons.put(x1 + "_" + y1 + "_" + x2 + "_" + y2, polygonName);
							} else {
								edgePolygons.put(x2 + "_" + y2 + "_" + x1 + "_" + y1, polygonName);
							}
							if (!iter.isDone()) {
								iter.next();
								if (iter.currentSegment(coords) == PathIterator.SEG_LINETO) {
									int x3 = (int) coords[0];
									int y3 = (int) coords[1];
									if (x2 < x3 || y2 < y3) {
										edgePolygons.put(x2 + "_" + y2 + "_" + x3 + "_" + y3, polygonName);
									} else {
										edgePolygons.put(x3 + "_" + y3 + "_" + x2 + "_" + y2, polygonName);
									}
									if (!iter.isDone()) {
										iter.next();
										if (iter.currentSegment(coords) == PathIterator.SEG_LINETO) {
											int x4 = (int) coords[0];
											int y4 = (int) coords[1];
											if (x3 < x4 || y3 < y4) {
												edgePolygons.put(x3 + "_" + y3 + "_" + x4 + "_" + y4, polygonName);
											} else {
												edgePolygons.put(x4 + "_" + y4 + "_" + x3 + "_" + y3, polygonName);
											}
										}
									}
								}
							}
						}
					}
				}
			}
			polygons.put(
				polygonName,
				new Polygon(polygonName, path, type, x + getBounds().getX(), y + getBounds().getMaxY()));
		}
	}

	/**
	 * ݥꥴ°ե뤫ɤ߹ߤޤ
	 * @param polygons ݥꥴ
	 * @param in ϥȥ꡼
	 * @throws IOException
	 */
	private void loadPolygonAttribute(Map polygons, BufferedReader in) throws IOException {
		String line;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() > 0) {
				String firstToken = tokenizer.nextToken(); // FHor ޼ʬॳ
				if (!firstToken.equals("FH")) {
					// °쥳ɤΤȤ
					int type = parsePolygonType(firstToken);
					String polygonName = tokenizer.nextToken(); // ֹ
					StringBuffer stringBuffer = new StringBuffer();
					while (tokenizer.hasMoreTokens()) {
						stringBuffer.append(tokenizer.nextToken()); // °ե
					}
					String attribute = stringBuffer.toString();
					attribute = Pattern.compile("^[0-9]+").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("ϻ$").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("Ȭ$").matcher(attribute).replaceFirst("");
					attribute = Pattern.compile("$").matcher(attribute).replaceFirst("");
					((Polygon) polygons.get(polygonName)).setAttribute(attribute);
				}
			}
		}
	}

	/**
	 * Ͽޤΰե뤫ɤ߹ߤޤ
	 */
	private void loadRectangle() throws Exception {
		BufferedReader in =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ mapName.toLowerCase()
							+ ".txt")));
		String line;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 10) {
				tokenizer.nextToken();
				double y2 = -Double.parseDouble(tokenizer.nextToken());
				double x1 = Double.parseDouble(tokenizer.nextToken());
				double y1 = -Double.parseDouble(tokenizer.nextToken());
				double x2 = Double.parseDouble(tokenizer.nextToken());
				setRectangle(new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1));
				break;
			}
		}
		in.close();
	}

	void loadRoadArc() throws Exception {
		String fileName =
			baseDir
				+ File.separator
				+ mapName.toUpperCase()
				+ File.separator
				+ "road"
				+ File.separator
				+ "roadntwk.arc";
		if (new File(fileName).canRead()) {
			roadArc = new HashMap();
			loadArc(roadArc, new BufferedReader(new InputStreamReader(new FileInputStream(fileName))));
		}
	}

	/**
	 * ĮΥݥꥴեɤ߹ߤޤ
	 * @throws Exception
	 */
	void loadSi_tyo() throws Exception {
		String polygonFileName =
			baseDir
				+ File.separator
				+ mapName.toUpperCase()
				+ File.separator
				+ "gyousei"
				+ File.separator
				+ "si_tyo.pgn";
		if (new File(polygonFileName).canRead()) {
			si_tyo = new HashMap();
			loadPolygon(
				si_tyo,
				gyousei,
				new BufferedReader(new InputStreamReader(new FileInputStream(polygonFileName))));
			String attributeFileName =
				baseDir
					+ File.separator
					+ mapName.toUpperCase()
					+ File.separator
					+ "gyousei"
					+ File.separator
					+ "si_tyo.atr";
			if (new File(attributeFileName).canRead()) {
				loadPolygonAttribute(
					si_tyo,
					new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")));
			}
		}
	}

	/**
	 * ʪΥݥꥴեɤ߹ߤޤ
	 * @throws Exception
	 */
	void loadTatemono() throws Exception {
		String polygonFileName =
			baseDir
				+ File.separator
				+ mapName.toUpperCase()
				+ File.separator
				+ "tatemono"
				+ File.separator
				+ "tatemono.pgn";
		if (new File(polygonFileName).canRead()) {
			tatemono = new HashMap();
			loadPolygon(
				tatemono,
				tatemonoArc,
				new BufferedReader(new InputStreamReader(new FileInputStream(polygonFileName))));
			String attributeFileName =
				baseDir
					+ File.separator
					+ mapName.toUpperCase()
					+ File.separator
					+ "tatemono"
					+ File.separator
					+ "tatemono.atr";
			if (new File(attributeFileName).canRead()) {
				loadPolygonAttribute(
					tatemono,
					new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")));
			}
		}
	}

	/**
	 * ʪθ̥եɤ߹ߤޤ
	 * @throws Exception
	 */
	void loadTatemonoArc() throws Exception {
		String fileName =
			baseDir
				+ File.separator
				+ mapName.toUpperCase()
				+ File.separator
				+ "tatemono"
				+ File.separator
				+ "tatemono.arc";
		if (new File(fileName).canRead()) {
			tatemonoArc = new HashMap();
			loadArc(tatemonoArc, new BufferedReader(new InputStreamReader(new FileInputStream(fileName))));
		}
	}

	/**
	 * ܳΥݥꥴեɤ߹ߤޤ
	 * @throws Exception
	 */
	void loadTyome() throws Exception {
		tyome = new HashMap();
		BufferedReader in1 =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ "gyousei"
							+ File.separator
							+ "tyome.pgn")));
		loadPolygon(tyome, gyousei, in1);
		BufferedReader in2 =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ "gyousei"
							+ File.separator
							+ "tyome.atr"),
					"SJIS"));
		loadPolygonAttribute(tyome, in2);
	}

	void loadZyouti() throws Exception {
		String polygonFileName =
			baseDir
				+ File.separator
				+ mapName.toUpperCase()
				+ File.separator
				+ "others"
				+ File.separator
				+ "zyouti.pgn";
		if (new File(polygonFileName).canRead()) {
			zyouti = new HashMap();
			loadPolygon(
				zyouti,
				others,
				new BufferedReader(new InputStreamReader(new FileInputStream(polygonFileName))));
			String attributeFileName =
				baseDir
					+ File.separator
					+ mapName.toUpperCase()
					+ File.separator
					+ "others"
					+ File.separator
					+ "zyouti.atr";
			if (new File(attributeFileName).canRead()) {
				loadPolygonAttribute(
					zyouti,
					new BufferedReader(new InputStreamReader(new FileInputStream(attributeFileName), "SJIS")));
			}
		}
	}

	/**
	 * ݥꥴο޼ʬॳɤѴޤ
	 * @param code ޼ʬॳ
	 * @return 
	 */
	private int parsePolygonType(String code) {
		if (code.equals("A1105")) {
			return Polygon.TYPE_SHI_KU_CHO_SON;
		} else if (code.equals("A1106")) {
			return Polygon.TYPE_OAZA_CHOME;
		} else if (code.equals("A6241")) {
			return Polygon.TYPE_RAILROAD;
		} else if (code.equals("A6242")) {
			return Polygon.TYPE_PARK;
		} else if (code.equals("A6243")) {
			return Polygon.TYPE_SCHOOL;
		} else if (code.equals("A6244")) {
			return Polygon.TYPE_TEMPLE;
		} else if (code.equals("A6215")) {
			return Polygon.TYPE_GRAVEYARD;
		} else if (code.equals("A6200")) {
			return Polygon.TYPE_OTHER;
		} else if (code.equals("A5101")) {
			return Polygon.TYPE_RIVER;
		} else if (code.equals("A5105")) {
			return Polygon.TYPE_LAKE;
		} else if (code.equals("A3500")) {
			return Polygon.TYPE_BUILDING;
		} else {
			return Polygon.TYPE_UNKNOWN;
		}
	}

	/**
	 * @param string
	 */
	private void setBaseDir(String string) {
		baseDir = string;
	}

	/**
	 * @param string
	 */
	private void setMapName(String string) {
		mapName = string;
	}

	/**
	 * @param rectangle2D
	 */
	private void setRectangle(Rectangle2D rectangle2D) {
		rectangle = rectangle2D;
	}

	public String toString() {
		return "[MapData name=" + mapName + ", gyousei=" + gyousei + "]";
	}

}
