import java.awt.*;
import java.awt.geom.*;
/**
 * ٥դ2ʿ̾ɽ饹Ǥ
 */
public class DrawablePoint extends Point2D.Double implements Drawable, Shape, Comparable {
	/**
	 * ƥѤΥ᥽åɤǤ
	 * @param args ޥɥ饤
	 */
	public static void main(String[] args) {
	}
	private Color borderColor;
	private Color fillColor;
	private Ellipse2D ellipse;
	private Font font;
	private String label;
	private Point2D labelLocation;
	private double pointSize;
	private int zOrder;
	/**
	 * ɸ֤θ (0, 0) ˥٥ʤۤƽޤ
	 */
	public DrawablePoint() {
		super(0, 0);
		setLabel("");
		setLabelLocation(new Point2D.Double(0, 0));
		setSize(4);
		setZOrder(0);
		setBorderColor(Color.BLACK);
		setFillColor(Color.BLACK);		setAlpha(1);

	}
	/**
	 * ɸ֤λꤵ줿 (x y) ۤƽޤ
	 * @param x x ɸ
	 * @param y y ɸ
	 */
	public DrawablePoint(double x, double y) {
		super(x, y);
		setLabel("");
		setLabelLocation(new Point2D.Double(x, y));
		setSize(4);
		setZOrder(0);
		setBorderColor(Color.BLACK);
		setFillColor(Color.BLACK);		setAlpha(1);

	}
	/* ( Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		if (getZOrder() == ((Drawable)o).getZOrder()) {
			return hashCode() - o.hashCode();
		} else {
			return getZOrder() - ((Drawable)o).getZOrder();
		}
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#contains(double, double)
	 */
	public boolean contains(double x, double y) {
		if (x == this.x && y == this.y) {
			return true;
		} else {
			return false;
		}
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#contains(double, double, double, double)
	 */
	public boolean contains(double x, double y, double w, double h) {
		return false;
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#contains(java.awt.geom.Point2D)
	 */
	public boolean contains(Point2D p) {
		return contains(p.getX(), p.getY());
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#contains(java.awt.geom.Rectangle2D)
	 */
	public boolean contains(Rectangle2D r) {
		return false;
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#getBounds()
	 */
	public Rectangle getBounds() {
		return new Rectangle((int)x, (int)y, 0, 0);
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#getBounds2D()
	 */
	public Rectangle2D getBounds2D() {
		return new Rectangle2D.Double(x, y, 0, 0);
	}
	/**
	 * @return
	 */
	public Font getFont() {
		return font;
	}
	/**
	 * Υ٥֤ޤ
	 * @return ٥
	 */
	public String getLabel() {
		return label;
	}
	/* ( Javadoc)
	 * @see Drawable#getLabelLocation()
	 */
	public Point2D getLabelLocation() {
		return labelLocation;
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#getPathIterator(java.awt.geom.AffineTransform)
	 */
	public PathIterator getPathIterator(AffineTransform at) {
		return ellipse.getPathIterator(at);
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#getPathIterator(java.awt.geom.AffineTransform, double)
	 */
	public PathIterator getPathIterator(AffineTransform at, double flatness) {
		return ellipse.getPathIterator(at, flatness);
	}
	/**
	 * @return
	 */
	public double getPointSize() {
		return pointSize;
	}
	/* ( Javadoc)
	 * @see Drawable#getZOrder()
	 */
	public int getZOrder() {
		return this.zOrder;
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#intersects(double, double, double, double)
	 */
	public boolean intersects(double x, double y, double w, double h) {
		if (x <= this.x && this.x <= x + w && y <= this.y && this.y <= y + h) {
			return true;
		} else {
			return false;
		}
	}
	/* ( Javadoc)
	 * @see java.awt.Shape#intersects(java.awt.geom.Rectangle2D)
	 */
	public boolean intersects(Rectangle2D r) {
		return intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
	}
	/**
	 * @param font
	 */
	public void setFont(Font font) {
		this.font = font;
	}
	/**
	 * Υ٥򡢻ꤵ줿ʸꤷޤ
	 * @param label ٥
	 */
	public void setLabel(String label) {
		this.label = label;
	}
	/* ( Javadoc)
	 * @see Drawable#setLabelLocation(java.awt.geom.Point2D)
	 */
	public void setLabelLocation(Point2D location) {
		labelLocation = location;
	}
	/* ( Javadoc)
	 * @see java.awt.geom.Point2D#setLocation(double, double)
	 */
	public void setLocation(double x, double y) {
		super.setLocation(x, y);
		setSize(pointSize);
	}
	/**
	 * @param d
	 */
	public void setSize(double d) {
		pointSize = d;
		ellipse = new Ellipse2D.Double(x - d / 2, y - d / 2, d, d);
	}
	/* ( Javadoc)
	 * @see Drawable#setZOrder(int)
	 */
	public void setZOrder(int zOrder) {
		this.zOrder = zOrder;
	}
	/**
	 * ʸɽ֤ޤ
	 */
	public String toString() {
		return "(" + x + ", " + y + ")[" + label + "]";
	}
	public Color getBorderColor() {
		return this.borderColor;
	}
	public Color getFillColor() {
		return this.fillColor;
	}
	public void setBorderColor(Color color) {
		this.borderColor = color;
	}
	public void setFillColor(Color color) {
		this.fillColor = color;
	}
	private double alpha;
	public double getAlpha() {
		return alpha;
	}
	public void setAlpha(double d) {
		alpha = d;
	}
}
