// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_4 $
// $Id: imkit_qlineedit.h,v 1.16 2002/08/07 07:08:55 yamaken Exp $

#ifndef IMKIT_QLINEEDIT_H
#define IMKIT_QLINEEDIT_H

#include <vector>
#include <qfontmetrics.h>
#include "keyfilter.h"


class IMKitQFontMetrics : public QFontMetrics {
public:
  IMKitQFontMetrics(const QFont &font_init);
  IMKitQFontMetrics(const QFontMetrics &orig);
  int width(const QString &str, int len = -1) const;
  int width(QChar ch) const;
  int width(char c) const;
};


//̤Preedit widget(饤)ήѤǤ褦
//IMKitQLineEditʬΥƤ
class SegmentedStringDrawer {

protected:
  QWidget &widget;
  QPixmap *pixmap;
  QPainter *painter;
  const QColorGroup &g;
  IMKitQFontMetrics fm;
  QString separator;
  int str_offset, y;

protected:
  static vector<QString *> split_string(const QString &sep,
                                        const QString &str);

  virtual void init_state(void);
  virtual bool intersects_pixmap(int w);
  virtual QColor separator_color(void);
  virtual int focused_segment(const QString &str, int focus_begin);

public:
  SegmentedStringDrawer(QWidget &widget_init, QPixmap *pixmap_init,
                        QPainter *painter_init,
                        const QString &separator_init,
                        int str_offset_init = 0);
  virtual ~SegmentedStringDrawer(void);
  virtual void prepare(QPixmap *new_pixmap, QPainter *new_painter,
                       int new_str_offset);
  virtual int separator_width(void) const;
  virtual int draw_segments(const QString &str, const QColor &color,
                            int focus_begin, QRect &focus);
  virtual QRect draw_string(const QString &str, const QColor &color,
                            bool focused);
  virtual int draw_separator(const QColor &color);
};


//copied from qt-embedded-2.3.3/src/widgets/qlineedit.h
//and modified under the terms of the GPL2
//{

struct IMKitQLineEditPrivate;

class QComboBox;
class QValidator;


#ifndef QT_H
#include "qwidget.h"
#include "qstring.h"
#endif // QT_H

#ifndef QT_NO_LINEEDIT

class Q_EXPORT IMKitQLineEdit : public QWidget
{
    Q_OBJECT
    Q_ENUMS( EchoMode )
    Q_PROPERTY( QString text READ text WRITE setText )
    Q_PROPERTY( int maxLength READ maxLength WRITE setMaxLength )
    Q_PROPERTY( bool frame READ frame WRITE setFrame )
    Q_PROPERTY( EchoMode echoMode READ echoMode WRITE setEchoMode )
    Q_PROPERTY( QString displayText READ displayText )
    Q_PROPERTY( int cursorPosition READ cursorPosition WRITE setCursorPosition )
    Q_PROPERTY( Alignment alignment READ alignment WRITE setAlignment )
    Q_PROPERTY( bool edited READ edited WRITE setEdited )
    Q_PROPERTY( bool hasMarkedText READ hasMarkedText )
    Q_PROPERTY( QString markedText READ markedText )
	
public:
    IMKitQLineEdit( QWidget *parent, const char *name=0 );
    IMKitQLineEdit( const QString &, QWidget *parent, const char *name=0 );
   ~IMKitQLineEdit();

    QString text() const;

    QString displayText() const;

    int		maxLength()	const;
    virtual void setMaxLength( int );

    virtual void setFrame( bool );
    bool	frame() const;

    enum	EchoMode { Normal, NoEcho, Password };
    virtual void setEchoMode( EchoMode );
    EchoMode 	echoMode() const;
#if QT_VERSION >= 300
#error "Make setReadOnly virtual"
#endif
    void setReadOnly( bool );
    bool isReadOnly() const;

    virtual void setValidator( const QValidator * );
    const QValidator * validator() const;

    QSize	sizeHint() const;
    QSize	minimumSizeHint() const;
    QSizePolicy sizePolicy() const;

    virtual void setEnabled( bool );
    virtual void setFont( const QFont & );
    virtual void setPalette( const QPalette & );
    virtual void setSelection( int, int );

    virtual void setCursorPosition( int );
    int		cursorPosition() const;

    bool	validateAndSet( const QString &, int, int, int );

#ifndef QT_NO_CLIPBOARD
    void	cut();
    void	copy() const;
    void	paste();
#endif

    void setAlignment( int flag );
    int alignment() const;

    void	cursorLeft( bool mark, int steps = 1 );
    void	cursorRight( bool mark, int steps = 1 );
    void	cursorWordForward( bool mark );
    void	cursorWordBackward( bool mark );
    void	backspace();
    void	del();
    void	home( bool mark );
    void	end( bool mark );

    void	setEdited( bool );
    bool	edited() const;

    bool	hasMarkedText() const;
    QString	markedText() const;
#if defined(Q_INCOMPATIBLE_3_0_ADDONS)
    bool 	getSelection( int *start, int *end );
    void 	setPasswordChar( QChar c );
    QChar 	passwordChar() const;
#endif    

public slots:
    virtual void setText( const QString &);

    void	selectAll();
    void	deselect();

    void	clearValidator();

    void	insert( const QString &);

    void	clear();

signals:
    void	textChanged( const QString &);
    void	returnPressed();
    void        selected(const QRect &selection);  //added for IMKit

protected:
    bool	event( QEvent * );
    void	mousePressEvent( QMouseEvent * );
    void	mouseMoveEvent( QMouseEvent * );
    void	mouseReleaseEvent( QMouseEvent * );
    void	mouseDoubleClickEvent( QMouseEvent * );
    void	keyPressEvent( QKeyEvent * );
    void	focusInEvent( QFocusEvent * );
    void	focusOutEvent( QFocusEvent * );
    void	paintEvent( QPaintEvent * );
    void	resizeEvent( QResizeEvent * );
    void	leaveEvent( QEvent * );
//#ifndef QT_NO_DRAGANDDROP
//    void	dragEnterEvent( QDragEnterEvent * );
//    void	dropEvent( QDropEvent * );
//#endif

    void	repaintArea( int, int );
    const QString &separator_str(void);  //added for IMKit

private slots:
    void	clipboardChanged();
    void	blinkSlot();
    void	dragScrollSlot();
//#ifndef QT_NO_DRAGANDDROP
//    void 	doDrag();
//#endif

private:
    // kept
    void	newMark( int pos, bool copy=TRUE );
    void	markWord( int pos );
    int		lastCharVisible() const;
    int		minMark() const;
    int		maxMark() const;
    int		frameW() const;

    void	init();

    QString	tbuf;
    IMKitQLineEditPrivate * d;
    int		cursorPos;
    int		offset;
    int		maxLen;
    int		markAnchor;
    int		markDrag;
    bool	cursorOn;
    bool	dragScrolling;
    bool	scrollingLeft;
    int		alignmentFlag;
    bool	ed;

    void updateOffset();
    int xPosToCursorPos( int ) const;
    void blinkOn();
    void makePixmap() const;
    void undoInternal();
    void redoInternal();

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
    IMKitQLineEdit( const IMKitQLineEdit & );
    IMKitQLineEdit &operator=( const IMKitQLineEdit & );
#endif
};

#endif // QT_NO_LINEEDIT

//} copied from qt-embedded-2.3.3/src/widgets/qlineedit.h
//and modified under the terms of the GPL2

#endif  //IMKIT_QLINEEDIT_H
