// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_4 $
// $Id: imkit_anthy_qpe.cpp,v 1.42 2002/08/07 07:08:54 yamaken Exp $

#include <qwidget.h>
#include <qhbox.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qpixmap.h>
#include <qtranslator.h>
#include <qapplication.h>
#include <qpe/inputmethodinterface.h>
#include <qpe/qpeapplication.h>
#include "keyfilter.h"
#include "engine_anthy.h"
#include "ui_anthy.h"
#include "imkit_qlineedit.h"
#include "imwidget.h"
#include "imwidget_std.h"
#include "platform_qpe.h"


#ifdef IMKIT_USE_TEMPLATE_QOBJECT
typedef QWidgetWithActivationSignal<QHBox> AnthyWidget;
#else  //IMKIT_USE_TEMPLATE_QOBJECT
typedef StdIMWidget AnthyWidget;
#endif  //IMKIT_USE_TEMPLATE_QOBJECT

static QListBox *create_candidate_window_widget(QWidget *parent,
                                                const char *name);
static QWidget *create_imwidget(QWidget *parent, Qt::WFlags flags,
                                Preedit *preedit,
                                InputMapIndicator *indicator,
                                CandidateWindow *cand_win);
static IMUserInterface *create_custom_anthy_ui(void);
static QPixmap *create_icon(void);

static const char *anthy_icon_xpm[];


//TODO: Anthy򤵤Ƥǧ䤹Τѹ
static const char *anthy_icon_xpm[] = {
"28 14 2 1",
"# c #000000",
". c None",
".........##..##.##..........",
"..........##.##.##..........",
"..........###########.......",
".......##....##.##..........",
"........##..########........",
"........##..##.##.##........",
"............########........",
".........##....##...........",
".........##.########........",
".........##....##...........",
"........##.##########.......",
"........##....##.#..........",
".......##....##..##.........",
".......##..###....###......."
};


static QListBox *
create_candidate_window_widget(QWidget *parent, const char *name) {
  QListBox *widget;

  widget = new QListBox(parent, name,
                        Qt::WType_TopLevel
                        | Qt::WStyle_Customize
                        | Qt::WStyle_NoBorderEx
                        | Qt::WStyle_StaysOnTop
                        );
  widget->setVScrollBarMode(QListBox::AlwaysOn);
  widget->setSelectionMode(QListBox::Single);
  widget->setColumnMode(1);
  widget->setResizePolicy(QListBox::AutoOneFit);

  return widget;
}

static QWidget *
create_imwidget(QWidget *parent, Qt::WFlags flags,
                Preedit *preedit, InputMapIndicator *indicator,
                CandidateWindow *cand_win)
{
  QWidget *imwidget;
  IMKitQLineEdit *preedit_widget;
  PreeditWidget *abstract_preedit_widget;
  QListBox *cand_win_widget;
  CandidateWindowWidget *abstract_cand_win_widget;
  QComboBox *indicator_widget;
  InputMapIndicatorWidget *abstract_indicator_widget;
  StdInputMapIndicator *typed_indicator;

  //TODO: StdInputMapIndicator
  typed_indicator = (StdInputMapIndicator *)indicator;
  imwidget = new AnthyWidget(parent, "IMWidget", flags);

  preedit_widget = new IMKitQLineEdit(imwidget, "Preedit");
  abstract_preedit_widget
    = new PreeditWidgetAbstractor<IMKitQLineEdit>(preedit_widget);

  indicator_widget = new QComboBox(imwidget, "MapIndicator");
  abstract_indicator_widget
    = new InputMapIndicatorWidgetAbstractor<QComboBox>(indicator_widget);

  cand_win_widget
    = create_candidate_window_widget(preedit_widget, "CandidateWindow");
  abstract_cand_win_widget
    = new CandidateWindowWidgetAbstractor<QListBox>(cand_win_widget);

  preedit->set_widget(abstract_preedit_widget);
  indicator->set_widget(abstract_indicator_widget);
  cand_win->set_widget(abstract_cand_win_widget);

  typed_indicator->add_state(IMKIT_INPUT_MAP_HIRAGANA,
                             StdInputMapIndicator::tr("hira"));
  typed_indicator->add_state(IMKIT_INPUT_MAP_KATAKANA,
                             StdInputMapIndicator::tr("kata"));
  typed_indicator->add_state(IMKIT_INPUT_MAP_ALPHA,
                             StdInputMapIndicator::tr("alnm"));
  typed_indicator->add_state(IMKIT_INPUT_MAP_WALPHA,
                             StdInputMapIndicator::tr("walnm"));

  indicator_widget->adjustSize();

  return imwidget;
}

static IMUserInterface *
create_custom_anthy_ui(void) {
  AnthyEngine *engine;
  IMUserInterface *anthy_ui;
  Preedit *preedit;
  InputMapIndicator *indicator;
  CandidateWindow *cand_win;

  engine = new AnthyEngine;
  preedit = new StdPreedit(QChar(IMKIT_NON_UNICODE_CHAR));
  indicator = new StdInputMapIndicator;
  cand_win = new StdCandidateWindow;
  
  anthy_ui
    = new AnthyGUI(engine, preedit, indicator, cand_win, &create_imwidget);

  return anthy_ui;
}

static QPixmap *
create_icon(void) {
  QPixmap *icon;

  icon = new QPixmap((const char **)anthy_icon_xpm);

  return icon;
}

//TODO: platform_qpe.*˼ץɤư
Q_EXPORT_INTERFACE() {
  IMUserInterface *ui;
  IMKitImpl *instance;
  QUnknownInterface *iface = 0;

  ui = create_custom_anthy_ui();

  //Q_CREATE_INSTANCE(IMKitImpl(ui, icon))
  instance = new IMKitImpl(ui, create_icon());
  instance->queryInterface(IID_QUnknown, &iface);

#ifdef IMKIT_MISSING_TRANSLATION_SETUP
  //CVSQtopiaˤϥɤޤޤƤ뤬widgetload
  //Τǵǽʤ

  QTranslator *trans = new QTranslator(qApp);
  QString tfn = QPEApplication::qpeDir() + "/i18n/ja/libimkit-anthy.qm";
  if (trans->load(tfn)) {
    qApp->installTranslator(trans);
  } else {
    delete trans;
  }
#endif

  return iface;
}
