// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_ANTHY_0_3_4 $
// $Id: engine.h,v 1.7 2002/07/12 11:51:46 yamaken Exp $

#ifndef IMKIT_ENGINE_H
#define IMKIT_ENGINE_H

#include <vector>
#include <qobject.h>
#include "keyfilter.h"

#define IMKIT_ENUM_TERMINATOR 0

class QString;
class Segment;
class Candidate;

typedef vector<Segment *> Segments;
typedef vector<Candidate *> Candidates;

class Segment {
public:
  enum Type {
    IMKIT_SEG_NORMAL,
    IMKIT_SEG_EDITING,
    IMKIT_SEG_PENDING,
    IMKIT_SEG_CURSOR,
    IMKIT_SEG_FOCUS,
  };

public:
  virtual ~Segment(void);
  virtual const QString &str(void) = 0;
  virtual Type type(void) const = 0;
};


class Candidate {
public:
  virtual ~Candidate(void);
  virtual const QString &str(void) = 0;
};


enum PreeditState {
  IMKIT_PREEDIT_ST_TERM = IMKIT_ENUM_TERMINATOR,
  IMKIT_PREEDIT_ST_NONE,
  IMKIT_PREEDIT_ST_EDIT,
  IMKIT_PREEDIT_ST_CONV,
  IMKIT_PREEDIT_ST_CSEG,
};

enum InputMap {
  IMKIT_INPUT_MAP_TERM = IMKIT_ENUM_TERMINATOR,
  IMKIT_INPUT_MAP_ALPHA,
  IMKIT_INPUT_MAP_WALPHA,
  IMKIT_INPUT_MAP_HIRAGANA,
  IMKIT_INPUT_MAP_KATAKANA,
  IMKIT_INPUT_MAP_HKATAKANA
};


class TranslationEngine : public QObject {
  Q_OBJECT

public:
  //TranslationEngine(QObject *parent = 0, const char *name = 0);
  virtual ~TranslationEngine(void);
  virtual const char *name(void) const = 0;
  virtual InputMap map_state(void) const = 0;
  virtual CommandMap *command_map(void) = 0;

signals:
  void committed(const QString &committed_str);
  void map_changed(InputMap new_map);
  void segments_changed(Segments &segments);
  void preedit_state_changed(PreeditState new_state);
  void update_candidates(Candidates &candidates);
  void hilight_candidate(int selected, bool reversely);
  void activation_hint_for_candidates(bool activity);

public slots:
  virtual void reset(void) = 0;
  virtual void input_str(const QString &str) = 0;
  virtual void input_char(QChar chr) = 0;
  virtual void select_map(InputMap new_map) = 0;
  virtual void select_candidate(Candidates::size_type which) = 0;
};

#endif  // IMKIT_ENGINE_H
