// IMKit-Anthy: A Qtopia InputMethod interface for Anthy
// Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// $Name: IMKIT_0_4_0_PRE5 $
// $Id: platform_qpe16.cpp,v 1.19 2003/11/03 07:41:00 yamaken Exp $

#include <qlabel.h>
#include <qapplication.h>
#include <qtopia/qpeapplication.h>
#include "widgets/imkit_compactselector.h"
#include "widgets/imwidget_std.h"
#include "platform_qpe16.h"


#ifdef IMKIT_QPE16_PLATFORM
QUnknownInterface *
imkit_create_instance(imkit_create_custom_ui ui_creator, QPixmap *icon) {
  IMUserInterface *ui;
  Qpe16IMElemFactory *elem_factory;
  ExtInputMethodInterface *instance;

  elem_factory = new Qpe16IMElemFactory;
  ui = (*ui_creator)(elem_factory);
  //Q_CREATE_INSTANCE(IMKitImpl(ui, elem_factory, icon))
  instance = new ExtIMKitImpl(ui, elem_factory, icon);

  return instance;
}
#endif

void
Qpe16QWSKeyBypassIn::on_activate(void) {
}

void
Qpe16QWSKeyBypassIn::on_deactivate(void) {
}

Qpe16QWSKeyBypassIn::Qpe16QWSKeyBypassIn(void) {
}

IMKitInputMethod::IMKitInputMethod(QWSKeyBypassIn *bypass_in_init,
                                   QWSKeyBypassOut *bypass_out_init)
  : bypass_in(bypass_in_init), bypass_out(bypass_out_init)
{
  qDebug("IMKitInputMethod::QWSInputMethod()");
#ifndef IMKIT_BROKEN_QPE16_KEYFILTER
  connect(bypass_out, SIGNAL(key(ushort, ushort, ushort, bool, bool)),
          this, SLOT(sendback(int, int, int, bool, bool)));
#endif
}

IMKitInputMethod::~IMKitInputMethod(void) {
  qDebug("IMKitInputMethod::~IMKitInputMethod()");
}

bool
IMKitInputMethod::filter(int unicode, int keycode, int modifiers, 
                         bool is_press, bool autorepeat)
{
  qDebug("IMKitInputMethod::filter(int unicode=%x, int keycode=%x,"
         " int modifiers=%x, bool is_press=%d, bool autorepeat=%d)",
         unicode, keycode, modifiers, is_press, autorepeat);
  return bypass_in->filter(unicode, keycode, modifiers, is_press, autorepeat);
}

void
IMKitInputMethod::sendback(int unicode, int keycode, int modifiers,
                           bool is_press, bool autorepeat)
{
  qDebug("IMKitInputMethod::sendback(int unicode=%x, int keycode=%x,"
         " int modifiers=%x, bool is_press=%d, bool autorepeat=%d)",
         unicode, keycode, modifiers, is_press, autorepeat);
#ifndef IMKIT_BROKEN_QPE16_KEYFILTER
  //privateʤΤǸƤ٤ʤQWSServer::sendKeyEvent()Ǥ̵ºƵˤʤäƤޤ
  QWSServer::sendKeyEventUnfiltered(unicode, keycode, modifiers,
                                    is_press, autorepeat);
#endif
}

void
IMKitInputMethod::reset(void) {
  qDebug("IMKitInputMethod::reset(void)");
#ifdef IMKIT_QPE16_EXPERIMENTAL_CONTEXT_RESET
  emit signal_reset();
#endif
}

void
IMKitInputMethod::setMicroFocus(int x, int y) {
  //(x, y)ѴʸΥեbottomLeft + (0, 1)
  qDebug("IMKitInputMethod::setMicroFocus(int x=%d, int y=%d)", x, y);

#ifdef IMKIT_BROKEN_QPE16_PREEDIT_FOCUS
  int font_height, dummy_width;
  QFontMetrics metrics(font());  //TODO: ƥեȤǤϤʤե¸ߤ֤Υե

  font_height = metrics.height();
  dummy_width = font_height;  //TODO: Τwidth
  y -= metrics.height();  // y is not baseline

  QRect focus(x, y, dummy_width, font_height);
  emit focus_changed(focus);
#endif
}

void
IMKitInputMethod::mouseHandler(int x, int state) {
  qDebug("IMKitInputMethod::mouseHandler(int x=%d, int state=%d)", x, state);
}

void
IMKitInputMethod::compose(const QString& str, int cursor_pos, int focus_len) {
  sendIMEvent(QWSServer::IMCompose, str, cursor_pos, focus_len);
}

void
IMKitInputMethod::commit(const QString& str) {
  sendIMEvent(QWSServer::IMEnd, str, 0, 0);
}

Qpe16Preedit::Qpe16Preedit(IMKitInputMethod *qws_im_init)
  : qws_im(NULL)
{
  set_qwsinputmethod(qws_im_init);
}

#ifdef IMKIT_BROKEN_QPE16_PREEDIT_FOCUS
void
Qpe16Preedit::notify_focus(const QRect &abs_focus) {
  emit focus_changed(abs_focus);
}
#endif

Qpe16Preedit::~Qpe16Preedit(void) {
}

void
Qpe16Preedit::set_qwsinputmethod(IMKitInputMethod *new_qws_im) {
  qws_im = new_qws_im;
  connect(qws_im, SIGNAL(focus_changed(const QRect &)),
          this, SLOT(notify_focus(const QRect &)));
}

QWidget *
Qpe16Preedit::widget(void) {
  return NULL;
}

void
Qpe16Preedit::set_widget(PreeditWidget *new_adaptee) {
}

void
Qpe16Preedit::update_state(PreeditState new_state) {
  _state = new_state;
}

void
Qpe16Preedit::update(Segments &segments) {
  Segments::const_iterator i;
  int cursor_pos = 0, focus_len = 0;
  QString str;  //TODO: 󥹥ѿˤƥȤ򲼤

  for (i = segments.begin(); i != segments.end(); i++) {
    switch ((*i)->type()) {
    case Segment::IMKIT_SEG_FOCUS:
      focus_len = (*i)->str().length();
    case Segment::IMKIT_SEG_CURSOR:
      cursor_pos = str.length();
      break;

    default:
      break;
    }

    str += (*i)->str();
  }

  if (str.isEmpty()) {
    qws_im->commit(str);
  } else {
    qws_im->compose(str, cursor_pos, focus_len);
  }
#ifndef IMKIT_BROKEN_QPE16_PREEDIT_FOCUS
  emit focus_changed(qws_im->inputRect());
#endif
}

void
Qpe16Preedit::commit(const QString& str) {
  qws_im->commit(str);
}

void
Qpe16IMElemFactory::initialize_inputmap_indicator(InputMapIndicator *indicator)
{
  StdIMWidgetFactory::initialize_inputmap_indicator(indicator);
  indicator->select(IMKIT_INPUT_MAP_HIRAGANA);
}

Qpe16IMElemFactory::Qpe16IMElemFactory(void)
  : qws_im(NULL), pixmaps(NULL)
{
  pixmaps = IMKitCompactSelectorPixmapRepository::instance();
}

Qpe16IMElemFactory::~Qpe16IMElemFactory(void) {
  delete pixmaps;
}

Preedit *
Qpe16IMElemFactory::create_preedit(QWidget *parent,
                                   Qt::WFlags flags,
                                   const char *name)
{
  return new Qpe16Preedit(qws_im);
}

InputMapIndicator *
Qpe16IMElemFactory::create_inputmap_indicator(QWidget *parent,
                                              Qt::WFlags flags,
                                              const char *name)
{
  InputMapIndicatorWidget *abstract_widget;
  StdInputMapIndicator *indicator;

  abstract_widget = create_inputmap_indicator_widget(parent, flags, name);
  indicator = new StdInputMapIndicator(abstract_widget, pixmaps);
  initialize_inputmap_indicator(indicator);

  return indicator;
}

InputMapIndicatorWidget *
Qpe16IMElemFactory::create_inputmap_indicator_widget(QWidget *parent,
                                                     Qt::WFlags flags,
                                                     const char *name)
{
  IMKitCompactSelector *widget;
  InputMapIndicatorWidget *abstract_widget;

  widget = new IMKitCompactSelector(parent, name, flags);
  abstract_widget = new InputMapIndicatorWidgetAbstractor<IMKitCompactSelector>(widget);

  return abstract_widget;
}

QWidget *
Qpe16IMElemFactory::build(QWidget *parent, Qt::WFlags flags) {
    _imwidget = create_imwidget(parent, flags);
    _preedit = create_preedit(NULL, flags);
    _indicator = create_inputmap_indicator(_imwidget, flags);
    _cand_win = create_candidate_window(NULL, flags);
    _committer = _preedit;
}

void
Qpe16IMElemFactory::set_qwsinputmethod(IMKitInputMethod *new_qws_im) {
  qws_im = new_qws_im;
}

void
ExtIMKitImpl::prepare_key_bypass(void) {
  bypass_in = new Qpe16QWSKeyBypassIn;
  bypass_out = new QWSKeyBypassOut;
  bypass_in->insert_after(bypass_out);
  bypass_out->activate();
}

void
ExtIMKitImpl::join_to_bypass(CascadeKeyFilter *im_keyfilter) {
  if (!bypass_in) {
    prepare_key_bypass();
  }
  bypass_out->insert_before(im_keyfilter);
}

ExtIMKitImpl::ExtIMKitImpl(IMUserInterface *im_ui_init,
                           Qpe16IMElemFactory *elem_factory,
                           QPixmap *icon_init)
  : ref(0), qws_im(NULL), im_ui(im_ui_init), _icon(icon_init),
    bypass_in(NULL), bypass_out(NULL)
{
  QString im_name;

  prepare_key_bypass();
  join_to_bypass(im_ui->keyfilter_begin());
  QObject::connect(im_ui, SIGNAL(slot_activated(bool)),
                   bypass_in, SLOT(slot_activate(bool)));
  qws_im = new IMKitInputMethod(bypass_in, bypass_out);
#ifdef IMKIT_QPE16_EXPERIMENTAL_CONTEXT_RESET
  QObject::connect(qws_im, SIGNAL(signal_reset(void)),
                   im_ui, SLOT(reset_state(void)));
#endif
  elem_factory->set_qwsinputmethod(qws_im);
#ifdef IMKIT_MISSING_TRANSLATION_SETUP
  //TODO: ǿsnapshotǳǧ
  //CVSQtopiaˤϥɤޤޤƤ뤬widgetload
  //Τǵǽʤ
  im_name = im_ui->name().lower();
  imkit_setup_translator(im_name);
#endif
}

ExtIMKitImpl::~ExtIMKitImpl(void) {
  delete qws_im;
  delete _icon;
  delete im_ui;
}

void
ExtIMKitImpl::resetState(void) {
  qDebug("ExtIMKitImpl::resetState(void)");
  im_ui->reset_state();
}

QPixmap *
ExtIMKitImpl::icon(void) {
  return _icon;
}

QString
ExtIMKitImpl::name(void) {
  return im_ui->name();
}

QStringList
ExtIMKitImpl::compatible(void) {
  qDebug("ExtIMKitImpl::compatible(void)");
  return QStringList();
}

QWSInputMethod *
ExtIMKitImpl::inputMethod(void) {
  qDebug("ExtIMKitImpl::inputMethod(void)");
  return qws_im;
}

QWidget *
ExtIMKitImpl::keyboardWidget(QWidget *parent, Qt::WFlags flags) {
  return NULL;
}

QWidget *
ExtIMKitImpl::statusWidget(QWidget *parent, Qt::WFlags flags) {
  qDebug("ExtIMKitImpl::statusWidget(QWidget *parent, Qt::WFlags flags)");
  return im_ui->imwidget(parent, flags);
}

void
ExtIMKitImpl::qcopReceive(const QCString &msg, const QByteArray &data) {
  qDebug("ExtIMKitImpl::(const QCString &msg, const QByteArray &data)");
}

QRESULT
ExtIMKitImpl::queryInterface(const QUuid &uuid, QUnknownInterface **interface)
{
  *interface = 0;

  if (uuid == IID_QUnknown || uuid == IID_ExtInputMethod) {
    *interface = this;
  } else {
    return QS_FALSE;
  }
  
  if (*interface) {
    (*interface)->addRef();
  }

  return QS_OK;
}
