/**
 * @file   qnengo.h
 * @author NOKUBI Takatsugu <knok@daionet.gr.jp>
 * @date   Thu May  1 12:19:08 2003
 * 
 * @brief  QNengo main widget header
 * 
 * $Id: qnengo.h,v 1.2 2003/05/03 02:10:30 knok Exp $
 */

#ifndef QNENGO_H_
#define QNENGO_H_

#include <qwidget.h>
#include <qmainwindow.h>

#define VERSION "0.10"

class QFrame;
class QGroupBox;
class QVBoxLayout;
class QHBoxLayout;
class QAction;
class QComboBox;
class QPushButton;

class QNengo : public QMainWindow {
    Q_OBJECT ;
public:
    QNengo(QWidget *parent = 0, const char *name = 0, int WFlags = 0);

    typedef enum {
	Meiji = 0,
	Taishou = 1,
	Syouwa = 2,
	Heisei = 3,
    } Nengo;

    void setWidgetAD();
    void setWidgetNengo();
    void ADtoNengo();
    void fixNengo();
    void NengoToAD();
    void updateFromAD();
    void updateFromNengo();

public slots:
    void updateAD();
    void updateNengo();
    void copyAD();
    void copyNengo();
    void exitapp();
    void about();

private:
    QFrame *topF;		///< top frame
    QVBoxLayout *topL;		///< top layout
    QGroupBox *upperF;		///< upper frame
    QHBoxLayout *upperL;	///< upper layout
    QGroupBox *downerF;		///< downer frame
    QHBoxLayout *downerL;	///< downer layout
    QFrame *btnF;		///< button frame
    QHBoxLayout *btnL;		///< button layout

    QComboBox *century;		///< century
    QComboBox *yten;		///< ten years
    QComboBox *year;		///< years

    QComboBox *nengo;		///< nengo
    QComboBox *nyten;		///< ten years
    QComboBox *nyear;		///< years

    QAction *actExit; 		///< menu item: exit
    QAction *actCopyAD;
    QAction *actCopyNengo;
    QAction *actAbout;

    QPushButton *btnCopyAD;
    QPushButton *btnCopyNengo;
    QPushButton *btnQuit;

    int adyear; 		///< years of A.D.
    Nengo ntype; 		///< type of nengo
    int neyear;			///< years of nengo
};

#endif /* QNENGO_H_ */
