#!/usr/bin/env ruby

require "qte"
include Qte
require "qpe"
include Qpe


class HelloApp < QObject

   def initialize
      super
      @qapp = QPEApplication.new([$0] + ARGV)
      @wbase = QWidget.new
      vl = QVBoxLayout.new(@wbase)
      @first = true
      @button0 = QPushButton.new("",@wbase)
      @button0.setText(QString::fromLocal8Bit("ˤ"))
      @button4 = QPushButton.new("void",@wbase)
      @button1 = QPushButton.new("int",@wbase)
      @button5 = QPushButton.new("double",@wbase)
      @button2 = QPushButton.new("const char*",@wbase)
      @button3 = QPushButton.new("Object",@wbase)
      @wbase.resize(100,150)
      vl.addWidget(@button0)
      vl.addWidget(@button4)
      vl.addWidget(@button1)
      vl.addWidget(@button5)
      vl.addWidget(@button2)
      vl.addWidget(@button3)
      vl.activate
      @qapp.showMainWidget(@wbase)
      @rsigVoid = RSignal.new()
      @rsigInt = RSignal.new("int")
      @rsigdbl = RSignal.new("double")
      @rsigStr = RSignal.new("const char*")
      @rsigObj = RSignal.new("Object")
      Qte::connect(@rsigVoid,self,'pslot')
      Qte::connect(@rsigInt,self,'pslot')
      Qte::connect(@rsigdbl,self,'pslot')
      Qte::connect(@rsigStr,self,'pslot')
      Qte::connect(@rsigObj,self,'pslot')
   end
   def callback
      if @first
         @button0.setText(QString::fromLocal8Bit("褦ʤ"))
         print "⤦ٲȽλ\n"
         @first = false
      else
         @qapp.quit
      end
   end
   def run
#      rs = QRObject::connect_rslot(@button,QSIGNAL('clicked()'),self,'callback')
      Qte::connect(@button0,QSIGNAL('clicked()'),self,'callback')
      Qte::connect(@button1,QSIGNAL('clicked()'),self,'sendInt')
      Qte::connect(@button5,QSIGNAL('clicked()'),self,'senddbl')
      Qte::connect(@button2,QSIGNAL('clicked()'),self,'sendStr')
      Qte::connect(@button3,QSIGNAL('clicked()'),self,'sendObj')
      Qte::connect(@button4,QSIGNAL('clicked()'),@rsigVoid)
      @qapp.exec
    end

    def sendInt
       @rsigInt.sendWith(10)
    end

    def senddbl
       @rsigdbl.sendWith(99.999)
    end

    def sendStr
       @rsigStr.sendWith("ˤ")
    end

    def sendObj
       a = []
       a[0]=10
       a[1]="\nˤ"
       a[2]="\n褦ʤ"
       @rsigObj.sendWith(a)
    end

    def pslot o="Ϥޤ"
      print o.to_s; print "\n"
    end
end

HelloApp.new.run

