#!/usr/bin/env ruby

require "qte"
include Qte
require "qpe"
include Qpe


class HelloApp < QObject

   def initialize
      super
      @qapp = QPEApplication.new([$0] + ARGV)
      @wbase = QWidget.new
      vl = QVBoxLayout.new(@wbase)
      @button0 = QPushButton.new("Hello",@wbase)
      @button1 = QPushButton.new("void",@wbase)
      @button2 = QPushButton.new("int",@wbase)
      @button3 = QPushButton.new("double",@wbase)
      @button4 = QPushButton.new("const char*",@wbase)
      @button5 = QPushButton.new("const QString &",@wbase)
      @button6 = QPushButton.new("Object",@wbase)
      @wbase.resize(100,150)
      vl.addWidget(@button0)
      vl.addWidget(@button1)
      vl.addWidget(@button2)
      vl.addWidget(@button3)
      vl.addWidget(@button4)
      vl.addWidget(@button5)
      vl.addWidget(@button6)
      vl.activate
      @qapp.showMainWidget(@wbase)
      @rsigVoid = RSignal.new()
      @rsigInt = RSignal.new("int")
      @rsigdbl = RSignal.new("double")
      @rsigStr = RSignal.new("const char*")
      @rsigQStr = RSignal.new("const QString &")
      @rsigObj = RSignal.new("Object")
      Qte::connect(@rsigVoid,self,'pslot')
      Qte::connect(@rsigInt,self,'pslot')
      Qte::connect(@rsigdbl,self,'pslot')
      Qte::connect(@rsigStr,self,'pslot')
      Qte::connect(@rsigQStr,self,'pslot')
      Qte::connect(@rsigObj,self,'pslot')
   end
   def callback
      if @button0.text.to_str == "Hello"
            @button0.setText("Good bye!")
            print "One more click quit the program.\n"
      else
         @qapp.quit
      end
   end
   def run
#      rs = QRObject::connect_rslot(@button,QSIGNAL('clicked()'),self,'callback')
      Qte::connect(@button0,QSIGNAL('clicked()'),self,'callback')
      Qte::connect(@button2,QSIGNAL('clicked()'),self,'sendInt')
      Qte::connect(@button3,QSIGNAL('clicked()'),self,'senddbl')
      Qte::connect(@button4,QSIGNAL('clicked()'),self,'sendStr')
      Qte::connect(@button5,QSIGNAL('clicked()'),self,'sendQStr')
      Qte::connect(@button6,QSIGNAL('clicked()'),self,'sendObj')
      Qte::connect(@button1,QSIGNAL('clicked()'),@rsigVoid)
      @qapp.exec
    end
    def sendInt
       @rsigInt.sendWith(10)
    end
    def senddbl
        @rsigdbl.sendWith(99.999)
    end
    def sendStr
       @rsigStr.sendWith("Hello")
    end
    def sendQStr
       @qstr = QString.new("QString")
       @rsigQStr.sendWith(@qstr)
    end
    def sendObj
       a = []
       a[0]=10
       a[1]="\nHello"
       a[2]="\nGood bye"
       @rsigObj.sendWith(a)
    end
    def pslot o="No argument"
      print o.to_s; print "\n"
    end
end

HelloApp.new.run

