=begin
For Ruby/Qt2 project:
Make Get and Wrap function for swig 1.3.12pre. (Compatible function of older
swig ruby module.)
Tue Apr  2 14:54:01 2002
by N. Horie
horie@smail.u-shizuoka-ken.ac.jp
=end
$Module_name="qtetable"
$Header = "swig_class_#{$Module_name}.h"
$Qt2Header = "../qte/swig_class_qte.h"
$CSource = "swig_class_#{$Module_name}.s"
$CSetkClass = "swig_class_#{$Module_name}_setkclass.s"

class SwigClass
attr_reader :name, :destructor, :swig_types_index
def initialize class_string,index
	@name = class_string
	@destructor = false
	@swig_types_index = index
end

def getGetFunction(varg)
	#translate String to QString if class is QString
        str = "{\nvoid *res;\n"
	case name
	when "QString"
	str += "if(rb_obj_is_kind_of(#{varg}, cQString)) {\n"
	str += "  SWIG_ConvertPtr(#{varg}, &res, SWIGTYPE_p_#{name}, 1);\n"
	str += "} else if(TYPE(#{varg}) == T_STRING) {\n"
	str += "  VALUE temp_#{varg} = rb_funcall(cQString.klass,rb_intern(\"new\"),1,#{varg});\n"
	str += "  SWIG_ConvertPtr(temp_#{varg}, &res, SWIGTYPE_p_#{name}, 1);\n"
	str += "} else {\n"
	str += "    rb_raise(rb_eTypeError, \"wrong argument type (expected QString or String)\");\n"
	str += "}"

	when "QMimeSource"
	str += "if(rb_obj_is_kind_of(#{varg}, cQMimeSource)) {\n"
	str += "  SWIG_ConvertPtr(#{varg}, &res, SWIGTYPE_p_#{name}, 1);\n"
#	str += "} else if (rb_obj_is_kind_of(#{varg}, cQDropEvent)) {\n"
#	str += "  return SWIG_ConvertPtr(#{varg}, SWIGTYPE_p_QDropEvent);\n"
	str += "} else {\n"
	str += "    rb_raise(rb_eTypeError, \"wrong argument type (expected QMimeSource or QDropEvent)\");\n"
	str += "}"
	else
	str += "SWIG_ConvertPtr(#{varg}, &res, SWIGTYPE_p_#{name}, 1);"
	end
    str += "return res;\n"
    str += "}\n"
end

def getWrapFunction(swig_class,carg)
	swig_class.gsub!('^c','')
	str = "return SWIG_NewPointerObj((void *) #{carg}, SWIGTYPE_p_#{name},0);"
end

end

class SwigWrapReader
	TemplateClass = ["QList","QMap","QValueList",
	"QValueListConstIterator","QValueListIterator",
	"QValueListNode","QValueListTQImageTextKeyLang_t",
	"QGVector","QLNode"]
def initialize( wrapper_file )
	@SClassCollection = []
	@exclude_list = TemplateClass
	if(!(/mswin/ =~ PLATFORM))
	if($Module_name != "qte")
	  file = File.new($Qt2Header,"r")
	  inputs = file.readlines
	  inputs.each{|l|
	    if(/k[Q,R]\S*/ =~ l)
	      name = $&
	      name.gsub!(/^k/,'')
	      @exclude_list.push(name)
	    end
	  }
	end
	end
	file = File.new(wrapper_file,"r")
	inputs = file.readlines
	inputs.each{|l|

	if(/#define  SWIGTYPE_p_/ =~ l)
		/\d+/ =~ l
		index = $&.to_i
		/_p_\S*/ =~ l
		name = $&
		name.gsub!(/_p_/,"")
		/[Q,R]\S*/ =~ name  #extract Qxxx class and Rxxx class
		if (($& != "") and ($& != nil) and @exclude_list.index($&).nil?)
			sclass = SwigClass.new($&,index)
			@SClassCollection.push(sclass)
		end

	end
	}
	@SClassCollection.uniq!
	@SClassCollection.sort!{|a, b| a.name <=> b.name }
	debug = File.new("debug.txt","w")
	@SClassCollection.each{|c|
		debug << c.name << ":" << c.swig_types_index << "\n"
	}
	debug.close
end

def getHeaderFile
	str = "/* For compatibility to SWIG1.3.6 for SWIG 1.3.12pre\n"
	str += "#{Time.now}\n"
	str += "*/\n"
	str += "#ifndef _SWIG_CLASS_#{$Module_name.upcase}\n"
	str += "#define _SWIG_CLASS_#{$Module_name.upcase}\n"
	str += "\n"
	str += "#include <ruby.h>\n"
	str += "\n"
	str += "#ifndef _SWIG_WRAP\n"
	str += "#define _SWIG_WRAP\n"
	str += "typedef struct {\n"
	str += "VALUE  klass;\n"
	str += "void  (*mark)(void *);\n"
	str += "void  (*destroy)(void *);\n"
	str += "} swig_class;\n"
	str += "#if defined(_WIN32) || defined(__WIN32__)\n"
	str += "#       if defined(_MSC_VER)\n"
	str += "#               if defined(STATIC_LINKED)\n"
	str += "#                       define SWIGEXPORT(a) a\n"
	str += "#                       define SWIGIMPORT(a) extern a\n"
	str += "#               else\n"
	str += "#                       define SWIGEXPORT(a) __declspec(dllexport) a\n"
	str += "#                       define SWIGIMPORT(a) extern a\n"
	str += "#               endif\n"
	str += "#       else\n"
	str += "#               if defined(__BORLANDC__)\n"
	str += "#                       define SWIGEXPORT(a) a _export\n"
	str += "#                       define SWIGIMPORT(a) a _export\n"
	str += "#               else\n"
	str += "#                       define SWIGEXPORT(a) a\n"
	str += "#                       define SWIGIMPORT(a) a\n"
	str += "#               endif\n"
	str += "#       endif\n"
	str += "#else\n"
	str += "#       define SWIGEXPORT(a) a\n"
	str += "#       define SWIGIMPORT(a) a\n"
	str += "#endif\n"

        str += "#ifdef SWIG_GLOBAL\n"
        str += "#define SWIGRUNTIME(a) SWIGEXPORT(a)\n"
        str += "#else\n"
        str += "#define SWIGRUNTIME(a) static a\n"
        str += "#endif\n"
	str += "\n"
	str += "#define SWIGRUBYEXTERN extern\n"
	str += "\n"
	str += "#else\n"
	str += "  #ifndef SWIGRUBYEXTERN\n"
	str += "    #define SWIGRUBYEXTERN \n"
	str += "  #endif\n"
	str += "#endif\n"
	str += "\n"
	str += "#ifndef _RB_OBJ_IS_KIND_OF_DEF\n"
	str += "#define _RB_OBJ_IS_KIND_OF_DEF\n"
        str += "bool rb_obj_is_kind_of(VALUE varg, swig_class sclass);\n"
	str += "#endif\n"
	str += "\n"

@SClassCollection.each{|sc|
	str += "extern swig_class c#{sc.name};\n"
	}
	str += "//get and wrap functions\n"
@SClassCollection.each{|sc|
		str += "// SWIGRUBYEXTERN VALUE k#{sc.name};\n"
		str += "SWIGRUNTIME(void *) Get_#{sc.name}(VALUE varg);\n"
		# "{#{sc.getGetFunction('varg')}}\n"
		str += "SWIGRUNTIME(VALUE) Wrap_#{sc.name}(swig_class cClass, void* carg);\n"
		# "{sc.getWrapFunction('cClass','carg')}\n"
		str += "\n"
}
	str += "#endif\n"
end

def getCFile
	str = "/* For compatibility to SWIG1.3.6 for SWIG 1.3.12pre\n"
	str += "#{Time.now}\n"
	str += "This file should be included from #{$Module_name}_wrap.cpp\n"
	str += "*/\n"
	str += "bool rb_obj_is_kind_of(VALUE varg, swig_class sclass)\n"
	str += "{\n"
	str += "return rb_obj_is_kind_of(varg, sclass.klass);\n"
	str += "}\n"
	@SClassCollection.each{|sc|
		str += "SWIGRUNTIME(void *)\n Get_#{sc.name}(VALUE varg)\n"
		str += "{\n  #{sc.getGetFunction('varg')}\n}\n"
		str += "SWIGRUNTIME(VALUE)\n Wrap_#{sc.name}(swig_class cClass, void* carg)\n"
		str += "{\n  #{sc.getWrapFunction('cClass','carg')}\n}\n"
		str += "\n"
	}
	str

end

def getSetkClassFunc
	str = "/* void setkClass();\n"
	str += " * set VALUE kClass from swig_type_info*->klass\n"
	str += " * for each class\n"
	str += " * for compatibility SWIG 1.3.6 for 1.3.12u */\n"

	str += "void setkClass()\n"
	str += "{\n"
	str += "  swig_class *sklass;\n"
	@SClassCollection.each{|sc|
	  class_name = sc.name.gsub(/^c/,"") 
		str += "  sklass = (swig_class*)SWIGTYPE_p_#{class_name}->clientdata;\n"
		str += "  k#{class_name} = sklass->klass;\n"
		str += "\n"
	}
	str += "}\n"
	str += "/* end of setkClass() */\n"
end

end

fname = "#{$Module_name}_wrap.cpp"
#ARGV.shift
p "file name = #{fname}"
sw = SwigWrapReader.new(fname)
hfile = File.new("#{$Header}","w")
 hfile << sw.getHeaderFile
hfile.close
sfile = File.new("#{$CSource}","w")
 sfile << sw.getCFile
sfile.close
#kfile = File.new("#{$CSetkClass}","w")
# kfile << sw.getSetkClassFunc
#kfile.close

