/***************************************************************************
                    rslot.cpp  -  description
                           -------------------
  begin                : Sat Aug 18 13:58:52 JST 2001
  copyright            : (C) 2001 by Nobuyuki Horie
  email                : horie@smail.u-shizuoka-ken.ac.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <qregexp.h>
#include <qobject.h>
//#include "qt2_wrap.h"
#include "swig_class_qte.h"
#include "qrbfunction.h"
#include "rslot.h"

/* Implementation of RSlot--for RubyQt
*/
//RSlot::RSlot(): qt_obj(0),qt_signal(0),ruby_obj(0),ruby_slot(0)
//{
   
//}


RSlot::~RSlot()
{
       //debug("RSlot destructed.");
}


/* RSlot for QObject:connect method. It connected qtsignal of
qtobject to rbslot of rbobject.
*/
RSlot::RSlot(VALUE rbobject, const char* rbslot, Argtype slot_type):
		ruby_obj(rbobject),ruby_slot(rbslot),
		arg(slot_type)
{   
}

void RSlotVoid::rslot()
{
   rb_funcall(ruby_obj,rb_intern(ruby_slot),0);
}
void RSlotBool::rslot(bool arg_bool)
{
   VALUE rbool;
   if(arg_bool == TRUE) rbool = Qtrue;
   else   rbool = Qfalse;
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,rbool);
}

void RSlotInt::rslot(int arg_int)
{
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,INT2NUM(arg_int));
}
void RSlotDouble::rslot(double arg_dbl)
{
    rb_funcall(ruby_obj,rb_intern(ruby_slot),1,rb_float_new(arg_dbl));

}
void RSlotStr::rslot(const char* arg_text)
{
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,rb_str_new2(arg_text));
}
void RSlotQStr::rslot(const QString & arg_text)
{
  if(arg_text.length() > 0)
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,
          rb_str_new2((const char *)(arg_text.local8Bit())));
  else
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,
          rb_str_new2((const char *)(arg_text)));
}

void RSlotRObj::rslot(VALUE arg_obj)
{
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,arg_obj);
}
void RSlotQRect::rslot(const QRect& qrect)
{
   //debug("RSlotQRect called");
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,
   Data_Wrap_Struct(cQRect.klass,0,0,&(QRect&)qrect));
}
void RSlotQSize::rslot(const QSize& qsize)
{
   //debug("RSlotQSize called");
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,
   Data_Wrap_Struct(cQSize.klass,0,0,&(QSize&)qsize));
}
#ifndef QT_NO_DRAGANDDROP
void RSlotQDropEvent::rslot(QDropEvent * qdropevent)
{
   //debug("RSlotQSize called");
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,
   Data_Wrap_Struct(cQDropEvent.klass,0,0,qdropevent));
}
#endif

void RSlotQColor::rslot(const QColor& qcolor)
{
   //debug("RSlotQColor called");
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,
   Data_Wrap_Struct(cQColor.klass,0,0,&(QColor&)qcolor));
}

void RSlotQDate::rslot(QDate qdate)
{
   //debug("RSlotQDate called");
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,
   Data_Wrap_Struct(cQDate.klass,0,0,&qdate));
}

void RMenuRSlot::rslot()
{
   //qDebug("RMenuRSlot rslot() called");
   if (ruby_respondTo(ruby_obj,ruby_slot))
         rb_funcall(ruby_obj,rb_intern(ruby_slot),0);
}
void RMenuRSlot::rslot(int id)
{
   //qDebug("RMenuSlot rslot(int) called");
   if(id == menuId) {
   if (ruby_respondTo(ruby_obj,ruby_slot)){
      if(argInt) {
         rb_funcall(ruby_obj,rb_intern(ruby_slot),
                    1,INT2NUM(id));
      } else {
        rb_funcall(ruby_obj,rb_intern(ruby_slot),0);
        } 
   }
  }
}
void RSlotQListBoxItem::rslot(QListBoxItem* item)
{
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,
   Wrap_QListBoxItem(cQListBoxItem,item));
}
void RSlotQListViewItem::rslot(QListViewItem* item)
{
   rb_funcall(ruby_obj,rb_intern(ruby_slot),1,
   Wrap_QListViewItem(cQListViewItem,item));
}
void RSlotQListBoxItemQPoint::rslot(QListBoxItem* item,const QPoint& pt)
{
   QPoint qpt = pt;
   rb_funcall(ruby_obj,rb_intern(ruby_slot),2,
   Wrap_QListBoxItem(cQListBoxItem,item),
   Data_Wrap_Struct(cQPoint.klass,0,0,&qpt));
}

void RSlotQListViewItemQPointInt::rslot(QListViewItem* item,
	const QPoint& pt,int i)
{
   QPoint qpt = pt;
   rb_funcall(ruby_obj,rb_intern(ruby_slot),3,
   Wrap_QListViewItem(cQListViewItem,item),
   Data_Wrap_Struct(cQPoint.klass,0,0,&qpt),
   INT2NUM(i));
}


/*
void RSlot::connect()
{
   switch(arg) {
      case NOARG:
         QObject::connect(qt_obj,qt_signal,this,SLOT(rslot()));
         break;
      case INTARG:
         QObject::connect(qt_obj,qt_signal,this,SLOT(rslot(int)));
         break;
      case TXTARG:
         QObject::connect(qt_obj,qt_signal,this,SLOT(rslot(const char*)));
         break;
      case OBJARG:
         QObject::connect(qt_obj,qt_signal,this,SLOT(rslot(VALUE)));
         break;
         
    }   
}
void RSlot::disconnect()
{
         QObject::disconnect(qt_obj,qt_signal,this,0);
}


*/
/**
*/
bool RSlot::find(QObject* qobj, const char* qtsignal, VALUE robj, const char* rmethod)
{
   return false;	
}


/**
*/
RSlotVoid::RSlotVoid(VALUE robj, const char* rmember):
	RSlot(robj,rmember,NOARG)
{
}
RSlotVoid::~RSlotVoid()
{
   //debug("RSlotVoid destructed.");
}

/**
*/
const char* RSlotVoid::qslot()
{
     return (SLOT(rslot())); 
}
/* RSlot for accel connect in menu item.
*/
RSlotVoid::RSlotVoid(QAccel* accel, int id, VALUE rbobject, const char* rbslot):
		RSlot(rbobject,rbslot,NOARG)
		
{
   accel->connectItem( id, this, SLOT(rslot()));
}



bool RSlotVoid::disconnectItem(QAccel* accel, int id )
{
       return accel->disconnectItem(id, this, SLOT(rslot()));
}


/**
*/
RSlotInt::RSlotInt(VALUE robj, const char* rmember):
	RSlot(robj,rmember,INTARG)
{
}
RSlotInt::~RSlotInt()
{
      //debug("RSlotInt destructed.");
}
/**
*/
RSlotDouble::RSlotDouble(VALUE robj, const char* rmember):
	RSlot(robj,rmember,DBLARG)
{
}
RSlotDouble::~RSlotDouble()
{
}
/**
*/
const char* RSlotDouble::qslot()
{
   return (SLOT(rslot(double)));
}

/**
*/
const char* RSlotInt::qslot()
{
   return (SLOT(rslot(int)));	
}

/**
*/
RSlotStr::RSlotStr(VALUE robj, const char* rmember):
	RSlot(robj,rmember,TXTARG)
{
}
RSlotStr::~RSlotStr()
{
      //debug("RSlotStr destructed.");
}

/**
*/
const char* RSlotStr::qslot()
{
     return (SLOT(rslot(const char*))); 
}


/**
*/
RSlotQStr::RSlotQStr(VALUE robj, const char* rmember):
	RSlot(robj,rmember,TXTARG)
{
}
RSlotQStr::~RSlotQStr()
{
      //debug("RSlotStr destructed.");
}

/**
*/
const char* RSlotQStr::qslot()
{
     return (SLOT(rslot(const QString &))); 
}


/**
*/
RSlotRObj::RSlotRObj(VALUE robj, const char* rmember):
	RSlot(robj,rmember,OBJARG)
{
}
RSlotRObj::~RSlotRObj()
{
      //debug("RSlotRObj destructed.");
}

/**
*/
const char* RSlotRObj::qslot()
{
     return (SLOT(rslot(VALUE))); 
}


/**
*/
RSlotQSize::RSlotQSize(VALUE robj, const char* rmember):
	RSlot(robj,rmember,QSIZEARG)
{
}
RSlotQSize::~RSlotQSize()
{
      //debug("RSlotQSize destructed.");
}


/**
*/
const char* RSlotQSize::qslot()
{
     return (SLOT(rslot(const QSize&))); 
}


/**
*/
RSlotQRect::RSlotQRect(VALUE robj, const char* rmember):
	RSlot(robj,rmember,QRECTARG)
{
}

RSlotQRect::~RSlotQRect()
{
      //debug("RSlotQRect destructed.");
}

/**
*/
const char* RSlotQRect::qslot()
{
     return (SLOT(rslot(const QRect&))); 
}

/**
*/
RSlotQColor::RSlotQColor(VALUE robj, const char* rmember):
	RSlot(robj,rmember,QCOLORARG)
{
}

RSlotQColor::~RSlotQColor()
{
      //debug("RSlotQColor destructed.");
}

/**
*/
const char* RSlotQColor::qslot()
{
     return (SLOT(rslot(const QColor&))); 
}


/**
*/
RSlotBool::RSlotBool(VALUE robj, const char* rmember):
	RSlot(robj,rmember,BOOLARG)
{
}

RSlotBool::~RSlotBool()
{
      //debug("RSlotBool destructed.");
}

/**
*/
const char* RSlotBool::qslot()
{
     return (SLOT(rslot(bool))); 
}


/**
*/
RSlotQDate::RSlotQDate(VALUE robj, const char* rmember):
	RSlot(robj,rmember,QRECTARG)
{
}

RSlotQDate::~RSlotQDate()
{
      //debug("RSlotQRect destructed.");
}

/**
*/
const char* RSlotQDate::qslot()
{
     return (SLOT(rslot(QDate))); 
}


/**
*/
#ifndef QT_NO_DRAGANDDROP
RSlotQDropEvent::RSlotQDropEvent(VALUE robj, const char* rmember):
	RSlot(robj,rmember,QDROPEVENTARG)
{
}

RSlotQDropEvent::~RSlotQDropEvent()
{
      //debug("RSlotQDropEvent destructed.");
}

/**
*/
const char* RSlotQDropEvent::qslot()
{
     return (SLOT(rslot(QDropEvent*))); 
}
#endif
/**
*/
RSlotQListBoxItem::RSlotQListBoxItem(VALUE robj, const char* rmember):
	RSlot(robj,rmember,QLISTBOXITEMARG)
{
}

RSlotQListBoxItem::~RSlotQListBoxItem()
{}

const char* RSlotQListBoxItem::qslot()
{
   return(SLOT(rslot(QListBoxItem*)));
}
/**
*/
RSlotQListViewItem::RSlotQListViewItem(VALUE robj, const char* rmember):
	RSlot(robj,rmember,QLISTVIEWITEMARG)
{
}

RSlotQListViewItem::~RSlotQListViewItem()
{}

const char* RSlotQListViewItem::qslot()
{
   return(SLOT(rslot(QListViewItem*)));
}

/**
*/
RSlotQListBoxItemQPoint::RSlotQListBoxItemQPoint(VALUE robj, const char* rmember):
	RSlot(robj,rmember,QLISTBOXITEMQPOINTARG)
{
}

RSlotQListBoxItemQPoint::~RSlotQListBoxItemQPoint()
{}

const char* RSlotQListBoxItemQPoint::qslot()
{
   return(SLOT(rslot(QListBoxItem*,const QPoint&)));
}
/**
*/
RSlotQListViewItemQPointInt::RSlotQListViewItemQPointInt(VALUE robj, const char* rmember):
	RSlot(robj,rmember,QLISTVIEWITEMQPOINTINTARG)
{
}

RSlotQListViewItemQPointInt::~RSlotQListViewItemQPointInt()
{}

const char* RSlotQListViewItemQPointInt::qslot()
{
   return(SLOT(rslot(QListViewItem*,const QPoint&,int)));
}



/**
*/
RMenuRSlot::RMenuRSlot(int menuid, VALUE robj, char* rmember):
            RSlot(robj,0,QMENUARG),menuId(menuid),argInt(FALSE)
{
   QRegExp argint("(\\s*int\\s*)");
   char qrmember[64];

   if(argint.match(rmember) > 0) {
      argInt = TRUE;
   }
//qDebug("rmember = %s,argInt = %d",rmember,argInt);
   strcpy(qrmember,rmember);
   ruby_slot = delparenth(qrmember);
}
RMenuRSlot::~RMenuRSlot()
{
}
const char* RMenuRSlot::qslot()
{
   if(argInt) {
      return(SLOT(rslot(int)));
   } else {
      return(SLOT(rslot(int)));
   }
}

