/****************************************************************************
** $Id: qwmatrix.i,v 1.1.1.1 2002/12/22 14:20:19 taka-hr Exp $
**
** Definition of QWMatrix class
**
** Created : 941020
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QWMATRIX_H
//#define QWMATRIX_H

//#ifndef QT_H
//#include "qwindowdefs.h"
//#include "qpointarray.h"
//#include "qrect.h"
//#endif // QT_H


class QWMatrix					// 2D transform matrix
{
public:
		 %extend {
	 QWMatrix ( float m11 = 1.0, float m12 = 0.0, float m21 = 0.0,
			 float m22 = 1.0 , float dx = 0.0, float dy = 0.0 ) {
			return new QWMatrix( m11,m12,m21,m22,dx,dy);
			}
	 QWMatrix mul(QWMatrix& owm) {
			return (*self * owm);
	 }
	 bool equal(QWMatrix& owm) {
			return( *self == owm);
	 }

	 }

//    QWMatrix();
//    QWMatrix( double m11, double m12, double m21, double m22,
//	      double dx, double dy );
		~QWMatrix();

		void	setMatrix( double m11, double m12, double m21, double m22,
			   double dx,  double dy );

		double	m11() const; // { return _m11; }
		double	m12() const; // { return _m12; }
		double	m21() const; // { return _m21; }
		double	m22() const; // { return _m22; }
		double	dx()  const; // { return _dx; }
		double	dy()  const; // { return _dy; }

		//RENAME %name(mapInt)void	map( int x, int y, int *OUTPUT=Qnil, int *OUTPUT=Qnil )	      const;
//    void	map( double x, double y, double *OUTPUT, double *OUTPUT ) const;
		//RENAME %name(mapQPoint) QPoint	map( const QPoint & )	const;
		//RENAME %name(mapQRect) QRect	 map( const QRect & )	const;
		//RENAME %name(mapQPointArray) QPointArray map( const QPointArray & ) const;
		%extend {
			 VALUE map(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,VALUE varg3=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint* qp;
						 QPoint* result;
						 VALUE vresult;
						 qp = (QPoint *)Get_QPoint(varg0);
						 result = new QPoint(self->map(*qp));
						 CHECK_PTR(result);
						 vresult = Wrap_QPoint(cQPoint,result);
						 return vresult;
					} else if(rb_obj_is_kind_of(varg0,cQRect)) { 
						 QRect* qr;
						 QRect* result;
						 VALUE vresult;
						 qr = (QRect *)Get_QRect(varg0);
						 result = new QRect(self->map(*qr));
						 CHECK_PTR(result);
						 vresult = Wrap_QRect(cQRect,result);
						 return vresult;             
					} else if(rb_obj_is_kind_of(varg0,cQPointArray)) { 
						 QPointArray* qpa;
						 QPointArray* result;
						 VALUE vresult;
						 qpa = (QPointArray *)Get_QPointArray(varg0);
						 result = new QPointArray(self->map(*qpa));
						 CHECK_PTR(result);
						 vresult = Wrap_QPointArray(cQPointArray,result);
						 return vresult;
					} else if(TYPE(varg0) == T_FLOAT && TYPE(varg1) == T_FLOAT) {
						 double x,y;
						 double rx,ry;
						 VALUE vresult;
						 x = NUM2DBL(varg0);
						 y = NUM2DBL(varg1);
						 self->map(x,y,&rx,&ry);
						 output_helper2(vresult,rb_float_new(rx));
						 output_helper2(vresult,rb_float_new(ry));
						 return vresult;
					} else if(TYPE(varg0) == T_FIXNUM && TYPE(varg1) == T_FIXNUM) {
						 int x,y;
						 int rx,ry;
						 VALUE vresult;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 self->map(x,y,&rx,&ry);
						 output_helper2(vresult,rb_float_new(rx));
						 output_helper2(vresult,rb_float_new(ry));
						 return vresult;
					} else {
						 rb_raise(rb_eArgError,"Error in map() argments");
					}
			 }
		}
								 
						 
						 

		void	reset();

		QWMatrix   &translate( double dx, double dy );
		QWMatrix   &scale( double sx, double sy );
		QWMatrix   &shear( double sh, double sv );
		QWMatrix   &rotate( double a );

		QWMatrix	invert( bool * bl = 0 ) const;

//    bool	operator==( const QWMatrix & ) const;
//    bool	operator!=( const QWMatrix & ) const;
//    QWMatrix   &operator*=( const QWMatrix & );
/*
private:
		QWMatrix   &bmul( const QWMatrix & );
		double	_m11, _m12;
		double	_m21, _m22;
		double	_dx,  _dy;
*/
};


//Q_EXPORT QWMatrix operator*( const QWMatrix &, const QWMatrix & );


/*****************************************************************************
	QWMatrix stream functions
 *****************************************************************************/

//Q_EXPORT QDataStream &operator<<( QDataStream &, const QWMatrix & );
//Q_EXPORT QDataStream &operator>>( QDataStream &, QWMatrix & );


//#endif // QWMATRIX_H
