/****************************************************************************
** $Id: qtabdialog.i,v 1.1.1.1 2002/12/22 14:20:16 taka-hr Exp $
**
** Definition of QTabDialog class
**
** Created : 960825
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the dialogs module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

//#ifndef QTABDIALOG_H
//#define QTABDIALOG_H

//#ifndef QT_H
//#include "qdialog.h"
//#include "qiconset.h"
//#endif // QT_H

//#ifndef QT_NO_TABDIALOG

class  QTabBar;
struct QTabPrivate;
class  QTab;


class QTabDialog : public QDialog
{
		//Q_OBJECT
public:
		QTabDialog( QWidget *parent=0, const char *name=0, bool modal=FALSE,
		WFlags f=wfDefault );
	 ~QTabDialog();

		void show();
		void setFont( const QFont & font );

//    void addTab( QWidget *, const QString &);
		//RENAME %name(addTabQIconSet) void addTab( QWidget *child, const QIconSet& iconset, const QString &label);
		//RENAME %name(addTabQTab) void addTab( QWidget *, QTab* );
		%extend {
			 void addTab(VALUE varg0,VALUE varg1,VALUE varg2=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQWidget)) {
						 QWidget* wd;
						 wd = (QWidget *)Get_QWidget(varg0);
						 if(rb_obj_is_kind_of(varg1,cQTab)) {
								QTab* qtab;
								qtab = (QTab *)Get_QTab(varg1);
								self->addTab(wd,qtab);
						 } else if(rb_obj_is_kind_of(varg1,cQIconSet)) {
								QIconSet* qic;
								qic = (QIconSet *)Get_QIconSet(varg1);
								QString* label;
								label = (QString *)Get_QString(varg2);
								self->addTab(wd,*qic,*label);
						 } else if(rb_obj_is_kind_of(varg1,cQPixmap)) {
								QPixmap* pixmap;
								pixmap = (QPixmap *)Get_QPixmap(varg1);
								QString* label;
								label = (QString *)Get_QString(varg2);
								self->addTab(wd,*pixmap,*label);                
						 } else {
								QString* qstr;
								qstr = (QString *)Get_QString(varg1);
								self->addTab(wd,*qstr);
						 }
					} else {
						 rb_raise(rb_eArgError,"Error in addTab() argments");
					}
			 }
		}
								

//    void insertTab( QWidget *, const QString &, int index = -1);
		//RENAME %name(insertTabQIconSet) void insertTab( QWidget *child, const QIconSet& iconset, const QString &label, int index = -1);
		//RENAME %name(insertTabQTab) void insertTab( QWidget *, QTab*, int index = -1 );
		%extend {
			 void insertTab(QWidget* wd,VALUE varg1,VALUE varg2=Qnil,VALUE varg3=Qnil,VALUE varg4=Qnil) {
					if(rb_obj_is_kind_of(varg1,cQTab)) {
						 QTab* qtab;
						 int index=-1;
						 qtab = (QTab *)Get_QTab(varg1);
						 if(varg2 != Qnil)
								 index = NUM2INT(varg2);
						 self->insertTab(wd,qtab,index);
					} else if(rb_obj_is_kind_of(varg1,cQString) ||
										TYPE(varg1) == T_STRING) {
						 QString* qstr;
						 int index = -1;
						 qstr = (QString *)Get_QString(varg1);
						 if(varg2 != Qnil)
								index = NUM2INT(varg2);
						 self->insertTab(wd,*qstr,index);
					} else if (rb_obj_is_kind_of(varg1,cQIconSet)) {
						 QIconSet* icon;
						 icon = (QIconSet *)Get_QIconSet(varg1);
						 QString* qstr;
						 int index = -1;
						 qstr = (QString *)Get_QString(varg2);
						 if(varg3 != Qnil)
								 index = NUM2INT(varg3);
						 self->insertTab(wd,*icon,*qstr,index);
					} else if(rb_obj_is_kind_of(varg1,cQPixmap)) {
						 QPixmap* pixmap;
						 pixmap = (QPixmap *)Get_QPixmap(varg1);
						 QString* qstr;
						 int index = -1;
						 qstr = (QString *)Get_QString(varg2);
						 if(varg3 != Qnil)
								 index = NUM2INT(varg3);
						 self->insertTab(wd,*pixmap,*qstr,index); 
					} else {
						 rb_raise(rb_eArgError,"Error in insertTab() argments");
					}
			 }
		}            
		
//    void changeTab( QWidget *, const QString &);
		//RENAME %name(changeTabQIconSet) void changeTab( QWidget *child, const QIconSet& iconset, const QString &label);
		%extend {
			 void changeTab(QWidget* wd, VALUE varg1,VALUE varg2=Qnil) {
					if(TYPE(varg1) == T_STRING ||
						 rb_obj_is_kind_of(varg1,cQString)) {
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg1);
						 self->changeTab(wd,*qstr);
					} else if(rb_obj_is_kind_of(varg1,cQIconSet)) {
						 QIconSet* icon;
						 QString* qstr;
						 icon = (QIconSet *)Get_QIconSet(varg1);
						 qstr = (QString *)Get_QString(varg2);
						 self->changeTab(wd,*icon,*qstr);
					}else if(rb_obj_is_kind_of(varg1,cQPixmap)) {
						 QPixmap* pixmap;
						 QString* qstr;
						 pixmap = (QPixmap *)Get_QPixmap(varg1);
						 qstr = (QString *)Get_QString(varg2);
						 self->changeTab(wd,*pixmap,*qstr);
					}  else {
						 rb_raise(rb_eArgError,"Error in changeTab() argments");
					}
			 }
		}

//    bool isTabEnabled(  QWidget * ) const;
//    void setTabEnabled( QWidget *, bool );
		//RENAME %name(isTabEnabledString) bool isTabEnabled( const char* ) const; // compatibility
		//RENAME %name(setTabEnabledString) void setTabEnabled( const char*, bool ); // compatibility
		%extend {
			 bool isTabEnabled(VALUE varg0) {
					if(TYPE(varg0) == T_STRING) {
						 char* str;
						 str = STR2CSTR(varg0);
						 return self->isTabEnabled(str);
					} else {
						 QWidget* wd;
						 wd = (QWidget *)Get_QWidget(varg0);
						 return self->isTabEnabled(wd);
					}
			 }
			void setTabEnabled(VALUE varg0,VALUE varg1) {
					bool fl;
					fl = (varg1 == Qtrue) ? TRUE:FALSE;
					if(TYPE(varg0) == T_STRING) {
						 char* str;
						 str = STR2CSTR(varg0);
						 self->setTabEnabled(str,fl);
					} else {
						 QWidget* wd;
						 wd = (QWidget *)Get_QWidget(varg0);
						 self->setTabEnabled(wd,fl);
					}
			 } 
			 }        

		void showPage( QWidget * );
		void removePage( QWidget * );
		QString tabLabel( QWidget * );

		QWidget * currentPage() const;

		//RENAME %name(setDefaultButtonQString) void setDefaultButton( const QString &text );
//    void setDefaultButton();
		%extend {
			 void setDefaultButton(VALUE varg0=Qnil) {
					if(varg0 == Qnil) {
						 self->setDefaultButton();
					} else {
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg0);
						 self->setDefaultButton(*qstr);
					}
			 }
		}
						 
		
		bool hasDefaultButton() const;

		//RENAME %name(setHelpButtonQString) void setHelpButton( const QString &text );
//    void setHelpButton();
		%extend {
			 void setHelpButton(VALUE varg0=Qnil) {
					if(varg0 == Qnil) {
						 self->setDefaultButton();
					} else {
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg0);
						 self->setHelpButton(*qstr);
					}
			 }
		}


		bool hasHelpButton() const;

		//RENAME %name(setCancelButtonQString) void setCancelButton( const QString &text );
//    void setCancelButton();
		%extend {
			 void setCancelButton(VALUE varg0=Qnil) {
					if(varg0 == Qnil) {
						 self->setDefaultButton();
					} else {
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg0);
						 self->setCancelButton(*qstr);
					}
			 }
		}
		
		
		bool hasCancelButton() const;

		//RENAME %name(setApplyButtonQString) void setApplyButton( const QString &text );
//    void setApplyButton();
		%extend {
			 void setApplyButton(VALUE varg0=Qnil) {
					if(varg0 == Qnil) {
						 self->setDefaultButton();
					} else {
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg0);
						 self->setApplyButton(*qstr);
					}
			 }
		}
		
		
		bool hasApplyButton() const;

//#if 1 // OBSOLETE
//    void setOKButton( const QString &text = QString::null );
//#endif
		//RENAME %name(setOkButtonQString) void setOkButton( const QString &text );
//    void setOkButton();
		%extend {
			 void setOkButton(VALUE varg0=Qnil) {
					if(varg0 == Qnil) {
						 self->setDefaultButton();
					} else {
						 QString* qstr;
						 qstr = (QString *)Get_QString(varg0);
						 self->setOkButton(*qstr);
					}
			 }
		}


		bool hasOkButton() const;
/*
protected:
		void paintEvent( QPaintEvent * );
		void resizeEvent( QResizeEvent * );
		void styleChange( QStyle& );
		void setTabBar( QTabBar* );
		QTabBar* tabBar() const;

signals:
		void aboutToShow();

		void applyButtonPressed();
		void cancelButtonPressed();
		void defaultButtonPressed();
		void helpButtonPressed();

		void currentChanged( QWidget * );
		void selected( const QString& ); // obsolete

private slots:
		void showTab( int i );

private:
		void setSizes();
		void setUpLayout();

		QTabPrivate *d;
private:	// Disabled copy constructor and operator=
//#if defined(Q_DISABLE_COPY)
		QTabDialog( const QTabDialog & );
		QTabDialog& operator=( const QTabDialog & );
//#endif
*/
};

//#endif // QT_NO_TABDIALOG

//#endif // QTABDIALOG_H
