  // Qt2 typemaps for swig 1.2.12pre
	// Tue Apr  2 14:17:12 2002
	// Helper function for Array output  modified by Horie
	// if VALUE o is Qnil, return only target (not Array)
%{
static VALUE output_helper2(VALUE target, VALUE o) {
		if (NIL_P(target)) {
				target = o;
		} else if(NIL_P(o)) {
				//do nothing
		} else  {
				if (TYPE(target) != T_ARRAY) {
						VALUE o2 = target;
						target = rb_ary_new();
						rb_ary_push(target, o2);
				}
				rb_ary_push(target, o);
		}
		return target;
}
%}
// Force the argument to be ignored.

%typemap(ignore)      int            &OUTPUT(int temp),
short          &OUTPUT(short temp),
long           &OUTPUT(long temp),
unsigned int   &OUTPUT(unsigned int temp),
unsigned short &OUTPUT(unsigned short temp),
unsigned long  &OUTPUT(unsigned long temp),
unsigned char  &OUTPUT(unsigned char temp),
signed char    &OUTPUT(signed char temp),
float          &OUTPUT(float temp),
double         &OUTPUT(double temp),
bool           &OUTPUT(bool temp)
{
		$1 = &temp;
}

%typemap(argout) int            &OUTPUT,
short          &OUTPUT,
long           &OUTPUT,
signed char    &OUTPUT
{
		$result = output_helper($result, INT2NUM(*$1));
}


%typemap(argout) unsigned int   &OUTPUT,
unsigned short &OUTPUT,
unsigned long  &OUTPUT,
unsigned char  &OUTPUT
{
		$result = output_helper($result, UINT2NUM(*$1));
}

%typemap(argout) float    &OUTPUT,
double   &OUTPUT
{
		$result = output_helper($result, rb_float_new(*$1));
}

%typemap(ignore) QStrList &OUTPUT()

{
	 $1 = new QStrList();
}

%typemap(argout) QStrList &OUTPUT

{
	 $result = output_helper($result, Wrap_QStrList(cQStrList,$1));
}

%typemap(ignore) QColor &OUTPUT()
{
	 $1 = new QColor();
}


%typemap(argout) QColor &OUTPUT

{
	$result = output_helper($result, Wrap_QColor(cQColor,$1));
}

%typemap(in) bool *
{
	 if ($input == Qtrue) {
           *$1 = TRUE;
         } else {
           *$1 = FALSE;
         }
}
/*
%typemap(freearg) bool *
{
	delete $1;
}
*/

%typemap(out) bool *
{
	 $result = ((*$1) ? Qtrue : Qfalse);
}

/*
%typemap(argout) bool * OUTPUT
{
		VALUE tf$1;
		if($1 == 0) {
                  $result = Qnil;
                }
}
*/

%typemap(ignore) bool * OUTPUT(bool temp)
{
  $1 = &temp;
}

%typemap(in) VALUE *, const VALUE *
{
	 $1 = &$input;
}

%typemap(out) VALUE *, const VALUE *
{
	 $result = *$1;
}   
%typemap(in) VALUE &, const VALUE & 
{
         $1 = &$input;
}

%typemap(out) VALUE &, const VALUE & 
{
         $result = *$1;
}
%typemap(in) const char *
{
	 $1 = STR2CSTR($input);
}

%typemap(in) const char &
{
	 $1 = STR2CSTR(&$input);
}

%typemap(out) const char *,
const char &,
char &
{
	 if(&$1 == 0)
			$result = Qnil;
	 else    
			$result = rb_str_new2($1);
}

%typemap(in) int *, QCOORD *, const QCOORD *
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 int* ar_li = ALLOC_N(int,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_li[i] = (int)NUM2INT(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_li;
	 } else {
			 int* li$1 = ALLOC(int);  // is it OK?
			 *li$1 = (int)NUM2INT($input);
			 $1 = li$1;
	 }
}
%typemap(in) int &
{
			 $1 = new int;
			 *$1 = (int)NUM2INT($input);
}
%typemap(freearg) int &
{
	delete $1;
}

%typemap(in) long int *
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 long int* ar_li = ALLOC_N(long int,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_li[i] = (long int)NUM2LONG(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_li;
	 } else {
			 long int* li$1 = ALLOC(long int);
			 *li$1 = NUM2INT($input);
			 $1 = li$1;  //is it OK?
	 }
}

%typemap(in) short *
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 short* ar_sh = ALLOC_N(short,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_sh[i] = (short)NUM2INT(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_sh;
	 } else {
			 short* sh$1 = ALLOC(short);
			 *sh$1 = NUM2SHRT($input);
			 $1 = sh$1t;  //is it OK?
	 }
}
%typemap(in) unsigned int * ,
						 QRgb * ,
						 WId * 
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 unsigned int* ar_ui = ALLOC_N(unsigned int,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_ui[i] = (unsigned int)NUM2INT(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_ui;
	 } else {
			 unsigned int* ui$1 = ALLOC(unsigned int);
			 *ui$1 = (unsigned int)NUM2UINT($input);
			 $1 = ui$1;
	 }
}
%typemap(in) unsigned char * ,
						 uchar * ,
						 const uchar *

{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 unsigned char* ar_uc = ALLOC_N(unsigned char,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_uc[i] = (unsigned char)NUM2INT(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_uc;
	 } else {
			 unsigned char* uc$1 = ALLOC(unsigned char);
			 *uc$1 = (unsigned char)NUM2UINT($input);
			 $1 = uc$1;
	 }
}
%typemap(in) unsigned short * ,
						 GLushort * 
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 unsigned short* ar_us = ALLOC_N(unsigned short,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_us[i] = NUM2USHRT(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_us;
	 } else {
			 unsigned short* us$1 = ALLOC(unsigned short);
			 *us$1 = (unsigned short)NUM2UINT($input);
			 $1 = us$1;
	 }
}
%typemap(in) signed char * ,
						 GLbyte * 
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 signed char* ar_sc = ALLOC_N(signed char,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_sc[i] = (signed char)NUM2INT(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_sc;
	 } else {
			 signed char* sc$1 = ALLOC(signed char);
			 *sc$1 = (signed char)NUM2UINT($input);
			 $1 = sc$1;
	 }
}
%typemap(ruby,in) double * ,
						 GLdouble * 
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 double* ar_db = ALLOC_N(double,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_db[i] = NUM2DBL(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_db;
	 } else {
			 double* db$1 = ALLOC(double);
			 *db$1 = (double)NUM2UINT($input);
			 $1 = db$1;
	 }
}
%typemap(in) float * ,
						 GLfloat * 
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 float* ar_fl = ALLOC_N(float,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_fl[i] = (float)NUM2DBL(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_fl;
	 } else {
			 float* fl$1 = ALLOC(float);
			 *fl$1 = (float)NUM2DBL($input);
			 $1 = fl$1;
	 }
}
%typemap(out) void *, const void *
{
		$result = (VALUE)$1;
}
%typemap(in) void *, const void *
{
	 $1 = (void *)$input;
}
// unsigned char *
// uchar * ... Qt library specific
// QRgb = unsigned int ... Qt library specific
// QCOORD = int ... Qt library
%typemap(out) unsigned char *,
uchar *, 
unsigned int *,
uint *,
unsigned short *,
ushort *,
QRgb *,
int *,
long int *

{
		$result = INT2NUM((long int)*$1);
}
%typemap(out) QCOORD *
{
		$result = INT2NUM((long int)*$1);
}

%typemap(out) unsigned char &,
						 uchar &,
						 unsigned int &,
						 uint &,
						 unsigned short &,
						 ushort &,
						 QRgb &,
						 int &,
						 long int &
{
		$result = INT2NUM((long int)$1);
}
%typemap(out) QCOORD & ,
const QCOORD &
	{
		$result = INT2NUM((long int)$1);
	}

%typemap(in) bool &
{
	bool* bl$1 = ALLOC(bool);
	*bl$1 = (($input) ? Qtrue:Qfalse);
	 $1 = bl$1;  // is it OK?
}
%typemap(out) bool &
{
	 $result = (($1) ? Qtrue:Qfalse); 
}

%typemap(in) double &
{
			 double* i$1 = ALLOC(double);
			 *i$1 = (double)NUM2DBL($input);
			 $1 = i$1;
}

%typemap(out) double &
{
		$result = rb_float_new(*$1);
}

%typemap(in) image_io_handler
{
		QImageIO* temp_$1;
		temp_$1 = (QImageIO *)Get_QImageIO($input);
		$1 = (image_io_handler)temp_$1;
}

//typedef void GLvoid; //for GL import
%typemap(in) GLvoid *INPUT_STR()
{
	 $1 = STR2CSTR($input);
}

%typemap(in) GLvoid *INPUT_INT_ARRAY()
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 long int* ar_li = ALLOC_N(long int,a_size);
			 for(int i = 0;i<a_size;i++) {
					 ar_li[i] = (long int)NUM2LONG(RARRAY($input)->ptr[i]);
					 }
			 $1 = ar_li;
	 } else {
			 long int* li$1 = ALLOC(long int);
			 *li$1 = NUM2INT($input);
			 $1 = li$1;
	 }
}

%typemap(in)     char **,const char**
{
	 if(TYPE($input) == T_ARRAY) {
			 int a_size = RARRAY($input)->len;
			 char** ar_str$1 = ALLOC_N(char *,a_size);
			 for(int i = 0; i<a_size;i++) {
					ar_str$1[i] = STR2CSTR(RARRAY($input)->ptr[i]);
			 }
			 $1 = ar_str$1;
	 } else {
			 rb_raise(rb_eTypeError, "Expected a String Array");
	 }
}


// input and output of QClasses for non-class methods

%typemap(in) QObject *,QObject &,const QObject *,const QObject &
{
	 $1 = (QObject *)Get_QObject($input);
}


%typemap(in) QPaintDevice *,
QPaintDevice &,
const QPaintDevice *,
const QPaintDevice &
{
	 if(rb_obj_is_kind_of($input,cQWidget)) {
			$1 = (QWidget*)Get_QWidget($input);
	 } else {
			$1 = (QPaintDevice*)Get_QPaintDevice($input);
	 }
}

%typemap(in) QString *,const QString *
{
	$1 = (QString *)Get_QString($input);
}
//%typemap(freearg) QString *, const QString *
//{
//	delete $1;
//}

%typemap(in) QString &,const QString &
{
	$1 = (QString *)Get_QString($input);
}
//%typemap(freearg) QString &, const QString &
//{
//	delete $1;
//}


