/****************************************************************************
** $Id: qstringlist.i,v 1.1.1.1 2002/12/22 14:20:15 taka-hr Exp $
**
** Definition of QStringList class
**
** Created : 990406
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QSTRINGLIST_H
//#define QSTRINGLIST_H

//#ifndef QT_H
//#include "qvaluelist.h"
//#include "qstring.h"
//#include "qregexp.h"
//#endif // QT_H

class QValueListIterator_QString : public QValueListIterator {
public:
			%extend {
			QString& data() {
				 return (*)self;
				 }
			}
};


class QStrList;
class QValueList_QString : public QValueList {
	 public:
	 QValueList_QString();
	 ~QValueList_QString();
//    typedef QValueListIterator_QString Iterator;
//    typedef QValueListConstIterator_QString ConstIterator;
//    typedef QString T;
		QValueListIterator_QString begin() { detach(); return QValueListIterator_QString( sh->node->next ); }
//    ConstQValueListIterator_QString begin() const { return ConstIterator( sh->node->next ); }
		QValueListIterator_QString end() { detach(); return QValueListIterator_QString( sh->node ); }
//    ConstIterator end() const { return ConstIterator( sh->node ); }
		QValueListIterator_QString fromLast() { detach(); return QValueListIterator_QString( sh->node->prev ); }
//    ConstIterator fromLast() const { return ConstIterator( sh->node->prev ); }

		bool isEmpty() const { return ( sh->nodes == 0 ); }

		QValueListIterator_QString insert( QValueListIterator_QString it, const QString& x ) { detach(); return sh->insert( it, x ); }

		QValueListIterator_QString append( const QString& x ) { detach(); return sh->insert( end(), x ); }
		QValueListIterator_QString prepend( const QString& x ) { detach(); return sh->insert( begin(), x ); }

//    QValueListIterator_QString remove( QValueListIterator_QString it ) { detach(); return sh->remove( it ); }
		//RENAME %name(removeQString) void remove( const QString& x ) { detach(); sh->remove( x ); }
		%extend {
			 VALUE remove(VALUE varg0) {
					VALUE vresult;
					if(rb_obj_is_kind_of(varg0,cQValueListIterator_QString)) {
						 QValueListIterator_QString* it;
						 QValueListIterator_QString* result;
						 it = (QValueListIterator_QString *)Get_QValueListIterator_QString(varg0);
						 result = new QValueListIterator_QString(self->remove(*it));
						 CHECK_PTR(result);
						 vresult = Wrap_QValueListIterator_QString(cQValueListIterator_QString,result);
						 return vresult;
					} else if(rb_obj_is_kind_of(varg0,cQString)) {
						 QString* x;
						 x = (QString *)Get_QString(varg0);
						 self->remove(*x);
						 return Qnil;
					} else {
						 rb_raise(rb_eArgError,"Error in remove() argment");
					}
			 }
		}


		QString& first() { detach(); return sh->node->next->data; }
//    const QString& first() const { return sh->node->next->data; }
		QString& last() { detach(); return sh->node->prev->data; }
//    const QString& last() const { return sh->node->prev->data; }

//    QString& operator[] ( uint i ) { detach(); return sh->at(i)->data; }
//    const QString& operator[] ( uint i ) const { return sh->at(i)->data; }
		%extend {
			 QString& data( uint i) {
					return (*self)[i];
			 }
		QString  __getitem__(int index) {
		  return (*self)[index];
		}
		QString __setitem__(int index, QString qstr) {
		  return (*self)[index] = qstr;
		}
		}
		QValueListIterator_QString at( uint i ) { detach(); return QValueListIterator_QString( sh->at(i) ); }
//    ConstIterator at( uint i ) const { return ConstIterator( sh->at(i) ); }
//    QValueListIterator_QString find ( const QString& x ) { detach(); return QValueListIterator_QString( sh->find( sh->node->next, x) ); }
//    ConstIterator find ( const QString& x ) const { return ConstIterator( sh->find( sh->node->next, x) ); }
		//RENAME %name(findQString) QValueListIterator_QString find ( QValueListIterator_QString it, const QString& x ) { detach(); return QValueListIterator_QString( sh->find( it.node, x ) ); }
//    ConstIterator find ( ConstIterator it, const QString& x ) const { return ConstIterator( sh->find( it.node, x ) ); }
		%extend {
			 QValueListIterator_QString find(VALUE varg0,VALUE varg1=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQString)) {
						 QString* x;
						 x = (QString *)Get_QString(varg0);
						 return self->find(*x);
					} else if(rb_obj_is_kind_of(varg0,cQValueListIterator_QString)) {
						 QValueListIterator_QString* it;
						 QString* x;
						 it = (QValueListIterator_QString *)Get_QValueListIterator_QString(varg0);
						 x = (QString *)Get_QString(varg1);
						 return self->find(*it,*x);
					} else {
						 rb_raise(rb_eArgError,"Error in find() argment");
					}
			 }
		}

		int findIndex( const QString& x ) const { return sh->findIndex( sh->node->next, x) ; }
		uint contains( const QString& x ) const { return sh->contains( x ); }

		uint count() const { return sh->nodes; }

		void clear() { if ( sh->count == 1 ) sh->clear(); else { sh->deref(); sh = new QValueListPrivate<QString>; } }


};


class QStringList : public QValueList_QString {

public:
		QStringList();// { }
//    QStringList( const QStringList& l ) : QValueList<QString>(l) { }
//    QStringList( const QValueList<QString>& l ) : QValueList<QString>(l) { }
//    QStringList( const QString& i ) { append(i); }
#ifndef QT_NO_CAST_ASCII
//    QStringList( const char* i ) { append(i); }
#endif
		~QStringList(); //added for ruby

	 void sort();

		static QStringList fromStrList(const QStrList&);

		//void sort();

		static QStringList split( const QString &sep, const QString &str, bool allowEmptyEntries = FALSE );
//    static QStringList split(  const QChar &sep, const QString &str, bool allowEmptyEntries = FALSE );
//    static QStringList split(  const QRegExp &sep, const QString &str, bool allowEmptyEntries = FALSE );
		QString join( const QString &sep ) const;

//    QStringList grep( const QString &str, bool cs = TRUE ) const;
		//RENAME %name(grepQRegExp) QStringList grep( const QRegExp &expr ) const;
		%extend {
			 QStringList grep(VALUE varg0,VALUE varg1=Qnil) {
					if(rb_obj_is_kind_of(varg0,cQRegExp)) {
						 QRegExp* expr;
						 expr = (QRegExp *)Get_QRegExp(varg0);
						 return self->grep(*expr);
					} else {
						 QString *str;
						 bool cs = TRUE;
						 str = (QString *)Get_QString(varg0);
						 if(varg1 != Qnil)
								 cs = (varg1 == Qtrue) ? TRUE:FALSE;
						 return self->grep(*str,cs);
					}
			 }
		}

};

//class QDataStream;

//extern Q_EXPORT QDataStream &operator>>( QDataStream &, QStringList& );
//extern Q_EXPORT QDataStream &operator<<( QDataStream &, const QStringList& );

//#endif
