/****************************************************************************
** $Id: qsize.i,v 1.1.1.1 2002/12/22 14:20:14 taka-hr Exp $
**
** Definition of QSize class
**
** Created : 931028
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QSIZE_H
//#define QSIZE_H

//#ifndef QT_H
//#include "qpoint.h"
//#endif // QT_H


class QSize
{
public:
		%extend {
			 QSize(VALUE varg0=Qnil,VALUE varg1=Qnil) {
					if(varg0 == Qnil) {
						 return new QSize();
					} else {
						 int w,h;
						 w = NUM2INT(varg0);
						 h = NUM2INT(varg1);
						 return new QSize(w,h);
					}
			 }
		}
 
//    QSize();
//    QSize( int w, int h );
		~QSize();

		bool   isNull()	const;
		bool   isEmpty()	const;
		bool   isValid()	const;

		int	   width()	const;
		int	   height()	const;
		void   setWidth( int w );
		void   setHeight( int h );
		void   transpose();

		QSize expandedTo( const QSize & ) const;
		QSize boundedTo( const QSize & ) const;

		QCOORD &rwidth();
		QCOORD &rheight();
/*
		QSize &operator+=( const QSize & );
		QSize &operator-=( const QSize & );
		QSize &operator*=( int c );
		QSize &operator*=( double c );
		QSize &operator/=( int c );
		QSize &operator/=( double c );

		friend inline bool	operator==( const QSize &, const QSize & );
		friend inline bool	operator!=( const QSize &, const QSize & );
		friend inline QSize operator+( const QSize &, const QSize & );
		friend inline QSize operator-( const QSize &, const QSize & );
		friend inline QSize operator*( const QSize &, int );
		friend inline QSize operator*( int, const QSize & );
		friend inline QSize operator*( const QSize &, double );
		friend inline QSize operator*( double, const QSize & );
		friend inline QSize operator/( const QSize &, int );
		friend inline QSize operator/( const QSize &, double );
*/
/*
private:
		static void warningDivByZero();

		QCOORD wd;
		QCOORD ht;
*/
};


//#endif // QSIZE_H
