/***************************************************************************
										qrobject.cpp  -  description
													 -------------------
	begin                : Sat Aug 18 13:58:51 JST 2001
	copyright            : (C) 2001 by Nobuyuki Horie
	email                : horie@smail.u-shizuoka-ken.ac.jp
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include <iostream>
#include <qrbfunction.h>
#include <qstring.h>
#include <qregexp.h>
#include <qobject.h>
#include "qrobject.h"
/**
*/
// Initialization 
QList<RSlot>* QRObject::RSlots=0;
QRObject* QRObject::_instance=0;

void QRObject::QRObj_init()
{
				//debug("QRObject created.");
				if(_instance == 0) {
					if(RSlots == 0)  {
						 RSlots = new QList<RSlot>;
						 CHECK_PTR(RSlots);
						 RSlots->setAutoDelete(TRUE);
						 }
					 _instance = new QRObject();
					 CHECK_PTR(_instance);
				}
//        return _instance;
}
		 

QRObject::QRObject()
{
			 //debug("QRObject created");
				if(RSlots == 0)  {
						 RSlots = new QList<RSlot>;
						 CHECK_PTR(RSlots);
						 RSlots->setAutoDelete(TRUE);
				 }

}
QRObject::~QRObject()
{
				//debug("QRObject destructor called.");
//	if(!(RSlots.isEmpty)) 
	RSlots->clear();
	//debug("QRObject destructed");
	delete RSlots;
}
void QRObject::callback_ruby(VALUE ruby_object, const char* ruby_method)
{
	 rb_funcall(ruby_object, rb_intern(ruby_method),0);
}

RSlot& QRObject::connect_rslot(const QObject* qt_object, const char* qt_signal,
		VALUE ruby_object, char* ruby_method)
{  
	 //debug("QRobject::connect_rslot called.");
	 //debug("qt_signal is %s",qt_signal);
	 
	 RSlot* rslot;
	 rslot = make_rslot(qt_signal,ruby_object,ruby_method);
	 CHECK_PTR(rslot);
	 QObject::connect(qt_object,qt_signal,rslot,rslot->qslot());
//   RSlots->append(rslot);
	 return *rslot;

}

RSlot& QRObject::connect_rslot_menuId(const QObject* qt_object, const char* qt_signal,int menuId,
		VALUE ruby_object, char* ruby_method)
{  
//   qDebug("QRobject::connect_rslot called.");
//   qDebug("qt_signal is %s",qt_signal);
	 
	 RSlot* rslot;
//   qDebug("ruby_method is %s", ruby_method);
	 rslot = make_rslot(qt_signal,menuId,ruby_object,ruby_method);
	 if (rslot == NULL) {
			fatal("RSlot cannot generate!/n");
			return *rslot;
	 }
	 QObject::connect(qt_object,qt_signal,rslot,rslot->qslot());
//    qDebug("connect_rslot_menuId called:(signal,slot) = %s,%s",qt_signal,rslot->qslot());
//   RSlots->append(rslot);
	 return *rslot;

}


RSignal& QRObject::connect_rsignal(RSignal& ruby_signal,
		const QObject* qt_object, const char* qt_slot)
{
	 ruby_signal.connect(qt_object, qt_slot);
	 return ruby_signal;

}


RSignal& QRObject::connect_rsignalslot(RSignal& ruby_signal,
	VALUE ruby_accept, char* ruby_slot)
{

	 ruby_signal.connect(ruby_accept, ruby_slot);
	 return ruby_signal;
}

RSignal& QRObject::connect_rsignalrsignal(RSignal& ruby_signal1,
	RSignal& ruby_signal2)
{
	 ruby_signal2.connect_rsignal(ruby_signal1);
	 return ruby_signal1;
}
	
void QRObject::connect_qsignalrsignal(const QObject* qt_object,
	const char* qt_signal,RSignal& ruby_signal)
{
	 ruby_signal.connect_qsignal(qt_object,qt_signal);
	 
}

bool QRObject::connectItem_rslot (QAccel* accel, int id, 
	VALUE receiver, char * member )
{
		RSlotVoid* rslot;
		char qrmember[64];
		strcpy(qrmember,member);
		delparenth(qrmember);
		rslot = new RSlotVoid(accel, id, receiver, qrmember);
		CHECK_PTR(rslot);
		RSlots->append(rslot);
		return true;   
}  

bool QRObject::connectItem_rsignal (QAccel* accel, int id, 
				 RSignal& ruby_signal )
{
	 return (ruby_signal.connectItem(accel, id));
			
}

bool QRObject::disconnectItem_rslot (QAccel* accel, int id,
	RSlotVoid& ruby_slot )
{
	 return (ruby_slot.disconnectItem(accel,id));      
}    
				
bool QRObject::disconnectItem_rsignal (QAccel* accel, int id,     
				 RSignal& ruby_signal )
{
	 return (ruby_signal.disconnectItem(accel, id));   
}	


/**
*/

RSlot* QRObject::make_rslot(const char* qtsignal, VALUE robj, char* rmember)
{
	 //debug("RSlot Generated.");
			 
	 RSlot* result=0;
	 char qrmember[64];
	 QRegExp argqlistboxitemqpoint("(\\s*QListBoxItem\\s*\\*\\s*,\\s*const\\s+QPoint\\s*\\&\\s*)");
	 QRegExp argqlistviewitemqpointint("(\\s*QListViewItem\\s*\\*\\s*,\\s*const\\s+QPoint\\s*\\&\\s*,\\s*int\\s*)"); 
	 QRegExp argqlistboxitem("(\\s*QListBoxItem\\s*\\*\\s*)");
	 QRegExp argqlistviewitem("(\\s*QListViewItem\\s*\\*\\s*)"); 
	 QRegExp argqiconviewitem3("(\\s*int\\s*,\\s*QIconViewItem\\s*\\*\\s*,\\s*const\\s+QPoint\\s*\\&\\s*)");
	 QRegExp argqiconviewitem2("(\\s*QIconViewItem\\s*\\*\\s*,\\s*const\\s+QPoint\\s*\\&\\s*)");
	 QRegExp argqiconviewitem1("((\\s*QIconViewItem\\s*\\*\\s*)");
	 QRegExp argint("(\\s*int\\s*)");
	 QRegExp argdbl("(\\s*double\\s*)");
	 QRegExp argbool("(\\s*bool\\s*)");
	 QRegExp argtext("(\\s*const\\s+char\\s*\\*\\s*)");
	 QRegExp argqstr("\\s*const\\s+QString\\s*\\&\\s*");
	 QRegExp argobj("(\\s*VALUE\\s*)");
	 QRegExp argqsize("(\\s*const\\s+QSize\\s*\\&\\s*)");
	 QRegExp argqrect("(\\s*const\\s+QRect\\s*\\&\\s*)");
	 QRegExp argqcolor("(\\s*const\\s+QColor\\s*\\&\\s*)");
	 QRegExp argqdate("(\\s*QDate\\s*)");
	 QRegExp argqdropevent("(\\s*QDropEvent\\s*\\*\\s*");
	 strcpy(qrmember,rmember);
	 delparenth(qrmember);

	 if(argqlistboxitemqpoint.match(qtsignal) > 0) {
			result = new RSlotQListBoxItemQPoint(robj,qrmember);
			CHECK_PTR(result);
			
	 }   else if(argqlistviewitemqpointint.match(qtsignal) > 0) {
			result = new RSlotQListViewItemQPointInt(robj,qrmember);
			CHECK_PTR(result);
			
	 }   else if(argqlistboxitem.match(qtsignal) > 0) {
			result = new RSlotQListBoxItem(robj,qrmember);
			CHECK_PTR(result);
	 
	 }   else if(argqlistviewitem.match(qtsignal) > 0) {
			result = new RSlotQListViewItem(robj,qrmember);
			CHECK_PTR(result);
			
	 }   else if(argqiconviewitem3.match(qtsignal) > 0) {
	                result = new RSlotQIconViewItem(robj,qrmember,3);
	                CHECK_PTR(result);
	                
	 }   else if(argqiconviewitem2.match(qtsignal) > 0) {
	                result = new RSlotQIconViewItem(robj,qrmember,2);
	                CHECK_PTR(result);
	                
	 }   else if(argqiconviewitem1.match(qtsignal) > 0) {
	                result = new RSlotQIconViewItem(robj,qrmember,1);
	                CHECK_PTR(result);
	                
	 }   else if(argint.match(qtsignal) > 0) {
			result = new RSlotInt(robj,qrmember);
			CHECK_PTR(result);
			//debug( "RSlot::Int slot.");
					
	 }   else if(argbool.match(qtsignal) > 0) {
			result = new RSlotBool(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::Bool slot.");

	 }   else if(argdbl.match(qtsignal) > 0) {
			result = new RSlotDouble(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::Double slot.");

	 }   else if(argtext.match(qtsignal) > 0) {
			result = new RSlotStr(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::Text slot.");

	 }   else if(argqstr.match(qtsignal) > 0) {
			result = new RSlotQStr(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::Text slot.");
					
	 }   else if(argobj.match(qtsignal) > 0) {
			result = new RSlotRObj(robj,qrmember);
			CHECK_PTR(result);      
					//debug( "RSlot::Object slot.");

	 }   else if(argqsize.match(qtsignal) > 0) {
			result = new RSlotQSize(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::Qsize slot.");

	 }   else if(argqrect.match(qtsignal) > 0) {
			result = new RSlotQRect(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::Qrect slot.");

	 }   else if(argqcolor.match(qtsignal) > 0) {
			result = new RSlotQColor(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::Qrect slot.");

	 }   else if(argqdate.match(qtsignal) > 0) {
			result = new RSlotQDate(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::Qrect slot.");

#ifndef QT_NO_DRAGANDDROP
	 }   else if(argqdropevent.match(qtsignal) > 0) {
			result = new RSlotQDropEvent(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::QDropEvent slot.");
					
#endif
	 }    else {
			result = new RSlotVoid(robj,qrmember);
			CHECK_PTR(result);
					//debug( "RSlot::No Arg slot.");	

	}
			//debug("result is %d",result->type());
 
			RSlots->append(result);
			return result;
}

RSlot* QRObject::make_rslot(const char* qtsignal,int menuId, VALUE robj, char* rmethod)
{
	 //debug("RSlot Generated.");
	 RMenuRSlot* result;
	 result = new RMenuRSlot(menuId,robj,rmethod);
	 CHECK_PTR(result);
	 RSlots->append(result);
	 return result;
}	
	

